/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pcbd.dao.impl;

import com.parablu.factory.ParacloudMongoFactoryUtils;
import com.parablu.pcbd.dao.MongoPropertiesDao;
import com.parablu.pcbd.dao.impl.PrivacyGateWayDaoImpl;
import com.parablu.pcbd.domain.MongoProperties;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;

public class MongoPropertiesDaoImpl
implements MongoPropertiesDao {
    private static final String HOSTED_SETUP = "HostedSetup";
    private static Logger logger = LogManager.getLogger(PrivacyGateWayDaoImpl.class);
    ParacloudMongoFactoryUtils paracloudMongoFactoryUtils;

    @Override
    public List<MongoProperties> getAllMongoProperties(int cloudId) {
        logger.debug("loading all mongoProperties....");
        return this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).findAll(MongoProperties.class);
    }

    @Override
    public void updateMongoProperties(int cloudId, MongoProperties element) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.save((Object)element);
    }

    @Override
    public boolean checkHostedSetup(int cloudId) {
        Criteria fieldCheckCriteria = Criteria.where((String)HOSTED_SETUP).exists(true);
        Query fieldCheckQuery = new Query((CriteriaDefinition)fieldCheckCriteria);
        boolean hostedSetupFieldExists = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).exists(fieldCheckQuery, MongoProperties.class);
        if (hostedSetupFieldExists) {
            logger.debug("HostedSetup field exists in mongo getting the field value and loading all mongoProperties...");
            List mongoProperties = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).findAll(MongoProperties.class);
            if (mongoProperties != null && mongoProperties.size() > 0 && mongoProperties.get(0) != null && "true".equals(((MongoProperties)mongoProperties.get(0)).getHostedSetup())) {
                logger.debug("process = getting mongo properties, HostedSetup value = {}", (Object)((MongoProperties)mongoProperties.get(0)).getHostedSetup());
                return true;
            }
            return false;
        }
        logger.debug("HostedSetup field does not exists in mongo, hence considering it to be Hosted Setup and return true");
        return true;
    }

    public ParacloudMongoFactoryUtils getParacloudMongoFactoryUtils() {
        return this.paracloudMongoFactoryUtils;
    }

    public void setParacloudMongoFactoryUtils(ParacloudMongoFactoryUtils paracloudMongoFactoryUtils) {
        this.paracloudMongoFactoryUtils = paracloudMongoFactoryUtils;
    }
}

