/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pcbd.dao.impl;

import com.parablu.factory.ParacloudMongoFactoryUtils;
import com.parablu.factory.ParacloudSessionFactoryUtils;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.paracloud.element.MiniCloudElement;
import com.parablu.pcbd.dao.MiniCloudDao;
import com.parablu.pcbd.domain.CollectionDetails;
import com.parablu.pcbd.domain.MiniCloud;
import com.parablu.pcbd.domain.MiniCloudGroupMapping;
import com.parablu.pcbd.domain.User;
import com.parablu.pcbd.domain.UserCloudAccessControl;
import java.util.List;
import org.bson.types.ObjectId;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;

public class MiniCloudDaoImpl
implements MiniCloudDao {
    ParacloudSessionFactoryUtils paracloudSessionFactoryUtils;
    ParacloudMongoFactoryUtils paracloudMongoFactoryUtils;
    private static final String STATUS = "status";
    private static final String DELETED = "DELETED";

    public ParacloudSessionFactoryUtils getParacloudSessionFactoryUtils() {
        return this.paracloudSessionFactoryUtils;
    }

    public void setParacloudSessionFactoryUtils(ParacloudSessionFactoryUtils paracloudSessionFactoryUtils) {
        this.paracloudSessionFactoryUtils = paracloudSessionFactoryUtils;
    }

    public ParacloudMongoFactoryUtils getParacloudMongoFactoryUtils() {
        return this.paracloudMongoFactoryUtils;
    }

    public void setParacloudMongoFactoryUtils(ParacloudMongoFactoryUtils paracloudMongoFactoryUtils) {
        this.paracloudMongoFactoryUtils = paracloudMongoFactoryUtils;
    }

    @Override
    public MiniCloud saveMiniCloud(int cloudId, String cloudName, MiniCloud miniCloud) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (MiniCloud)mongoTemplate.save((Object)miniCloud);
    }

    @Override
    public MiniCloud getMiniCloudByName(int cloudId, String cloudName, String miniCloudName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"miniCloudName").is((Object)miniCloudName), Criteria.where((String)STATUS).ne((Object)DELETED)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (MiniCloud)mongoTemplate.findOne(query, MiniCloud.class);
    }

    @Override
    public MiniCloud getMiniCloudByID(int cloudId, String cloudName, ObjectId id) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)id)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (MiniCloud)mongoTemplate.findOne(query, MiniCloud.class);
    }

    @Override
    public List<MiniCloud> getAllMiniCloud(int cloudId, String cloudName) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Query query = new Query((CriteriaDefinition)Criteria.where((String)STATUS).ne((Object)DELETED));
        return mongoTemplate.find(query, MiniCloud.class);
    }

    @Override
    public List<MiniCloud> getAllActiveMiniCloudsForSync(int cloudId) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.findAll(MiniCloud.class);
    }

    @Override
    public long getMiniCloudCount(int cloudId, String cloudName) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)STATUS).ne((Object)DELETED)});
        Query query = new Query((CriteriaDefinition)criteria);
        return mongoTemplate.count(query, MiniCloud.class);
    }

    @Override
    public void deleteMiniCloud(int cloudId, String cloudName, MiniCloud cloud) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        cloud.setStatus(DELETED);
        mongoTemplate.save((Object)cloud);
    }

    @Override
    public void updateOwnershipForMC(int cloudId, String userName, String miniCloudName) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        MiniCloud miniCloud = this.getMiniCloudByName(cloudId, "", miniCloudName);
        if (miniCloud != null) {
            miniCloud.setOwner(userName);
            mongoTemplate.save((Object)miniCloud);
            this.createMCAccessForUser(cloudId, miniCloud.getId(), userName);
        }
    }

    public void createMCAccessForUser(int cloudId, ObjectId miniCloudId, String userName) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        UserCloudAccessControl accessControl = new UserCloudAccessControl();
        accessControl.setMiniCloudFK(miniCloudId);
        User user = this.getUserForName(mongoTemplate, userName);
        accessControl.setUserFK(user.getUserId());
        mongoTemplate.save((Object)accessControl);
    }

    private User getUserForName(MongoTemplate mongoTemplate, String userName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"userName").regex("^" + userName + "$", "i"), Criteria.where((String)"active").is((Object)true)});
        Query query = new Query((CriteriaDefinition)criteria);
        return (User)mongoTemplate.findOne(query, User.class);
    }

    public void deleteUserCloudAccessControlMappingWithUserFK(int cloudId, ObjectId userId, ObjectId miniCloudId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"userFK").is((Object)userId), Criteria.where((String)"miniCloudFK").is((Object)miniCloudId)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.remove(query, UserCloudAccessControl.class);
    }

    @Override
    public void deleteUserCloudAccessControlMappingForUser(int cloudId, MiniCloud miniCloud) {
        Criteria criteria = new Criteria();
        ObjectId miniCloudId = miniCloud.getId();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"miniCloudFK").is((Object)miniCloudId)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.remove(query, UserCloudAccessControl.class);
        this.createMCAccessForUser(cloudId, miniCloudId, miniCloud.getOwner());
    }

    @Override
    public List<MiniCloud> getAllMiniCloudForUser(int cloudId, String userName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"owner").regex("^" + userName + "$", "i"), Criteria.where((String)STATUS).ne((Object)DELETED)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, MiniCloud.class);
    }

    @Override
    public List<MiniCloud> getMiniCloudByName(int cloudId, String miniCloudName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"miniCloudName").is((Object)miniCloudName), Criteria.where((String)STATUS).ne((Object)DELETED)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, MiniCloud.class);
    }

    @Override
    public void deleteGroupMappingForMC(int cloudId, MiniCloud miniCloud) {
        Criteria criteria = new Criteria();
        ObjectId miniCloudId = miniCloud.getId();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"miniCloud.$id").is((Object)miniCloudId)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.remove(query, MiniCloudGroupMapping.class);
    }

    @Override
    public void updateMiniCloud(int cloudId, MiniCloudElement miniCloudElement) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        MiniCloud miniCloud = this.getMiniCloudByName(cloudId, "", miniCloudElement.getMiniCloudName());
        if (miniCloud != null) {
            miniCloud.setMcDisabled(miniCloudElement.isMcDisabled());
            miniCloud.setMcQuota(miniCloudElement.getMcQuota());
            miniCloud.setMcDisableDate(miniCloudElement.getMcDisableDate());
            miniCloud.setMcDisabledNotification(miniCloudElement.isMcDisabledNotification());
            mongoTemplate.save((Object)miniCloud);
        }
    }

    @Override
    public void updateMiniCloudforQuota(int cloudId, String miniCloudName, boolean allowUpload) {
        Criteria criteria = Criteria.where((String)"miniCloudName").is((Object)miniCloudName);
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("allowUpload", (Object)allowUpload);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.updateFirst(query, update, MiniCloud.class);
    }

    @Override
    public String findDestinationCollection(int cloudId) {
        String destinationCollectionName;
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        long entitiesAllowed = PCHelperConstant.getEntitiesAllowedPerCollection();
        CollectionDetails collectionDetails = (CollectionDetails)mongoTemplate.findOne(new Query((CriteriaDefinition)Criteria.where((String)"entityCount").lt((Object)entitiesAllowed)), CollectionDetails.class);
        if (collectionDetails == null) {
            long count = mongoTemplate.count(new Query(), CollectionDetails.class);
            long destinationCollectionCount = count + 2L;
            destinationCollectionName = "BACKUP_" + destinationCollectionCount;
            collectionDetails = new CollectionDetails();
            collectionDetails.setCollectionName(destinationCollectionName);
            collectionDetails.setEntityCount(1L);
            mongoTemplate.save((Object)collectionDetails);
        } else {
            destinationCollectionName = collectionDetails.getCollectionName();
            collectionDetails.setEntityCount(collectionDetails.getEntityCount() + 1L);
            mongoTemplate.save((Object)collectionDetails);
        }
        return destinationCollectionName;
    }
}

