/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pcbd.dao.impl;

import com.mongodb.BasicDBObject;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import com.parablu.factory.ParacloudMongoFactoryUtils;
import com.parablu.paracloud.element.DeviceElement;
import com.parablu.pcbd.dao.EventHubDao;
import com.parablu.pcbd.domain.BackupAttempt;
import com.parablu.pcbd.domain.BackupBatch;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.DeviceBackupOverView;
import com.parablu.pcbd.domain.EventHub;
import com.parablu.pcbd.domain.MailBackupBatch;
import com.parablu.pcbd.domain.ODBBackupBatch;
import com.parablu.pcbd.domain.OfficeBackupPolicy;
import com.parablu.pcbd.domain.RestoreEvents;
import com.parablu.pcbd.domain.RestoreProgressEvents;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.types.ObjectId;
import org.springframework.beans.BeanUtils;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.aggregation.TypedAggregation;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.util.CollectionUtils;

public class EventHubDaoImpl
implements EventHubDao {
    private static Logger logger = LogManager.getLogger(EventHubDaoImpl.class);
    ParacloudMongoFactoryUtils paracloudMongoFactoryUtils;
    private static final String ACTION_TO_USER_NAME = "actionToUserName";
    private static final String ACTION_TO_DEVICEUUID = "actionToDeviceUUID";
    private static final String ACTION_STATUS = "actionStatus";
    private static final String ACTION = "action";
    private static final String USER_NAME = "userName";
    private static final String JOB_TYPE = "jobType";
    private static final String BACK_UP = "BACKUP";
    private static final String STATUS = "status";
    private static final String BATCH_START_TIME_STAMP = "batchStartTimestamp";
    private static final String DEVICEUUID = "deviceUUID";
    private static final String RESTORE = "RESTORE";
    private static final String COMPLETED = "COMPLETED";
    private static final String COUNT = "count";
    public static final String CHUNK_DETAIL = "CHUNK_DETAIL";
    private MongoOperations msgMongoTemplate;

    public MongoOperations getMongoTemplate() {
        return this.msgMongoTemplate;
    }

    public void setMsgMongoTemplate(MongoOperations msgMongoTemplate) {
        this.msgMongoTemplate = msgMongoTemplate;
    }

    public ParacloudMongoFactoryUtils getParacloudMongoFactoryUtils() {
        return this.paracloudMongoFactoryUtils;
    }

    public void setParacloudMongoFactoryUtils(ParacloudMongoFactoryUtils paracloudMongoFactoryUtils) {
        this.paracloudMongoFactoryUtils = paracloudMongoFactoryUtils;
    }

    @Override
    public void saveAction(int cloudId, String cloudName, EventHub eventHub) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.save((Object)eventHub);
    }

    @Override
    public void changeStatus(int cloudId, String cloudName, EventHub eventHub) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)ACTION_TO_USER_NAME).is((Object)eventHub.getActionToUserName()), Criteria.where((String)ACTION_TO_DEVICEUUID).is((Object)eventHub.getActionToDeviceUUID()), Criteria.where((String)ACTION).is((Object)eventHub.getAction())});
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set(ACTION_STATUS, (Object)eventHub.getActionStatus());
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.updateFirst(query, update, EventHub.class);
    }

    @Override
    public void deleteAction(int cloudId, String cloudName, EventHub eventHub) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)ACTION_TO_USER_NAME).is((Object)eventHub.getActionToUserName()), Criteria.where((String)ACTION_TO_DEVICEUUID).is((Object)eventHub.getActionToDeviceUUID()), Criteria.where((String)ACTION).is((Object)eventHub.getAction())});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.remove(query, EventHub.class);
    }

    @Override
    public List<EventHub> getActionsByUserNameAndActionByDeviceUUID(int cloudId, String cloudName, EventHub eventHub) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)ACTION_TO_USER_NAME).is((Object)eventHub.getActionToUserName()), Criteria.where((String)ACTION_TO_DEVICEUUID).is((Object)eventHub.getActionToDeviceUUID())});
        Query query = new Query((CriteriaDefinition)criteria);
        return mongoTemplate.find(query, EventHub.class);
    }

    @Override
    public boolean checkActionIsPresent(int cloudId, String cloudName, EventHub eventHub) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)ACTION_TO_USER_NAME).is((Object)eventHub.getActionToUserName()), Criteria.where((String)ACTION_TO_DEVICEUUID).is((Object)eventHub.getActionToDeviceUUID()), Criteria.where((String)ACTION).is((Object)eventHub.getAction())});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return Optional.ofNullable(mongoTemplate.findOne(query, EventHub.class)).isPresent();
    }

    @Override
    public void deleteAllActionByDeviceUUID(int cloudId, EventHub eventHub) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)ACTION_TO_USER_NAME).is((Object)eventHub.getActionToUserName()), Criteria.where((String)ACTION_TO_DEVICEUUID).is((Object)eventHub.getActionToDeviceUUID())});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.remove(query, EventHub.class);
    }

    @Override
    public void deleteActionBasedOnBackupBatchStatus(int cloudId, String deviceUUID, String action) {
        logger.debug("deleteActionBasedOnBackupBatchStatus......" + deviceUUID + action);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)ACTION_TO_DEVICEUUID).is((Object)deviceUUID), Criteria.where((String)ACTION).is((Object)action)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.remove(query, EventHub.class);
    }

    @Override
    public void updateBackupBatchForStopAndPauseBkp(int cloudId, String actionToDeviceUUID, String errorCode, String status, String policyName) {
        EventHub eventHub;
        logger.debug("......." + actionToDeviceUUID + "........" + errorCode + "......." + status);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICEUUID).is((Object)actionToDeviceUUID), Criteria.where((String)JOB_TYPE).is((Object)BACK_UP)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{"batchEndTimestamp"}));
        query.limit(1);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        BackupBatch backupBatch = (BackupBatch)mongoTemplate.findOne(query, BackupBatch.class);
        String prevErrorCode = backupBatch.getErrorCode();
        boolean officeProduct = false;
        if (backupBatch.getDeviceName().contains("Microsoft Exchange") || backupBatch.getDeviceName().contains("Microsoft OneDrive") || backupBatch.getDeviceName().contains("Microsoft SharePoint")) {
            officeProduct = true;
        }
        String currentStatus = backupBatch.getStatus();
        logger.debug(officeProduct + "......statuscheck222...." + currentStatus);
        backupBatch.setErrorCode(errorCode);
        logger.debug(officeProduct + "......errorcode...." + errorCode);
        logger.debug(backupBatch.getStatus() + "...updateBackupBatchForStopAndPauseBkp...." + backupBatch.getErrorCode());
        if (backupBatch != null && backupBatch.getStatus().equals("SCANNING")) {
            logger.debug("..........");
            eventHub = new EventHub();
            eventHub.setActionToDeviceUUID(actionToDeviceUUID);
            eventHub.setActionToUserName(backupBatch.getUserName());
            eventHub.setAction(status);
            if (!this.checkActionIsPresent(cloudId, "", eventHub)) {
                logger.debug("..saving action....");
                this.saveAction(cloudId, "", eventHub);
            } else {
                logger.debug("event is alredy present....");
            }
        }
        logger.debug(officeProduct + "......statuscheck1...." + currentStatus);
        errorCode = errorCode.trim();
        if (errorCode.trim().equals("1207") || errorCode.trim().equals("1209") || errorCode.trim().equals("1311") || errorCode.trim().equals("1310")) {
            backupBatch.setBatchEndTimestamp(System.currentTimeMillis());
            backupBatch.setStatus("ABORTED");
        }
        if (errorCode.trim().equals("1992") || errorCode.trim().equals("1208")) {
            backupBatch.setStatus("PAUSED");
            backupBatch.setBatchEndTimestamp(System.currentTimeMillis());
            if (errorCode.equals("1208")) {
                this.updateOverViewStatus(cloudId, actionToDeviceUUID, "PAUSED", 1208);
            }
            if (errorCode.equals("1992")) {
                this.updateOverViewStatus(cloudId, actionToDeviceUUID, "PAUSED", 1992);
            }
        }
        mongoTemplate.save((Object)backupBatch);
        logger.debug(officeProduct + "......statuscheck2...." + currentStatus);
        if (errorCode.equals("1207") || errorCode.equals("1209") || errorCode.trim().equals("1311") || errorCode.trim().equals("1310")) {
            eventHub = this.getEventActionBasedOnBackupBatchStatus(cloudId, actionToDeviceUUID);
            logger.debug(officeProduct + "......statuscheck3...." + eventHub);
            if (eventHub == null && !officeProduct) {
                BackupAttempt lastBackupAttempt;
                BackupAttempt lastBackupAttemptById;
                BackupAttempt bkpAttempt;
                if (errorCode.equals("1207")) {
                    this.updateBackBatch(cloudId, backupBatch.getId(), "ABORTED", 1207);
                    this.updateOverViewStatus(cloudId, actionToDeviceUUID, "ABORTED", 1207);
                }
                if (errorCode.equals("1209")) {
                    this.updateBackBatch(cloudId, backupBatch.getId(), "ABORTED", 1209);
                    this.updateOverViewStatus(cloudId, actionToDeviceUUID, "ABORTED", 1209);
                }
                if (errorCode.equals("1311")) {
                    this.updateBackBatch(cloudId, backupBatch.getId(), "ABORTED", 1311);
                    this.updateOverViewStatus(cloudId, actionToDeviceUUID, "ABORTED", 1311);
                }
                if (errorCode.equals("1310")) {
                    this.updateBackBatch(cloudId, backupBatch.getId(), "ABORTED", 1310);
                    this.updateOverViewStatus(cloudId, actionToDeviceUUID, "ABORTED", 1310);
                }
                if ((bkpAttempt = (lastBackupAttemptById = (lastBackupAttempt = this.getLastBackupAttemptById(cloudId, backupBatch.getId().toString())))) != null) {
                    bkpAttempt.setErrorCode(backupBatch.getErrorCode());
                    logger.debug(bkpAttempt.getStatus() + "Size...attempt1....." + bkpAttempt.getUploadedSize());
                    logger.debug("Size...batch1....." + backupBatch.getUploadedSize());
                    bkpAttempt.setStatus(backupBatch.getStatus());
                    if (errorCode.equals("1209")) {
                        bkpAttempt.setStatus("ABORTED");
                    }
                    bkpAttempt.setBatchEndTimestamp(System.currentTimeMillis());
                    this.saveBackupAttempt(cloudId, "", bkpAttempt);
                }
            } else {
                logger.debug(officeProduct + "......statuscheck4...." + currentStatus);
                if (officeProduct && (currentStatus.equalsIgnoreCase("SCANNING") || currentStatus.equalsIgnoreCase("QUEUED"))) {
                    try {
                        if (errorCode.equals("1209")) {
                            this.updateBackBatch(cloudId, backupBatch.getId(), "ABORTED", 1209);
                            this.updateOverViewStatus(cloudId, actionToDeviceUUID, "ABORTED", 1209);
                        }
                        if (errorCode.equals("1311")) {
                            logger.debug("...currentstatus....." + errorCode);
                            this.updateBackBatch(cloudId, backupBatch.getId(), "ABORTED", 1311);
                            this.updateOverViewStatus(cloudId, actionToDeviceUUID, "ABORTED", 1311);
                            Thread.sleep(TimeUnit.SECONDS.toMillis(20L));
                        }
                        if (errorCode.equals("1310")) {
                            logger.debug("...currentstatus....." + errorCode);
                            this.updateBackBatch(cloudId, backupBatch.getId(), "ABORTED", 1310);
                            this.updateOverViewStatus(cloudId, actionToDeviceUUID, "ABORTED", 1310);
                            Thread.sleep(TimeUnit.SECONDS.toMillis(20L));
                        }
                        if (errorCode.equals("1208")) {
                            this.updateOverViewStatus(cloudId, actionToDeviceUUID, "PAUSED", 1208);
                        }
                        logger.debug(errorCode + "........updateBatchAttempt.status........" + backupBatch.getStatus());
                        if (!backupBatch.getStatus().equals("STARTED")) {
                            logger.debug(backupBatch.getErrorCode() + ".........attempt vla........" + backupBatch.getStatus());
                            BackupAttempt existingBackupAttempt = this.getLastBackupAttemptById(cloudId, backupBatch.getId().toString());
                            if (existingBackupAttempt != null) {
                                existingBackupAttempt.setErrorCode(backupBatch.getErrorCode());
                                existingBackupAttempt.setBatchEndTimestamp(System.currentTimeMillis());
                                if (errorCode.equals("1209")) {
                                    existingBackupAttempt.setStatus("ABORTED");
                                }
                                this.saveBackupAttempt(cloudId, existingBackupAttempt);
                            }
                        }
                    }
                    catch (Exception e) {
                        logger.trace("Error failed to save BackupAttempt ..." + e);
                        logger.error("Error failed to save BackupAttempt ..." + e);
                    }
                }
            }
        }
        if (officeProduct && (errorCode.equals("1208") || errorCode.equals("1209"))) {
            if (!currentStatus.equalsIgnoreCase("SCANNING") && !currentStatus.equalsIgnoreCase("QUEUED")) {
                BackupAttempt lastBkpAttempt = new BackupAttempt();
                logger.debug("....errrocode testing..." + prevErrorCode);
                if (StringUtils.isEmpty((String)prevErrorCode) || prevErrorCode.equalsIgnoreCase("0")) {
                    lastBkpAttempt = this.getLastBackupAttemptById(cloudId, backupBatch.getId().toString());
                    lastBkpAttempt.setStatus(backupBatch.getStatus());
                    lastBkpAttempt.setErrorCode(backupBatch.getErrorCode());
                } else {
                    lastBkpAttempt = new BackupAttempt();
                    BeanUtils.copyProperties((Object)backupBatch, (Object)lastBkpAttempt);
                    lastBkpAttempt.setId(null);
                    lastBkpAttempt.setBatchStartTimestamp(System.currentTimeMillis());
                    lastBkpAttempt.setErrorCode(backupBatch.getErrorCode());
                    lastBkpAttempt.setUploadedSize(backupBatch.getUploadedSize());
                    lastBkpAttempt.setStatus(backupBatch.getStatus());
                    lastBkpAttempt.setBatchId(backupBatch.getId().toString());
                    lastBkpAttempt.setBatchEndTimestamp(System.currentTimeMillis());
                    lastBkpAttempt.setUploadedFiles(backupBatch.getUploadedFiles());
                    lastBkpAttempt.setUploadedSize(backupBatch.getUploadedSize());
                }
                this.saveBackupAttempt(cloudId, lastBkpAttempt);
            }
            this.updateBatchStatusInOdServer(backupBatch.getId(), policyName);
            if (errorCode.equals("1209")) {
                this.updateOverViewStatus(cloudId, actionToDeviceUUID, "ABORTED", 1209);
            } else if (errorCode.equals("1208")) {
                this.updateOverViewStatus(cloudId, actionToDeviceUUID, "PAUSED", 1208);
            } else if (errorCode.equals("1311")) {
                this.updateOverViewStatus(cloudId, actionToDeviceUUID, "ABORTED", 1311);
            } else if (errorCode.equals("1310")) {
                this.updateOverViewStatus(cloudId, actionToDeviceUUID, "ABORTED", 1310);
            }
        }
    }

    public void updateBatchStatusInOdServer(ObjectId id, String policyName) {
        Criteria criteria = Criteria.where((String)"id").is((Object)id);
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set(STATUS, (Object)"PAUSED");
        UpdateResult updateFirst = this.msgMongoTemplate.updateFirst(query, update, ODBBackupBatch.class, "BACKUP_BATCH_" + policyName.toUpperCase());
        logger.debug(updateFirst.getModifiedCount() + "... paused successfully.... " + policyName + "..." + id);
    }

    @Override
    public void saveBackupAttempt(int cloudId, BackupAttempt attempt) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.save((Object)attempt);
        logger.debug("....attempt id...." + attempt.getId().toString());
    }

    public void saveBackupAttempt(int cloudId, String cloudName, BackupAttempt attempt) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.save((Object)attempt);
    }

    public BackupAttempt getLastBackupAttemptById(int cloudId, String batchId) {
        Criteria criteria1 = Criteria.where((String)"batchId").is((Object)batchId);
        Query query = new Query((CriteriaDefinition)criteria1);
        query.with(new Sort(Sort.Direction.DESC, new String[]{"id"}));
        query.limit(1);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (BackupAttempt)mongoTemplate.findOne(query, BackupAttempt.class);
    }

    public void updateBackBatch(int cloudId, ObjectId backupBatchId, String status, int errorCode) {
        Criteria criteria;
        Query query;
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        BackupBatch backupBatch = (BackupBatch)mongoTemplate.findOne(query = new Query((CriteriaDefinition)(criteria = Criteria.where((String)"id").is((Object)backupBatchId))), BackupBatch.class);
        if (backupBatch != null) {
            Update update = new Update();
            update.set(STATUS, (Object)status);
            update.set("errorCode", (Object)("" + errorCode));
            update.set("batchEndTimestamp", (Object)System.currentTimeMillis());
            mongoTemplate.updateFirst(query, update, BackupBatch.class);
        }
    }

    public void updateOverViewStatus(int cloudId, String actionToDeviceUUID, String status, int errorCode) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICEUUID).is((Object)actionToDeviceUUID)});
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("lastBkpStatus", (Object)status);
        update.set("reason", (Object)("" + errorCode));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        UpdateResult updateFirst = mongoTemplate.updateFirst(query, update, DeviceBackupOverView.class);
        logger.debug(status + "....updated overview....." + actionToDeviceUUID + "....." + updateFirst.getModifiedCount());
    }

    public EventHub getEventActionBasedOnBackupBatchStatus(int cloudId, String deviceUUID) {
        Criteria andCriteria = new Criteria();
        Criteria criteria = new Criteria();
        criteria.orOperator(new Criteria[]{Criteria.where((String)ACTION).is((Object)"FULL_BACKUP"), Criteria.where((String)ACTION).is((Object)"START_BACKUP")});
        Criteria devUUIDCriteria = Criteria.where((String)ACTION_TO_DEVICEUUID).is((Object)deviceUUID);
        andCriteria.andOperator(new Criteria[]{devUUIDCriteria, criteria});
        Query query = new Query((CriteriaDefinition)andCriteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (EventHub)mongoTemplate.findOne(query, EventHub.class);
    }

    @Override
    public RestoreEvents getRestoreEventsByDestUUIDAndFolder(int cloudId, String deviceUUID, String destinationFolder) {
        Criteria criteria = new Criteria();
        if (!StringUtils.isEmpty((String)destinationFolder)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)"destinationDeviceUUID").is((Object)deviceUUID), Criteria.where((String)"destinationFolder").is((Object)destinationFolder)});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)"destinationDeviceUUID").is((Object)deviceUUID)});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (RestoreEvents)mongoTemplate.findOne(query, RestoreEvents.class);
    }

    @Override
    public void deleteRestoreEventsByDestUUID(int cloudId, String deviceUUID) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"actionOnDeviceUUID").is((Object)deviceUUID)});
        Query query = new Query((CriteriaDefinition)criteria);
        RestoreEvents restoreEvents = (RestoreEvents)mongoTemplate.findOne(query, RestoreEvents.class);
        if (restoreEvents != null) {
            criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICEUUID).is((Object)restoreEvents.getDestinationDeviceUUID())});
            query = new Query((CriteriaDefinition)criteria);
            mongoTemplate.findAndRemove(query, RestoreProgressEvents.class);
            criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)"actionOnDeviceUUID").is((Object)deviceUUID)});
            query = new Query((CriteriaDefinition)criteria);
            mongoTemplate.findAndRemove(query, RestoreEvents.class);
            this.updateBackupBatchForStopRestore(cloudId, deviceUUID, "1207");
        }
    }

    @Override
    public void saveRestoreEvents(int cloudId, RestoreEvents restoreEvents) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.save((Object)restoreEvents);
    }

    @Override
    public void deleteRestoreEvents(int cloudId, RestoreEvents restoreEvents) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.remove((Object)restoreEvents);
    }

    @Override
    public MailBackupBatch getMailBackupBatch(int cloudId, String deviceUUID) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICEUUID).is((Object)deviceUUID), Criteria.where((String)STATUS).is((Object)"STARTED"), Criteria.where((String)JOB_TYPE).is((Object)RESTORE)});
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (MailBackupBatch)mongoTemplate.findOne(new Query((CriteriaDefinition)criteria), MailBackupBatch.class);
    }

    @Override
    public BackupBatch getBackupBatch(int cloudId, String deviceUUID) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICEUUID).is((Object)deviceUUID), Criteria.where((String)STATUS).is((Object)"STARTED"), Criteria.where((String)JOB_TYPE).is((Object)RESTORE)});
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (BackupBatch)mongoTemplate.findOne(new Query((CriteriaDefinition)criteria), BackupBatch.class);
    }

    @Override
    public void updateBackupBatchForStopRestore(int cloudId, String actionToDeviceUUID, String errorCode, String status) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICEUUID).is((Object)actionToDeviceUUID), Criteria.where((String)JOB_TYPE).is((Object)RESTORE)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{"batchEndTimestamp"}));
        query.limit(1);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        BackupBatch backupBatch = (BackupBatch)mongoTemplate.findOne(query, BackupBatch.class);
        backupBatch.setErrorCode(errorCode);
        if (backupBatch != null) {
            logger.debug("......backupBatch...." + backupBatch.getErrorCode());
            backupBatch.setErrorCode(errorCode);
            logger.debug("......backupBatch...." + backupBatch.getErrorCode());
            mongoTemplate.save((Object)backupBatch);
        }
    }

    @Override
    public RestoreEvents getRestoreEventsByDestUUIDAndFolder(int cloudId, String deviceUUID) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"destinationDeviceUUID").is((Object)deviceUUID)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (RestoreEvents)mongoTemplate.findOne(query, RestoreEvents.class);
    }

    @Override
    public RestoreEvents getRestoreEventsBySourceUUID(int cloudId, String deviceUUID) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"actionOnDeviceUUID").is((Object)deviceUUID)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (RestoreEvents)mongoTemplate.findOne(query, RestoreEvents.class);
    }

    @Override
    public RestoreProgressEvents getRestoreProgressByEvents(int cloudId, String deviceUUID) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICEUUID).is((Object)deviceUUID)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (RestoreProgressEvents)mongoTemplate.findOne(query, RestoreProgressEvents.class);
    }

    @Override
    public void removeRestoreProgress(int cloudId, String deviceUUID) {
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICEUUID).is((Object)deviceUUID)});
        Query query = new Query((CriteriaDefinition)criteria);
        paracloudMongoTemplate.findAndRemove(query, RestoreProgressEvents.class);
    }

    @Override
    public void removeRestoreProgressById(int cloudId, ObjectId id) {
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)id)});
        Query query = new Query((CriteriaDefinition)criteria);
        paracloudMongoTemplate.findAndRemove(query, RestoreProgressEvents.class);
    }

    @Override
    public RestoreProgressEvents getRestoreEventProgressByUUID(int cloudId, String deviceUUID) {
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICEUUID).is((Object)deviceUUID)});
        Query query = new Query((CriteriaDefinition)criteria);
        return (RestoreProgressEvents)paracloudMongoTemplate.findOne(query, RestoreProgressEvents.class);
    }

    @Override
    public void updateBackupBatchForStopRestore(int cloudId, String actionToDeviceUUID, String errorCode) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICEUUID).is((Object)actionToDeviceUUID), Criteria.where((String)JOB_TYPE).is((Object)RESTORE)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{"batchEndTimestamp"}));
        query.limit(1);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        BackupBatch backupBatch = (BackupBatch)mongoTemplate.findOne(query, BackupBatch.class);
        if (backupBatch != null) {
            logger.debug("......backupBatch...." + backupBatch.getErrorCode());
            backupBatch.setStatus("STOPPED");
            backupBatch.setErrorCode(errorCode);
            logger.debug("......backupBatch...." + backupBatch.getErrorCode());
            mongoTemplate.save((Object)backupBatch);
        }
    }

    @Override
    public RestoreEvents getRestoreEventForBatchId(int cloudId, String batchId) {
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)batchId)});
        Query query = new Query((CriteriaDefinition)criteria);
        return (RestoreEvents)paracloudMongoTemplate.findOne(query, RestoreEvents.class);
    }

    @Override
    public void deleteBatchFromOdServer(String deviceUUID, String policyName) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)DEVICEUUID).is((Object)deviceUUID));
        this.msgMongoTemplate.findAndRemove(query, ODBBackupBatch.class, "BACKUP_BATCH_" + policyName.toUpperCase());
    }

    @Override
    public void deleteEventHubForDeviceUUID(int cloudId, String deviceUUID, String action) {
        Criteria andCriteria = new Criteria();
        Criteria criteria = new Criteria();
        criteria.orOperator(new Criteria[]{Criteria.where((String)ACTION).is((Object)"FULL_BACKUP"), Criteria.where((String)ACTION).is((Object)"START_BACKUP"), Criteria.where((String)ACTION).is((Object)"STOP_BACKUP")});
        Criteria devUUIDCriteria = Criteria.where((String)ACTION_TO_DEVICEUUID).is((Object)deviceUUID);
        andCriteria.andOperator(new Criteria[]{devUUIDCriteria, criteria});
        Query query = new Query((CriteriaDefinition)andCriteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        DeleteResult remove = mongoTemplate.remove(query, EventHub.class);
        logger.debug("...removed eventhub.... " + action + "....." + deviceUUID + "......" + remove.getDeletedCount());
    }

    @Override
    public String saveBatchDetails(int cloudId, ODBBackupBatch backupBatch, String policyName, long batchStartTime) {
        backupBatch.setBatchStartTimestamp(batchStartTime);
        ODBBackupBatch batch = (ODBBackupBatch)this.msgMongoTemplate.save((Object)backupBatch, "BACKUP_BATCH_" + policyName.toUpperCase());
        logger.debug(batch + "...dao... " + backupBatch);
        logger.debug("...dao1... " + batch.getId());
        if ("STARTED".equalsIgnoreCase(backupBatch.getStatus())) {
            // empty if block
        }
        return batch.getId().toString();
    }

    @Override
    public void saveBackupBatch(int cloudId, BackupBatch backupBatch) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.save((Object)backupBatch);
    }

    private String getDateInFormat(Long deviceCreatedDate) {
        SimpleDateFormat df2 = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
        Date dateD = new Date(deviceCreatedDate);
        return df2.format(dateD);
    }

    @Override
    public void updateBackupOverview(int cloudId, String string, String deviceUUID, DeviceElement device, BackupBatch backupBatch, int errorCode) {
    }

    long getActualUploadedFiles(String uploadedFiles) {
        if (StringUtils.isEmpty((String)uploadedFiles)) {
            uploadedFiles = "0/0";
        }
        String[] parts = uploadedFiles.split("/");
        return Long.parseLong(parts[0]);
    }

    @Override
    public void updateDeviceBackupOverView(int cloudId, DeviceBackupOverView overView) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.save((Object)overView);
    }

    @Override
    public Long getFirstBackupEndDate(int cloudId, String userName, String deviceUUID) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Long bkpEndTime = null;
        Criteria criteria = new Criteria();
        Criteria criteria1 = new Criteria();
        criteria1.andOperator(new Criteria[]{Criteria.where((String)JOB_TYPE).is((Object)BACK_UP), Criteria.where((String)STATUS).is((Object)COMPLETED)});
        ArrayList<Criteria> list = new ArrayList<Criteria>();
        list.add(criteria1);
        this.addUserNameCriteria(cloudId, userName, list);
        if (!StringUtils.isEmpty((String)deviceUUID)) {
            Criteria criteria4 = Criteria.where((String)DEVICEUUID).is((Object)deviceUUID);
            list.add(criteria4);
        }
        criteria.andOperator(list.toArray(new Criteria[list.size()]));
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.ASC, new String[]{BATCH_START_TIME_STAMP}));
        query.limit(1);
        BackupBatch backupBatch = (BackupBatch)mongoTemplate.findOne(query, BackupBatch.class);
        if (backupBatch != null) {
            bkpEndTime = backupBatch.getBatchEndTimestamp();
        }
        return bkpEndTime;
    }

    private void addUserNameCriteria(int cloudId, String userName, List<Criteria> list) {
        if (!StringUtils.isEmpty((String)userName)) {
            logger.debug(" NEWQUERY to avoid in query ...................");
            if (!StringUtils.isEmpty((String)userName)) {
                Criteria criteria3 = Criteria.where((String)USER_NAME).is((Object)userName);
                list.add(criteria3);
                logger.debug(" NEWQUERY to avoid in query userName..................." + userName);
            }
            logger.debug(" end of NEWQUERY to avoid in query  for backupbatch...................");
        }
    }

    @Override
    public Object[] getBackupDateHistoryElement(int cloudId, String cloudName, String userName, String deviceUUID) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Object[] arr = new Object[7];
        BackupBatch lastSuccessfulBatch = this.getLastSuccessfulWithoutTemplate(cloudId, cloudName, userName, deviceUUID, mongoTemplate);
        arr[0] = lastSuccessfulBatch != null ? Long.valueOf(lastSuccessfulBatch.getBatchEndTimestamp()) : null;
        BackupBatch firstBkpBatch = this.getFirstBackupWithoutTemplate(cloudId, userName, deviceUUID, mongoTemplate);
        arr[1] = firstBkpBatch != null ? Long.valueOf(firstBkpBatch.getBatchStartTimestamp()) : null;
        BackupBatch lastBkpBatch = this.getLastBackupOnlyWithoutTemplate(cloudId, userName, deviceUUID, mongoTemplate);
        if (lastBkpBatch != null) {
            arr[2] = lastBkpBatch.getStatus();
            arr[3] = lastBkpBatch.getErrorCode();
            arr[4] = lastBkpBatch.getBatchStartTimestamp();
            this.setSummaryValues(lastBkpBatch, arr);
        } else {
            arr[2] = null;
            arr[3] = null;
            arr[4] = null;
            arr[5] = new Integer(0);
            arr[6] = new Integer(0);
        }
        return arr;
    }

    private BackupBatch getFirstBackupWithoutTemplate(int cloudId, String userName, String deviceName, MongoTemplate mongoTemplate) {
        Criteria criteria = new Criteria();
        Criteria criteria1 = Criteria.where((String)JOB_TYPE).is((Object)BACK_UP);
        ArrayList<Criteria> list = new ArrayList<Criteria>();
        this.addUserNameCriteria(cloudId, userName, list);
        this.addDeviceNameCriteria(cloudId, deviceName, list);
        list.add(criteria1);
        criteria.andOperator(list.toArray(new Criteria[list.size()]));
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.ASC, new String[]{BATCH_START_TIME_STAMP}));
        query.limit(1);
        return (BackupBatch)mongoTemplate.findOne(query, BackupBatch.class);
    }

    private void addDeviceNameCriteria(int cloudId, String deviceName, List<Criteria> list) {
        if (!StringUtils.isEmpty((String)deviceName)) {
            Criteria criteria4 = Criteria.where((String)"deviceName").is((Object)deviceName);
            list.add(criteria4);
        }
    }

    private Criteria getBackupBatchCriteria(int cloudId, String cloudName, String userName, String deviceName) {
        Criteria criteria = new Criteria();
        Criteria criteria1 = Criteria.where((String)JOB_TYPE).is((Object)BACK_UP);
        Criteria criteria2 = Criteria.where((String)STATUS).is((Object)COMPLETED);
        ArrayList<Criteria> list = new ArrayList<Criteria>();
        this.addUserNameCriteria(cloudId, userName, list);
        this.addDeviceNameCriteria(cloudId, deviceName, list);
        list.add(criteria1);
        list.add(criteria2);
        criteria.andOperator(list.toArray(new Criteria[list.size()]));
        return criteria;
    }

    private BackupBatch getLastSuccessfulWithoutTemplate(int cloudId, String cloudName, String userName, String deviceName, MongoTemplate mongoTemplate) {
        Criteria criteria = this.getBackupBatchCriteria(cloudId, cloudName, userName, deviceName);
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{BATCH_START_TIME_STAMP}));
        query.limit(1);
        List list1 = mongoTemplate.find(query, BackupBatch.class);
        if (!CollectionUtils.isEmpty((Collection)list1)) {
            return (BackupBatch)list1.get(0);
        }
        return null;
    }

    private void setSummaryValues(BackupBatch backupBatch, Object[] arr) {
        Integer totalNoOfFiles = 0;
        Integer noOfFilesRemaining = 0;
        if (backupBatch != null) {
            String uploadedFiles;
            if (!StringUtils.isEmpty((String)backupBatch.getTotalNoOfFiles())) {
                totalNoOfFiles = Integer.parseInt(backupBatch.getTotalNoOfFiles());
            }
            if (StringUtils.isEmpty((String)(uploadedFiles = backupBatch.getUploadedFiles()))) {
                uploadedFiles = "0/" + totalNoOfFiles;
            }
            String[] parts = uploadedFiles.split("/");
            try {
                Integer actualNoOfFiles = Integer.parseInt(parts[1]);
                Integer noOfFilesBackedup = Integer.parseInt(parts[0]);
                noOfFilesRemaining = actualNoOfFiles - noOfFilesBackedup;
            }
            catch (Exception e) {
                logger.trace(" Exception  :" + e);
                logger.error(" Exception  :" + e.getMessage());
            }
        }
        arr[5] = totalNoOfFiles.toString();
        arr[6] = noOfFilesRemaining.toString();
    }

    private BackupBatch getLastBackupOnlyWithoutTemplate(int cloudId, String userName, String deviceUUID, MongoTemplate mongoTemplate) {
        Criteria criteria = new Criteria();
        Criteria criteria1 = Criteria.where((String)JOB_TYPE).is((Object)BACK_UP);
        ArrayList<Criteria> list = new ArrayList<Criteria>();
        if (!StringUtils.isEmpty((String)userName)) {
            Criteria criteria3 = Criteria.where((String)USER_NAME).is((Object)userName);
            list.add(criteria3);
            logger.debug(" user from controller..................." + userName);
        }
        if (!StringUtils.isEmpty((String)deviceUUID)) {
            Criteria criteria4 = Criteria.where((String)DEVICEUUID).is((Object)deviceUUID);
            list.add(criteria4);
            logger.debug("device from controller...");
        }
        list.add(criteria1);
        criteria.andOperator(list.toArray(new Criteria[list.size()]));
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{BATCH_START_TIME_STAMP}));
        query.limit(1);
        return (BackupBatch)mongoTemplate.findOne(query, BackupBatch.class);
    }

    @Override
    public Object[] getCountForJobType(int cloudId, String deviceUUID, String userName) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Object[] arr = new Object[2];
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).is((Object)userName), Criteria.where((String)DEVICEUUID).is((Object)deviceUUID), Criteria.where((String)STATUS).is((Object)COMPLETED)});
        TypedAggregation aggregation = Aggregation.newAggregation(BackupBatch.class, (AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{JOB_TYPE}).count().as(COUNT), Aggregation.project((String[])new String[]{COUNT, JOB_TYPE})});
        AggregationResults result = mongoTemplate.aggregate(aggregation, BasicDBObject.class);
        List stateStatsList = result.getMappedResults();
        for (BasicDBObject dbObject : stateStatsList) {
            String jobType = (String)dbObject.get("_id");
            if (jobType.equalsIgnoreCase(RESTORE)) {
                arr[0] = Long.valueOf(dbObject.get(COUNT).toString());
            }
            if (!jobType.equalsIgnoreCase(BACK_UP)) continue;
            arr[1] = Long.valueOf(dbObject.get(COUNT).toString());
        }
        return arr;
    }

    public BackupBatch getLastBackupOnly(int cloudId, String userName, String deviceUUID) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).is((Object)userName), Criteria.where((String)DEVICEUUID).is((Object)deviceUUID), Criteria.where((String)JOB_TYPE).is((Object)BACK_UP)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{BATCH_START_TIME_STAMP}));
        query.limit(1);
        return (BackupBatch)mongoTemplate.findOne(query, BackupBatch.class);
    }

    @Override
    public void resumeBackup(String policyName, Device device, Cloud cloudFinal) {
        int cloudId = cloudFinal.getCloudId();
        BackupBatch backupBatch = this.getLastBackupOnly(cloudId, device.getUserName(), device.getDeviceUUID());
        ObjectId batchId = backupBatch.getId();
        Criteria criteria = Criteria.where((String)"id").is((Object)batchId);
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set(STATUS, (Object)COMPLETED);
        UpdateResult updateFirst = this.msgMongoTemplate.updateFirst(query, update, ODBBackupBatch.class, "BACKUP_BATCH_" + policyName.toUpperCase());
        logger.debug(updateFirst.getModifiedCount() + "... paused changed to COMPLETED successfully.... " + policyName + "..." + batchId);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        backupBatch.setStatus(BackupBatch.STATUS.STARTED.toString());
        backupBatch.setErrorCode("0");
        mongoTemplate.save((Object)backupBatch);
        BackupAttempt lastBkpAttempt = new BackupAttempt();
        BeanUtils.copyProperties((Object)backupBatch, (Object)lastBkpAttempt);
        lastBkpAttempt.setId(null);
        lastBkpAttempt.setBatchStartTimestamp(System.currentTimeMillis());
        lastBkpAttempt.setErrorCode(backupBatch.getErrorCode());
        lastBkpAttempt.setUploadedSize(backupBatch.getUploadedSize());
        lastBkpAttempt.setStatus(backupBatch.getStatus());
        lastBkpAttempt.setBatchId(backupBatch.getId().toString());
        lastBkpAttempt.setBatchEndTimestamp(System.currentTimeMillis());
        lastBkpAttempt.setUploadedFiles(backupBatch.getUploadedFiles());
        lastBkpAttempt.setUploadedSize(backupBatch.getUploadedSize());
        this.saveBackupAttempt(cloudId, lastBkpAttempt);
    }

    @Override
    public OfficeBackupPolicy getOfficeBackupPolicyForNameAndType(int cloudId, String policyName, String policyType) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"policyName").is((Object)policyName), Criteria.where((String)"policyType").is((Object)policyType)});
        Query query = new Query((CriteriaDefinition)criteria);
        return (OfficeBackupPolicy)mongoTemplate.findOne(query, OfficeBackupPolicy.class);
    }
}

