/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pcbd.dao.impl;

import com.parablu.factory.ParacloudMongoFactoryUtils;
import com.parablu.pcbd.dao.EncryptionKeyDao;
import com.parablu.pcbd.domain.EncryptionKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.util.CollectionUtils;

public class EncryptionKeyDaoImpl
implements EncryptionKeyDao {
    ParacloudMongoFactoryUtils paracloudMongoFactoryUtils;
    private static final String END_TIME_STAMP = "endTimestamp";
    private static final String PRODUCT_TYPE = "productType";

    public ParacloudMongoFactoryUtils getParacloudMongoFactoryUtils() {
        return this.paracloudMongoFactoryUtils;
    }

    public void setParacloudMongoFactoryUtils(ParacloudMongoFactoryUtils paracloudMongoFactoryUtils) {
        this.paracloudMongoFactoryUtils = paracloudMongoFactoryUtils;
    }

    @Override
    public void saveEncryptionKey(int cloudId, EncryptionKey encryptionKey) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        this.getPreviousKeyAndUpdateEndTimeStamp(cloudId, encryptionKey.getProductType());
        encryptionKey.setStartTimestamp(System.currentTimeMillis());
        mongoTemplate.save((Object)encryptionKey);
    }

    public void getPreviousKeyAndUpdateEndTimeStamp(int cloudId, String productType) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)END_TIME_STAMP).is((Object)0), Criteria.where((String)PRODUCT_TYPE).is((Object)productType)});
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set(END_TIME_STAMP, (Object)System.currentTimeMillis());
        mongoTemplate.updateFirst(query, update, EncryptionKey.class);
    }

    @Override
    public List<EncryptionKey> getAllEncryptionKeys(int cloudId, String productType) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)PRODUCT_TYPE).is((Object)productType)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{"startTimestamp"}));
        return mongoTemplate.find(query, EncryptionKey.class);
    }

    @Override
    public EncryptionKey getEncryptionKey(int cloudId, String productType) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)END_TIME_STAMP).is((Object)0), Criteria.where((String)PRODUCT_TYPE).is((Object)productType)});
        Query query = new Query((CriteriaDefinition)criteria);
        return (EncryptionKey)mongoTemplate.findOne(query, EncryptionKey.class);
    }

    @Override
    public EncryptionKey getKeyForDecrypt(int cloudId, long timeStamp, String productType) {
        Criteria criteria = new Criteria();
        ArrayList<Criteria> list = new ArrayList<Criteria>();
        this.addStartAndEndDateBetweenCriteria(timeStamp, list);
        list.add(Criteria.where((String)PRODUCT_TYPE).is((Object)productType));
        criteria.andOperator(list.toArray(new Criteria[list.size()]));
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (EncryptionKey)mongoTemplate.findOne(query, EncryptionKey.class);
    }

    private void addStartAndEndDateBetweenCriteria(Long timeStamp, List<Criteria> list) {
        Criteria criteria2 = Criteria.where((String)"startTimestamp").lte((Object)timeStamp);
        Criteria criteria3 = new Criteria().orOperator(new Criteria[]{Criteria.where((String)END_TIME_STAMP).gte((Object)timeStamp), Criteria.where((String)END_TIME_STAMP).is((Object)0)});
        list.add(criteria2);
        list.add(criteria3);
    }

    @Override
    public List<EncryptionKey> getAllProductEncryptionKeys(int cloudId) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List keys = mongoTemplate.findAll(EncryptionKey.class);
        if (CollectionUtils.isEmpty((Collection)keys)) {
            return null;
        }
        return keys;
    }
}

