/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pcbd.dao.impl;

import com.parablu.factory.ParacloudMongoFactoryUtils;
import com.parablu.factory.ParacloudSessionFactoryUtils;
import com.parablu.pcbd.dao.DeviceCrawlHistoryDao;
import com.parablu.pcbd.domain.BackupBatch;
import com.parablu.pcbd.domain.DeviceCrawlHistory;
import java.util.Collection;
import java.util.List;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.util.CollectionUtils;

public class DeviceCrawlHistoryDaoImpl
implements DeviceCrawlHistoryDao {
    ParacloudSessionFactoryUtils paracloudSessionFactoryUtils;
    ParacloudMongoFactoryUtils paracloudMongoFactoryUtils;
    private static final String REG_ID = "regID";
    private static final String MINI_CLOUD_ID = "miniCloudId";
    private static final String SERVER_CRAWL_TIME = "serverCrawlTime";

    public ParacloudSessionFactoryUtils getParacloudSessionFactoryUtils() {
        return this.paracloudSessionFactoryUtils;
    }

    public void setParacloudSessionFactoryUtils(ParacloudSessionFactoryUtils paracloudSessionFactoryUtils) {
        this.paracloudSessionFactoryUtils = paracloudSessionFactoryUtils;
    }

    public ParacloudMongoFactoryUtils getParacloudMongoFactoryUtils() {
        return this.paracloudMongoFactoryUtils;
    }

    public void setParacloudMongoFactoryUtils(ParacloudMongoFactoryUtils paracloudMongoFactoryUtils) {
        this.paracloudMongoFactoryUtils = paracloudMongoFactoryUtils;
    }

    @Override
    public void registerDeviceForCrawl(int cloudId, String cloudName, DeviceCrawlHistory dch) {
        this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).save((Object)dch);
    }

    @Override
    public DeviceCrawlHistory getServerDetailsForTimeStamp(int cloudId, String cloudName, String crawlTime, String regID, String miniCloudId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)REG_ID).is((Object)regID), Criteria.where((String)MINI_CLOUD_ID).is((Object)miniCloudId), Criteria.where((String)"clientCrawlTime").is((Object)crawlTime)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{SERVER_CRAWL_TIME}));
        query.limit(1);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (DeviceCrawlHistory)mongoTemplate.findOne(query, DeviceCrawlHistory.class);
    }

    @Override
    public DeviceCrawlHistory getServerLastCrawlServerTimeStampForRegID(int cloudId, String cloudName, String regID, int miniCloudId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)REG_ID).is((Object)regID), Criteria.where((String)MINI_CLOUD_ID).is((Object)miniCloudId)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{SERVER_CRAWL_TIME}));
        query.limit(1);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (DeviceCrawlHistory)mongoTemplate.findOne(query, DeviceCrawlHistory.class);
    }

    @Override
    public long getCrawlRequestCountSinceTimeStamp(int cloudId, String cloudName, long prevTimeStamp) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)SERVER_CRAWL_TIME).gt((Object)"prevTimeStamp")});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.count(query, BackupBatch.class);
    }

    @Override
    public DeviceCrawlHistory getLastServerDetailExcludingCurrentTimeStamp(int cloudId, String cloudName, long serverTimeStamp, String devUUID, String miniCloudId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)REG_ID).is((Object)devUUID), Criteria.where((String)MINI_CLOUD_ID).is((Object)miniCloudId), Criteria.where((String)SERVER_CRAWL_TIME).ne((Object)serverTimeStamp)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.ASC, new String[]{SERVER_CRAWL_TIME}));
        query.limit(1);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (DeviceCrawlHistory)mongoTemplate.findOne(query, DeviceCrawlHistory.class);
    }

    @Override
    public Long getLatestServerCrawlTimestamp(int cloudId, String cloudName) {
        Query query = new Query();
        query.with(new Sort(Sort.Direction.DESC, new String[]{SERVER_CRAWL_TIME}));
        query.limit(1);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List dchList = mongoTemplate.find(query, DeviceCrawlHistory.class);
        if (!CollectionUtils.isEmpty((Collection)dchList)) {
            DeviceCrawlHistory dch = (DeviceCrawlHistory)dchList.get(0);
            return dch.getServerCrawlTime();
        }
        return null;
    }
}

