/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pcbd.dao.impl;

import com.parablu.factory.ParacloudMongoFactoryUtils;
import com.parablu.pcbd.dao.DailyUserBackupOverviewDao;
import com.parablu.pcbd.domain.DailyUserBackupOverView;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class DailyUserBackupOverviewDaoImpl
implements DailyUserBackupOverviewDao {
    Logger logger = LogManager.getLogger(DailyUserBackupOverviewDaoImpl.class);
    ParacloudMongoFactoryUtils paracloudMongoFactoryUtils;
    private static final String STORAGE_DATE = "storageDate";

    public ParacloudMongoFactoryUtils getParacloudMongoFactoryUtils() {
        return this.paracloudMongoFactoryUtils;
    }

    public void setParacloudMongoFactoryUtils(ParacloudMongoFactoryUtils paracloudMongoFactoryUtils) {
        this.paracloudMongoFactoryUtils = paracloudMongoFactoryUtils;
    }

    @Override
    public List<DailyUserBackupOverView> getDailyUserBackupOverview(int cloudId, List<String> userNameList) {
        Criteria criteria = new Criteria();
        List<DailyUserBackupOverView> list = new ArrayList<DailyUserBackupOverView>();
        if (!CollectionUtils.isEmpty(userNameList)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)"userName").in(userNameList)});
            this.logger.debug(userNameList.size() + " ...usersize ....");
            Query query = new Query((CriteriaDefinition)criteria);
            query.with(new Sort(Sort.Direction.DESC, new String[]{STORAGE_DATE}));
            MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
            list = mongoTemplate.find(query, DailyUserBackupOverView.class);
            this.logger.debug("total overviews count ................. " + list.size());
        }
        return list;
    }

    @Override
    public void deleteDailyUserBackupOverviewByUserName(int cloudId, String userName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"userName").is((Object)userName)});
        this.logger.debug("Deleting Daily UserBackupOverView for User Name :" + userName);
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.remove(query, DailyUserBackupOverView.class);
    }

    @Override
    public void deleteDailyUserBackupOverviewByDeviceUUID(int cloudId, String deviceUUID) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceUUID").is((Object)deviceUUID)});
        this.logger.debug("Deleting Daily UserBackupOverView for DeviceUUID :" + deviceUUID);
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.remove(query, DailyUserBackupOverView.class);
    }

    @Override
    public List<DailyUserBackupOverView> getDailyUserAndDeviceBackupOverview(int cloudId, String userName, String deviceUUID) {
        Criteria criteria = new Criteria();
        if (!StringUtils.isEmpty((Object)userName)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)"userName").regex(Pattern.compile("^" + userName + "$", 2))});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceUUID").is((Object)deviceUUID)});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List list = mongoTemplate.find(query, DailyUserBackupOverView.class);
        this.logger.debug("total overviews count ................. " + list.size());
        return list;
    }

    @Override
    public List<DailyUserBackupOverView> getDailyUserBackupOverview(int cloudId, String userName) {
        Criteria criteria = new Criteria();
        List<DailyUserBackupOverView> list = new ArrayList<DailyUserBackupOverView>();
        if (!StringUtils.isEmpty((Object)userName)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)"userName").is((Object)userName)});
            this.logger.debug(userName + " ...user ....");
            Query query = new Query((CriteriaDefinition)criteria);
            query.with(new Sort(Sort.Direction.DESC, new String[]{STORAGE_DATE}));
            MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
            list = mongoTemplate.find(query, DailyUserBackupOverView.class);
            this.logger.debug("total overviews count ................. " + list.size());
        }
        return list;
    }
}

