/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pcbd.dao.impl;

import com.parablu.factory.ParacloudMongoFactoryUtils;
import com.parablu.pcbd.dao.CrawlStatusDAO;
import com.parablu.pcbd.domain.CrawlStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;

public class CrawlStatusDAOImpl
implements CrawlStatusDAO {
    Logger logger = LoggerFactory.getLogger(CrawlStatusDAOImpl.class);
    ParacloudMongoFactoryUtils paracloudMongoFactoryUtils;
    public static final String CRAWL_STATUS_TIMESTAMP = "crawlStatusTimestamp";

    public ParacloudMongoFactoryUtils getParacloudMongoFactoryUtils() {
        return this.paracloudMongoFactoryUtils;
    }

    public void setParacloudMongoFactoryUtils(ParacloudMongoFactoryUtils paracloudMongoFactoryUtils) {
        this.paracloudMongoFactoryUtils = paracloudMongoFactoryUtils;
    }

    @Override
    public String getCrawlStatus(int cloudId, String cloudName, String pollId) {
        String status = null;
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"pollId").is((Object)pollId)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        CrawlStatus crawlStatus = (CrawlStatus)mongoTemplate.findOne(query, CrawlStatus.class);
        if (crawlStatus != null) {
            status = crawlStatus.getStatus();
        }
        return status;
    }

    @Override
    public void saveCrawlStatusToDB(int cloudId, String cloudName, CrawlStatus crawlStatus) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.save((Object)crawlStatus);
    }

    @Override
    public CrawlStatus getCrawlResult(int cloudId, String cloudName, String pollId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"pollId").is((Object)pollId)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (CrawlStatus)mongoTemplate.findOne(query, CrawlStatus.class);
    }

    @Override
    public void deleteCrawlStatusListBeforeTimestamp(int cloudId, long timestamp) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)CRAWL_STATUS_TIMESTAMP).lt((Object)timestamp)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.remove(query, CrawlStatus.class);
    }
}

