/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pcbd.dao.impl;

import com.parablu.pcbd.dao.ComputerDao;
import com.parablu.pcbd.domain.Computer;
import java.util.List;
import java.util.Map;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NamingException;
import javax.naming.ldap.LdapName;
import org.springframework.ldap.core.ContextMapper;
import org.springframework.ldap.core.DirContextAdapter;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.ldap.core.DistinguishedName;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.core.NameClassPairMapper;
import org.springframework.ldap.core.support.AbstractContextMapper;
import org.springframework.ldap.core.support.BaseLdapNameAware;
import org.springframework.ldap.filter.AndFilter;
import org.springframework.ldap.filter.EqualsFilter;
import org.springframework.ldap.filter.Filter;
import org.springframework.ldap.filter.WhitespaceWildcardsFilter;
import org.springframework.ldap.support.LdapUtils;

public class ComputerDaoImpl
implements ComputerDao,
BaseLdapNameAware {
    private static final LdapName DEVICES_OU = LdapUtils.newLdapName((String)"ou=Devices");
    private LdapTemplate ldapTemplate;

    public void setLdapTemplate(LdapTemplate ldapTemplate) {
        this.ldapTemplate = ldapTemplate;
    }

    @Override
    public void create(Computer computer) {
        DirContextAdapter context = new DirContextAdapter(this.buildDn(computer));
        this.mapToContext(computer, (DirContextOperations)context);
        this.ldapTemplate.bind((DirContextOperations)context);
    }

    @Override
    public List<Computer> findByName(String name) {
        AndFilter filter = new AndFilter();
        filter.and((Filter)new EqualsFilter("objectclass", "computer")).and((Filter)new WhitespaceWildcardsFilter("cn", name));
        return this.ldapTemplate.search((Name)DistinguishedName.EMPTY_PATH, filter.encode(), this.getContextMapper());
    }

    @Override
    public List<Computer> findAll() {
        return this.ldapTemplate.list((Name)DEVICES_OU, (NameClassPairMapper)new OuValueNameClassPairMapper());
    }

    public void setBaseLdapPath(LdapName baseLdapPath) {
    }

    protected ContextMapper getContextMapper() {
        return new ComputerContextMapper();
    }

    protected Name buildDn(Computer computer) {
        return this.buildDn(computer.getComputerName(), computer.getOsName());
    }

    protected Name buildDn(String computerName, String osName) {
        DistinguishedName dn = new DistinguishedName();
        dn.add("cn", computerName);
        return dn;
    }

    protected void mapToContext(Computer computer, DirContextOperations context) {
        context.setAttributeValues("objectclass", (Object[])new String[]{"top", "computer"});
        context.setAttributeValue("cn", (Object)computer.getComputerName());
    }

    @Override
    public List<String> getAllPersonNames() {
        return null;
    }

    @Override
    public Map<String, List<String>> getDevicesMap() {
        return null;
    }

    private static class OuValueNameClassPairMapper
    implements NameClassPairMapper<Computer> {
        private OuValueNameClassPairMapper() {
        }

        public Computer mapFromNameClassPair(NameClassPair nameClassPair) throws NamingException {
            Computer computer = new Computer();
            LdapName name = LdapUtils.newLdapName((String)nameClassPair.getName());
            computer.setComputerName(LdapUtils.getStringValue((Name)name, (String)"cn"));
            return computer;
        }
    }

    private static class ComputerContextMapper
    extends AbstractContextMapper<Computer> {
        private ComputerContextMapper() {
        }

        public Computer doMapFromContext(DirContextOperations context) {
            Computer computer = new Computer();
            computer.setComputerName(context.getStringAttribute("cn"));
            return computer;
        }
    }
}

