/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pcbd.dao.impl;

import com.parablu.factory.ParacloudMongoFactoryUtils;
import com.parablu.pcbd.dao.ComponentDao;
import com.parablu.pcbd.domain.BluVault;
import com.parablu.pcbd.domain.Components;
import com.parablu.pcbd.domain.MSAppSetting;
import com.parablu.pcbd.domain.PrivacyGateway;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.util.StringUtils;

public class ComponentDaoImpl
implements ComponentDao {
    private static Logger logger = LogManager.getLogger(ComponentDaoImpl.class);
    ParacloudMongoFactoryUtils paracloudMongoFactoryUtils;
    private static final String COMPONENT_NAME = "componentName";

    public ParacloudMongoFactoryUtils getParacloudMongoFactoryUtils() {
        return this.paracloudMongoFactoryUtils;
    }

    public void setParacloudMongoFactoryUtils(ParacloudMongoFactoryUtils paracloudMongoFactoryUtils) {
        this.paracloudMongoFactoryUtils = paracloudMongoFactoryUtils;
    }

    @Override
    public Components getComponentProperties(String componetName, int cloudId) {
        Criteria criteria = Criteria.where((String)"bluVaultName").is((Object)componetName);
        Query query = new Query((CriteriaDefinition)criteria);
        logger.debug("BluVault Name" + componetName);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        BluVault bluvalut = (BluVault)mongoTemplate.findOne(query, BluVault.class);
        Components components = new Components();
        if (!StringUtils.isEmpty((Object)bluvalut)) {
            components.setComponentName(componetName);
            components.setComponentsProperties(bluvalut.getComponentsProperties());
        }
        return components;
    }

    @Override
    public void updateComponentProperties(Components components, int cloudId) {
        Criteria criteria = Criteria.where((String)COMPONENT_NAME).is((Object)components.getComponentName());
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("componentsProperties", components.getComponentsProperties());
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.updateFirst(query, update, Components.class);
    }

    @Override
    public void saveComponentProperties(Components components, int cloudId) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.save((Object)components);
    }

    @Override
    public MSAppSetting getMSAppSettingsDetails(int cloudId) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (MSAppSetting)mongoTemplate.findOne(new Query(), MSAppSetting.class);
    }

    @Override
    public Components getPrivacyGatewayComponents(int cloudId) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").exists(true));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        PrivacyGateway privacyGateway = (PrivacyGateway)mongoTemplate.findOne(query, PrivacyGateway.class);
        Components components = new Components();
        if (!StringUtils.isEmpty((Object)privacyGateway)) {
            components.setComponentName(privacyGateway.getGatewayName());
            components.setComponentsProperties(privacyGateway.getComponentsProperties());
        }
        return components;
    }
}

