/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pcbd.dao.impl;

import com.mongodb.BasicDBObject;
import com.mongodb.ReadPreference;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.Filters;
import com.parablu.factory.ParacloudMongoFactoryUtils;
import com.parablu.factory.ParacloudSessionFactoryUtils;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.paracloud.element.BackupOverviewElement;
import com.parablu.pcbd.dao.BackupBatchDao;
import com.parablu.pcbd.domain.ArchiveBackupBatch;
import com.parablu.pcbd.domain.BackupAttempt;
import com.parablu.pcbd.domain.BackupBatch;
import com.parablu.pcbd.domain.BackupLog;
import com.parablu.pcbd.domain.BackupOverView;
import com.parablu.pcbd.domain.BackupPolicy;
import com.parablu.pcbd.domain.CPBackupBatch;
import com.parablu.pcbd.domain.DeleteRestoreBatch;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.DeviceBackupOverView;
import com.parablu.pcbd.domain.OfficeBackupPolicy;
import com.parablu.pcbd.domain.RestoreHistory;
import com.parablu.pcbd.domain.RwSampleFileInfo;
import com.parablu.pcbd.domain.RwSampleFileInfoNames;
import com.parablu.pcbd.domain.User;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.springframework.beans.BeanUtils;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.aggregation.TypedAggregation;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.util.CollectionUtils;

public class BackupBatchDaoImpl
implements BackupBatchDao {
    public static final String USER_NAME = "userName";
    private static final String STATUS_STARTED = "STARTED";
    private static final String STATUS_FAILED = "FAILED";
    private static final String JOB_TYPE = "jobType";
    private static final String BACK_UP = "BACKUP";
    private static final String STATUS = "status";
    private static final String BATCH_END_TIME_STAMP = "batchEndTimestamp";
    private static final String BATCH_START_TIME_STAMP = "batchStartTimestamp";
    private static final String DEVICEUUID = "deviceUUID";
    private static final String RESTORE = "RESTORE";
    private static final String COMPLETED = "COMPLETED";
    private static final String COUNT = "count";
    private static final String BACKUP_BATCH = "BACKUP_BATCH";
    private static Logger logger = LogManager.getLogger(BackupBatchDaoImpl.class);
    ParacloudSessionFactoryUtils paracloudSessionFactoryUtils;
    ParacloudMongoFactoryUtils paracloudMongoFactoryUtils;

    public ParacloudSessionFactoryUtils getParacloudSessionFactoryUtils() {
        return this.paracloudSessionFactoryUtils;
    }

    public void setParacloudSessionFactoryUtils(ParacloudSessionFactoryUtils paracloudSessionFactoryUtils) {
        this.paracloudSessionFactoryUtils = paracloudSessionFactoryUtils;
    }

    public ParacloudMongoFactoryUtils getParacloudMongoFactoryUtils() {
        return this.paracloudMongoFactoryUtils;
    }

    public void setParacloudMongoFactoryUtils(ParacloudMongoFactoryUtils paracloudMongoFactoryUtils) {
        this.paracloudMongoFactoryUtils = paracloudMongoFactoryUtils;
    }

    @Override
    public void saveBackupBatch(int cloudId, String cloudName, BackupBatch backupBatch) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.save((Object)backupBatch);
    }

    @Override
    public void saveRestoreHistory(int cloudId, String cloudName, RestoreHistory restoreHistory) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.save((Object)restoreHistory);
    }

    @Override
    public void saveArchiveBackupBatch(int cloudId, ArchiveBackupBatch archiveBackupBatch) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.save((Object)archiveBackupBatch);
    }

    @Override
    public BackupBatch getBackupBatch(int cloudId, String cloudName, String backupBatchId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)backupBatchId)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.limit(1);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List backupBatchList = mongoTemplate.find(query, BackupBatch.class);
        if (!CollectionUtils.isEmpty((Collection)backupBatchList)) {
            return (BackupBatch)backupBatchList.get(0);
        }
        return null;
    }

    @Override
    public List<BackupBatch> getAllBackupBatch(int cloudId, String cloudName) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.findAll(BackupBatch.class);
    }

    @Override
    public List<BackupBatch> getAllBackupBatchForStatus(int cloudId, String status, int skipValue) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)JOB_TYPE).is((Object)BACK_UP), Criteria.where((String)STATUS).is((Object)status)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.limit(PCHelperConstant.getReportDisplayRecords());
        logger.debug(" SKIP VALUE .... " + skipValue);
        query.with(new Sort(Sort.Direction.DESC, new String[]{BATCH_END_TIME_STAMP}));
        if (skipValue != 0) {
            query.skip((long)(skipValue * PCHelperConstant.getReportDisplayRecords()));
        }
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, BackupBatch.class);
    }

    @Override
    public List<BackupBatch> getAllBackupBatchForStatus(int cloudId, String status, String status1, int skipValue, String searchValue) {
        Criteria criteria1 = new Criteria();
        Criteria criteria = new Criteria();
        criteria1.orOperator(new Criteria[]{Criteria.where((String)STATUS).is((Object)status), Criteria.where((String)STATUS).is((Object)status1), Criteria.where((String)STATUS).is((Object)BackupBatch.STATUS.QUEUED.toString())});
        criteria.andOperator(new Criteria[]{Criteria.where((String)JOB_TYPE).is((Object)BACK_UP), criteria1});
        if (!StringUtils.isEmpty((String)searchValue)) {
            Criteria userOrDeviceName = new Criteria();
            userOrDeviceName.orOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex(Pattern.compile("^" + searchValue, 2)), Criteria.where((String)"deviceName").regex(Pattern.compile("^" + searchValue, 2))});
            criteria1 = new Criteria();
            criteria1 = criteria;
            criteria = new Criteria();
            criteria.andOperator(new Criteria[]{criteria1, userOrDeviceName});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        logger.debug(searchValue + " SKIP VALUE .... " + skipValue);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, BackupBatch.class);
    }

    @Override
    public List<CPBackupBatch> getAllCapacityBackupBatchForStatus(int cloudId, String status, String searchValue, String productType) {
        Criteria criteria = new Criteria();
        Query query = new Query((CriteriaDefinition)criteria);
        Criteria orcriteria = new Criteria();
        orcriteria.orOperator(new Criteria[]{Criteria.where((String)STATUS).is((Object)status), Criteria.where((String)STATUS).is((Object)"PAUSED")});
        logger.debug("....product Type....." + productType);
        if (PCHelperConstant.PARABLU_PRODUCT_TYPE.EXCHANGE.getProductType().equalsIgnoreCase(productType)) {
            criteria.andOperator(new Criteria[]{orcriteria, Criteria.where((String)"productType").is((Object)Device.TYPE.OUTLOOK.name())});
        } else if (PCHelperConstant.PARABLU_PRODUCT_TYPE.ODB.getProductType().equalsIgnoreCase(productType)) {
            criteria.andOperator(new Criteria[]{orcriteria, Criteria.where((String)"productType").is((Object)Device.TYPE.ONEDRIVE.name())});
        } else if (PCHelperConstant.PARABLU_PRODUCT_TYPE.SHAREPOINT.getProductType().equalsIgnoreCase(productType)) {
            criteria.andOperator(new Criteria[]{orcriteria, Criteria.where((String)"productType").is((Object)Device.TYPE.SHAREPOINT.name())});
        }
        logger.debug(status + "producttype...." + productType);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, CPBackupBatch.class);
    }

    @Override
    public List<BackupBatch> getAllRestoreBackupBatchForStatus(int cloudId, String status, int skipValue) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)JOB_TYPE).is((Object)RESTORE), Criteria.where((String)STATUS).is((Object)status)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.limit(PCHelperConstant.getReportDisplayRecords());
        logger.debug(" SKIP VALUE .... " + skipValue);
        if (skipValue != 0) {
            query.skip((long)(skipValue * PCHelperConstant.getReportDisplayRecords()));
        }
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, BackupBatch.class);
    }

    @Override
    public long getAllBackupBatchCountForStatus(int cloudId, String status, String otherStatus) {
        Criteria criteria1 = new Criteria();
        Criteria criteria = new Criteria();
        criteria1.orOperator(new Criteria[]{Criteria.where((String)STATUS).is((Object)status), Criteria.where((String)STATUS).is((Object)otherStatus)});
        criteria.andOperator(new Criteria[]{Criteria.where((String)JOB_TYPE).is((Object)BACK_UP), criteria1});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.count(query, BackupBatch.class);
    }

    @Override
    public long getAllRestoreCountForStatus(int cloudId, String status) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)JOB_TYPE).is((Object)RESTORE), Criteria.where((String)STATUS).is((Object)status)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.limit(PCHelperConstant.getReportDisplayRecords());
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.count(query, BackupBatch.class);
    }

    @Override
    public List<BackupBatch> getAllBackupBatchForStatus(int cloudId, String status, String otherStatus) {
        Criteria criteria1 = new Criteria();
        Criteria criteria = new Criteria();
        criteria1.orOperator(new Criteria[]{Criteria.where((String)STATUS).is((Object)status), Criteria.where((String)STATUS).is((Object)otherStatus)});
        criteria.andOperator(new Criteria[]{Criteria.where((String)JOB_TYPE).is((Object)BACK_UP), criteria1});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, BackupBatch.class);
    }

    @Override
    public List<BackupBatch> getAllBackupBatchForStatus(int cloudId, String status, Long fromDate, Long endDate, String userName, String deviceName, int skipValue) {
        Criteria criteria = new Criteria();
        Criteria criteria1 = Criteria.where((String)JOB_TYPE).is((Object)BACK_UP);
        Criteria criteria2 = new Criteria();
        ArrayList<Criteria> list = new ArrayList<Criteria>();
        this.addUserNameCriteria(cloudId, userName, list);
        this.addDeviceNameCriteria(cloudId, deviceName, list);
        list.add(criteria1);
        this.addStartDateAndEndDateBetweenCriteria(fromDate, endDate, list);
        criteria2 = STATUS_FAILED.equalsIgnoreCase(status) ? Criteria.where((String)STATUS).is((Object)"INTERRUPTED") : Criteria.where((String)STATUS).is((Object)status);
        list.add(criteria2);
        criteria.andOperator(list.toArray(new Criteria[list.size()]));
        boolean limit = false;
        if (StringUtils.isEmpty((String)userName) && StringUtils.isEmpty((String)deviceName)) {
            limit = true;
        }
        return this.getListOfBackupBatch(cloudId, criteria, skipValue, true);
    }

    @Override
    public List<BackupBatch> getAllBackupBatchForStatus(int cloudId, String status, Long fromDate, Long endDate, List<String> userNames, String deviceName, int skipValue) {
        Criteria criteria = new Criteria();
        Criteria criteria1 = Criteria.where((String)JOB_TYPE).is((Object)BACK_UP);
        Criteria criteria2 = new Criteria();
        ArrayList<Criteria> list = new ArrayList<Criteria>();
        this.addUserListNamesCriteria(cloudId, userNames, list);
        this.addDeviceNameCriteria(cloudId, deviceName, list);
        list.add(criteria1);
        this.addStartDateAndEndDateBetweenCriteria(fromDate, endDate, list);
        criteria2 = STATUS_FAILED.equalsIgnoreCase(status) ? Criteria.where((String)STATUS).is((Object)"INTERRUPTED") : Criteria.where((String)STATUS).is((Object)status);
        list.add(criteria2);
        criteria.andOperator(list.toArray(new Criteria[list.size()]));
        boolean limit = false;
        if (CollectionUtils.isEmpty(userNames) && StringUtils.isEmpty((String)deviceName)) {
            limit = true;
        }
        return this.getListOfBackupBatch(cloudId, criteria, skipValue, true);
    }

    @Override
    public long getBackupBatchCountForStatus(int cloudId, String status, Long fromDate, Long endDate, String userName, String deviceName) {
        Criteria criteria = new Criteria();
        Criteria criteria1 = Criteria.where((String)JOB_TYPE).is((Object)BACK_UP);
        Criteria criteria2 = new Criteria();
        ArrayList<Criteria> list = new ArrayList<Criteria>();
        this.addUserNameCriteria(cloudId, userName, list);
        this.addDeviceNameCriteria(cloudId, deviceName, list);
        list.add(criteria1);
        this.addStartDateAndEndDateBetweenCriteria(fromDate, endDate, list);
        criteria2 = STATUS_FAILED.equalsIgnoreCase(status) ? Criteria.where((String)STATUS).is((Object)"INTERRUPTED") : Criteria.where((String)STATUS).is((Object)status);
        list.add(criteria2);
        criteria.andOperator(list.toArray(new Criteria[list.size()]));
        return this.getCountOfBackupBatch(cloudId, criteria);
    }

    private List<BackupBatch> getListOfBackupBatch(int cloudId, Criteria criteria, int skipValue, boolean limit) {
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{BATCH_END_TIME_STAMP}));
        if (limit) {
            query.limit(PCHelperConstant.getReportDisplayRecords());
            if (skipValue != 0) {
                query.skip((long)(skipValue * PCHelperConstant.getReportDisplayRecords()));
            }
        }
        logger.debug("query.....find." + query.toString());
        logger.debug("criteria...find..." + criteria.toString());
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, BackupBatch.class);
    }

    private List<BackupAttempt> getListOfBackupAttempt(int cloudId, Criteria criteria, int skipValue, boolean limit) {
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{BATCH_END_TIME_STAMP}));
        if (limit) {
            query.limit(PCHelperConstant.getReportDisplayRecords());
        }
        if (skipValue != 0) {
            query.skip((long)(skipValue * PCHelperConstant.getReportDisplayRecords()));
        }
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, BackupAttempt.class);
    }

    private long getCountOfBackupBatch(int cloudId, Criteria criteria) {
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{BATCH_END_TIME_STAMP}));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        logger.debug("query.....count." + query.toString());
        logger.debug("criteria...count..." + criteria.toString());
        return mongoTemplate.count(query, BackupBatch.class);
    }

    private List<BackupBatch> getListOfBackupBatch(int cloudId, Criteria criteria) {
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{BATCH_END_TIME_STAMP}));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, BackupBatch.class);
    }

    private void addStartAndEndDateBetweenCriteria(Long fromDate, Long endDate, List<Criteria> list) {
        Criteria criteria5 = Criteria.where((String)BATCH_START_TIME_STAMP).gte((Object)fromDate);
        Criteria criteria6 = Criteria.where((String)BATCH_START_TIME_STAMP).lte((Object)endDate);
        list.add(criteria5);
        list.add(criteria6);
        Criteria criteria7 = Criteria.where((String)BATCH_END_TIME_STAMP).gte((Object)fromDate);
        Criteria criteria8 = Criteria.where((String)BATCH_END_TIME_STAMP).lte((Object)endDate);
        list.add(criteria7);
        list.add(criteria8);
    }

    private void addStartOrEndDateBetweenCriteria(Long fromDate, Long endDate, List<Criteria> list) {
        Criteria criteria5 = Criteria.where((String)BATCH_START_TIME_STAMP).gte((Object)fromDate);
        Criteria criteria6 = Criteria.where((String)BATCH_START_TIME_STAMP).lte((Object)endDate);
        Criteria criteria7 = new Criteria();
        criteria7.andOperator(new Criteria[]{criteria5, criteria6});
        Criteria criteria8 = Criteria.where((String)BATCH_END_TIME_STAMP).gte((Object)fromDate);
        Criteria criteria9 = Criteria.where((String)BATCH_END_TIME_STAMP).lte((Object)endDate);
        Criteria criteria10 = new Criteria();
        criteria10.andOperator(new Criteria[]{criteria8, criteria9});
        Criteria criteria11 = new Criteria();
        criteria11.orOperator(new Criteria[]{criteria7, criteria10});
        list.add(criteria11);
    }

    private void addDeviceNameCriteria(int cloudId, String deviceName, List<Criteria> list) {
        if (!StringUtils.isEmpty((String)deviceName)) {
            Criteria criteria4 = Criteria.where((String)"deviceName").is((Object)deviceName);
            list.add(criteria4);
        }
    }

    private Criteria addCurrentRunningBackups(int cloudId, List<Criteria> list) {
        Criteria criteria12 = Criteria.where((String)STATUS).is((Object)STATUS_STARTED);
        list.add(criteria12);
        return criteria12;
    }

    @Override
    public List<BackupBatch> getAllBackupBatch(int cloudId, String userName, String deviceName, Long fromDate, Long endDate) {
        Criteria criteria = new Criteria();
        Criteria criteria2 = Criteria.where((String)JOB_TYPE).is((Object)BACK_UP);
        ArrayList<Criteria> list = new ArrayList<Criteria>();
        this.addUserNameCriteria(cloudId, userName, list);
        this.addDeviceNameCriteria(cloudId, deviceName, list);
        list.add(criteria2);
        this.addStartDateAndEndDateBetweenCriteria(fromDate, endDate, list);
        criteria.andOperator(list.toArray(new Criteria[list.size()]));
        return this.getListOfBackupBatch(cloudId, criteria, 0, false);
    }

    @Override
    public List<BackupAttempt> getAllBackupAttempt(int cloudId, String userName, String deviceName, Long fromDate, Long endDate) {
        Criteria criteria = new Criteria();
        Criteria criteria2 = Criteria.where((String)JOB_TYPE).is((Object)BACK_UP);
        ArrayList<Criteria> list = new ArrayList<Criteria>();
        this.addUserNameCriteria(cloudId, userName, list);
        this.addDeviceNameCriteria(cloudId, deviceName, list);
        list.add(criteria2);
        this.addStartDateAndEndDateBetweenCriteria(fromDate, endDate, list);
        criteria.andOperator(list.toArray(new Criteria[list.size()]));
        return this.getListOfBackupAttempt(cloudId, criteria, 0, false);
    }

    private void addUserNameCriteria(int cloudId, String userName, List<Criteria> list) {
        if (!StringUtils.isEmpty((String)userName) && !StringUtils.isEmpty((String)userName)) {
            Criteria criteria3 = Criteria.where((String)USER_NAME).is((Object)userName);
            list.add(criteria3);
        }
    }

    private void addUserListNamesCriteria(int cloudId, List<String> userNames, List<Criteria> list) {
        if (!CollectionUtils.isEmpty(userNames)) {
            Criteria criteria3 = Criteria.where((String)USER_NAME).in(userNames);
            list.add(criteria3);
        }
    }

    @Override
    public List<BackupBatch> getAllBackupBatchForJobType(int cloudId, String cloudName, String deviceName, String jobType, String status) {
        ArrayList<Criteria> list = new ArrayList<Criteria>();
        Criteria criteria = new Criteria();
        this.addDeviceNameCriteria(cloudId, deviceName, list);
        Criteria criteria2 = Criteria.where((String)JOB_TYPE).is((Object)jobType);
        list.add(criteria2);
        if (StringUtils.isEmpty((String)status)) {
            Criteria criteria1 = Criteria.where((String)STATUS).is((Object)status);
            list.add(criteria1);
        }
        criteria.andOperator(list.toArray(new Criteria[list.size()]));
        return this.getListOfBackupBatch(cloudId, criteria);
    }

    @Override
    public long getCountBackupBatchForJobType(int cloudId, String cloudName, String deviceName, String jobType, String status) {
        ArrayList<Criteria> list = new ArrayList<Criteria>();
        Criteria criteria = new Criteria();
        this.addDeviceNameCriteria(cloudId, deviceName, list);
        Criteria criteria2 = Criteria.where((String)JOB_TYPE).is((Object)jobType);
        list.add(criteria2);
        if (StringUtils.isEmpty((String)status)) {
            Criteria criteria1 = Criteria.where((String)STATUS).is((Object)status);
            list.add(criteria1);
        }
        criteria.andOperator(list.toArray(new Criteria[list.size()]));
        return this.getCountOfBackupBatch(cloudId, criteria);
    }

    @Override
    public List<BackupBatch> getAllBackupBatchForJobType(int cloudId, String deviceName, String userName, String jobType, String status, Long fromDate, Long endDate, int skipValue) {
        Criteria criteria = new Criteria();
        Criteria criteria1 = Criteria.where((String)JOB_TYPE).is((Object)jobType);
        ArrayList<Criteria> list = new ArrayList<Criteria>();
        this.addUserNameCriteria(cloudId, userName, list);
        this.addDeviceNameCriteria(cloudId, deviceName, list);
        list.add(criteria1);
        if (!StringUtils.isEmpty((String)status)) {
            Criteria criteria2 = Criteria.where((String)STATUS).is((Object)status);
            list.add(criteria2);
        }
        boolean limit = false;
        if (StringUtils.isEmpty((String)userName) && StringUtils.isEmpty((String)deviceName)) {
            limit = true;
        }
        this.addStartAndEndDateBetweenCriteria(fromDate, endDate, list);
        criteria.andOperator(list.toArray(new Criteria[list.size()]));
        return this.getListOfBackupBatch(cloudId, criteria, skipValue, true);
    }

    @Override
    public long getCountBackupBatchForJobType(int cloudId, String deviceName, String userName, String jobType, String status, Long fromDate, Long endDate) {
        Criteria criteria = new Criteria();
        Criteria criteria1 = Criteria.where((String)JOB_TYPE).is((Object)jobType);
        ArrayList<Criteria> list = new ArrayList<Criteria>();
        this.addUserNameCriteria(cloudId, userName, list);
        this.addDeviceNameCriteria(cloudId, deviceName, list);
        list.add(criteria1);
        if (!StringUtils.isEmpty((String)status)) {
            Criteria criteria2 = Criteria.where((String)STATUS).is((Object)status);
            list.add(criteria2);
        }
        this.addStartAndEndDateBetweenCriteria(fromDate, endDate, list);
        criteria.andOperator(list.toArray(new Criteria[list.size()]));
        return this.getCountOfBackupBatch(cloudId, criteria);
    }

    @Override
    public Long getNoOfRestoresDone(int cloudId, String cloudName, Long startDate, Long endDate) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return this.getNoOfRestoresDone(mongoTemplate);
    }

    private Long getNoOfRestoresDone(MongoTemplate mongoTemplate) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)JOB_TYPE).is((Object)RESTORE), Criteria.where((String)STATUS).is((Object)COMPLETED)});
        Query query = new Query((CriteriaDefinition)criteria);
        return mongoTemplate.count(query, BackupBatch.class);
    }

    @Override
    public Object[] getCountForJobType(int cloudId, String deviceUUID, String userName) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Object[] arr = new Object[2];
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).is((Object)userName), Criteria.where((String)DEVICEUUID).is((Object)deviceUUID), Criteria.where((String)STATUS).is((Object)COMPLETED)});
        TypedAggregation aggregation = Aggregation.newAggregation(BackupBatch.class, (AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{JOB_TYPE}).count().as(COUNT), Aggregation.project((String[])new String[]{COUNT, JOB_TYPE})});
        AggregationResults result = mongoTemplate.aggregate(aggregation, Document.class);
        List stateStatsList = result.getMappedResults();
        for (Document dbObject : stateStatsList) {
            String jobType = (String)dbObject.get((Object)"_id");
            if (jobType.equalsIgnoreCase(RESTORE)) {
                arr[0] = Long.valueOf(dbObject.get((Object)COUNT).toString());
            }
            if (!jobType.equalsIgnoreCase(BACK_UP)) continue;
            arr[1] = Long.valueOf(dbObject.get((Object)COUNT).toString());
        }
        return arr;
    }

    @Override
    public Long getNoOfBackupsDone(int cloudId, String cloudName, Long startDate, Long endDate) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return this.getNoOfBackupsDone(mongoTemplate);
    }

    private Long getNoOfBackupsDone(MongoTemplate mongoTemplate) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)JOB_TYPE).is((Object)BACK_UP), Criteria.where((String)STATUS).is((Object)COMPLETED)});
        Query query = new Query((CriteriaDefinition)criteria);
        return mongoTemplate.count(query, BackupBatch.class);
    }

    @Override
    public List<BackupBatch> getAllLongBackupBatches(int cloudId, int skipValue) {
        ArrayList<BackupBatch> list = new ArrayList<BackupBatch>();
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        MongoCollection collection = mongoTemplate.getCollection(BACKUP_BATCH);
        Bson searchQuery = Filters.and((Bson[])new Bson[]{Filters.eq((String)"$where", (Object)"new Date().getTime() - this.batchStartTimestamp >= 86400000"), Filters.eq((String)JOB_TYPE, (Object)BACK_UP), Filters.eq((String)STATUS, (Object)STATUS_STARTED)});
        FindIterable find = collection.find(searchQuery);
        MongoCursor cursor = find.iterator();
        if (cursor.hasNext()) {
            Document next = (Document)cursor.next();
            BackupBatch backupBatch = (BackupBatch)mongoTemplate.getConverter().read(BackupBatch.class, (Object)next);
            list.add(backupBatch);
        }
        cursor.close();
        return list;
    }

    @Override
    public List<BackupBatch> getBackupBatchesMoreThanWeek(int cloudId, String cloudName) {
        ArrayList<BackupBatch> list = new ArrayList<BackupBatch>();
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        MongoCollection collection = mongoTemplate.getCollection(BACKUP_BATCH);
        Bson searchQuery = Filters.and((Bson[])new Bson[]{Filters.eq((String)"$where", (Object)"new Date().getTime() - this.batchStartTimestamp >= 604800000"), Filters.eq((String)JOB_TYPE, (Object)BACK_UP)});
        FindIterable find = collection.find(searchQuery);
        MongoCursor cursor = find.iterator();
        if (cursor.hasNext()) {
            Document next = (Document)cursor.next();
            BackupBatch backupBatch = (BackupBatch)mongoTemplate.getConverter().read(BackupBatch.class, (Object)next);
            list.add(backupBatch);
        }
        cursor.close();
        return list;
    }

    @Override
    public List<BackupBatch> getListOfRestoresInitiated(int cloudId, String cloudName, Long startDate, Long endDate) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)JOB_TYPE).is((Object)RESTORE)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, BackupBatch.class);
    }

    @Override
    public List<BackupBatch> getLastBackup(int cloudId, String cloudName, String userName, String deviceName) {
        Criteria criteria = new Criteria();
        Criteria criteria1 = Criteria.where((String)JOB_TYPE).is((Object)BACK_UP);
        Criteria criteria2 = Criteria.where((String)STATUS).is((Object)COMPLETED);
        ArrayList<Criteria> list = new ArrayList<Criteria>();
        this.addUserNameCriteria(cloudId, userName, list);
        this.addDeviceNameCriteria(cloudId, deviceName, list);
        list.add(criteria1);
        list.add(criteria2);
        criteria.andOperator(list.toArray(new Criteria[list.size()]));
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{BATCH_START_TIME_STAMP}));
        query.limit(1);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, BackupBatch.class);
    }

    @Override
    public List<BackupBatch> getLastBackupReport(int cloudId, String cloudName, String userName, String deviceName) {
        Criteria criteria = new Criteria();
        Criteria criteria1 = Criteria.where((String)JOB_TYPE).is((Object)BACK_UP);
        ArrayList<Criteria> list = new ArrayList<Criteria>();
        list.add(criteria1);
        this.addUserNameCriteria(cloudId, userName, list);
        this.addDeviceNameCriteria(cloudId, deviceName, list);
        criteria.andOperator(list.toArray(new Criteria[list.size()]));
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{BATCH_START_TIME_STAMP}));
        query.limit(1);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, BackupBatch.class);
    }

    @Override
    public BackupBatch getLastBackup(int cloudId, String cloudName, String userName) {
        Criteria criteria = new Criteria();
        Criteria criteria1 = Criteria.where((String)JOB_TYPE).is((Object)BACK_UP);
        ArrayList<Criteria> list = new ArrayList<Criteria>();
        this.addUserNameCriteria(cloudId, userName, list);
        list.add(criteria1);
        criteria.andOperator(list.toArray(new Criteria[list.size()]));
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{BATCH_START_TIME_STAMP}));
        query.limit(1);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (BackupBatch)mongoTemplate.findOne(query, BackupBatch.class);
    }

    @Override
    public List<BackupBatch> getNoBackup(int cloudId, String cloudName, String userName, String deviceName, int skipValue, int noOfDays) {
        return new ArrayList<BackupBatch>();
    }

    @Override
    public List<BackupBatch> getNoBackup(int cloudId) {
        return new ArrayList<BackupBatch>();
    }

    @Override
    public BackupBatch getLastSuccessfullBackup(int cloudId, String cloudName, String userName, String deviceName) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return this.getLastSuccessfulWithoutTemplate(cloudId, cloudName, userName, deviceName, mongoTemplate);
    }

    private BackupBatch getLastSuccessfulWithoutTemplate(int cloudId, String cloudName, String userName, String deviceName, MongoTemplate mongoTemplate) {
        Criteria criteria = this.getBackupBatchCriteria(cloudId, cloudName, userName, deviceName);
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{BATCH_START_TIME_STAMP}));
        query.limit(1);
        List list1 = mongoTemplate.find(query, BackupBatch.class);
        if (!CollectionUtils.isEmpty((Collection)list1)) {
            return (BackupBatch)list1.get(0);
        }
        return null;
    }

    private Criteria getBackupBatchCriteria(int cloudId, String cloudName, String userName, String deviceName) {
        Criteria criteria = new Criteria();
        Criteria criteria1 = Criteria.where((String)JOB_TYPE).is((Object)BACK_UP);
        Criteria criteria2 = Criteria.where((String)STATUS).is((Object)COMPLETED);
        ArrayList<Criteria> list = new ArrayList<Criteria>();
        this.addUserNameCriteria(cloudId, userName, list);
        this.addDeviceNameCriteria(cloudId, deviceName, list);
        list.add(criteria1);
        list.add(criteria2);
        criteria.andOperator(list.toArray(new Criteria[list.size()]));
        return criteria;
    }

    @Override
    public BackupBatch getFirstBackup(int cloudId, String cloudName, String userName, String deviceName) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return this.getFirstBackupWithoutTemplate(cloudId, userName, deviceName, mongoTemplate);
    }

    private BackupBatch getFirstBackupWithoutTemplate(int cloudId, String userName, String deviceName, MongoTemplate mongoTemplate) {
        Criteria criteria = new Criteria();
        Criteria criteria1 = Criteria.where((String)JOB_TYPE).is((Object)BACK_UP);
        ArrayList<Criteria> list = new ArrayList<Criteria>();
        this.addUserNameCriteria(cloudId, userName, list);
        this.addDeviceNameCriteria(cloudId, deviceName, list);
        list.add(criteria1);
        criteria.andOperator(list.toArray(new Criteria[list.size()]));
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.ASC, new String[]{BATCH_START_TIME_STAMP}));
        query.limit(1);
        return (BackupBatch)mongoTemplate.findOne(query, BackupBatch.class);
    }

    @Override
    public BackupBatch getLastBackupOnly(int cloudId, String cloudName, User user, Device device) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return this.getLastBackupOnlyWithoutTemplate(cloudId, user.getUserName(), device.getDeviceUUID(), mongoTemplate);
    }

    private BackupBatch getLastBackupOnlyWithoutTemplate(int cloudId, String userName, String deviceUUID, MongoTemplate mongoTemplate) {
        Criteria criteria = new Criteria();
        Criteria criteria1 = Criteria.where((String)JOB_TYPE).is((Object)BACK_UP);
        ArrayList<Criteria> list = new ArrayList<Criteria>();
        if (!StringUtils.isEmpty((String)userName)) {
            Criteria criteria3 = Criteria.where((String)USER_NAME).is((Object)userName);
            list.add(criteria3);
        }
        if (!StringUtils.isEmpty((String)deviceUUID)) {
            Criteria criteria4 = Criteria.where((String)DEVICEUUID).is((Object)deviceUUID);
            list.add(criteria4);
        }
        list.add(criteria1);
        criteria.andOperator(list.toArray(new Criteria[list.size()]));
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{BATCH_START_TIME_STAMP}));
        query.limit(1);
        return (BackupBatch)mongoTemplate.findOne(query, BackupBatch.class);
    }

    @Override
    public Object[] getBackupDateHistoryElement(int cloudId, String cloudName, User user, Device device) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Object[] arr = new Object[9];
        BackupBatch lastSuccessfulBatch = this.getLastSuccessfulWithoutTemplate(cloudId, cloudName, user.getUserName(), device.getDeviceName(), mongoTemplate);
        arr[0] = lastSuccessfulBatch != null ? Long.valueOf(lastSuccessfulBatch.getBatchEndTimestamp()) : null;
        BackupBatch firstBkpBatch = this.getFirstBackupWithoutTemplate(cloudId, user.getUserName(), device.getDeviceName(), mongoTemplate);
        if (firstBkpBatch != null) {
            arr[1] = firstBkpBatch.getBatchStartTimestamp();
            arr[7] = firstBkpBatch.getBatchEndTimestamp();
            arr[8] = firstBkpBatch.getStatus();
        } else {
            arr[1] = null;
            arr[7] = null;
        }
        BackupBatch lastBkpBatch = this.getLastBackupOnlyWithoutTemplate(cloudId, user.getUserName(), device.getDeviceUUID(), mongoTemplate);
        if (lastBkpBatch != null) {
            arr[2] = lastBkpBatch.getStatus();
            arr[3] = lastBkpBatch.getErrorCode();
            arr[4] = lastBkpBatch.getBatchStartTimestamp();
            this.setSummaryValues(lastBkpBatch, arr);
        } else {
            arr[2] = null;
            arr[3] = null;
            arr[4] = null;
            arr[5] = new Integer(0);
            arr[6] = new Integer(0);
        }
        return arr;
    }

    @Override
    public Long getFirstBackupEndDate(int cloudId, String userName, String deviceUUID) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Long bkpEndTime = null;
        Criteria criteria = new Criteria();
        Criteria criteria1 = new Criteria();
        criteria1.andOperator(new Criteria[]{Criteria.where((String)JOB_TYPE).is((Object)BACK_UP), Criteria.where((String)STATUS).is((Object)COMPLETED)});
        ArrayList<Criteria> list = new ArrayList<Criteria>();
        list.add(criteria1);
        this.addUserNameCriteria(cloudId, userName, list);
        if (!StringUtils.isEmpty((String)deviceUUID)) {
            Criteria criteria4 = Criteria.where((String)DEVICEUUID).is((Object)deviceUUID);
            list.add(criteria4);
        }
        criteria.andOperator(list.toArray(new Criteria[list.size()]));
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.ASC, new String[]{BATCH_START_TIME_STAMP}));
        query.limit(1);
        BackupBatch backupBatch = (BackupBatch)mongoTemplate.findOne(query, BackupBatch.class);
        if (backupBatch != null) {
            bkpEndTime = backupBatch.getBatchEndTimestamp();
        }
        return bkpEndTime;
    }

    private void setSummaryValues(BackupBatch backupBatch, Object[] arr) {
        Integer totalNoOfFiles = 0;
        Integer noOfFilesRemaining = 0;
        if (backupBatch != null) {
            String uploadedFiles;
            if (!StringUtils.isEmpty((String)backupBatch.getTotalNoOfFiles())) {
                totalNoOfFiles = Integer.parseInt(backupBatch.getTotalNoOfFiles());
            }
            if (StringUtils.isEmpty((String)(uploadedFiles = backupBatch.getUploadedFiles()))) {
                uploadedFiles = "0/" + totalNoOfFiles;
            }
            String[] parts = uploadedFiles.split("/");
            try {
                Integer actualNoOfFiles = Integer.parseInt(parts[1]);
                Integer noOfFilesBackedup = Integer.parseInt(parts[0]);
                noOfFilesRemaining = actualNoOfFiles - noOfFilesBackedup;
            }
            catch (Exception e) {
                logger.trace(" Exception  :" + e);
                logger.error(" Exception  :" + e.getMessage());
            }
        }
        arr[5] = totalNoOfFiles.toString();
        arr[6] = noOfFilesRemaining.toString();
    }

    @Override
    public List<BackupBatch> getAllBackupBatchForDevice(int cloudId, String cloudName, String userName, String deviceUUID) {
        Criteria criteria = new Criteria();
        Criteria criteria1 = Criteria.where((String)JOB_TYPE).is((Object)BACK_UP);
        ArrayList<Criteria> list = new ArrayList<Criteria>();
        if (!StringUtils.isEmpty((String)userName)) {
            Criteria criteria2 = Criteria.where((String)USER_NAME).is((Object)userName);
            list.add(criteria2);
        }
        if (!StringUtils.isEmpty((String)deviceUUID)) {
            Criteria criteria3 = Criteria.where((String)DEVICEUUID).is((Object)deviceUUID);
            list.add(criteria3);
        }
        list.add(criteria1);
        criteria.andOperator(list.toArray(new Criteria[list.size()]));
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{BATCH_END_TIME_STAMP}));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        return mongoTemplate.find(query, BackupBatch.class);
    }

    @Override
    public List<BackupAttempt> getAllBackupAttemptById(int cloudId, String batchId) {
        Criteria criteria1 = Criteria.where((String)"batchId").is((Object)batchId);
        Query query = new Query((CriteriaDefinition)criteria1);
        query.with(new Sort(Sort.Direction.ASC, new String[]{BATCH_END_TIME_STAMP}));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, BackupAttempt.class);
    }

    @Override
    public Long getNoOfSuccessfulBackups(int cloudId, String cloudName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)JOB_TYPE).is((Object)BACK_UP), Criteria.where((String)STATUS).is((Object)COMPLETED), Criteria.where((String)"errorCode").is((Object)0)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.count(query, BackupBatch.class);
    }

    @Override
    public Long getNoOfRestoresDoneForUser(int cloudId, String cloudName, Long startDate, Long endDate, User user) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).is((Object)user.getUserName()), Criteria.where((String)JOB_TYPE).is((Object)RESTORE), Criteria.where((String)STATUS).is((Object)COMPLETED)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.count(query, BackupBatch.class);
    }

    @Override
    public List<BackupBatch> getAllBackupBatchForDeviceWithPagination(int cloudId, String cloudName, String userName, String deviceUUID, int pageNo) {
        Criteria criteria = new Criteria();
        Criteria criteria1 = Criteria.where((String)JOB_TYPE).is((Object)BACK_UP);
        ArrayList<Criteria> list = new ArrayList<Criteria>();
        if (!StringUtils.isEmpty((String)userName)) {
            Criteria criteria2 = Criteria.where((String)USER_NAME).is((Object)userName);
            list.add(criteria2);
        }
        if (!StringUtils.isEmpty((String)deviceUUID)) {
            Criteria criteria3 = Criteria.where((String)DEVICEUUID).is((Object)deviceUUID);
            list.add(criteria3);
        }
        list.add(criteria1);
        criteria.andOperator(list.toArray(new Criteria[list.size()]));
        Query query = new Query((CriteriaDefinition)criteria);
        if (pageNo != 0) {
            query.skip((long)(pageNo * PCHelperConstant.getReportDisplayRecords()));
        }
        if (PCHelperConstant.getReportDisplayRecords() != 0) {
            query.limit(PCHelperConstant.getReportDisplayRecords());
        }
        query.with(new Sort(Sort.Direction.DESC, new String[]{BATCH_END_TIME_STAMP}));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        return mongoTemplate.find(query, BackupBatch.class);
    }

    @Override
    public List<BackupBatch> getAllCPBackupBatchForDeviceWithPagination(int cloudId, String productType, int pageNo) {
        Query query = new Query();
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        if (PCHelperConstant.PARABLU_PRODUCT_TYPE.EXCHANGE.getProductType().equalsIgnoreCase(productType) || Device.TYPE.OUTLOOK.name().equalsIgnoreCase(productType)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)"productType").is((Object)Device.TYPE.OUTLOOK.name())});
        } else if (PCHelperConstant.PARABLU_PRODUCT_TYPE.ODB.getProductType().equalsIgnoreCase(productType) || Device.TYPE.ONEDRIVE.name().equalsIgnoreCase(productType)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)"productType").is((Object)Device.TYPE.ONEDRIVE.name())});
        } else if (PCHelperConstant.PARABLU_PRODUCT_TYPE.SHAREPOINT.getProductType().equalsIgnoreCase(productType) || Device.TYPE.SHAREPOINT.name().equalsIgnoreCase(productType)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)"productType").is((Object)Device.TYPE.SHAREPOINT.name())});
        }
        if (pageNo != 0) {
            query.skip((long)(pageNo * PCHelperConstant.getReportDisplayRecords()));
        }
        if (PCHelperConstant.getReportDisplayRecords() != 0) {
            query.limit(PCHelperConstant.getReportDisplayRecords());
        }
        query.with(new Sort(Sort.Direction.DESC, new String[]{BATCH_END_TIME_STAMP}));
        mongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        List list = mongoTemplate.find(Query.query((CriteriaDefinition)criteria), CPBackupBatch.class);
        ArrayList<BackupBatch> backupBatchs = new ArrayList<BackupBatch>();
        for (CPBackupBatch cpBackupBatch : list) {
            BackupBatch backupBatch = new BackupBatch();
            BeanUtils.copyProperties((Object)cpBackupBatch, (Object)backupBatch);
            backupBatch.setUploadedSize(cpBackupBatch.getUploadedSize());
            backupBatchs.add(backupBatch);
        }
        return backupBatchs;
    }

    @Override
    public List<BackupBatch> getAllBackupBatchWithPagination(int cloudId, String cloudName, List<String> userNames, int pageNo, String reason, boolean isPagination, long fromDate, long endDate) {
        Criteria criteria = new Criteria();
        Criteria criteria1 = Criteria.where((String)JOB_TYPE).is((Object)BACK_UP);
        ArrayList<Criteria> list = new ArrayList<Criteria>();
        if (!CollectionUtils.isEmpty(userNames)) {
            Criteria criteria3 = Criteria.where((String)USER_NAME).in(userNames);
            list.add(criteria3);
        }
        if (!StringUtils.isEmpty((String)reason)) {
            Criteria criteria2;
            if (reason.equalsIgnoreCase("STOPPED")) {
                criteria2 = Criteria.where((String)STATUS).is((Object)reason);
                Criteria criteria3 = Criteria.where((String)STATUS).is((Object)"ABORTED");
                Criteria criteria4 = new Criteria();
                criteria4.orOperator(new Criteria[]{criteria2, criteria3});
                list.add(criteria4);
            } else {
                criteria2 = Criteria.where((String)STATUS).is((Object)reason);
                list.add(criteria2);
            }
        }
        list.add(criteria1);
        if (fromDate != 0L && endDate != 0L) {
            logger.debug("fromDate " + fromDate + "endDate " + endDate);
            this.addStartDateAndEndDateBetweenCriteria(fromDate, endDate, list);
        }
        criteria.andOperator(list.toArray(new Criteria[list.size()]));
        Query query = new Query((CriteriaDefinition)criteria);
        if (isPagination) {
            if (pageNo != 0) {
                query.skip((long)(pageNo * PCHelperConstant.getReportDisplayRecords()));
            }
            if (PCHelperConstant.getReportDisplayRecords() != 0) {
                query.limit(PCHelperConstant.getReportDisplayRecords());
            }
        }
        query.with(new Sort(Sort.Direction.DESC, new String[]{BATCH_END_TIME_STAMP}));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        return mongoTemplate.find(query, BackupBatch.class);
    }

    @Override
    public Long getNoOfBackupsDoneForUser(int cloudId, String cloudName, Long startDate, Long endDate, User user) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).is((Object)user.getUserName()), Criteria.where((String)JOB_TYPE).is((Object)BACK_UP), Criteria.where((String)STATUS).is((Object)COMPLETED)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.count(query, BackupBatch.class);
    }

    @Override
    public Object[] getBSDeviceInfoElement(int cloudId, String cloudName, Device device, User user) {
        String deviceName;
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Object[] arr = new Object[5];
        String userName = user.getUserName();
        BackupBatch lastSuccessfulBatch = this.getLastSuccessfulWithoutTemplate(cloudId, cloudName, userName, deviceName = device.getDeviceName(), mongoTemplate);
        arr[0] = lastSuccessfulBatch != null ? Long.valueOf(lastSuccessfulBatch.getBatchEndTimestamp()) : null;
        BackupBatch firstBkpBatch = this.getFirstBackupWithoutTemplate(cloudId, userName, deviceName, mongoTemplate);
        arr[1] = firstBkpBatch != null ? Long.valueOf(firstBkpBatch.getBatchStartTimestamp()) : null;
        DeviceBackupOverView deviceBackupOverView = this.getDeviceBkpOverviewForDeviceUUID(cloudId, device.getDeviceUUID());
        if (deviceBackupOverView != null) {
            long storageUsed = deviceBackupOverView.getStorageUtilized();
            arr[2] = storageUsed;
        }
        if (!StringUtils.isEmpty((String)user.getPolicyName())) {
            BackupPolicy policy = this.getBackupPolicy(mongoTemplate, user.getPolicyName());
            arr[3] = policy;
        } else {
            arr[3] = null;
        }
        OfficeBackupPolicy officeBackupPolicy = null;
        if (device.getDeviceType().equalsIgnoreCase(Device.TYPE.SHAREPOINT.name())) {
            officeBackupPolicy = this.getOfficePolicy(cloudId, user.getSpPolicyName(), OfficeBackupPolicy.TYPE.SHAREPOINT.toString());
        }
        if (device.getDeviceType().equalsIgnoreCase(Device.TYPE.OUTLOOK.name())) {
            officeBackupPolicy = this.getOfficePolicy(cloudId, user.getExchangePolicyName(), OfficeBackupPolicy.TYPE.EXCHANGE.toString());
        }
        if (device.getDeviceType().equalsIgnoreCase(Device.TYPE.ONEDRIVE.name())) {
            officeBackupPolicy = this.getOfficePolicy(cloudId, user.getOneDrivePolicyName(), OfficeBackupPolicy.TYPE.ODB.toString());
        }
        arr[4] = officeBackupPolicy != null ? officeBackupPolicy : null;
        return arr;
    }

    private OfficeBackupPolicy getOfficePolicy(int cloudId, String policyName, String policyType) {
        Criteria policyTypeCriteria = new Criteria();
        if (OfficeBackupPolicy.TYPE.ODB.toString().equalsIgnoreCase(policyType)) {
            policyTypeCriteria = Criteria.where((String)"policyType").is((Object)"ODB");
        } else if (OfficeBackupPolicy.TYPE.EXCHANGE.toString().equalsIgnoreCase(policyType)) {
            policyTypeCriteria = Criteria.where((String)"policyType").is((Object)"Exchange");
        } else if (OfficeBackupPolicy.TYPE.SHAREPOINT.toString().equalsIgnoreCase(policyType)) {
            policyTypeCriteria = Criteria.where((String)"policyType").is((Object)"Sharepoint");
        }
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"policyName").is((Object)policyName), policyTypeCriteria});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (OfficeBackupPolicy)paracloudMongoTemplate.findOne(query, OfficeBackupPolicy.class);
    }

    private BackupPolicy getBackupPolicy(MongoTemplate mongoTemplate, String policyName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"policyName").is((Object)policyName)});
        return (BackupPolicy)mongoTemplate.findOne(new Query((CriteriaDefinition)criteria), BackupPolicy.class);
    }

    private DeviceBackupOverView getDeviceBkpOverviewForDeviceUUID(int cloudId, String deviceUUID) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICEUUID).is((Object)deviceUUID)});
        Query query = new Query((CriteriaDefinition)criteria);
        return (DeviceBackupOverView)this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).findOne(query, DeviceBackupOverView.class);
    }

    public long getStorageUsed(MongoTemplate mongoTemplate, String cloudName, ObjectId userId, ObjectId deviceId) {
        DeviceBackupOverView deviceBackupOverView;
        Long totalSizeUsed = 0L;
        Criteria criteria = Criteria.where((String)"id").is((Object)deviceId);
        Query query = new Query((CriteriaDefinition)criteria);
        Device device = (Device)mongoTemplate.findOne(query, Device.class);
        if (device != null && (deviceBackupOverView = this.getDeviceBkpOverviewForDeviceUUID(1, device.getDeviceUUID())) != null) {
            totalSizeUsed = deviceBackupOverView.getStorageUtilized();
        }
        return totalSizeUsed;
    }

    private Long getDeviceCount(MongoTemplate mongoTemplate) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"blocked").is((Object)false)});
        Query query = new Query((CriteriaDefinition)criteria);
        return mongoTemplate.count(query, Device.class);
    }

    private long getUsersCount(MongoTemplate mongoTemplate) {
        Criteria criteria = Criteria.where((String)"active").is((Object)true);
        Query query = new Query((CriteriaDefinition)criteria);
        return mongoTemplate.count(query, User.class);
    }

    private Long getTotalSizeUsed(int cloudId) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Long totalSizeUsed = 0L;
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"blocked").is((Object)false)});
        Query query = new Query((CriteriaDefinition)criteria);
        List deviceList = mongoTemplate.find(query, Device.class);
        for (Device device : deviceList) {
            DeviceBackupOverView deviceBackupOverView;
            if (device == null || (deviceBackupOverView = this.getDeviceBkpOverviewForDeviceUUID(cloudId, device.getDeviceUUID())) == null) continue;
            totalSizeUsed = totalSizeUsed + deviceBackupOverView.getStorageUtilized();
        }
        return totalSizeUsed;
    }

    @Override
    public Object[] getCloudOverviewElement(int cloudId, String cloudName) {
        long startTime = System.currentTimeMillis();
        logger.debug("  Before start of getCloudOverviewElement ...... " + startTime);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Object[] arr = new Object[5];
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)STATUS).is((Object)COMPLETED)});
        TypedAggregation aggregation = Aggregation.newAggregation(BackupBatch.class, (AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{JOB_TYPE}).count().as(COUNT), Aggregation.project((String[])new String[]{COUNT, JOB_TYPE})});
        AggregationResults result = mongoTemplate.aggregate(aggregation, BasicDBObject.class);
        List stateStatsList = result.getMappedResults();
        for (BasicDBObject dbObject : stateStatsList) {
            String jobType = (String)dbObject.get("_id");
            if (jobType.equalsIgnoreCase(RESTORE)) {
                arr[0] = Long.valueOf(dbObject.get(COUNT).toString());
            }
            if (!jobType.equalsIgnoreCase(BACK_UP)) continue;
            arr[1] = Long.valueOf(dbObject.get(COUNT).toString());
        }
        logger.debug(System.currentTimeMillis() + "  After backup restore count...... " + (System.currentTimeMillis() - startTime));
        Long deviceCount = this.getDeviceCount(mongoTemplate);
        arr[2] = deviceCount != null ? (Number)deviceCount : (Number)0;
        logger.debug(System.currentTimeMillis() + "  After device count...... " + (System.currentTimeMillis() - startTime));
        Long usersCount = this.getUsersCount(mongoTemplate);
        arr[3] = usersCount != null ? (Number)usersCount : (Number)0;
        logger.debug(System.currentTimeMillis() + "  After users count...... " + (System.currentTimeMillis() - startTime));
        Long totalBackupSize = this.getTotalSizeUsed(cloudId);
        if (totalBackupSize == null) {
            totalBackupSize = 0L;
        }
        totalBackupSize = totalBackupSize * 1024L;
        arr[4] = totalBackupSize;
        logger.debug(System.currentTimeMillis() + "  End of getCloudOverviewElement ...... " + (System.currentTimeMillis() - startTime));
        return arr;
    }

    @Override
    public void saveBackupOverView(int cloudId, List<BackupOverviewElement> backupOverviewElementsList) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.dropCollection(BackupOverView.class);
        Long currentmills = System.currentTimeMillis();
        for (BackupOverviewElement element : backupOverviewElementsList) {
            BackupOverView backupOverview = new BackupOverView();
            BeanUtils.copyProperties((Object)element, (Object)backupOverview);
            backupOverview.setOverviewJobTime(currentmills.toString());
            mongoTemplate.save((Object)backupOverview);
        }
    }

    @Override
    public List<BackupOverviewElement> getAllBackupOverivew(int cloudId, String cloudName, int skipValue, boolean loadAll) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        Query query = new Query((CriteriaDefinition)criteria);
        if (!loadAll) {
            query.limit(PCHelperConstant.getReportDisplayRecords());
            logger.debug(" SKIP VALUE .... " + skipValue);
            if (skipValue != 0) {
                query.skip((long)(skipValue * PCHelperConstant.getReportDisplayRecords()));
            }
        }
        List list = mongoTemplate.find(query, BackupOverView.class);
        ArrayList<BackupOverviewElement> backupOverviewElementsList = new ArrayList<BackupOverviewElement>();
        for (BackupOverView backupOverview : list) {
            BackupOverviewElement element = new BackupOverviewElement();
            BeanUtils.copyProperties((Object)backupOverview, (Object)element);
            backupOverviewElementsList.add(element);
        }
        return backupOverviewElementsList;
    }

    @Override
    public Object[] getCloudOverviewElementForSize(int cloudId, String cloudName) {
        long startTime = System.currentTimeMillis();
        logger.debug("  Before start of getCloudOverviewElement size...... " + startTime);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Object[] arr = new Object[2];
        Long usersCount = this.getUsersCount(mongoTemplate);
        arr[0] = usersCount != null ? (Number)usersCount : (Number)0;
        logger.debug(System.currentTimeMillis() + "  After users count...... " + (System.currentTimeMillis() - startTime));
        Long totalBackupSize = this.getTotalSizeUsed(cloudId);
        if (totalBackupSize == null) {
            totalBackupSize = 0L;
        }
        totalBackupSize = totalBackupSize * 1024L;
        arr[1] = totalBackupSize;
        logger.debug(System.currentTimeMillis() + "  End of getCloudOverviewElementForSize ...... " + (System.currentTimeMillis() - startTime));
        return arr;
    }

    @Override
    public Object[] getBackupDateHistoryElement(int cloudId, String cloudName, String userName, String deviceUUID) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Object[] arr = new Object[7];
        BackupBatch lastSuccessfulBatch = this.getLastSuccessfulWithoutTemplate(cloudId, cloudName, userName, deviceUUID, mongoTemplate);
        arr[0] = lastSuccessfulBatch != null ? Long.valueOf(lastSuccessfulBatch.getBatchEndTimestamp()) : null;
        BackupBatch firstBkpBatch = this.getFirstBackupWithoutTemplate(cloudId, userName, deviceUUID, mongoTemplate);
        arr[1] = firstBkpBatch != null ? Long.valueOf(firstBkpBatch.getBatchStartTimestamp()) : null;
        BackupBatch lastBkpBatch = this.getLastBackupOnlyWithoutTemplate(cloudId, userName, deviceUUID, mongoTemplate);
        if (lastBkpBatch != null) {
            arr[2] = lastBkpBatch.getStatus();
            arr[3] = lastBkpBatch.getErrorCode();
            arr[4] = lastBkpBatch.getBatchStartTimestamp();
            this.setSummaryValues(lastBkpBatch, arr);
        } else {
            arr[2] = null;
            arr[3] = null;
            arr[4] = null;
            arr[5] = new Integer(0);
            arr[6] = new Integer(0);
        }
        return arr;
    }

    @Override
    public void deleteRecordsForUser(int cloudId, String cloudName, String userName) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).is((Object)userName)});
        Query query1 = new Query((CriteriaDefinition)criteria);
        mongoTemplate.remove(query1, BackupBatch.class);
    }

    @Override
    public void updateBackupBatch(int cloudId, String objectId, String status, String errorCode, BackupBatch backupBatch) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)objectId)});
        backupBatch.setStatus(status);
        backupBatch.setErrorCode(errorCode);
        mongoTemplate.save((Object)backupBatch);
    }

    @Override
    public void updateBackupBatch(int cloudId, String deviceUUID, String userName) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).is((Object)userName), Criteria.where((String)DEVICEUUID).is((Object)deviceUUID), Criteria.where((String)STATUS).is((Object)STATUS_STARTED)});
        List list = mongoTemplate.find(Query.query((CriteriaDefinition)criteria), BackupBatch.class);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (BackupBatch backupBatch : list) {
                backupBatch.setStatus(STATUS_FAILED);
                mongoTemplate.save((Object)backupBatch);
            }
        }
    }

    @Override
    public BackupLog getBackupLog(int cloudId, String cloudName, BackupBatch backupBacth, String deviceUUID) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)backupBacth.getId())});
        Query query = new Query((CriteriaDefinition)criteria);
        logger.debug("Before Getting backup log>>>>>>>>>>>");
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        BackupLog backupLog = (BackupLog)mongoTemplate.findOne(query, BackupLog.class);
        BackupBatch backupBatch1 = null;
        if (backupLog == null && backupBacth.getStatus().equalsIgnoreCase(STATUS_FAILED)) {
            logger.debug("backupLog is null and previous status is failed so get previous one>>>>>>>>>>>>");
            backupLog = this.getPreviousLog(cloudId, backupBacth.getId(), deviceUUID);
            if (backupLog != null && (backupBatch1 = this.getBackupBatch(cloudId, cloudName, backupLog.getId().toString())) != null && !backupBatch1.getStatus().equalsIgnoreCase(STATUS_FAILED)) {
                logger.debug("previous backup is completed so set null for backup log>>>>>>>>>>>>");
                backupLog = null;
            }
        }
        ObjectId objectId = backupBatch1 != null ? backupBatch1.getId() : backupBacth.getId();
        this.deletePreviousLogs(cloudId, objectId, deviceUUID);
        return backupLog;
    }

    public BackupLog getPreviousLog(int cloudId, ObjectId objectId, String deviceUUID) {
        Criteria criteria1 = new Criteria();
        criteria1.andOperator(new Criteria[]{Criteria.where((String)DEVICEUUID).is((Object)deviceUUID), Criteria.where((String)"id").ne((Object)objectId)});
        Query query1 = new Query((CriteriaDefinition)criteria1);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (BackupLog)mongoTemplate.findOne(query1, BackupLog.class);
    }

    private void deletePreviousLogs(int cloudId, ObjectId objectId, String deviceUUID) {
        Criteria criteria1 = new Criteria();
        criteria1.andOperator(new Criteria[]{Criteria.where((String)DEVICEUUID).is((Object)deviceUUID), Criteria.where((String)"id").ne((Object)objectId)});
        Query query1 = new Query((CriteriaDefinition)criteria1);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.remove(query1, BackupLog.class);
    }

    @Override
    public List<BackupBatch> getAllBackupBatchBtwTimestamps(int cloudId, String cloudName, long startTime, long endTime, int skipValue, int recordsCount, String sortParam, String sortDirection) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)BATCH_START_TIME_STAMP).gte((Object)startTime), Criteria.where((String)BATCH_END_TIME_STAMP).lte((Object)endTime), Criteria.where((String)JOB_TYPE).ne((Object)"SYNC")});
        Query query = new Query((CriteriaDefinition)criteria);
        if (skipValue != 0) {
            query.skip((long)(skipValue * recordsCount));
        }
        if (recordsCount != 0) {
            query.limit(recordsCount);
        }
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List list = mongoTemplate.find(query, BackupBatch.class);
        logger.debug("total backupbatch count with limits................. " + list.size());
        return list;
    }

    @Override
    public long getAllBackupBatchBtwTimestampsCount(int cloudId, String cloudName, long startTime, long endTime) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)BATCH_START_TIME_STAMP).gte((Object)startTime), Criteria.where((String)BATCH_END_TIME_STAMP).lte((Object)endTime), Criteria.where((String)JOB_TYPE).ne((Object)"SYNC")});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        long totalCount = mongoTemplate.count(query, BackupBatch.class);
        logger.debug("total backupbatch count ................. " + totalCount);
        return totalCount;
    }

    private void addStartDateAndEndDateBetweenCriteria(Long fromDate, Long endDate, List<Criteria> list) {
        Criteria criteria5 = Criteria.where((String)BATCH_START_TIME_STAMP).gte((Object)fromDate);
        Criteria criteria6 = Criteria.where((String)BATCH_START_TIME_STAMP).lte((Object)endDate);
        Criteria criteria7 = Criteria.where((String)BATCH_END_TIME_STAMP).gte((Object)fromDate);
        Criteria criteria8 = Criteria.where((String)BATCH_END_TIME_STAMP).lte((Object)endDate);
        Criteria criteria9 = new Criteria();
        criteria9.andOperator(new Criteria[]{criteria5, criteria6});
        Criteria criteria10 = new Criteria();
        criteria10.andOperator(new Criteria[]{criteria7, criteria8});
        Criteria criteria11 = new Criteria();
        criteria11.orOperator(new Criteria[]{criteria9, criteria10});
        list.add(criteria10);
    }

    @Override
    public BackupBatch getPrevLastBackup(int cloudId, Device device, User user) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)JOB_TYPE).is((Object)BACK_UP), Criteria.where((String)USER_NAME).is((Object)user.getUserName()), Criteria.where((String)DEVICEUUID).is((Object)DEVICEUUID), Criteria.where((String)STATUS).is((Object)COMPLETED)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{BATCH_START_TIME_STAMP}));
        query.limit(1);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List bkplist = mongoTemplate.find(query, BackupBatch.class);
        if (!CollectionUtils.isEmpty((Collection)bkplist)) {
            return (BackupBatch)bkplist.get(0);
        }
        return null;
    }

    @Override
    public void deleteRecordsForDevice(int cloudId, Device device) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICEUUID).is((Object)device.getDeviceUUID())});
        Query query = new Query((CriteriaDefinition)criteria);
        mongoTemplate.remove(query, BackupBatch.class);
    }

    @Override
    public List<BackupBatch> getLastBatchsBydeviceUUIDAndSkipvalue(int cloudId, String deviceUUID, int skipValue, long firstCompltedBatchEndTime) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)JOB_TYPE).is((Object)BACK_UP), Criteria.where((String)DEVICEUUID).is((Object)deviceUUID), Criteria.where((String)BATCH_START_TIME_STAMP).gte((Object)firstCompltedBatchEndTime)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{BATCH_START_TIME_STAMP}));
        query.skip((long)skipValue);
        query.limit(100);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, BackupBatch.class);
    }

    @Override
    public BackupBatch getFirstCompletedBackupBatch(int cloudId, String deviceUUID) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)JOB_TYPE).is((Object)BACK_UP), Criteria.where((String)DEVICEUUID).is((Object)deviceUUID), Criteria.where((String)STATUS).is((Object)COMPLETED)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.ASC, new String[]{BATCH_START_TIME_STAMP}));
        query.limit(1);
        List list = mongoTemplate.find(query, BackupBatch.class);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            return (BackupBatch)list.get(0);
        }
        return null;
    }

    @Override
    public void deletedBackupBatchByIDs(int cloudId, List<String> backupBatchIds) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").in(backupBatchIds)});
        Query query = new Query((CriteriaDefinition)criteria);
        mongoTemplate.remove(query, BackupBatch.class);
    }

    @Override
    public BackupBatch getBackupBatchByUserName(int cloudId, String userName) {
        Criteria criteria = new Criteria();
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).is((Object)userName)});
        Query query = new Query((CriteriaDefinition)criteria);
        return (BackupBatch)mongoTemplate.findOne(query, BackupBatch.class);
    }

    @Override
    public List<BackupBatch> getAllBackupBatch(int cloudId, String userName, String deviceName, Long fromDate, Long endDate, int skipValue, boolean limit) {
        Criteria criteria = new Criteria();
        Criteria criteria2 = Criteria.where((String)JOB_TYPE).is((Object)BACK_UP);
        ArrayList<Criteria> list = new ArrayList<Criteria>();
        this.addUserNameCriteria(cloudId, userName, list);
        this.addDeviceNameCriteria(cloudId, deviceName, list);
        list.add(criteria2);
        this.addStartDateAndEndDateBetweenCriteria(fromDate, endDate, list);
        criteria.andOperator(list.toArray(new Criteria[list.size()]));
        return this.getListOfBackupBatch(cloudId, criteria, skipValue, limit);
    }

    @Override
    public long getAllBackupBatchCount(int cloudId, String userName, String deviceName, Long fromDate, Long endDate) {
        Criteria criteria = new Criteria();
        Criteria criteria2 = Criteria.where((String)JOB_TYPE).is((Object)BACK_UP);
        ArrayList<Criteria> list = new ArrayList<Criteria>();
        this.addUserNameCriteria(cloudId, userName, list);
        this.addDeviceNameCriteria(cloudId, deviceName, list);
        list.add(criteria2);
        this.addStartDateAndEndDateBetweenCriteria(fromDate, endDate, list);
        criteria.andOperator(list.toArray(new Criteria[list.size()]));
        return this.getCountOfBackupBatch(cloudId, criteria);
    }

    @Override
    public List<BackupBatch> getAllBackupBatchForExcel(int cloudId, String userName, String deviceName, Long fromDate, Long endDate, int skipValue, boolean limit) {
        Criteria criteria = new Criteria();
        Criteria criteria2 = Criteria.where((String)JOB_TYPE).is((Object)BACK_UP);
        ArrayList<Criteria> list = new ArrayList<Criteria>();
        this.addUserNameCriteria(cloudId, userName, list);
        this.addDeviceNameCriteria(cloudId, deviceName, list);
        list.add(criteria2);
        this.addStartDateAndEndDateBetweenCriteria(fromDate, endDate, list);
        logger.debug("...fromDate.." + fromDate + "...endDate.." + endDate);
        criteria.andOperator(list.toArray(new Criteria[list.size()]));
        return this.getListOfBackupBatch(cloudId, criteria, skipValue, limit);
    }

    @Override
    public List<BackupBatch> getAllBackupBatchForExcelWithoutPagination(int cloudId, String userName, String deviceName, Long fromDate, Long endDate) {
        Criteria criteria = new Criteria();
        Criteria criteria2 = Criteria.where((String)JOB_TYPE).is((Object)BACK_UP);
        ArrayList<Criteria> list = new ArrayList<Criteria>();
        this.addUserNameCriteria(cloudId, userName, list);
        this.addDeviceNameCriteria(cloudId, deviceName, list);
        list.add(criteria2);
        this.addStartDateAndEndDateBetweenCriteria(fromDate, endDate, list);
        logger.debug("...fromDate.." + fromDate + "...endDate.." + endDate);
        criteria.andOperator(list.toArray(new Criteria[list.size()]));
        return this.getListOfBackupBatch(cloudId, criteria);
    }

    @Override
    public long getAllBackupBatchCountForExcel(int cloudId, String userName, String deviceName, Long fromDate, Long endDate) {
        Criteria criteria = new Criteria();
        Criteria criteria2 = Criteria.where((String)JOB_TYPE).is((Object)BACK_UP);
        ArrayList<Criteria> list = new ArrayList<Criteria>();
        this.addUserNameCriteria(cloudId, userName, list);
        this.addDeviceNameCriteria(cloudId, deviceName, list);
        list.add(criteria2.andOperator(new Criteria[]{Criteria.where((String)STATUS).ne((Object)STATUS_STARTED)}));
        this.addStartDateAndEndDateBetweenCriteria(fromDate, endDate, list);
        criteria.andOperator(list.toArray(new Criteria[list.size()]));
        return this.getCountOfBackupBatch(cloudId, criteria);
    }

    @Override
    public long getCountOfBackupHistoryWithoutTime(int cloudId, String userName, String deviceName) {
        Criteria criteria = new Criteria();
        Criteria criteria2 = Criteria.where((String)JOB_TYPE).is((Object)BACK_UP);
        ArrayList<Criteria> list = new ArrayList<Criteria>();
        this.addUserNameCriteria(cloudId, userName, list);
        this.addDeviceNameCriteria(cloudId, deviceName, list);
        list.add(criteria2);
        criteria.andOperator(list.toArray(new Criteria[list.size()]));
        return this.getCountOfBackupBatch(cloudId, criteria);
    }

    @Override
    public long getCountOfCPBackupHistory(int cloudId, String productType) {
        Criteria criteria = new Criteria();
        if (PCHelperConstant.PARABLU_PRODUCT_TYPE.EXCHANGE.getProductType().equalsIgnoreCase(productType)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)"productType").is((Object)Device.TYPE.OUTLOOK.name())});
        } else if (PCHelperConstant.PARABLU_PRODUCT_TYPE.ODB.getProductType().equalsIgnoreCase(productType)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)"productType").is((Object)Device.TYPE.ONEDRIVE.name())});
        } else if (PCHelperConstant.PARABLU_PRODUCT_TYPE.SHAREPOINT.getProductType().equalsIgnoreCase(productType)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)"productType").is((Object)Device.TYPE.SHAREPOINT.name())});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        logger.debug(productType + "...query.....count." + query.toString());
        logger.debug("criteria...count..." + criteria.toString());
        return mongoTemplate.count(query, CPBackupBatch.class);
    }

    @Override
    public RestoreHistory getRestoreHistoryById(int cloudId, ObjectId objectId) {
        Criteria criteria = new Criteria();
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)objectId)});
        Query query = new Query((CriteriaDefinition)criteria);
        return (RestoreHistory)mongoTemplate.findOne(query, RestoreHistory.class);
    }

    @Override
    public BackupAttempt getLastBackupAttemptById(int cloudId, String batchId) {
        Criteria criteria1 = Criteria.where((String)"batchId").is((Object)batchId);
        Query query = new Query((CriteriaDefinition)criteria1);
        query.with(new Sort(Sort.Direction.DESC, new String[]{BATCH_END_TIME_STAMP}));
        query.limit(1);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (BackupAttempt)mongoTemplate.findOne(query, BackupAttempt.class);
    }

    @Override
    public BackupBatch getLastRestoreBatch(int cloudId, String actionToDeviceUUID) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICEUUID).is((Object)actionToDeviceUUID), Criteria.where((String)JOB_TYPE).is((Object)RESTORE)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{BATCH_END_TIME_STAMP}));
        query.limit(1);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (BackupBatch)mongoTemplate.findOne(query, BackupBatch.class);
    }

    @Override
    public void deleteRestoredFilesCollById(int cloudId, String restoreBatchId) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        String collectionName = this.getRestoreFileCollectionName(restoreBatchId);
        mongoTemplate.dropCollection(collectionName);
    }

    private String getRestoreFileCollectionName(String restoreId) {
        String collectionName = "RESTORE_" + restoreId;
        return collectionName;
    }

    @Override
    public void saveBackupAttempt(int cloudId, String cloudName, BackupAttempt attempt) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.save((Object)attempt);
    }

    @Override
    public void saveRestoreDetailsForDelFolders(int cloudId, ObjectId restoreBatchId, String deviceUUID) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        DeleteRestoreBatch deleteRestoreBatch = new DeleteRestoreBatch();
        deleteRestoreBatch.setId(restoreBatchId);
        deleteRestoreBatch.setDeviceUUID(deviceUUID);
        mongoTemplate.save((Object)deleteRestoreBatch);
    }

    @Override
    public Collection<? extends BackupBatch> getAllBackupBatchForJobTypeWithStartOrEndTime(int cloudId, String deviceName, String userName, String jobType, String status, Long fromDate, Long endDate, boolean currentRunningBackups) {
        ArrayList queriedBackupBatches = new ArrayList();
        Criteria currentBackupRunningCriteria = new Criteria();
        Criteria onDateCriteria = new Criteria();
        Criteria criteria1 = Criteria.where((String)JOB_TYPE).is((Object)jobType);
        ArrayList<Criteria> list = new ArrayList<Criteria>();
        logger.debug("jobType entered for backupBatch report={}", (Object)jobType);
        logger.debug("date entered for backupBatch report={}", (Object)fromDate);
        logger.debug("is current running backup enabled={}", (Object)currentRunningBackups);
        this.addUserNameCriteria(cloudId, userName, list);
        this.addDeviceNameCriteria(cloudId, deviceName, list);
        logger.debug("userName entered for backupBatch reprort={}", (Object)userName);
        logger.debug("deviceName entered for backupBatch reprort={}", (Object)deviceName);
        list.add(criteria1);
        if (!StringUtils.isEmpty((String)status)) {
            Criteria criteria2 = Criteria.where((String)STATUS).is((Object)status);
            list.add(criteria2);
        }
        boolean limit = false;
        if (StringUtils.isEmpty((String)userName) && StringUtils.isEmpty((String)deviceName)) {
            limit = true;
        }
        Criteria criteriatoDelete = this.addCurrentRunningBackups(cloudId, list);
        currentBackupRunningCriteria.andOperator(list.toArray(new Criteria[list.size()]));
        list.remove(criteriatoDelete);
        Query currentBackupRunningQuery = new Query((CriteriaDefinition)currentBackupRunningCriteria);
        this.addStartOrEndDateBetweenCriteria(fromDate, endDate, list);
        onDateCriteria.andOperator(list.toArray(new Criteria[list.size()]));
        Query onDateQuery = new Query((CriteriaDefinition)onDateCriteria);
        logger.debug("The onDateQuery formed={} ", (Object)onDateQuery.toString());
        logger.debug("The currentBackupRunningQuery formed={} ", (Object)currentBackupRunningQuery.toString());
        onDateQuery.with(new Sort(Sort.Direction.DESC, new String[]{BATCH_END_TIME_STAMP}));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List onDateBackupBatchList = mongoTemplate.find(onDateQuery, BackupBatch.class);
        logger.debug("onDateQuery executed, onDateBackupBatchList size={}", (Object)onDateBackupBatchList.size());
        currentBackupRunningQuery.with(new Sort(Sort.Direction.DESC, new String[]{BATCH_END_TIME_STAMP}));
        List currentBackupRunningBackupBatchList = mongoTemplate.find(currentBackupRunningQuery, BackupBatch.class);
        logger.debug("currentBackupRunningQuery executed, currentBackupRunningBackupBatchList size={}", (Object)currentBackupRunningBackupBatchList.size());
        List currentBackupRunningNotOnDateList = currentBackupRunningBackupBatchList.stream().filter(batch -> batch.getBatchStartTimestamp() < fromDate).collect(Collectors.toList());
        logger.debug("currentBackupRunningNotOnDateList executed, currentBackupRunningNotOnDateList size={}", (Object)currentBackupRunningNotOnDateList.size());
        onDateBackupBatchList.removeIf(onDateList -> currentBackupRunningNotOnDateList.stream().anyMatch(currentRunningDateList -> currentRunningDateList.getId().equals((Object)onDateList.getId())));
        queriedBackupBatches.addAll(onDateBackupBatchList);
        if (currentRunningBackups) {
            queriedBackupBatches.addAll(currentBackupRunningNotOnDateList);
        }
        return queriedBackupBatches;
    }

    @Override
    public Collection<? extends BackupBatch> getAllBackupBatchForJobTypeWOPagination(int cloudId, String deviceName, String userName, String jobType, String status, Long fromDate, Long endDate, String productType) {
        logger.debug(".....search for productType ...." + productType);
        Criteria criteria = new Criteria();
        Criteria criteria1 = Criteria.where((String)JOB_TYPE).is((Object)jobType);
        ArrayList<Criteria> list = new ArrayList<Criteria>();
        this.addUserNameCriteria(cloudId, userName, list);
        this.addDeviceNameCriteria(cloudId, deviceName, list);
        list.add(criteria1);
        if (!StringUtils.isEmpty((String)productType)) {
            Criteria criteria4;
            logger.debug(".....search for productType regex1...." + productType);
            if (PCHelperConstant.PARABLU_PRODUCT_TYPE.EXCHANGE.getProductType().equals(productType)) {
                criteria4 = Criteria.where((String)"deviceName").regex("(Microsoft Exchange)");
                list.add(criteria4);
            } else if (PCHelperConstant.PARABLU_PRODUCT_TYPE.ODB.getProductType().equals(productType)) {
                criteria4 = Criteria.where((String)"deviceName").regex("(Microsoft OneDrive)");
                list.add(criteria4);
            } else if (PCHelperConstant.PARABLU_PRODUCT_TYPE.SHAREPOINT.getProductType().equals(productType)) {
                criteria4 = Criteria.where((String)"deviceName").regex("(Microsoft SharePoint)");
                list.add(criteria4);
            } else if (PCHelperConstant.PARABLU_PRODUCT_TYPE.BACKUP.getProductType().equals(productType)) {
                criteria4 = new Criteria().andOperator(new Criteria[]{Criteria.where((String)"deviceName").not().regex("(Microsoft OneDrive)"), Criteria.where((String)"deviceName").not().regex("(Microsoft SharePoint)"), Criteria.where((String)"deviceName").not().regex("(Microsoft Exchange)")});
                list.add(criteria4);
            }
        }
        if (!StringUtils.isEmpty((String)status)) {
            Criteria criteria2 = Criteria.where((String)STATUS).is((Object)status);
            list.add(criteria2);
        }
        boolean limit = false;
        if (StringUtils.isEmpty((String)userName) && StringUtils.isEmpty((String)deviceName)) {
            limit = true;
        }
        this.addStartAndEndDateBetweenCriteria(fromDate, endDate, list);
        criteria.andOperator(list.toArray(new Criteria[list.size()]));
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{BATCH_END_TIME_STAMP}));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, BackupBatch.class);
    }

    @Override
    public List<BackupBatch> getAllBackupBatchForStatus(int cloudId, String status, Long fromDate, Long endDate, String userName, String deviceName) {
        Criteria criteria = new Criteria();
        Criteria criteria1 = Criteria.where((String)JOB_TYPE).is((Object)BACK_UP);
        Criteria criteria2 = new Criteria();
        ArrayList<Criteria> list = new ArrayList<Criteria>();
        this.addUserNameCriteria(cloudId, userName, list);
        this.addDeviceNameCriteria(cloudId, deviceName, list);
        list.add(criteria1);
        this.addStartDateAndEndDateBetweenCriteria(fromDate, endDate, list);
        criteria2 = STATUS_FAILED.equalsIgnoreCase(status) ? Criteria.where((String)STATUS).is((Object)"INTERRUPTED") : Criteria.where((String)STATUS).is((Object)status);
        list.add(criteria2);
        criteria.andOperator(list.toArray(new Criteria[list.size()]));
        boolean limit = false;
        if (StringUtils.isEmpty((String)userName) && StringUtils.isEmpty((String)deviceName)) {
            limit = true;
        }
        return this.getListOfBackupBatch(cloudId, criteria);
    }

    @Override
    public List<BackupBatch> getAllBackupBatchForStatus(int cloudId, String status, Long fromDate, Long endDate, List<String> userNames, String deviceName) {
        Criteria criteria = new Criteria();
        Criteria criteria1 = Criteria.where((String)JOB_TYPE).is((Object)BACK_UP);
        Criteria criteria2 = new Criteria();
        ArrayList<Criteria> list = new ArrayList<Criteria>();
        this.addUserListNamesCriteria(cloudId, userNames, list);
        this.addDeviceNameCriteria(cloudId, deviceName, list);
        list.add(criteria1);
        this.addStartDateAndEndDateBetweenCriteria(fromDate, endDate, list);
        criteria2 = STATUS_FAILED.equalsIgnoreCase(status) ? Criteria.where((String)STATUS).is((Object)"INTERRUPTED") : Criteria.where((String)STATUS).is((Object)status);
        list.add(criteria2);
        criteria.andOperator(list.toArray(new Criteria[list.size()]));
        boolean limit = false;
        if (CollectionUtils.isEmpty(userNames) && StringUtils.isEmpty((String)deviceName)) {
            limit = true;
        }
        return this.getListOfBackupBatch(cloudId, criteria);
    }

    @Override
    public BackupBatch getLastSuccessfullBackup(int cloudId, String deviceUUID) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = this.getBackupBatchCriteria(cloudId, deviceUUID);
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{BATCH_START_TIME_STAMP}));
        query.limit(1);
        List list1 = mongoTemplate.find(query, BackupBatch.class);
        if (!CollectionUtils.isEmpty((Collection)list1)) {
            return (BackupBatch)list1.get(0);
        }
        return null;
    }

    private Criteria getBackupBatchCriteria(int cloudId, String deviceUUID) {
        Criteria criteria = new Criteria();
        Criteria criteria1 = Criteria.where((String)JOB_TYPE).is((Object)BACK_UP);
        Criteria criteria2 = Criteria.where((String)STATUS).is((Object)COMPLETED);
        Criteria criteria3 = Criteria.where((String)DEVICEUUID).is((Object)deviceUUID);
        ArrayList<Criteria> list = new ArrayList<Criteria>();
        list.add(criteria1);
        list.add(criteria2);
        list.add(criteria3);
        criteria.andOperator(list.toArray(new Criteria[list.size()]));
        return criteria;
    }

    @Override
    public int getSuccessFullBackupBatchCount(int cloudId, String cloudName, String deviceUUID) {
        Criteria criteria;
        Query query;
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List list1 = mongoTemplate.find(query = new Query((CriteriaDefinition)(criteria = this.getBackupBatchCriteria(cloudId, deviceUUID))), BackupBatch.class);
        if (!CollectionUtils.isEmpty((Collection)list1)) {
            return list1.size();
        }
        return 0;
    }

    @Override
    public List<String> getRWSampleFilesList(int cloudId) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List list = mongoTemplate.findAll(RwSampleFileInfoNames.class);
        ArrayList<String> md5List = new ArrayList<String>();
        for (RwSampleFileInfoNames rw : list) {
            md5List.add(rw.getFileName());
        }
        return md5List;
    }

    @Override
    public List<String> getRWSampleList(int cloudId) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List list = mongoTemplate.findAll(RwSampleFileInfo.class);
        ArrayList<String> md5List = new ArrayList<String>();
        for (RwSampleFileInfo rw : list) {
            md5List.add(rw.getMd5Checksum());
        }
        return md5List;
    }

    @Override
    public void stopCapacitySavings(int cloudId, String productType, String status) {
        CPBackupBatch backupBatch = null;
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        if (productType.equalsIgnoreCase(Device.TYPE.SHAREPOINT.name())) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)"productType").is((Object)Device.TYPE.SHAREPOINT.name())});
        } else if (productType.equalsIgnoreCase(Device.TYPE.ONEDRIVE.name())) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)"productType").is((Object)Device.TYPE.ONEDRIVE.name())});
        } else if (productType.equalsIgnoreCase(Device.TYPE.OUTLOOK.name())) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)"productType").is((Object)Device.TYPE.OUTLOOK.name())});
        }
        Query query = Query.query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{BATCH_START_TIME_STAMP}));
        query.limit(1);
        backupBatch = (CPBackupBatch)mongoTemplate.findOne(query, CPBackupBatch.class);
        logger.debug("... before batch exists...." + productType);
        if (backupBatch != null) {
            logger.debug("...batch exists...." + backupBatch.getStatus());
            criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)backupBatch.getId())});
            query = new Query((CriteriaDefinition)criteria);
            Update update = new Update();
            if (status.contains("stop")) {
                update.set(STATUS, (Object)"ABORTED");
                update.set("errorCode", (Object)"1207");
            } else if (status.contains("pause")) {
                update.set(STATUS, (Object)"PAUSED");
                update.set("errorCode", (Object)"1992");
            } else if (status.contains("start")) {
                update.set(STATUS, (Object)STATUS_STARTED);
                update.set("errorCode", (Object)"0");
            }
            update.set(BATCH_END_TIME_STAMP, (Object)System.currentTimeMillis());
            mongoTemplate.updateFirst(query, update, CPBackupBatch.class);
        }
    }
}

