/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pcbd.dao.impl;

import com.mongodb.ReadPreference;
import com.parablu.factory.ParacloudMongoFactoryUtils;
import com.parablu.factory.ParacloudSessionFactoryUtils;
import com.parablu.pcbd.dao.AuthorizationDao;
import com.parablu.pcbd.domain.AuthorizationTokens;
import com.parablu.pcbd.domain.OTPValidation;
import com.parablu.pcbd.domain.User;
import java.util.Collection;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hibernate.SQLQuery;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.util.CollectionUtils;

public class AuthorizationDaoImpl
implements AuthorizationDao {
    Logger logger = LogManager.getLogger(AuthorizationDaoImpl.class);
    ParacloudSessionFactoryUtils paracloudSessionFactoryUtils;
    ParacloudMongoFactoryUtils paracloudMongoFactoryUtils;
    private static final String MODIFIED_TIME = "modifiedTime";
    private static final String CLIENT_TYPE = "clientType";

    public ParacloudSessionFactoryUtils getParacloudSessionFactoryUtils() {
        return this.paracloudSessionFactoryUtils;
    }

    public void setParacloudSessionFactoryUtils(ParacloudSessionFactoryUtils paracloudSessionFactoryUtils) {
        this.paracloudSessionFactoryUtils = paracloudSessionFactoryUtils;
    }

    public ParacloudMongoFactoryUtils getParacloudMongoFactoryUtils() {
        return this.paracloudMongoFactoryUtils;
    }

    public void setParacloudMongoFactoryUtils(ParacloudMongoFactoryUtils paracloudMongoFactoryUtils) {
        this.paracloudMongoFactoryUtils = paracloudMongoFactoryUtils;
    }

    @Override
    public void updateTokenForDevice(int cloudId, String cloudName, AuthorizationTokens authorizationTokens) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.save((Object)authorizationTokens);
    }

    @Override
    public AuthorizationTokens getAuthorizationTokenForDevice(int cloudId, String cloudName, String devUUId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"uniqueId").is((Object)devUUId)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{MODIFIED_TIME}));
        query.limit(1);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (AuthorizationTokens)mongoTemplate.findOne(query, AuthorizationTokens.class);
    }

    @Override
    public AuthorizationTokens getAuthorizationTokenForUserName(int cloudId, String cloudName, String userName) {
        Criteria criteria;
        Query query;
        AuthorizationTokens authorizationTokens = null;
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        User user = (User)mongoTemplate.findOne(query = new Query((CriteriaDefinition)(criteria = Criteria.where((String)"userName").regex("^" + userName + "$", "i"))), User.class);
        if (user != null) {
            criteria = Criteria.where((String)"user").is((Object)user);
            query = new Query((CriteriaDefinition)criteria);
            query.with(new Sort(Sort.Direction.DESC, new String[]{MODIFIED_TIME}));
            query.limit(1);
            authorizationTokens = (AuthorizationTokens)mongoTemplate.findOne(query, AuthorizationTokens.class);
        }
        return authorizationTokens;
    }

    @Override
    public List<AuthorizationTokens> getAuthorizationTokensForUserName(int cloudId, String cloudName, String userName) {
        Criteria criteria;
        Query query;
        List authorizationTokens = null;
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        User user = (User)mongoTemplate.findOne(query = new Query((CriteriaDefinition)(criteria = Criteria.where((String)"userName").regex("^" + userName + "$", "i"))), User.class);
        if (user != null) {
            criteria = Criteria.where((String)"user").is((Object)user);
            query = new Query((CriteriaDefinition)criteria);
            query.with(new Sort(Sort.Direction.DESC, new String[]{MODIFIED_TIME}));
            query.limit(1);
            authorizationTokens = mongoTemplate.find(query, AuthorizationTokens.class);
        }
        return authorizationTokens;
    }

    @Override
    public void deleteRowFromTable(int cloudId, String cloudName, AuthorizationTokens authorizationTokens) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.remove((Object)authorizationTokens);
    }

    @Override
    public void deleteRowsFromTable(int cloudId, String cloudName, List<AuthorizationTokens> authorizationTokensList) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        for (AuthorizationTokens tokens : authorizationTokensList) {
            mongoTemplate.remove((Object)tokens);
        }
    }

    @Override
    public List<AuthorizationTokens> getLimitedValiditoryTokens(int cloudId, String cloudName) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = Criteria.where((String)"validitoryPeriod").gt((Object)0);
        Query query = new Query((CriteriaDefinition)criteria);
        return mongoTemplate.find(query, AuthorizationTokens.class);
    }

    @Override
    public AuthorizationTokens getAuthorizationTokenDetailsForToken(int cloudId, String cloudName, String token) {
        Criteria criteria = Criteria.where((String)"token").is((Object)token);
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.setReadPreference(ReadPreference.primary());
        return (AuthorizationTokens)mongoTemplate.findOne(query, AuthorizationTokens.class);
    }

    @Override
    public void deleteAllTokensForUser(int cloudId, String cloudName, User user) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = Criteria.where((String)"user.$id").is((Object)user.getUserId());
        Query query = new Query((CriteriaDefinition)criteria);
        mongoTemplate.remove(query, AuthorizationTokens.class);
    }

    @Override
    public List<AuthorizationTokens> getAuthorizationTokenByUser(int cloudId, String cloudName, User user) {
        Criteria criteria = Criteria.where((String)"user.$id").is((Object)user.getUserId());
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{MODIFIED_TIME}));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, AuthorizationTokens.class);
    }

    @Override
    public AuthorizationTokens getLatestAuthorizationTokenByUserAndType(int cloudId, String cloudName, User user, int clientType) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"user").is((Object)user), Criteria.where((String)CLIENT_TYPE).is((Object)clientType)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{MODIFIED_TIME}));
        query.limit(1);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (AuthorizationTokens)mongoTemplate.findOne(query, AuthorizationTokens.class);
    }

    @Override
    public AuthorizationTokens getLatestAuthorizationTokenByUserAndType(int cloudId, String cloudName, User user, int clientType, int row) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"user").is((Object)user), Criteria.where((String)CLIENT_TYPE).is((Object)clientType)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{MODIFIED_TIME}));
        query.limit(1);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (AuthorizationTokens)mongoTemplate.findOne(query, AuthorizationTokens.class);
    }

    @Override
    public List<AuthorizationTokens> getAllValidTokensForUser(int cloudId, String cloudName, User user) {
        String sqlQuery = "select a.* from AUTHORIZATION_TOKENS a INNER JOIN (select max(MODIFIED_TIME) as MAX_SERVER_TIMESTAMP,CLIENT_TYPE from AUTHORIZATION_TOKENS where USER_FK=:userId1 group by CLIENT_TYPE) amax on a.USER_FK=:userId2 and a.MODIFIED_TIME=amax.MAX_SERVER_TIMESTAMP and a.CLIENT_TYPE=amax.CLIENT_TYPE";
        SQLQuery query = this.paracloudSessionFactoryUtils.getParacloudSession(cloudId).getCurrentSession().createSQLQuery(sqlQuery).addEntity(AuthorizationTokens.class);
        query.setParameter("userId1", (Object)user.getUserId());
        query.setParameter("userId2", (Object)user.getUserId());
        return query.list();
    }

    @Override
    public List<AuthorizationTokens> getLatestAuthorizationTokensByUserAndType(int cloudId, String cloudName, User user, int clientType, int offset) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"user").is((Object)user), Criteria.where((String)CLIENT_TYPE).is((Object)clientType)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{MODIFIED_TIME}));
        query.limit(offset);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, AuthorizationTokens.class);
    }

    @Override
    public Long getLatestValidTokenDate(int cloudId, String cloudName) {
        Query query = new Query();
        query.with(new Sort(Sort.Direction.DESC, new String[]{MODIFIED_TIME}));
        query.limit(1);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List tokensList = mongoTemplate.find(query, AuthorizationTokens.class);
        if (!CollectionUtils.isEmpty((Collection)tokensList)) {
            AuthorizationTokens authorizationTokens = (AuthorizationTokens)tokensList.get(0);
            return authorizationTokens.getModifiedTime();
        }
        return null;
    }

    @Override
    public void saveNewDeviceToTable(int cloudId, String cloudName, AuthorizationTokens authorizationTokens) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        this.logger.debug(".... Inside daving new Auth token......");
        if (authorizationTokens != null && authorizationTokens.getClientType() == 2 && authorizationTokens.getUser() != null) {
            try {
                Criteria criteria = new Criteria();
                criteria.andOperator(new Criteria[]{Criteria.where((String)"user.$id").is((Object)authorizationTokens.getUser().getUserId()), Criteria.where((String)CLIENT_TYPE).is((Object)2)});
                Query query = new Query((CriteriaDefinition)criteria);
                long count = mongoTemplate.count(query, AuthorizationTokens.class);
                this.logger.debug(authorizationTokens.getUser().getUserName() + "....token to be deleted .... " + count);
                mongoTemplate.remove(query, AuthorizationTokens.class);
                this.logger.debug(" .. end of deleting .....");
            }
            catch (Exception e) {
                this.logger.error("...error deleting old tokens......");
                this.logger.trace("...error deleting old tokens......" + e.getMessage());
            }
        } else {
            this.logger.error(authorizationTokens + ".....not able to delete tokens.... ");
        }
        mongoTemplate.save((Object)authorizationTokens);
    }

    @Override
    public void deleteAllLimitedValiditoryPeriodTokens(int cloudId) {
        Integer clientType = 2;
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        long currentTimeMillis = System.currentTimeMillis();
        this.logger.debug(clientType + "....inside deleteAllLimitedValiditoryPeriodTokens .... " + currentTimeMillis);
        criteria.andOperator(new Criteria[]{Criteria.where((String)"validitoryPeriod").lt((Object)currentTimeMillis), Criteria.where((String)CLIENT_TYPE).is((Object)clientType)});
        Query query = new Query((CriteriaDefinition)criteria);
        List list = mongoTemplate.find(query, AuthorizationTokens.class);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            this.logger.debug(currentTimeMillis + " AuthorizationTokens cleaner list is not empty .... " + list.size());
            for (AuthorizationTokens authorizationTokens : list) {
                mongoTemplate.remove((Object)authorizationTokens);
            }
        } else {
            this.logger.debug(currentTimeMillis + " AuthorizationTokens cleaner list is  empty .... ");
        }
    }

    @Override
    public void deleteToken(int cloudId, User user, int clientType) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"user").is((Object)user), Criteria.where((String)CLIENT_TYPE).is((Object)clientType)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.findAllAndRemove(query, AuthorizationTokens.class);
    }

    @Override
    public void deleteAuthTokenByUserAndUniqueID(int cloudId, User user, String devUUId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"uniqueId").is((Object)devUUId), Criteria.where((String)"user").is((Object)user)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.findAllAndRemove(query, AuthorizationTokens.class);
    }

    @Override
    public void updateOTPForUniqueId(int cloudId, OTPValidation otpValidataion) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.save((Object)otpValidataion);
    }

    @Override
    public OTPValidation getOTPForUniqueId(int cloudId, String uniqueId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"uniqueId").is((Object)uniqueId)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (OTPValidation)mongoTemplate.findOne(query, OTPValidation.class);
    }

    @Override
    public void deleteOTPForUniqueId(int cloudId, String uniqueId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"uniqueId").is((Object)uniqueId)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.remove(query, OTPValidation.class);
    }
}

