/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pcbd.dao.impl;

import com.parablu.factory.ParacloudMongoFactoryUtils;
import com.parablu.factory.ParacloudSessionFactoryUtils;
import com.parablu.pcbd.dao.AuditHistoryDao;
import com.parablu.pcbd.domain.AuditHistory;
import com.parablu.pcbd.domain.SuperAdminAuditHistory;
import com.parablu.pcbd.domain.UnusualDataActivityHistory;
import com.parablu.pcbd.domain.User;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.util.CollectionUtils;

public class AuditHistoryImpl
implements AuditHistoryDao {
    private static Logger logger = LogManager.getLogger(AuditHistoryImpl.class);
    private static final String MM_DD_YYY = "MM/dd/yyyy";
    ParacloudSessionFactoryUtils paracloudSessionFactoryUtils;
    ParacloudMongoFactoryUtils paracloudMongoFactoryUtils;
    private static final String TIME_STAMP = "timestamp";
    private static final String ACTION_BY_USER_NAME = "actionByUserName";
    private static final String ACTIONUSINGOBJECT = "actionUsingObject";
    private static final String ACTION = "action";
    private static final String ACTIONTYPE = "actiontype";
    private static final String ACTIONTONOBJECT = "actionOnObject";
    private static final String USERNAME = "userName";
    private static final String DEVICENAME = "deviceName";
    private static final String DELETED = "deleted";
    private static HashMap<String, Set<String>> superAdminMap = null;
    private MongoOperations mongoAuditOps;

    public ParacloudSessionFactoryUtils getParacloudSessionFactoryUtils() {
        return this.paracloudSessionFactoryUtils;
    }

    public void setParacloudSessionFactoryUtils(ParacloudSessionFactoryUtils paracloudSessionFactoryUtils) {
        this.paracloudSessionFactoryUtils = paracloudSessionFactoryUtils;
    }

    public ParacloudMongoFactoryUtils getParacloudMongoFactoryUtils() {
        return this.paracloudMongoFactoryUtils;
    }

    public void setParacloudMongoFactoryUtils(ParacloudMongoFactoryUtils paracloudMongoFactoryUtils) {
        this.paracloudMongoFactoryUtils = paracloudMongoFactoryUtils;
    }

    @Override
    public List<AuditHistory> getAllAuditsInDesc(int cloudId, String cloudName) {
        Query query = new Query();
        query.with(new Sort(Sort.Direction.DESC, new String[]{TIME_STAMP}));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, AuditHistory.class);
    }

    @Override
    public void saveAudit(int cloudId, String cloudName, AuditHistory audit) {
        Set<String> superAdminNames;
        boolean isSuperAdmin = false;
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        if (superAdminMap == null || superAdminMap.isEmpty()) {
            this.initialiseMap(cloudId);
        }
        if (!CollectionUtils.isEmpty(superAdminNames = superAdminMap.get("superAdminMap"))) {
            for (String superAdminName : superAdminNames) {
                if (!audit.getActionByUserName().contains(superAdminName)) continue;
                isSuperAdmin = true;
                break;
            }
        }
        if (isSuperAdmin) {
            SuperAdminAuditHistory superAdminAudit = new SuperAdminAuditHistory();
            BeanUtils.copyProperties((Object)audit, (Object)superAdminAudit);
            this.mongoAuditOps.save((Object)superAdminAudit);
        } else {
            mongoTemplate.save((Object)audit);
        }
    }

    @Override
    public void deleteRecordsBasedOnTimeStamp(int cloudId, String cloudName, long timeStamp) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)TIME_STAMP).lt((Object)timeStamp));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.remove(query, AuditHistory.class);
    }

    @Override
    public void deleteUnusualActivityRecordsBasedOnTimeStamp(int cloudId, String cloudName, long timeStamp) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)TIME_STAMP).lt((Object)timeStamp));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.remove(query, UnusualDataActivityHistory.class);
    }

    @Override
    public List<AuditHistory> getAuditsByIndex(int cloudId, String cloudName, int offset, int rows) {
        Query query = new Query();
        query.with(new Sort(Sort.Direction.DESC, new String[]{TIME_STAMP}));
        if (offset > 0) {
            query.skip((long)offset);
        }
        if (rows > 0) {
            query.limit(rows);
        }
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, AuditHistory.class);
    }

    @Override
    public List<AuditHistory> getAllAuditsByUser(int cloudId, String cloudName, String user, int offset, int rows) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)ACTION_BY_USER_NAME).is((Object)user));
        query.with(new Sort(Sort.Direction.DESC, new String[]{TIME_STAMP}));
        if (offset > 0) {
            query.skip((long)offset);
        }
        if (rows > 0) {
            query.limit(rows);
        }
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, AuditHistory.class);
    }

    @Override
    public List<AuditHistory> getAllAuditsByDevice(int cloudId, String cloudName, String device, int offset, int rows) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)ACTIONUSINGOBJECT).is((Object)device));
        query.with(new Sort(Sort.Direction.DESC, new String[]{TIME_STAMP}));
        if (offset > 0) {
            query.skip((long)offset);
        }
        if (rows > 0) {
            query.limit(rows);
        }
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, AuditHistory.class);
    }

    @Override
    public List<AuditHistory> getAllAuditsByDeviceAndUser(int cloudId, String cloudName, String device, String user, int offset, int rows) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)ACTION_BY_USER_NAME).is((Object)user), Criteria.where((String)ACTIONUSINGOBJECT).is((Object)device)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{TIME_STAMP}));
        if (offset > 0) {
            query.skip((long)offset);
        }
        if (rows > 0) {
            query.limit(rows);
        }
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, AuditHistory.class);
    }

    @Override
    public List<AuditHistory> getAuditsByDeviceAndUserForSyncFailedFiles(int cloudId, String cloudName, String device, String user, int offset, int rows) {
        Criteria criteria1 = new Criteria();
        Criteria criteria = new Criteria();
        if (StringUtils.isNotEmpty((String)device)) {
            criteria1.orOperator(new Criteria[]{Criteria.where((String)ACTIONUSINGOBJECT).is((Object)device), Criteria.where((String)ACTIONUSINGOBJECT).is((Object)"PORTAL")});
        }
        criteria.andOperator(new Criteria[]{Criteria.where((String)ACTION_BY_USER_NAME).is((Object)user), Criteria.where((String)ACTION).is((Object)"Failed to upload"), criteria1});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{TIME_STAMP}));
        if (offset > 0) {
            query.skip((long)offset);
        }
        if (rows > 0) {
            query.limit(rows);
        }
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, AuditHistory.class);
    }

    @Override
    public Long getLatestTimeStampEntry(int cloudId, String cloudName) {
        Query query = new Query();
        query.with(new Sort(Sort.Direction.DESC, new String[]{TIME_STAMP}));
        query.limit(1);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List ahList = mongoTemplate.find(query, AuditHistory.class);
        if (!CollectionUtils.isEmpty((Collection)ahList)) {
            AuditHistory auditHistory = (AuditHistory)ahList.get(0);
            return auditHistory.getTimestamp();
        }
        return null;
    }

    @Override
    public void deleteRecordsForUser(int cloudId, String cloudName, String userName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)ACTION_BY_USER_NAME).is((Object)userName)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.remove(query, AuditHistory.class);
    }

    public static boolean validateRegex(String regex) {
        boolean validRegex = false;
        try {
            Pattern pattern = Pattern.compile(regex);
            validRegex = true;
        }
        catch (PatternSyntaxException e) {
            logger.debug("..invalid regex....");
        }
        return validRegex;
    }

    @Override
    public List<AuditHistory> getAllAuditsForUsersAndDuration(int cloudId, String user, long startDate, long endDate, int skipValue) {
        ArrayList<AuditHistory> audits = new ArrayList<AuditHistory>();
        ArrayList<Criteria> list = new ArrayList<Criteria>();
        if (AuditHistoryImpl.validateRegex("^" + user + "$")) {
            list.add(Criteria.where((String)ACTION_BY_USER_NAME).regex("^" + user + "$", "i"));
        } else {
            logger.debug("...invalid regex....");
            list.add(Criteria.where((String)ACTION_BY_USER_NAME).is((Object)user));
        }
        list.add(Criteria.where((String)TIME_STAMP).gte((Object)startDate));
        list.add(Criteria.where((String)TIME_STAMP).lte((Object)endDate));
        Criteria criteria = new Criteria();
        criteria.andOperator(list.toArray(new Criteria[list.size()]));
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{TIME_STAMP}));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        logger.debug("skip value>>>>>>>>>>" + skipValue);
        if (skipValue != 0) {
            query.skip((long)(skipValue * 1000));
            query.limit(1000);
        } else {
            query.limit(1000);
        }
        List queryList = mongoTemplate.find(query, AuditHistory.class);
        audits.addAll(queryList);
        return audits;
    }

    @Override
    public List<UnusualDataActivityHistory> getAllAuditsForUAD(int cloudId, String user, long startDate, long endDate, int skipValue) {
        ArrayList<UnusualDataActivityHistory> audits = new ArrayList<UnusualDataActivityHistory>();
        ArrayList<Criteria> list = new ArrayList<Criteria>();
        list.add(Criteria.where((String)USERNAME).regex("^" + user + "$", "i"));
        list.add(Criteria.where((String)TIME_STAMP).gte((Object)startDate));
        list.add(Criteria.where((String)TIME_STAMP).lte((Object)endDate));
        list.add(Criteria.where((String)ACTIONTYPE).is((Object)112));
        Criteria criteria = new Criteria();
        criteria.andOperator(list.toArray(new Criteria[list.size()]));
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{TIME_STAMP}));
        logger.debug("criteria>>>>>>>>>>" + criteria);
        logger.debug("query>>>>>>>>>>" + query);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        logger.debug("skip value>>>>>>>>>>" + skipValue);
        if (skipValue != 0) {
            query.skip((long)(skipValue * 1000));
            query.limit(1000);
        } else {
            query.limit(1000);
        }
        List queryList = mongoTemplate.find(query, UnusualDataActivityHistory.class);
        audits.addAll(queryList);
        return audits;
    }

    @Override
    public long getAllAuditsCountByDeviceAndUser(int cloudId, String cloudName, String device, String user) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)ACTION_BY_USER_NAME).is((Object)user), Criteria.where((String)ACTIONUSINGOBJECT).is((Object)device)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.count(query, AuditHistory.class);
    }

    @Override
    public long getAuditHistoryTotalCountForSyncFailedFiles(int cloudId, String cloudName, String device, String user) {
        Criteria criteria1 = new Criteria();
        Criteria criteria = new Criteria();
        if (StringUtils.isNotEmpty((String)device)) {
            criteria1.orOperator(new Criteria[]{Criteria.where((String)ACTIONUSINGOBJECT).is((Object)device), Criteria.where((String)ACTIONUSINGOBJECT).is((Object)"PORTAL")});
            criteria.andOperator(new Criteria[]{Criteria.where((String)ACTION_BY_USER_NAME).is((Object)user), Criteria.where((String)ACTION).is((Object)"Failed to upload"), criteria1});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)ACTION_BY_USER_NAME).is((Object)user), Criteria.where((String)ACTION).is((Object)"Failed to upload")});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.count(query, AuditHistory.class);
    }

    @Override
    public long getAllAuditsCountByUser(int cloudId, String cloudName, String user) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)ACTION_BY_USER_NAME).is((Object)user));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.count(query, AuditHistory.class);
    }

    @Override
    public long getAllAuditsCountByDevice(int cloudId, String cloudName, String device) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)ACTIONUSINGOBJECT).is((Object)device));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.count(query, AuditHistory.class);
    }

    @Override
    public long getAuditsCountByIndex(int cloudId, String cloudName) {
        Query query = new Query();
        query.with(new Sort(Sort.Direction.DESC, new String[]{TIME_STAMP}));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.count(query, AuditHistory.class);
    }

    @Override
    public void saveAuditHistory(int cloudId, AuditHistory audit) {
        Set<String> superAdminNames;
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        boolean isSuperAdmin = false;
        if (superAdminMap == null || superAdminMap.isEmpty()) {
            this.initialiseMap(cloudId);
        }
        if (!CollectionUtils.isEmpty(superAdminNames = superAdminMap.get("superAdminMap"))) {
            for (String superAdminName : superAdminNames) {
                if (!audit.getActionByUserName().contains(superAdminName)) continue;
                isSuperAdmin = true;
                break;
            }
        }
        if (isSuperAdmin) {
            SuperAdminAuditHistory superAdminAudit = new SuperAdminAuditHistory();
            BeanUtils.copyProperties((Object)audit, (Object)superAdminAudit);
            this.mongoAuditOps.save((Object)superAdminAudit);
        } else {
            mongoTemplate.save((Object)audit);
        }
    }

    @Override
    public List<AuditHistory> getAllAuditsByMC(int cloudId, List<String> mcList, String startDate, String toDate, int offset, int rows) {
        Criteria criteria = new Criteria();
        long startDateMills = AuditHistoryImpl.getStartDateNew(startDate);
        long endDateMills = AuditHistoryImpl.getEndOfDayNew(toDate);
        logger.debug("....timee..." + startDateMills + "..." + endDateMills);
        if (!CollectionUtils.isEmpty(mcList)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)"mcName").in(mcList), Criteria.where((String)"isMiniCloud").is((Object)true), Criteria.where((String)TIME_STAMP).gte((Object)startDateMills), Criteria.where((String)TIME_STAMP).lte((Object)endDateMills)});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)"isMiniCloud").is((Object)true), Criteria.where((String)TIME_STAMP).gte((Object)startDateMills), Criteria.where((String)TIME_STAMP).lte((Object)endDateMills)});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{TIME_STAMP}));
        if (offset > 0) {
            query.skip((long)offset);
        }
        if (rows > 0) {
            query.limit(rows);
        }
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, AuditHistory.class);
    }

    @Override
    public List<AuditHistory> getAuditsByMCIndex(int cloudId, String startDate, String toDate, int offset, int rows) {
        long startDateMills = AuditHistoryImpl.getStartDateNew(startDate);
        long endDateMills = AuditHistoryImpl.getEndOfDayNew(toDate);
        logger.debug("....timee..." + startDateMills + "..." + endDateMills);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"isMiniCloud").is((Object)true), Criteria.where((String)TIME_STAMP).gte((Object)startDateMills), Criteria.where((String)TIME_STAMP).lte((Object)endDateMills)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{TIME_STAMP}));
        if (offset > 0) {
            query.skip((long)offset);
        }
        if (rows > 0) {
            query.limit(rows);
        }
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, AuditHistory.class);
    }

    @Override
    public long getAllAuditsCountByMC(int cloudId, List<String> mcList, String startDate, String toDate) {
        Criteria criteria = new Criteria();
        long startDateMills = AuditHistoryImpl.getStartDateNew(startDate);
        long endDateMills = AuditHistoryImpl.getEndOfDayNew(toDate);
        if (!CollectionUtils.isEmpty(mcList)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)"mcName").in(mcList), Criteria.where((String)"isMiniCloud").is((Object)true), Criteria.where((String)TIME_STAMP).gte((Object)startDateMills), Criteria.where((String)TIME_STAMP).lte((Object)endDateMills)});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)"isMiniCloud").is((Object)true), Criteria.where((String)TIME_STAMP).gte((Object)startDateMills), Criteria.where((String)TIME_STAMP).lte((Object)endDateMills)});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{TIME_STAMP}));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.count(query, AuditHistory.class);
    }

    @Override
    public long getAuditsCountByMCIndex(int cloudId, String startDate, String toDate) {
        long startDateMills = AuditHistoryImpl.getStartDateNew(startDate);
        long endDateMills = AuditHistoryImpl.getEndOfDayNew(toDate);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"isMiniCloud").is((Object)true), Criteria.where((String)TIME_STAMP).gte((Object)startDateMills), Criteria.where((String)TIME_STAMP).lte((Object)endDateMills)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{TIME_STAMP}));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.count(query, AuditHistory.class);
    }

    public static Date atEndOfDay(Date date) {
        return DateUtils.addMilliseconds((Date)DateUtils.ceiling((Date)date, (int)5), (int)-1);
    }

    public static Date atStartOfDay(Date date) {
        return DateUtils.truncate((Date)date, (int)5);
    }

    public static long getEndOfDayNew(String endDate) {
        SimpleDateFormat sdf = new SimpleDateFormat(MM_DD_YYY);
        Date date = null;
        try {
            date = sdf.parse(endDate);
        }
        catch (ParseException e) {
            logger.debug("........." + e.getMessage());
        }
        Date atEndOfDay = AuditHistoryImpl.atEndOfDay(date);
        logger.debug(atEndOfDay + "...enddate..." + atEndOfDay.getTime());
        return atEndOfDay.getTime();
    }

    public static long getStartDateNew(String startDate) {
        SimpleDateFormat sdf = new SimpleDateFormat(MM_DD_YYY);
        Date date = null;
        try {
            date = sdf.parse(startDate);
        }
        catch (ParseException e) {
            logger.debug("........." + e.getMessage());
        }
        Date atStartOfDay = AuditHistoryImpl.atStartOfDay(date);
        logger.debug(atStartOfDay + ".....startdate..." + atStartOfDay.getTime());
        return atStartOfDay.getTime();
    }

    @Override
    public List<AuditHistory> getAllMCAuditHistory(int cloudId, List<String> mcList, String fromDate, String toDate) {
        Criteria criteria = new Criteria();
        long startDateMills = AuditHistoryImpl.getStartDateNew(fromDate);
        long endDateMills = AuditHistoryImpl.getEndOfDayNew(toDate);
        if (!CollectionUtils.isEmpty(mcList)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)"mcName").in(mcList), Criteria.where((String)"isMiniCloud").is((Object)true), Criteria.where((String)TIME_STAMP).gte((Object)startDateMills), Criteria.where((String)TIME_STAMP).lte((Object)endDateMills)});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)"isMiniCloud").is((Object)true), Criteria.where((String)TIME_STAMP).gte((Object)startDateMills), Criteria.where((String)TIME_STAMP).lte((Object)endDateMills)});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{TIME_STAMP}));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, AuditHistory.class);
    }

    @Override
    public UnusualDataActivityHistory getEventBasedOnId(String id, int cloudId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)id)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        UnusualDataActivityHistory unusualDataActivity = (UnusualDataActivityHistory)mongoTemplate.findOne(query, UnusualDataActivityHistory.class);
        return unusualDataActivity;
    }

    @Override
    public void updateUnusualActivityaction(String id, int cloudId, boolean active) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)id)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Update update = new Update();
        update.set("active", (Object)active);
        mongoTemplate.updateFirst(query, update, UnusualDataActivityHistory.class);
    }

    @Override
    public void updateAllUnusualActivities(String deviceUUID, int cloudId, boolean active) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceUUID").is((Object)deviceUUID)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Update update = new Update();
        update.set("active", (Object)active);
        mongoTemplate.updateMulti(query, update, UnusualDataActivityHistory.class);
    }

    @Override
    public List<UnusualDataActivityHistory> getAllUnusualActivitiesForDevice(int cloudId, String cloudName, String device, String user, int offset, int rows, boolean isActiveDetailsOnly, boolean OnlyRansomewarepossibilities, boolean isAuditHistory) {
        Query query;
        Calendar cal = Calendar.getInstance();
        cal.add(6, -7);
        long fromDate = cal.getTimeInMillis();
        long endDate = System.currentTimeMillis();
        Criteria criteria = new Criteria();
        Criteria criteria3 = new Criteria();
        Criteria criteria4 = new Criteria();
        if (OnlyRansomewarepossibilities) {
            if (StringUtils.isNotEmpty((String)user) && StringUtils.isNotEmpty((String)device)) {
                if (isActiveDetailsOnly) {
                    criteria.andOperator(new Criteria[]{Criteria.where((String)USERNAME).is((Object)user), Criteria.where((String)ACTIONTYPE).is((Object)112), Criteria.where((String)DEVICENAME).is((Object)device), Criteria.where((String)"Active").is((Object)isActiveDetailsOnly), Criteria.where((String)"possibleRansomeware").is((Object)OnlyRansomewarepossibilities)});
                } else {
                    criteria.andOperator(new Criteria[]{Criteria.where((String)USERNAME).is((Object)user), Criteria.where((String)ACTIONTYPE).is((Object)112), Criteria.where((String)DEVICENAME).is((Object)device), Criteria.where((String)"possibleRansomeware").is((Object)OnlyRansomewarepossibilities)});
                }
            } else if (isActiveDetailsOnly) {
                criteria.andOperator(new Criteria[]{Criteria.where((String)ACTIONTYPE).is((Object)112), Criteria.where((String)"Active").is((Object)isActiveDetailsOnly), Criteria.where((String)"possibleRansomeware").is((Object)OnlyRansomewarepossibilities)});
                query = new Query((CriteriaDefinition)criteria);
            } else {
                criteria.andOperator(new Criteria[]{Criteria.where((String)ACTIONTYPE).is((Object)112), Criteria.where((String)"possibleRansomeware").is((Object)OnlyRansomewarepossibilities)});
            }
        } else if (StringUtils.isNotEmpty((String)user) && StringUtils.isNotEmpty((String)device)) {
            if (isActiveDetailsOnly) {
                criteria.andOperator(new Criteria[]{Criteria.where((String)USERNAME).is((Object)user), Criteria.where((String)ACTIONTYPE).is((Object)112), Criteria.where((String)DEVICENAME).is((Object)device), Criteria.where((String)"Active").is((Object)isActiveDetailsOnly)});
            } else {
                criteria.andOperator(new Criteria[]{Criteria.where((String)USERNAME).is((Object)user), Criteria.where((String)ACTIONTYPE).is((Object)112), Criteria.where((String)DEVICENAME).is((Object)device)});
            }
        } else if (isActiveDetailsOnly) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)ACTIONTYPE).is((Object)112), Criteria.where((String)"Active").is((Object)isActiveDetailsOnly)});
            query = new Query((CriteriaDefinition)criteria);
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)ACTIONTYPE).is((Object)112)});
        }
        if (!isAuditHistory) {
            Criteria criteria1 = Criteria.where((String)TIME_STAMP).gte((Object)fromDate);
            Criteria criteria2 = Criteria.where((String)TIME_STAMP).lte((Object)endDate);
            criteria3.andOperator(new Criteria[]{criteria1, criteria2});
        }
        criteria4.andOperator(new Criteria[]{criteria, criteria3});
        query = new Query((CriteriaDefinition)criteria4);
        query.with(new Sort(Sort.Direction.DESC, new String[]{TIME_STAMP}));
        if (offset > 0) {
            query.skip((long)offset);
        }
        if (rows > 0) {
            query.limit(rows);
        }
        logger.debug("query string...." + query.toString());
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, UnusualDataActivityHistory.class);
    }

    @Override
    public long getUnusualActivityCount(int cloudId, String cloudName, String deviceName, String userName, boolean active, boolean onlyRansomewarepossibilities, boolean isAuditHistory) {
        Calendar cal = Calendar.getInstance();
        cal.add(6, -7);
        long fromDate = cal.getTimeInMillis();
        long endDate = System.currentTimeMillis();
        Criteria criteria3 = new Criteria();
        Criteria criteria4 = new Criteria();
        Query query = new Query();
        Criteria andCriteria = new Criteria();
        if (onlyRansomewarepossibilities) {
            if (StringUtils.isNotEmpty((String)userName) && StringUtils.isNotEmpty((String)userName) && !active) {
                andCriteria.andOperator(new Criteria[]{Criteria.where((String)USERNAME).is((Object)userName), Criteria.where((String)ACTIONTYPE).is((Object)112), Criteria.where((String)DEVICENAME).is((Object)deviceName), Criteria.where((String)"possibleRansomeware").is((Object)onlyRansomewarepossibilities)});
            } else if (StringUtils.isNotEmpty((String)userName) && StringUtils.isNotEmpty((String)deviceName) && active) {
                andCriteria.andOperator(new Criteria[]{Criteria.where((String)USERNAME).is((Object)userName), Criteria.where((String)ACTIONTYPE).is((Object)112), Criteria.where((String)DEVICENAME).is((Object)deviceName), Criteria.where((String)"active").is((Object)true), Criteria.where((String)"possibleRansomeware").is((Object)onlyRansomewarepossibilities)});
            } else if (StringUtils.isEmpty((String)userName) && StringUtils.isEmpty((String)deviceName) && active) {
                andCriteria.andOperator(new Criteria[]{Criteria.where((String)"active").is((Object)true), Criteria.where((String)"possibleRansomeware").is((Object)onlyRansomewarepossibilities)});
            }
        } else if (StringUtils.isNotEmpty((String)deviceName) && StringUtils.isNotEmpty((String)userName) && !active) {
            andCriteria.andOperator(new Criteria[]{Criteria.where((String)USERNAME).is((Object)userName), Criteria.where((String)ACTIONTYPE).is((Object)112), Criteria.where((String)DEVICENAME).is((Object)deviceName)});
        } else if (StringUtils.isNotEmpty((String)userName) && StringUtils.isNotEmpty((String)deviceName) && active) {
            andCriteria.andOperator(new Criteria[]{Criteria.where((String)USERNAME).is((Object)userName), Criteria.where((String)ACTIONTYPE).is((Object)112), Criteria.where((String)DEVICENAME).is((Object)deviceName), Criteria.where((String)"active").is((Object)true)});
        } else if (StringUtils.isEmpty((String)deviceName) && StringUtils.isEmpty((String)userName) && active) {
            andCriteria.andOperator(new Criteria[]{Criteria.where((String)"active").is((Object)true)});
        }
        if (!isAuditHistory) {
            Criteria criteria1 = Criteria.where((String)TIME_STAMP).gte((Object)fromDate);
            Criteria criteria2 = Criteria.where((String)TIME_STAMP).lte((Object)endDate);
            criteria3.andOperator(new Criteria[]{criteria1, criteria2});
        }
        criteria4.andOperator(new Criteria[]{andCriteria, criteria3});
        query.addCriteria((CriteriaDefinition)criteria4);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.count(query, UnusualDataActivityHistory.class);
    }

    @Override
    public void saveAudit(int cloudId, String cloudName, UnusualDataActivityHistory audit) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.save((Object)audit);
    }

    private synchronized void initialiseMap(int cloudId) {
        Set<String> superAdminNames;
        logger.debug("INITIALIZE cloud map............");
        if (superAdminMap == null) {
            superAdminMap = new HashMap();
        }
        if ((superAdminNames = this.getAllSuperAdmins(cloudId)) == null || superAdminNames.isEmpty()) {
            return;
        }
        if (!CollectionUtils.isEmpty(superAdminNames)) {
            superAdminMap.put("superAdminMap", superAdminNames);
            logger.debug("INITIALIZE superAdminNames ............" + superAdminNames);
        }
    }

    @Override
    public Set<String> getAllSuperAdmins(int cloudId) {
        HashSet<String> superAdminNames = new HashSet<String>();
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"superAdmin").is((Object)true), criteria.orOperator(new Criteria[]{Criteria.where((String)DELETED).is((Object)false), Criteria.where((String)DELETED).exists(false)})});
        Query query = new Query((CriteriaDefinition)criteria);
        List superAdmins = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, User.class);
        if (!CollectionUtils.isEmpty((Collection)superAdmins)) {
            for (User user : superAdmins) {
                superAdminNames.add(user.getUserName());
            }
        }
        return superAdminNames;
    }

    public MongoOperations getMongoAuditOps() {
        return this.mongoAuditOps;
    }

    public void setMongoAuditOps(MongoOperations mongoAuditOps) {
        this.mongoAuditOps = mongoAuditOps;
    }
}

