/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pcbd.dao.impl;

import com.parablu.factory.ParacloudMongoFactoryUtils;
import com.parablu.pcbd.dao.AlertHistoryDao;
import com.parablu.pcbd.domain.AlertHistory;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.User;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.bson.types.ObjectId;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;

public class AlertHistoryDaoImpl
implements AlertHistoryDao {
    ParacloudMongoFactoryUtils paracloudMongoFactoryUtils;
    private static final String USER_NAME = "userName";
    private static final String BATCH_END_TIME_STAMP = "batchEndTimestamp";

    public ParacloudMongoFactoryUtils getParacloudMongoFactoryUtils() {
        return this.paracloudMongoFactoryUtils;
    }

    public void setParacloudMongoFactoryUtils(ParacloudMongoFactoryUtils paracloudMongoFactoryUtils) {
        this.paracloudMongoFactoryUtils = paracloudMongoFactoryUtils;
    }

    @Override
    public void saveAlertHistory(int cloudId, String cloudName, AlertHistory alertHistory) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.save((Object)alertHistory);
    }

    @Override
    public List<AlertHistory> getAllAlertHistory(int cloudId, String cloudName) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.findAll(AlertHistory.class);
    }

    @Override
    public AlertHistory getAlertHistory(int cloudId, String cloudName, ObjectId alertHistoryId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)alertHistoryId)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.limit(1);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (AlertHistory)mongoTemplate.findOne(query, AlertHistory.class);
    }

    @Override
    public List<AlertHistory> getAllAlertHistoryForJobType(int cloudId, String cloudName, String userName, String deviceName, long startOfDay, long endOfDay) {
        Criteria criteria = new Criteria();
        Criteria criteria2 = Criteria.where((String)"jobType").is((Object)"BACKUP");
        ArrayList<Criteria> list = new ArrayList<Criteria>();
        list.add(criteria2);
        this.addUsersCriteria(cloudId, userName, list);
        this.addDeviceCriteria(cloudId, deviceName, list);
        this.addStartAndEndDateBetweenCriteria(startOfDay, endOfDay, list);
        criteria.andOperator(list.toArray(new Criteria[list.size()]));
        return this.getListOfAlertHistory(cloudId, criteria);
    }

    private void addUsersCriteria(int cloudId, String userName, List<Criteria> list) {
        if (!StringUtils.isEmpty((String)userName)) {
            List<User> users = this.getUsersForName(cloudId, userName);
            Criteria criteria3 = Criteria.where((String)"user").in(users);
            list.add(criteria3);
        }
    }

    private List<User> getUsersForName(int cloudId, String userName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i")});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, User.class);
    }

    private void addDeviceCriteria(int cloudId, String deviceName, List<Criteria> list) {
        if (!StringUtils.isEmpty((String)deviceName)) {
            List<Device> devices = this.getDevicesForName(cloudId, deviceName);
            Criteria criteria4 = Criteria.where((String)"device").in(devices);
            list.add(criteria4);
        }
    }

    private List<Device> getDevicesForName(int cloudId, String deviceName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceName").is((Object)deviceName)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, Device.class);
    }

    private List<AlertHistory> getListOfAlertHistory(int cloudId, Criteria criteria) {
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{BATCH_END_TIME_STAMP}));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, AlertHistory.class);
    }

    private void addStartAndEndDateBetweenCriteria(Long fromDate, Long endDate, List<Criteria> list) {
        Criteria criteria5 = Criteria.where((String)"batchStartTimestamp").gte((Object)fromDate);
        Criteria criteria6 = Criteria.where((String)"batchStartTimestamp").lte((Object)endDate);
        list.add(criteria5);
        list.add(criteria6);
        Criteria criteria7 = Criteria.where((String)BATCH_END_TIME_STAMP).gte((Object)fromDate);
        Criteria criteria8 = Criteria.where((String)BATCH_END_TIME_STAMP).lte((Object)endDate);
        list.add(criteria7);
        list.add(criteria8);
    }

    @Override
    public void deleteAlertHistoryForUser(int cloudId, String cloudName, String userName) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        User user = (User)mongoTemplate.findOne(query, User.class);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"user").is((Object)user)});
        Query query1 = new Query((CriteriaDefinition)criteria);
        mongoTemplate.remove(query1, AlertHistory.class);
    }

    @Override
    public void deleteAlertHistoryForDevice(int cloudId, Device device) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"device").is((Object)device)});
        Query query1 = new Query((CriteriaDefinition)criteria);
        mongoTemplate.remove(query1, AlertHistory.class);
    }
}

