/*
 * Decompiled with CFR 0.152.
 */
package com.pg.listener;

import com.parablu.paracloud.element.CloudPropertyElement;
import com.parablu.pcbd.domain.C2CAppSettings;
import com.parablu.pcbd.domain.Components;
import com.parablu.pcbd.domain.MSAppSetting;
import com.pg.helper.constant.PCHelperConstant;
import com.pg.service.ComponentSettingService;
import com.pg.service.JobConfigService;
import com.pg.service.UtilService;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;

public class InitiateSettings {
    private static Logger logger = LogManager.getLogger(InitiateSettings.class);
    private ComponentSettingService componentSettingService;
    private JobConfigService jobConfigService;
    @Autowired
    private UtilService utilService;

    public ComponentSettingService getComponentSettingService() {
        return this.componentSettingService;
    }

    public void setComponentSettingService(ComponentSettingService componentSettingService) {
        this.componentSettingService = componentSettingService;
    }

    public void setJobConfigService(JobConfigService jobConfigService) {
        this.jobConfigService = jobConfigService;
    }

    public void setUtilService(UtilService utilService) {
        this.utilService = utilService;
    }

    public void initiateComponentProperty() {
        this.initiatePropertiesFromDB();
    }

    private void initiatePropertiesFromDB() {
        logger.debug("Inside InitiateSettings");
        Properties props = null;
        try {
            ClassPathResource resource = new ClassPathResource("privacygateway.properties");
            props = PropertiesLoaderUtils.loadProperties((Resource)resource);
            Components components = this.componentSettingService.getComponents(props.getProperty("componentName"), 1);
            logger.debug("getting components properties from db of" + components.getComponentName());
            Map componentProperties = components.getComponentsProperties();
            CloudPropertyElement cloudPropertyElement = this.componentSettingService.getCloudPropertyElement(1);
            if (cloudPropertyElement == null) {
                logger.debug("cloud property element is null at the first time so setting default values");
                cloudPropertyElement = new CloudPropertyElement();
                this.setDefaultValuesToCloudPropertyElement(cloudPropertyElement);
                logger.debug("Cloud property element vlaue adfsurl>>" + cloudPropertyElement.getAdfsUrl());
            }
            MSAppSetting msAppSetting = this.utilService.getMSAppSettingsDetails(1);
            C2CAppSettings c2cAppSettings = this.utilService.geC2CAppSettingsDetails(1);
            if (msAppSetting != null) {
                PCHelperConstant.setMSClientId((String)msAppSetting.getClientId());
                PCHelperConstant.setMSClientSecret((String)msAppSetting.getClientSecretKey());
                PCHelperConstant.setMSTenantId((String)msAppSetting.getTenantId());
                PCHelperConstant.setMSSharePointUrl((String)msAppSetting.getClientTokenURL());
            }
            if (c2cAppSettings != null) {
                PCHelperConstant.setC2cGraphClientId((String)c2cAppSettings.getClientId());
                PCHelperConstant.setC2cGraphClientSecret((String)c2cAppSettings.getClientSecretKey());
                PCHelperConstant.setC2cGraphTenantId((String)c2cAppSettings.getTenantId());
            } else if (msAppSetting != null) {
                PCHelperConstant.setC2cGraphClientId((String)msAppSetting.getClientId());
                PCHelperConstant.setC2cGraphClientSecret((String)msAppSetting.getClientSecretKey());
                PCHelperConstant.setC2cGraphTenantId((String)msAppSetting.getTenantId());
            }
            try {
                PCHelperConstant.setSkipOverLoadCount((int)Integer.parseInt((String)componentProperties.get("skipOverLoadCount")));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                PCHelperConstant.setUploadLocalChunkLimit((int)Integer.parseInt((String)componentProperties.get("uploadLocalChunkLimit")));
            }
            catch (Exception exception) {
                // empty catch block
            }
            PCHelperConstant.setHttpEnabled((boolean)cloudPropertyElement.isHttpEnabled());
            PCHelperConstant.setMuxedEnabled((boolean)cloudPropertyElement.isMuxedEnabled());
            PCHelperConstant.setNumOfChunksToCheckPgOverloadLimit((int)(cloudPropertyElement.getNumOfChunksToCheckPgOverloadLimit() == 0 ? 10 : cloudPropertyElement.getNumOfChunksToCheckPgOverloadLimit()));
            PCHelperConstant.setNumOfHitsToDBForContentChunkCheck((int)(cloudPropertyElement.getNumOfHitsToDBForContentChunkCheck() == 0 ? 10 : cloudPropertyElement.getNumOfHitsToDBForContentChunkCheck()));
            PCHelperConstant.setBrevityLogging((boolean)cloudPropertyElement.isBrevityLogging());
            PCHelperConstant.setGlobalCheckForLocalStorage((boolean)cloudPropertyElement.isGlobalCheckForLocalStorage());
            PCHelperConstant.setComponentName((String)props.getProperty("componentName"));
            PCHelperConstant.setPropertyFileValueParacloudMountPoint((String)cloudPropertyElement.getMntParacloudPath());
            PCHelperConstant.setPropertyFileValueSslAuthEnabled((String)String.valueOf(cloudPropertyElement.getSslAuthEnabled()));
            PCHelperConstant.setSearchExclusionExtName((String)cloudPropertyElement.getSearchExclusionExtName());
            PCHelperConstant.setMigratedTenant((boolean)cloudPropertyElement.isMigratedTenant());
            PCHelperConstant.setBlobFuseEnabled((boolean)cloudPropertyElement.isBlobFuseEnabled());
            logger.debug(PCHelperConstant.isMigratedTenant() + "...getNumOfChunksToCheckPgOverloadLimit----" + PCHelperConstant.getNumOfChunksToCheckPgOverloadLimit());
            logger.debug("getNumOfChunksToCheckPgOverloadLimit----" + PCHelperConstant.getNumOfHitsToDBForContentChunkCheck());
            PCHelperConstant.setOneDriveBackupType((String)cloudPropertyElement.getOneDriveBackupType());
            PCHelperConstant.setClamAvScanDelayInSec((int)cloudPropertyElement.getClamAvScanDelayInSec());
            PCHelperConstant.setNumOfSecsToWaitBeforeSEndDummyContentToAgent((int)(cloudPropertyElement.getNumOfSecsToWaitBeforeSEndDummyContentToAgent() == 0 ? 10 : cloudPropertyElement.getNumOfSecsToWaitBeforeSEndDummyContentToAgent()));
            if (componentProperties.containsKey("encryptionEnabled")) {
                PCHelperConstant.setPropertyFileValueEncryptionEnabled((String)((String)componentProperties.get("encryptionEnabled")));
            }
            if (componentProperties.containsKey("ftpHost")) {
                PCHelperConstant.setSyncFtpHostProperty((String)((String)componentProperties.get("ftpHost")));
            }
            if (componentProperties.containsKey("syncUploadPath")) {
                PCHelperConstant.setPropertyFileValueSyncUploadPath((String)((String)componentProperties.get("syncUploadPath")));
            }
            if (componentProperties.containsKey("syncFtpEnabled")) {
                PCHelperConstant.setPropertyFileValueSyncFtpEnabled((String)((String)componentProperties.get("syncFtpEnabled")));
            }
            if (componentProperties.containsKey("localStorageEnabled")) {
                PCHelperConstant.setPropertyFileValueLocalStorageEnabled((String)((String)componentProperties.get("localStorageEnabled")));
            }
            if (componentProperties.containsKey("ftpUser")) {
                PCHelperConstant.setSyncFtpUserProperty((String)((String)componentProperties.get("ftpUser")));
            }
            if (componentProperties.containsKey("ftpPwd")) {
                PCHelperConstant.setSyncFtpPwdProperty((String)((String)componentProperties.get("ftpPwd")));
            }
            if (componentProperties.containsKey("odbFrequencyCallValue")) {
                PCHelperConstant.setODBCallFrequency((String)((String)componentProperties.get("odbFrequencyCallValue")));
            }
            if (componentProperties.containsKey("queryLimit")) {
                PCHelperConstant.setQueryLimit((String)((String)componentProperties.get("queryLimit")));
            }
            if (componentProperties.containsKey("uploadFileSizeLimitInMB")) {
                PCHelperConstant.setUploadFileSizeLimitInMB((String)((String)componentProperties.get("uploadFileSizeLimitInMB")));
            }
            if (componentProperties.containsKey("proxyPassword")) {
                PCHelperConstant.setProxyPassword((String)((String)componentProperties.get("proxyPassword")));
            }
            if (componentProperties.containsKey("paracloudUrl")) {
                PCHelperConstant.setPropertyFileValueParacloudUrl((String)((String)componentProperties.get("paracloudUrl")));
            }
            if (componentProperties.containsKey("proxyParacloudUrl")) {
                PCHelperConstant.setProxyParacloudUrl((String)((String)componentProperties.get("proxyParacloudUrl")));
            } else {
                PCHelperConstant.setProxyParacloudUrl((String)((String)componentProperties.get("paracloudUrl")));
            }
            if (componentProperties.containsKey("gatewayName")) {
                PCHelperConstant.setPropertyFileValueGatewayname((String)((String)componentProperties.get("gatewayName")));
            }
            if (componentProperties.containsKey("odbUserAgentVal")) {
                PCHelperConstant.setODBDecorationValue((String)((String)componentProperties.get("odbUserAgentVal")));
            }
            if (componentProperties.containsKey("odbRetryFolderVal")) {
                PCHelperConstant.setRetryOdbFolderValue((String)((String)componentProperties.get("odbRetryFolderVal")));
            }
            if (componentProperties.containsKey("bkpColQueryRequired")) {
                PCHelperConstant.setBackupCollectionQueryRequired((String)((String)componentProperties.get("bkpColQueryRequired")));
            }
            if (componentProperties.containsKey("chunkColQueryRequired")) {
                PCHelperConstant.setChunkCollectionQueryRequired((String)((String)componentProperties.get("chunkColQueryRequired")));
            }
            if (componentProperties.containsKey("chunkTotalBuckets")) {
                PCHelperConstant.setChunkTotalBuckets((String)((String)componentProperties.get("chunkTotalBuckets")));
            }
            if (componentProperties.containsKey("updateGatewayWhenChunkNotFound")) {
                PCHelperConstant.setPropertyFileValueUpdatepgnameWhenChunkNotFoundMultipgenv((String)((String)componentProperties.get("updateGatewayWhenChunkNotFound")));
            }
            if (componentProperties.containsKey("deleteBkpTblWhenChnkNotFound")) {
                PCHelperConstant.setPropertyFileValueDeleteBkptblWhenChunksNotFound((String)((String)componentProperties.get("deleteBkpTblWhenChnkNotFound")));
            }
            if (componentProperties.containsKey("noOfJobThreads")) {
                PCHelperConstant.setJobThreadLimit((String)((String)componentProperties.get("noOfJobThreads")));
            }
            if (componentProperties.containsKey("chunkUpdateMaxRetry")) {
                PCHelperConstant.setMaxRetryForChunkUpdate((String)((String)componentProperties.get("chunkUpdateMaxRetry")));
            }
            if (componentProperties.containsKey("proxyHost")) {
                PCHelperConstant.setProxyHost((String)((String)componentProperties.get("proxyHost")));
            }
            if (componentProperties.containsKey("proxyPort")) {
                PCHelperConstant.setProxyPort((String)((String)componentProperties.get("proxyPort")));
            }
            if (componentProperties.containsKey("proxyUserName")) {
                PCHelperConstant.setProxyUserName((String)((String)componentProperties.get("proxyUserName")));
            }
            if (componentProperties.containsKey("officeDownloadThreads")) {
                PCHelperConstant.setOfficeThreadsValue((String)((String)componentProperties.get("officeDownloadThreads")));
            }
            if (componentProperties.containsKey("pgOverloadLimit")) {
                PCHelperConstant.setPGOverloadLimit((String)((String)componentProperties.get("pgOverloadLimit")));
            }
            if (componentProperties.containsKey("o365BkpThreadsLimit")) {
                PCHelperConstant.setNoOfO365BkpThreads((String)((String)componentProperties.get("o365BkpThreadsLimit")));
            }
            if (componentProperties.containsKey("crawlThreadsLimit")) {
                PCHelperConstant.setCrawlThreadsLimit((String)((String)componentProperties.get("crawlThreadsLimit")));
            }
            if (componentProperties.containsKey("graphTimeoutInMins")) {
                PCHelperConstant.setGraphTimeoutInMins((String)((String)componentProperties.get("graphTimeoutInMins")));
            }
            if (componentProperties.containsKey("pgOverLoadInactivityPeriod")) {
                PCHelperConstant.setPGOverLoadInactivityPeriod((String)((String)componentProperties.get("pgOverLoadInactivityPeriod")));
            }
            if (componentProperties.containsKey("resoreQueryLimit")) {
                PCHelperConstant.setRestoreQueryLimit((String)((String)componentProperties.get("resoreQueryLimit")));
            }
            if (componentProperties.containsKey("stopJobsEnabled")) {
                PCHelperConstant.setJobsStopEnabled((String)((String)componentProperties.get("stopJobsEnabled")));
            }
            if (componentProperties.containsKey("noOfThreads")) {
                PCHelperConstant.setThreadLimit((String)((String)componentProperties.get("noOfThreads")));
            }
            if (componentProperties.containsKey("delayInUploadInSec")) {
                PCHelperConstant.setDelayInUploadInSec((String)((String)componentProperties.get("delayInUploadInSec")));
            }
            if (componentProperties.containsKey("delayIn429CaseInSec")) {
                PCHelperConstant.setDelayIn429CaseInSec((String)((String)componentProperties.get("delayIn429CaseInSec")));
            }
            if (componentProperties.containsKey("countOfContinuous429")) {
                PCHelperConstant.setCountOfContinuous429((String)((String)componentProperties.get("countOfContinuous429")));
            }
            if (componentProperties.containsKey("countOfODBFiles")) {
                PCHelperConstant.setCountOfODBFiles((String)((String)componentProperties.get("countOfODBFiles")));
            }
            if (componentProperties.containsKey("addn429WaitMultiplier")) {
                logger.debug(".... additional wait for 429 like 1x of sleep... " + (String)componentProperties.get("addn429WaitMultiplier"));
                PCHelperConstant.setAddn429WaitMultiplier((String)((String)componentProperties.get("addn429WaitMultiplier")));
            }
            if (componentProperties.containsKey("numOfThreadsToUseForContentChunkFile")) {
                logger.debug(".... NO_OF_THREADS_CONTENTCHUNK... " + (String)componentProperties.get("numOfThreadsToUseForContentChunkFile"));
                PCHelperConstant.setNumOfThreadsToUseForContentChunkFile((String)((String)componentProperties.get("numOfThreadsToUseForContentChunkFile")));
            }
            if (this.jobConfigService.getJobConfigByServerName(1, components.getComponentName()) != null) {
                PCHelperConstant.setJobConfig(this.jobConfigService.getJobConfigByServerName(1, components.getComponentName()));
            }
            if (componentProperties.containsKey("ODBDownloadPriorityTimeStamp")) {
                logger.debug(".... ODBDownloadPriorityTimeStamp... " + (String)componentProperties.get("ODBDownloadPriorityTimeStamp"));
                PCHelperConstant.setODBDownloadPriorityTimeStamp((String)((String)componentProperties.get("ODBDownloadPriorityTimeStamp")));
            }
            if (componentProperties.containsKey("paracloud")) {
                logger.debug(".... checking if it is a paracloud machine sant... " + (String)componentProperties.get("paracloud"));
                if (StringUtils.isNotEmpty((CharSequence)((CharSequence)componentProperties.get("paracloud")))) {
                    PCHelperConstant.setParacloud((((String)componentProperties.get("paracloud")).equals("true") ? 1 : 0) != 0);
                } else {
                    PCHelperConstant.setParacloud((boolean)false);
                }
            }
            if (componentProperties.containsKey("moveFileFromBkpToLocalInterval")) {
                logger.debug(".... MOVE_FILES_FROM_BKP_TO_LOCAL_INTERVAL... " + (String)componentProperties.get("moveFileFromBkpToLocalInterval"));
                PCHelperConstant.setMoveFileFromBkpToLocalInterval((String)((String)componentProperties.get("moveFileFromBkpToLocalInterval")));
                logger.debug(".... PCHELPER_MOVE_FILES_FROM_BKP_TO_LOCAL_INTERVAL... " + PCHelperConstant.getMoveFileFromBkpToLocalInterval());
            }
            if (componentProperties.containsKey("numOfThreadsToUseForPSTCreation")) {
                PCHelperConstant.setNumOfThreadsToUseForPSTCreation((int)Integer.valueOf((String)componentProperties.get("numOfThreadsToUseForPSTCreation")));
            }
            if (componentProperties.containsKey("delayInMillisecForChunksDuringUpload")) {
                PCHelperConstant.setDelayInMillisecForChunksDuringUpload((int)Integer.valueOf((String)componentProperties.get("delayInMillisecForChunksDuringUpload")));
            }
            logger.debug(PCHelperConstant.isParacloud() + "..sant.getDelayInMillisecForChunksDuringUpload...." + PCHelperConstant.getDelayInMillisecForChunksDuringUpload());
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("  ********************EXCEPTION while trying to load " + e);
        }
    }

    private void setDefaultValuesToCloudPropertyElement(CloudPropertyElement cloudProperty2Element) {
        CloudPropertyElement cloudPropertyElement = cloudProperty2Element;
        cloudPropertyElement.setMntParacloudPath("/mnt/");
        cloudPropertyElement.setSslAuthEnabled(false);
        cloudPropertyElement.setBrevityLogging(true);
        cloudPropertyElement.setGlobalCheckForLocalStorage(false);
        cloudPropertyElement.setNumOfChunksToCheckPgOverloadLimit(10);
    }
}

