/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.graphsdk;

import com.parablu.graphsdk.IAuthorizationManager;
import com.parablu.graphsdk.TestAuthorizationManager;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.net.ssl.SSLException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.BoundRequestBuilder;
import org.asynchttpclient.DefaultAsyncHttpClient;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.asynchttpclient.Response;
import org.asynchttpclient.proxy.ProxyServer;

public class MSGraphHelper {
    private final String host;
    private final String userName;
    private final IAuthorizationManager authManager;
    private AsyncHttpClient asyncHttpClient;
    private String token;
    private String tokenHeader;
    static final Logger logger = LogManager.getLogger(MSGraphHelper.class);

    private void ConstructTokenHeader() {
        this.token = this.authManager.getTokenForUser(this.userName);
        this.tokenHeader = "Bearer " + this.token;
    }

    public String getHost() {
        return this.host;
    }

    public String getTokenHeader() {
        return this.tokenHeader;
    }

    public CompletableFuture<Response> get(String apiEndpoint) {
        String url = this.host + apiEndpoint;
        logger.trace("RESTHELPER : GET URL " + url);
        return ((BoundRequestBuilder)((BoundRequestBuilder)this.asyncHttpClient.prepareGet(url).addHeader((CharSequence)"Authorization", this.tokenHeader)).addHeader((CharSequence)"Accept", "application/json")).execute().toCompletableFuture().exceptionally(e -> {
            logger.error("FAILED : GET for " + url + " " + e.getCause() + e.toString() + e.getClass());
            return null;
        });
    }

    public CompletableFuture<Response> post(String apiEndpoint) {
        String url = this.host + apiEndpoint;
        return ((BoundRequestBuilder)this.asyncHttpClient.preparePost(url).addHeader((CharSequence)"Authorization", this.tokenHeader)).execute().toCompletableFuture().exceptionally(e -> {
            logger.error("failed for " + url + " " + e.getCause());
            return null;
        });
    }

    private MSGraphHelper(Builder val) throws SSLException {
        logger.info("Building MSGraphHelper!");
        this.host = val.host;
        this.userName = val.userName;
        this.authManager = val.authManager;
        try {
            this.ConstructTokenHeader();
            logger.info("token header done!");
            SslContext sslContext = SslContextBuilder.forClient().sslProvider(SslProvider.JDK).trustManager(InsecureTrustManagerFactory.INSTANCE).build();
            logger.info("Building DefaultAsyncHttpClientConfig!");
            DefaultAsyncHttpClientConfig asyncHttpClientConfig = new DefaultAsyncHttpClientConfig.Builder().setSslContext(sslContext).build();
            this.asyncHttpClient = new DefaultAsyncHttpClient((AsyncHttpClientConfig)asyncHttpClientConfig);
        }
        catch (Throwable e) {
            this.asyncHttpClient = null;
            logger.error("Failed to launch things", e);
        }
    }

    public static class ProxySettings {
        public String host;
        public int port;
        public int securedPort;

        public ProxySettings(String host, int port, int securedPort) {
            this.host = host;
            this.port = port;
            this.securedPort = securedPort;
        }
    }

    public static class Builder {
        private String host = null;
        private String userName = null;
        private String version = null;
        private IAuthorizationManager authManager = null;
        private ProxyServer ps = null;

        public Builder host(String val) {
            this.host = val;
            return this;
        }

        public Builder version(String val) {
            this.version = val;
            return this;
        }

        public Builder userName(String val) {
            this.userName = val;
            return this;
        }

        public Builder authManager(IAuthorizationManager val) {
            this.authManager = val;
            return this;
        }

        public Builder proxy(Optional<ProxySettings> proxy) {
            this.ps = new ProxyServer.Builder(proxy.get().host, proxy.get().port).setSecuredPort(proxy.get().securedPort).build();
            return this;
        }

        public MSGraphHelper build() throws SSLException {
            if (this.host == null) {
                this.host = "https://graph.microsoft.com/";
            }
            if (this.version == null) {
                this.version = "v1.0";
            }
            if (this.authManager == null) {
                this.authManager = new TestAuthorizationManager();
            }
            this.host = this.host + this.version + "/";
            return new MSGraphHelper(this);
        }
    }
}

