/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.cloudcontroller.Util;

import com.parablu.cloudcontroller.Util.GlobalStrings;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Optional;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public enum Config {
    GETINST;

    private Properties prop = null;
    private boolean initialized = false;
    private boolean isInteractive = false;
    private boolean isController = false;
    private String InstallFilePath = null;
    private final Logger logger = LogManager.getLogger(Config.class);

    private Config() {
        try (FileInputStream input = new FileInputStream("/etc/default/CloudController");){
            this.prop = new Properties();
            this.prop.load(input);
            this.initialized = true;
        }
        catch (FileNotFoundException e) {
            this.initialized = false;
            this.logger.error("Failed to get file ", (Throwable)e);
        }
        catch (IOException e) {
            this.initialized = false;
            this.logger.error("Error happened ", (Throwable)e);
        }
    }

    private String getEnvironmentConfig() {
        Properties props = new Properties();
        try {
            props.load(new FileInputStream(GlobalStrings.ETC_DEFAULT_PARAMS.toString()));
            Optional<String> serviceRole = this.getProperty(GlobalStrings.SERVICE_ROLE);
            serviceRole.ifPresent(role -> {
                this.isController = role.equals("controller");
            });
            return props.getProperty(GlobalStrings.CONFIG_PATH_ENV.toString());
        }
        catch (IOException e) {
            return null;
        }
    }

    public boolean isInit() {
        return this.initialized;
    }

    private Optional<String> getProperty(String property) {
        if (!this.initialized) {
            this.logger.error("Config not initialized to fetch " + property);
            return Optional.empty();
        }
        String value = this.prop.getProperty(property);
        if (value != null) {
            value = value.trim();
        }
        return Optional.ofNullable(value);
    }

    public Optional<String> getProperty(GlobalStrings value) {
        return this.getProperty(value.toString());
    }

    public void enableServiceInteractive() {
        if (!this.initialized) {
            this.logger.error("Config not initialized");
        } else {
            this.isInteractive = true;
        }
    }

    public boolean isServiceInteractive() {
        return this.isInteractive;
    }

    public boolean isController() {
        return this.isController;
    }
}

