/*
 * Decompiled with CFR 0.152.
 */
package com.pg.service.impl;

import com.parablu.paracloud.element.CloudPropertyElement;
import com.parablu.pcbd.dao.CloudDao;
import com.parablu.pcbd.dao.ComponentDao;
import com.parablu.pcbd.dao.impl.CloudDaoImpl;
import com.parablu.pcbd.domain.CloudProperties;
import com.parablu.pcbd.domain.Components;
import com.pg.service.ComponentSettingService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;

public class ComponentSettingServiceImpl
implements ComponentSettingService {
    private static Logger logger = LogManager.getLogger(CloudDaoImpl.class);
    private ComponentDao componentDao;
    private CloudDao cloudDao;

    public CloudDao getCloudDao() {
        return this.cloudDao;
    }

    public void setCloudDao(CloudDao cloudDao) {
        this.cloudDao = cloudDao;
    }

    public ComponentDao getComponentDao() {
        return this.componentDao;
    }

    public void setComponentDao(ComponentDao componentDao) {
        this.componentDao = componentDao;
    }

    @Override
    public Components getComponents(String componentName, int cloudId) {
        return this.componentDao.getComponents(componentName, cloudId);
    }

    @Override
    public CloudPropertyElement getCloudPropertyElement(int cloudId) {
        CloudProperties cloudProperties = this.cloudDao.getCloudProperties(cloudId);
        CloudPropertyElement cloudPropertyElement = null;
        if (cloudProperties != null) {
            cloudPropertyElement = new CloudPropertyElement();
            BeanUtils.copyProperties((Object)cloudProperties, (Object)cloudPropertyElement);
        }
        return cloudPropertyElement;
    }

    @Override
    public void updateComponentProperties(String gatewayName, int cloudId, long noOfThreadsUsed) {
        this.componentDao.updateComponentProperties(gatewayName, cloudId, noOfThreadsUsed);
    }

    @Override
    public void updatePGOverloadLimitInComponentProperties(String gatewayName, int cloudId, String pgOverloadLimit) {
        this.componentDao.updatePGOverloadLimitInComponentProperties(gatewayName, cloudId, pgOverloadLimit);
    }
}

