/*
 * Decompiled with CFR 0.152.
 */
package com.pg.timer;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.parablu.pcbd.domain.BackupBatch;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.CloudCustomisableDetails;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.OfficeBackupPolicy;
import com.parablu.pcbd.domain.User;
import com.pg.helper.utils.MemoryStore;
import com.pg.service.MSService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CompletionService;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;
import org.quartz.SchedulerException;
import org.springframework.scheduling.quartz.QuartzJobBean;

@PersistJobDataAfterExecution
@DisallowConcurrentExecution
public class SPAutoScheduleJob
extends QuartzJobBean
implements Job {
    private MSService msService;
    private Set<String> policyUnderProcess = new HashSet<String>();
    private static Logger logger = LogManager.getLogger(SPAutoScheduleJob.class);
    private static List<OfficeBackupPolicy> officeBackupPolicyList = null;
    private TimerTask userTimerTask = null;
    private Timer userTimer = null;
    private TimerTask policyTimerTask = null;
    private Timer policyTimer = null;
    CompletionService<String> userPool = null;
    private static String SP_POLICY_TYPE = "Sharepoint";

    public void setMsService(MSService msService) {
        this.msService = msService;
    }

    protected void executeInternal(JobExecutionContext arg0) throws JobExecutionException {
        try {
            List jobs = arg0.getScheduler().getCurrentlyExecutingJobs();
            if (jobs != null && !jobs.isEmpty()) {
                for (JobExecutionContext job : jobs) {
                    if (!job.getTrigger().equals((Object)arg0.getTrigger()) || job.getJobInstance().equals((Object)this)) continue;
                    logger.debug("There's another instance running,SO skipping>>>>>>>>>>>>> : " + (Object)((Object)this));
                    return;
                }
            }
        }
        catch (SchedulerException e) {
            logger.debug("" + (Object)((Object)e));
            logger.error("" + e.getCause());
        }
        logger.debug("....SPAutoScheduleJob job started...");
        ExecutorService executor = null;
        try {
            int cloudId = 1;
            Cloud cloud = this.msService.getCloud(cloudId);
            boolean isEnabled = this.isSharePointBackupEnabled(cloud);
            if (isEnabled) {
                boolean licenseActive = this.vaildatedLicensceStatus(cloud);
                if (!licenseActive) {
                    logger.debug("....license inactive no crawl....");
                    Thread.sleep(1200000L);
                    return;
                }
                boolean threadSizeVal = true;
                executor = Executors.newFixedThreadPool(1);
                ExecutorCompletionService<String> pool = new ExecutorCompletionService<String>(executor);
                ExecutorService userExecutor = Executors.newCachedThreadPool();
                this.userPool = new ExecutorCompletionService<String>(userExecutor);
                officeBackupPolicyList = new ArrayList<OfficeBackupPolicy>();
                logger.debug("... get officeBackupPolicyList list ... " + officeBackupPolicyList.size());
                this.checkThreadStatusAndStartScheduleForPolicy(cloud, executor, pool);
                for (int i = 0; i < 1; ++i) {
                    logger.debug("Creating thread for first time policy >>>>>>>>> i value::" + i);
                    this.initiatePolicySchedules(cloud, executor, pool, true);
                }
            } else {
                logger.debug("...sp not enabled.... so sleep for 20 mins...");
                Thread.sleep(1200000L);
            }
            logger.debug(" exit upload part.........." + isEnabled);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(" exception in SPAutoScheduleJob......." + e.getMessage());
            logger.trace("exception in SPAutoScheduleJob ......." + e);
        }
        logger.debug("....SPAutoScheduleJob job ended...");
    }

    private boolean vaildatedLicensceStatus(Cloud cloud) {
        return cloud.getValidityPeriod() >= System.currentTimeMillis() && cloud.getStatusCode().equals("ACTIVE");
    }

    private boolean isSharePointBackupEnabled(Cloud cl) {
        boolean isSharePointBackupEnabled = false;
        List list = cl.getCloudCustomisableDetails();
        list.removeAll(Collections.singleton(null));
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (CloudCustomisableDetails cloudPluginDetails : list) {
                if (cloudPluginDetails == null || StringUtils.isEmpty((String)cloudPluginDetails.getName()) || !"Sharepoint Backup Enabled".equalsIgnoreCase(cloudPluginDetails.getName())) continue;
                isSharePointBackupEnabled = true;
                break;
            }
        }
        return isSharePointBackupEnabled;
    }

    private void initiatePolicySchedules(Cloud cloud, ExecutorService executor, CompletionService<String> pool, boolean firstTime) {
        logger.debug("starting policy schedules ............... :");
        Runnable schedulePolicyJob = () -> this.schdeuleUsersForPolicy(cloud, executor, pool, firstTime);
        pool.submit(schedulePolicyJob, "");
    }

    private void checkThreadStatusAndStartScheduleForPolicy(final Cloud cloud, final ExecutorService executor, final CompletionService<String> pool) {
        if (this.policyTimer == null) {
            this.policyTimer = new Timer();
        }
        if (this.policyTimerTask == null) {
            this.policyTimerTask = new TimerTask(){

                @Override
                public void run() {
                    try {
                        logger.error("Check the task is completed schedule policy >>>>>>>>");
                        Future future = pool.take();
                        if (future.isDone()) {
                            logger.debug("Thread is completed for schedule policy so assign new task with future>>>>>>>>>>>" + (String)future.get());
                            SPAutoScheduleJob.this.initiatePolicySchedules(cloud, executor, pool, false);
                        }
                    }
                    catch (Exception e) {
                        logger.error("Error in checkThreadStatusAndStartScheduleForPolicy", (Throwable)e);
                        logger.trace("" + e);
                    }
                }
            };
            logger.debug(".......inside checkThreadStatusAndStartScheduleForPolicy....  ");
            this.policyTimer.schedule(this.policyTimerTask, 100L, 1000L);
        }
    }

    public void checkThreadStatusAndStartUpload(final Cloud cloud, final CompletionService<String> pool, final List<User> usersList, final OfficeBackupPolicy officeBackupPolicy) {
        if (this.userTimer == null) {
            this.userTimer = new Timer();
        }
        if (this.userTimerTask == null) {
            this.userTimerTask = new TimerTask(){

                @Override
                public void run() {
                    try {
                        logger.error("Check the task is completed>>>>>>>>");
                        Future future = pool.take();
                        if (future.isDone()) {
                            logger.debug("Thread is completed so assign new task>>>>>>>>>>>");
                            SPAutoScheduleJob.this.initiateMSDeltaQueries(cloud, pool, usersList, officeBackupPolicy);
                        }
                    }
                    catch (Exception e) {
                        logger.error("Error in checkThreadStatusAndStartUpload", (Throwable)e);
                        logger.trace("" + e);
                    }
                }
            };
            logger.debug("...iniitiatecheckThreadStatusAndStartUpload...");
            this.userTimer.schedule(this.userTimerTask, 1000L, 1000L);
        }
    }

    private void initiateMSDeltaQueries(Cloud cloud, CompletionService<String> pool, List<User> usersList, OfficeBackupPolicy officeBackupPolicy) {
        logger.debug("Files to backup ............... :");
        Runnable uploadJob = () -> this.uploadFiles(cloud, pool, usersList, officeBackupPolicy);
        pool.submit(uploadJob, "");
    }

    private void schdeuleUsersForPolicy(Cloud cloud, ExecutorService executor, CompletionService<String> pool, boolean firstTime) {
        try {
            block17: {
                int cloudId = cloud.getCloudId();
                List<OfficeBackupPolicy> policyList = this.msService.getAllOfficeBackupPoliciesForBluKrypt(cloudId, SP_POLICY_TYPE);
                ArrayList<User> usersList = new ArrayList<User>();
                HashedMap userPolicyMap = new HashedMap();
                ArrayList<OfficeBackupPolicy> eligiblePolicy = new ArrayList<OfficeBackupPolicy>();
                for (OfficeBackupPolicy officeBackupPolicy : policyList) {
                    long nextSchedule;
                    if (!officeBackupPolicy.isActive() || (nextSchedule = this.msService.getNextScheduledMinute(officeBackupPolicy)) > 1L) continue;
                    eligiblePolicy.add(officeBackupPolicy);
                }
                for (OfficeBackupPolicy officeBackupPolicy : eligiblePolicy) {
                    List<User> allSitesForOfficeBackupPolicy = this.msService.getAllSitesForOfficeBackupPolicy(cloudId, officeBackupPolicy.getPolicyName());
                    usersList.addAll(allSitesForOfficeBackupPolicy);
                    for (User user : allSitesForOfficeBackupPolicy) {
                        userPolicyMap.put(user.getUserName(), officeBackupPolicy);
                    }
                }
                usersList.removeAll(Collections.singleton(null));
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                logger.debug(".... before sp backup..................." + usersList.size());
                try {
                    long batchStartTime = System.currentTimeMillis();
                    ArrayList<User> finalList = new ArrayList<User>();
                    for (User user : usersList) {
                        if (!user.isSite()) continue;
                        String userName = user.getUserName();
                        Device device = this.msService.getSharePointDeviceForUserName(cloud.getCloudId(), userName);
                        boolean userEligible = true;
                        if (device == null || device.isBlocked() || device.isDeleted()) {
                            userEligible = false;
                        } else {
                            BackupBatch lastBkpBatch = this.msService.getLastBackupOnly(cloud.getCloudId(), userName, device.getDeviceUUID());
                            if (lastBkpBatch != null && (lastBkpBatch.getStatus().equalsIgnoreCase(BackupBatch.STATUS.STARTED.toString()) || lastBkpBatch.getStatus().equalsIgnoreCase(BackupBatch.STATUS.PAUSED.toString()) || lastBkpBatch.getStatus().equalsIgnoreCase(BackupBatch.STATUS.QUEUED.toString()) || lastBkpBatch.getStatus().equalsIgnoreCase(BackupBatch.STATUS.SCANNING.toString()) || lastBkpBatch.getStatus().equalsIgnoreCase(BackupBatch.STATUS.WAITING_FOR_BACKUP.toString()))) {
                                this.msService.checkBatchExistsOrNot(lastBkpBatch, ((OfficeBackupPolicy)userPolicyMap.get(user.getUserName())).getPolicyName());
                                logger.debug("....user already in " + lastBkpBatch.getStatus() + " so not scheduling..." + userName + "...." + device.getDeviceType());
                                userEligible = false;
                            }
                            if (lastBkpBatch != null && BackupBatch.STATUS.INTERRUPTED.toString().equalsIgnoreCase(lastBkpBatch.getStatus()) && StringUtils.isNotEmpty((String)lastBkpBatch.getErrorCode()) && "1996".equalsIgnoreCase(lastBkpBatch.getErrorCode())) {
                                userEligible = false;
                            }
                        }
                        if (!userEligible) continue;
                        finalList.add(user);
                    }
                    logger.debug("....policy and users....." + finalList.size());
                    if (CollectionUtils.isEmpty(finalList)) break block17;
                    ThreadFactoryBuilder threadFactoryBuilder = new ThreadFactoryBuilder().setNameFormat("SPQueueThread-$$%d$$");
                    CountDownLatch latch = new CountDownLatch(finalList.size());
                    ExecutorService executorService = Executors.newFixedThreadPool(10, threadFactoryBuilder.build());
                    for (User user : finalList) {
                        Runnable uploadJob = () -> this.lambda$schdeuleUsersForPolicy$2(cloud, (Map)userPolicyMap, user, batchStartTime, cloudId, latch);
                        executorService.submit(uploadJob);
                    }
                    try {
                        latch.await();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    executorService.shutdown();
                }
                catch (Exception e) {
                    logger.error("..error trying to parse user sp..." + e.getMessage());
                }
            }
            logger.debug(".... completed usersList....................");
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("exception inside SPAutoScheduleJob .... " + e.getMessage());
            logger.trace("exception inside SPAutoScheduleJob ...." + e);
        }
        logger.error("completed users for schedule wait for next retry>>>>");
    }

    private boolean isBackupAllowed(OfficeBackupPolicy oneDriveBackupPolicy, boolean firstTime) {
        boolean isBackupAllowed = false;
        if (!oneDriveBackupPolicy.isActive()) {
            logger.debug(".....Not a Valid policy....." + oneDriveBackupPolicy.getPolicyName());
            return isBackupAllowed;
        }
        long nextSchedule = this.msService.getNextScheduledMinute(oneDriveBackupPolicy);
        String policyName = oneDriveBackupPolicy.getPolicyName();
        if (!firstTime && nextSchedule <= 2L) {
            try {
                logger.debug(oneDriveBackupPolicy.getPolicyName() + "....wait for mins..." + nextSchedule);
                Thread.sleep(nextSchedule * 60000L);
                nextSchedule = 1L;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        logger.debug(policyName + "....after getting nextscheduel..." + nextSchedule);
        if (nextSchedule == 1L) {
            logger.debug(policyName + "... wait for backup schedule to start in 1 min for policy ..." + policyName);
            if (MemoryStore.get((String)("SP_AUTO_" + policyName)) == null) {
                logger.debug("... enable backup for policy ... " + policyName);
                MemoryStore.add((String)("SP_AUTO_" + policyName), (Object)nextSchedule);
                if (MemoryStore.get((String)("SP_AUTO_" + policyName + "thread")) == null) {
                    MemoryStore.add((String)("SP_AUTO_" + policyName + "thread"), (Object)Thread.currentThread().getName());
                }
                isBackupAllowed = true;
            } else {
                logger.debug("... already backup enable for policy ... " + policyName);
                isBackupAllowed = false;
            }
        }
        return isBackupAllowed;
    }

    private List<OfficeBackupPolicy> getPolicyListForProcessing(int cloudId) {
        List<OfficeBackupPolicy> policyList = this.msService.getAllOfficeBackupPoliciesForBluKrypt(cloudId, SP_POLICY_TYPE);
        for (OfficeBackupPolicy policy : policyList) {
            logger.debug("......policy....." + policy.getPolicyName());
            officeBackupPolicyList.add(policy);
        }
        logger.debug(SP_POLICY_TYPE + "......policy list....." + officeBackupPolicyList.size());
        return officeBackupPolicyList;
    }

    private void uploadFiles(Cloud cloud, CompletionService<String> pool1, List<User> usersList, OfficeBackupPolicy officeBackupPolicy) {
        block9: {
            int cloudId = cloud.getCloudId();
            logger.debug(".... before sp backup...................");
            try {
                long batchStartTime = System.currentTimeMillis();
                ArrayList<User> finalList = new ArrayList<User>();
                for (User user : usersList) {
                    String userName = user.getUserName();
                    Device device = this.msService.getSharePointDeviceForUserName(cloud.getCloudId(), userName);
                    boolean userEligible = true;
                    if (device == null || device.isBlocked() || device.isDeleted()) {
                        userEligible = false;
                    } else {
                        BackupBatch lastBkpBatch = this.msService.getLastBackupOnly(cloud.getCloudId(), userName, device.getDeviceUUID());
                        if (lastBkpBatch != null && (lastBkpBatch.getStatus().equalsIgnoreCase(BackupBatch.STATUS.STARTED.toString()) || lastBkpBatch.getStatus().equalsIgnoreCase(BackupBatch.STATUS.PAUSED.toString()) || lastBkpBatch.getStatus().equalsIgnoreCase(BackupBatch.STATUS.QUEUED.toString()) || lastBkpBatch.getStatus().equalsIgnoreCase(BackupBatch.STATUS.SCANNING.toString()))) {
                            logger.debug("....user already in " + lastBkpBatch.getStatus() + " so not scheduling..." + userName + "...." + device.getDeviceType());
                            userEligible = false;
                        }
                    }
                    if (!userEligible) continue;
                    finalList.add(user);
                }
                logger.debug("....policy and users..." + officeBackupPolicy.getPolicyName() + "..." + finalList.size());
                if (CollectionUtils.isEmpty(finalList)) break block9;
                ThreadFactoryBuilder threadFactoryBuilder = new ThreadFactoryBuilder().setNameFormat("SPQueueThread-$$%d$$");
                CountDownLatch latch = new CountDownLatch(finalList.size());
                ExecutorService executorService = Executors.newFixedThreadPool(10, threadFactoryBuilder.build());
                for (User user : finalList) {
                    Runnable uploadJob = () -> this.createQueueForUser(cloud, officeBackupPolicy, batchStartTime, cloudId, user, latch);
                    executorService.submit(uploadJob);
                }
                try {
                    latch.await();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                executorService.shutdown();
            }
            catch (Exception e) {
                logger.error("..error trying to parse user sp..." + e.getMessage());
            }
        }
        MemoryStore.delete((String)("SP_AUTO_" + officeBackupPolicy.getPolicyName()));
        logger.debug(".... completed usersList....................");
    }

    private void createQueueForUser(Cloud cloud, OfficeBackupPolicy officeBackupPolicy, long batchStartTime, int cloudId, User user, CountDownLatch latch) {
        String userName = user.getUserName();
        Device device = this.msService.getSharePointDeviceForUserName(cloudId, userName);
        if (device == null || device.isBlocked() || device.isDeleted()) {
            logger.debug("... no mail device or device blocked for user.. " + userName);
            latch.countDown();
        } else {
            boolean isFullBkp = this.msService.isFullBkpStarted(cloud, device, userName);
            this.msService.createQueuedBatch(cloud, officeBackupPolicy, batchStartTime, user, isFullBkp, device);
            latch.countDown();
        }
    }

    private synchronized OfficeBackupPolicy getPolicyForProcessing(int cloudId) {
        if (CollectionUtils.isEmpty(officeBackupPolicyList)) {
            logger.debug("*********empty**wait for 50 millis*****");
            try {
                Thread.sleep(TimeUnit.SECONDS.toMillis(50L));
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            officeBackupPolicyList = this.getPolicyListForProcessing(cloudId);
            if (CollectionUtils.isEmpty(officeBackupPolicyList)) {
                try {
                    logger.debug("...no policy to process... ");
                    Thread.sleep(10000L);
                }
                catch (Exception e1) {
                    // empty catch block
                }
                return null;
            }
        }
        logger.debug("....policy list .... " + officeBackupPolicyList.size());
        OfficeBackupPolicy oneDriveBackupPolicy = null;
        if (!CollectionUtils.isEmpty(officeBackupPolicyList)) {
            oneDriveBackupPolicy = officeBackupPolicyList.get(0);
        }
        if (oneDriveBackupPolicy != null) {
            if (this.policyUnderProcess.contains(oneDriveBackupPolicy.getPolicyName())) {
                officeBackupPolicyList.remove(oneDriveBackupPolicy);
            } else {
                this.policyUnderProcess.add(oneDriveBackupPolicy.getPolicyName());
                officeBackupPolicyList.remove(oneDriveBackupPolicy);
            }
        }
        if (oneDriveBackupPolicy == null) {
            try {
                logger.debug("... wait for next policy... ");
                Thread.sleep(10000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        logger.debug("...after list size....." + officeBackupPolicyList.size());
        return oneDriveBackupPolicy;
    }

    private /* synthetic */ void lambda$schdeuleUsersForPolicy$2(Cloud cloud, Map userPolicyMap, User user, long batchStartTime, int cloudId, CountDownLatch latch) {
        this.createQueueForUser(cloud, (OfficeBackupPolicy)userPolicyMap.get(user.getUserName()), batchStartTime, cloudId, user, latch);
    }
}

