/*
 * Decompiled with CFR 0.152.
 */
package com.pg.timer;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.parablu.pcbd.domain.BackupBatch;
import com.parablu.pcbd.domain.BackupFolders;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.CloudCustomisableDetails;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.EventHub;
import com.parablu.pcbd.domain.ExcludedFolders;
import com.parablu.pcbd.domain.OfficeBackupPolicy;
import com.parablu.pcbd.domain.RestoreEvents;
import com.parablu.pcbd.domain.User;
import com.parablu.pcbd.domain.UserDefinedFolders;
import com.pg.helper.constant.PCHelperConstant;
import com.pg.helper.utils.MemoryStore;
import com.pg.service.MSService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.types.ObjectId;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;
import org.quartz.SchedulerException;
import org.springframework.scheduling.quartz.QuartzJobBean;

@PersistJobDataAfterExecution
@DisallowConcurrentExecution
public class ODBAutoCrawlJob
extends QuartzJobBean
implements Job {
    private static Logger logger = LogManager.getLogger(ODBAutoCrawlJob.class);
    private static String OD_POLICY_TYPE = "ODB";
    private static final String IS_JOB_RUNNING = "isJobRunning";
    private MSService msService;
    private Set<String> userUnderProcess = new HashSet<String>();
    private TimerTask crawlTimerTask = null;
    private Timer crawlTimer = null;

    public void setMsService(MSService msService) {
        this.msService = msService;
    }

    protected void executeInternal(JobExecutionContext arg0) throws JobExecutionException {
        try {
            List jobs = arg0.getScheduler().getCurrentlyExecutingJobs();
            if (jobs != null && !jobs.isEmpty()) {
                for (JobExecutionContext job : jobs) {
                    if (!job.getTrigger().equals((Object)arg0.getTrigger()) || job.getJobInstance().equals((Object)this)) continue;
                    logger.debug("There's another instance running,SO skipping>>>>>>>>>>>>> : " + (Object)((Object)this));
                    return;
                }
            }
        }
        catch (SchedulerException e) {
            logger.debug("" + (Object)((Object)e));
            logger.error("" + e.getCause());
        }
        logger.debug("....odbAutoCrawlJob job started...");
        ExecutorService executor = null;
        try {
            int cloudId = 1;
            Cloud cloud = this.msService.getCloud(cloudId);
            boolean isOneDriveForBusinessBackupEnabled = this.isOneDriveForBusinessBackupEnabled(cloud);
            String deviceType = Device.TYPE.ONEDRIVE.name();
            this.msService.updateAllIncompleteBatchQueueStatus(cloud.getCloudId(), deviceType);
            if (isOneDriveForBusinessBackupEnabled) {
                boolean licenseActive;
                if (cloud != null) {
                    logger.debug("......cloud val...." + cloud.getCloudName());
                }
                if (!(licenseActive = this.vaildatedLicensceStatus(cloud))) {
                    logger.debug("....license inactive no crawl....");
                    Thread.sleep(1200000L);
                    return;
                }
                int crawlThreads = 50;
                if (PCHelperConstant.getCrawlThreadsLimit() > 0) {
                    crawlThreads = PCHelperConstant.getCrawlThreadsLimit();
                }
                logger.debug(" threads val........" + crawlThreads);
                ThreadFactoryBuilder factoryBuilder = new ThreadFactoryBuilder().setNameFormat("ODBCrawl-%d");
                executor = Executors.newFixedThreadPool(crawlThreads, factoryBuilder.build());
                ExecutorCompletionService<String> pool = new ExecutorCompletionService<String>(executor);
                this.checkThreadStatusAndStartUpload(cloud, executor, pool);
                for (int i = 0; i < crawlThreads; ++i) {
                    this.delay();
                    logger.debug("Creating thread for first time>>>>>>>>> i value::" + i);
                    this.callUploadFiles(cloud, executor, pool);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(" exception in odbAutoCrawlJob......." + e.getMessage());
            logger.trace("exception in odbAutoCrawlJob ......." + e);
        }
        logger.debug("....odbAutoCrawlJob job ended...");
    }

    private void delay() {
        try {
            Thread.sleep(TimeUnit.SECONDS.toMillis(3L));
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void checkThreadStatusAndStartUpload(final Cloud cloud, final ExecutorService executor, final CompletionService<String> pool) {
        if (this.crawlTimer == null) {
            this.crawlTimer = new Timer();
        }
        if (this.crawlTimerTask == null) {
            this.crawlTimerTask = new TimerTask(){

                @Override
                public void run() {
                    try {
                        logger.debug("Check the task is completed>>>>>>>>", (Object)PCHelperConstant.isBrevityLogging());
                        Future future = pool.take();
                        if (future.isDone()) {
                            logger.debug("Thread is completed so assign new task>>>>>>>>>>>");
                            ODBAutoCrawlJob.this.callUploadFiles(cloud, executor, pool);
                        }
                    }
                    catch (Exception e) {
                        logger.error("Error in checkThreadStatusAndStartUpload", (Throwable)e);
                        logger.trace("" + e);
                    }
                }
            };
            this.crawlTimer.schedule(this.crawlTimerTask, 1000L, 1000L);
        }
    }

    private void callUploadFiles(Cloud cloud, ExecutorService executor, CompletionService<String> pool) {
        Runnable uploadJob = () -> this.uploadFiles(cloud, executor, pool);
        pool.submit(uploadJob, "");
    }

    private void uploadFiles(Cloud cloud, ExecutorService executor, CompletionService<String> pool) {
        logger.debug("....inside while loop..........", (Object)PCHelperConstant.isBrevityLogging());
        BackupBatch backupBatch = null;
        try {
            boolean isTomcatRunning = true;
            if (MemoryStore.get((String)IS_JOB_RUNNING) != null) {
                isTomcatRunning = (Boolean)MemoryStore.get((String)IS_JOB_RUNNING);
            }
            logger.debug("........Is tomcat job running........." + isTomcatRunning);
            if (!isTomcatRunning) {
                logger.error("..Tomcat job is going to be stopped.. so stopping upload ....");
                return;
            }
        }
        catch (Exception e) {
            logger.error("Exception While stopping :" + e.getMessage());
        }
        try {
            logger.debug("........Before getFileForProcessing........." + Device.TYPE.ONEDRIVE.name());
            backupBatch = this.getFileForProcessing(cloud);
            if (backupBatch != null) {
                logger.debug("...assigning batch......" + backupBatch.getUserName());
                User user = this.msService.getUserInfo(cloud.getCloudId(), backupBatch.getUserName());
                this.crawlIndUserData(cloud, user, backupBatch.getBatchStartTimestamp());
                logger.error(backupBatch.getId().toString() + " %%%%%%% batch completed for user ...." + backupBatch.getUserName());
            } else {
                logger.debug("....no batch wit for 1 mins ....");
                Thread.sleep(TimeUnit.MINUTES.toMillis(1L));
            }
            logger.debug("Thread ready for next batch .... ");
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("exception inside odbAutoCrawlJob .... " + e.getMessage());
            logger.trace("exception inside odbAutoCrawlJob ...." + e);
        }
        logger.error("no batch to upload so wait and then retry>>>>");
        this.callUploadFiles(cloud, executor, pool);
    }

    private void crawlIndUserData(Cloud cloud, User user, long batchStartTime) {
        logger.debug(user.getExchangePolicyName() + "...odb process started user...." + user.getUserName());
        this.uploadUserFiles(cloud, user, batchStartTime);
        logger.debug(user.getExchangePolicyName() + "...odb process ended user...." + user.getUserName());
    }

    private synchronized BackupBatch getFileForProcessing(Cloud cloud) {
        BackupBatch backupBatch = this.msService.getIncompleteBatch(cloud.getCloudId(), Device.TYPE.ONEDRIVE.name());
        if (backupBatch == null) {
            logger.debug("...no batch to process ...");
        }
        return backupBatch;
    }

    private boolean isOneDriveForBusinessBackupEnabled(Cloud cl) {
        boolean isExpiredFileDeleteEnabled = false;
        List list = cl.getCloudCustomisableDetails();
        list.removeAll(Collections.singleton(null));
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (CloudCustomisableDetails cloudPluginDetails : list) {
                if (cloudPluginDetails == null || StringUtils.isEmpty((String)cloudPluginDetails.getName()) || !"OneDrive Backup Enabled".equalsIgnoreCase(cloudPluginDetails.getName())) continue;
                isExpiredFileDeleteEnabled = true;
                break;
            }
        }
        return isExpiredFileDeleteEnabled;
    }

    private void uploadUserFiles(Cloud cloud, User user, long batchStartTime) {
        ArrayList<String> excludedFoldStr;
        ArrayList<String> backupFoldLocalStr;
        ArrayList<String> backupFoldStr;
        ArrayList excludedFoldersLocal;
        ArrayList excludedFolders;
        ArrayList backupFoldersLocal;
        ArrayList backupFolders;
        OfficeBackupPolicy officeBackupPolicy = null;
        logger.debug("....inside for loopslatest.........." + user.getUserName());
        boolean isPolicyModified = false;
        String userName = user.getUserName();
        Device device = this.msService.getODDeviceForUserName(cloud.getCloudId(), userName);
        if (device == null) {
            logger.debug("...device does not exist for user ... " + userName);
            return;
        }
        RestoreEvents restoreEvents = this.msService.getRestoreEventsByUUID(cloud.getCloudId(), device.getDeviceUUID());
        if (restoreEvents != null && restoreEvents.isSuspendBackup()) {
            logger.error(".....restore is running so backup cannot continue...  ");
            return;
        }
        int cloudId = cloud.getCloudId();
        if (officeBackupPolicy == null) {
            officeBackupPolicy = this.msService.getOfficeBackupPolicyForUserName(cloud.getCloudId(), user.getUserName(), OD_POLICY_TYPE);
        }
        OfficeBackupPolicy officeBackupPolicyFromLocal = this.msService.getOfficeBackupPolicyFromLocal(cloud.getCloudId(), officeBackupPolicy.getPolicyName());
        logger.debug(userName + "... policy..local.. " + officeBackupPolicyFromLocal);
        if (device != null) {
            ArrayList<Object> inclusionbackupFolders = new ArrayList<Object>();
            List<UserDefinedFolders> userDefinedFoldersList = this.msService.getAllUserDefinedInclusionFolders(cloudId, device.getDeviceUUID(), userName);
            if (!CollectionUtils.isEmpty(userDefinedFoldersList)) {
                for (UserDefinedFolders userDefinedFolders : userDefinedFoldersList) {
                    BackupFolders backupFolderElement = new BackupFolders();
                    backupFolderElement.setId(userDefinedFolders.getId());
                    backupFolderElement.setFolderPath(userDefinedFolders.getFolderPath());
                    inclusionbackupFolders.add(backupFolderElement);
                }
            }
            ArrayList<ExcludedFolders> exclusionbackupFolders = new ArrayList<ExcludedFolders>();
            List<UserDefinedFolders> exclusionuserDefinedFoldersList = this.msService.getAllUserDefinedExclusionFolders(cloudId, device.getDeviceUUID(), userName);
            if (!CollectionUtils.isEmpty(exclusionuserDefinedFoldersList)) {
                for (UserDefinedFolders userDefinedFolders : exclusionuserDefinedFoldersList) {
                    ExcludedFolders backupFolderElement = new ExcludedFolders();
                    backupFolderElement.setId(userDefinedFolders.getId());
                    backupFolderElement.setFolderPath(userDefinedFolders.getFolderPath());
                    exclusionbackupFolders.add(backupFolderElement);
                }
            }
            if (CollectionUtils.isEmpty((Collection)officeBackupPolicy.getBackupFolders())) {
                officeBackupPolicy.setBackupFolders(new ArrayList());
            }
            if (CollectionUtils.isEmpty((Collection)officeBackupPolicy.getExcludedFolders())) {
                officeBackupPolicy.setExcludedFolders(new ArrayList());
            }
            officeBackupPolicy.getBackupFolders().addAll(inclusionbackupFolders);
            officeBackupPolicy.getExcludedFolders().addAll(exclusionbackupFolders);
        }
        if (officeBackupPolicyFromLocal == null) {
            logger.debug("..... policy local .... null..");
        }
        if (officeBackupPolicyFromLocal == null || officeBackupPolicy.getLastModifiedTimestamp() != officeBackupPolicyFromLocal.getLastModifiedTimestamp()) {
            if (officeBackupPolicyFromLocal == null) {
                officeBackupPolicyFromLocal = officeBackupPolicy;
            } else {
                boolean allElementsPresent;
                isPolicyModified = false;
                backupFolders = officeBackupPolicy.getBackupFolders();
                backupFoldersLocal = officeBackupPolicyFromLocal.getBackupFolders();
                if (CollectionUtils.isEmpty((Collection)backupFolders)) {
                    backupFolders = new ArrayList();
                }
                if (CollectionUtils.isEmpty((Collection)backupFoldersLocal)) {
                    backupFoldersLocal = new ArrayList();
                }
                excludedFolders = officeBackupPolicy.getExcludedFolders();
                excludedFoldersLocal = officeBackupPolicyFromLocal.getExcludedFolders();
                if (CollectionUtils.isEmpty((Collection)excludedFolders)) {
                    excludedFolders = new ArrayList();
                }
                if (CollectionUtils.isEmpty((Collection)excludedFoldersLocal)) {
                    excludedFoldersLocal = new ArrayList();
                }
                backupFoldStr = new ArrayList<String>();
                backupFoldLocalStr = new ArrayList<String>();
                excludedFoldStr = new ArrayList<String>();
                ArrayList<String> excludedFoldLocalStr = new ArrayList<String>();
                for (BackupFolders folders : backupFolders) {
                    backupFoldStr.add(folders.getFolderPath());
                }
                for (BackupFolders folders : backupFoldersLocal) {
                    backupFoldLocalStr.add(folders.getFolderPath());
                }
                for (BackupFolders folders : excludedFolders) {
                    excludedFoldStr.add(folders.getFolderPath());
                }
                for (BackupFolders folders : excludedFoldersLocal) {
                    excludedFoldLocalStr.add(folders.getFolderPath());
                }
                logger.debug("....folllsss........." + backupFoldStr.size() + ".." + backupFoldLocalStr.size() + "...exc.." + excludedFoldStr.size() + "..." + excludedFoldLocalStr.size());
                boolean bl = allElementsPresent = backupFoldStr.equals(backupFoldLocalStr) && excludedFoldStr.equals(excludedFoldLocalStr);
                if (!allElementsPresent) {
                    isPolicyModified = true;
                }
            }
            this.msService.saveOfficeBackupPolicy(cloud.getCloudId(), officeBackupPolicy);
        } else {
            boolean allElementsPresent;
            backupFolders = officeBackupPolicy.getBackupFolders();
            backupFoldersLocal = officeBackupPolicyFromLocal.getBackupFolders();
            if (CollectionUtils.isEmpty((Collection)backupFolders)) {
                backupFolders = new ArrayList();
            }
            if (CollectionUtils.isEmpty((Collection)backupFoldersLocal)) {
                backupFoldersLocal = new ArrayList();
            }
            excludedFolders = officeBackupPolicy.getExcludedFolders();
            excludedFoldersLocal = officeBackupPolicyFromLocal.getExcludedFolders();
            if (CollectionUtils.isEmpty((Collection)excludedFolders)) {
                excludedFolders = new ArrayList();
            }
            if (CollectionUtils.isEmpty((Collection)excludedFoldersLocal)) {
                excludedFoldersLocal = new ArrayList();
            }
            backupFoldStr = new ArrayList();
            backupFoldLocalStr = new ArrayList();
            excludedFoldStr = new ArrayList();
            ArrayList<String> excludedFoldLocalStr = new ArrayList<String>();
            for (BackupFolders folders : backupFolders) {
                backupFoldStr.add(folders.getFolderPath());
            }
            for (BackupFolders folders : backupFoldersLocal) {
                backupFoldLocalStr.add(folders.getFolderPath());
            }
            for (BackupFolders folders : excludedFolders) {
                excludedFoldStr.add(folders.getFolderPath());
            }
            for (BackupFolders folders : excludedFoldersLocal) {
                excludedFoldLocalStr.add(folders.getFolderPath());
            }
            logger.debug("....folllsss........." + backupFoldStr.size() + ".." + backupFoldLocalStr.size() + "...exc.." + excludedFoldStr.size() + "..." + excludedFoldLocalStr.size());
            boolean bl = allElementsPresent = backupFoldStr.equals(backupFoldLocalStr) && excludedFoldStr.equals(excludedFoldLocalStr);
            if (!allElementsPresent) {
                isPolicyModified = true;
            }
        }
        try {
            if (user != null && user.isActive() && user.isOnedriveBkpEnabled()) {
                logger.debug(user.getUserName() + " %%%%%%% process started for user ...");
                this.processUser(user, cloud, officeBackupPolicy, officeBackupPolicyFromLocal, isPolicyModified, batchStartTime);
                logger.debug(user.getUserName() + " %%%%%%% process ended for user ...");
                this.userUnderProcess.remove(user.getUserName());
            }
            logger.debug(user.getUserName() + "Thread ready for next user .... " + this.userUnderProcess.size());
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("exception inside BackupUploadJob .... " + e.getMessage());
            logger.trace("exception inside BackupUploadJob ...." + e);
        }
    }

    public void processUser(User user, Cloud cloud, OfficeBackupPolicy oneDriveBackupPolicy, OfficeBackupPolicy oneDriveBackupPolicyFromLocal, boolean isPolicyModified, long batchStartTime) {
        try {
            String userName = user.getUserName();
            logger.debug("Processing " + userName);
            Device device = this.msService.getODDeviceForUserName(cloud.getCloudId(), userName);
            if (device == null) {
                logger.debug("... no onedrive device for user... " + userName);
                return;
            }
            if (device.isBlocked() || device.isDeleted()) {
                logger.debug("... device blocked for user... " + userName);
                return;
            }
            if (!PCHelperConstant.getComponentName().equalsIgnoreCase(oneDriveBackupPolicy.getMsAppBluKrypt())) {
                logger.error(PCHelperConstant.getComponentName() + ".....wrong agent for backup..." + oneDriveBackupPolicy.getMsAppBluKrypt());
                return;
            }
            boolean alreadyBkpStarted = this.msService.isBkpAllowed(cloud.getCloudId(), device, userName, oneDriveBackupPolicyFromLocal.getPolicyName());
            logger.debug(userName + "....ready for backup ..." + alreadyBkpStarted + "...starttime..." + batchStartTime + "..dateinformat..." + ODBAutoCrawlJob.getDateInFormat(batchStartTime));
            if (!alreadyBkpStarted) {
                ObjectId eventHubId = this.updateEventHub(cloud, device);
                this.msService.processDeltaChangesForUserDrive(user, cloud, oneDriveBackupPolicy, oneDriveBackupPolicyFromLocal, isPolicyModified, eventHubId.toString(), batchStartTime);
                this.msService.updateEventHubOdStatus(cloud.getCloudId(), eventHubId);
            } else {
                logger.debug("... backup already forced....");
                this.msService.deleteQueuedEntry(cloud.getCloudId(), device.getUserName(), device.getDeviceUUID(), oneDriveBackupPolicyFromLocal.getPolicyName());
            }
            logger.debug(" processed user .............. " + userName);
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("Exception inside BackupUploadJob Processor PooledConnectionFactory !" + e.getMessage());
        }
    }

    private static String getDateInFormat(Long deviceCreatedDate) {
        String dateStringFormat = "";
        if (deviceCreatedDate == null || deviceCreatedDate == 0L) {
            return dateStringFormat;
        }
        try {
            SimpleDateFormat df2 = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
            Date dateD = new Date(deviceCreatedDate);
            dateStringFormat = df2.format(dateD);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return dateStringFormat;
    }

    public ObjectId updateEventHub(Cloud cloud, Device device) {
        logger.debug("calling updateEventHub ....");
        ObjectId eventHubId = null;
        try {
            int cloudId = cloud.getCloudId();
            String deviceUUID = device.getDeviceUUID();
            String userName = device.getUserName();
            String actionByUserName = "Schedule";
            String acctionToUserName = userName;
            logger.debug("... creating event hub....");
            EventHub eventHub = new EventHub();
            eventHub.setActionBy(actionByUserName);
            eventHub.setActionStatus(PCHelperConstant.EVENTHUB_ACTION_STATUS.CREATED.toString());
            eventHub.setActionToUserName(acctionToUserName);
            eventHub.setActionToDeviceUUID(deviceUUID);
            eventHub.setOdStatus(EventHub.ODSTATUS.STARTED.toString());
            String action = PCHelperConstant.EVENTHUB_ACTION.START_BACKUP.toString();
            eventHub.setAction(action);
            eventHubId = this.msService.saveEventHubAction(cloudId, eventHub);
        }
        catch (Exception e) {
            logger.error("... exception trying to save eventhub ..." + e.getMessage());
        }
        return eventHubId;
    }

    private boolean vaildatedLicensceStatus(Cloud cloud) {
        return cloud.getValidityPeriod() >= System.currentTimeMillis() && cloud.getStatusCode().equals("ACTIVE");
    }

    public static boolean compare(List<String> first, List<String> second) {
        if (first == null && second == null) {
            return true;
        }
        if (first != null && second == null) {
            return false;
        }
        if (first == null && second != null) {
            return false;
        }
        if (first.size() != second.size()) {
            return false;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (String str : first) {
            map.put(str, str);
        }
        for (String str : second) {
            if (map.containsKey(str)) continue;
            return false;
        }
        return true;
    }
}

