/*
 * Decompiled with CFR 0.152.
 */
package com.pg.graph.helper;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.ProxyOptions;
import com.azure.core.util.HttpClientOptions;
import com.azure.identity.ClientSecretCredential;
import com.azure.identity.ClientSecretCredentialBuilder;
import com.microsoft.graph.authentication.IAuthenticationProvider;
import com.microsoft.graph.authentication.TokenCredentialAuthProvider;
import com.microsoft.graph.httpcore.HttpClients;
import com.microsoft.graph.requests.GraphServiceClient;
import com.pg.helper.constant.PCHelperConstant;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.time.Duration;
import java.util.ArrayList;
import okhttp3.Authenticator;
import okhttp3.Credentials;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.util.StringUtils;

public class Graph {
    private static Logger logger = LogManager.getLogger(Graph.class);
    private static volatile Graph singleInst;
    static GraphServiceClient<Request> graphClient;
    static OkHttpClient okHttpClient;

    private Graph() {
    }

    public static synchronized Graph getInstance() {
        if (singleInst == null) {
            singleInst = new Graph();
            Graph.setGraphClient(Graph.getGraphClientFromGraph());
            Graph.setOkHttpClient(Graph.getOkHttpClientFromGraph());
        }
        return singleInst;
    }

    public static GraphServiceClient<Request> getGraphClientFromGraph() {
        String authorityHost = "https://login.microsoftonline.com";
        logger.debug("...helper constant ...." + PCHelperConstant.getMSClientId());
        if (org.apache.commons.lang.StringUtils.isEmpty((String)PCHelperConstant.getMSClientId())) {
            return null;
        }
        if (org.apache.commons.lang.StringUtils.isEmpty((String)PCHelperConstant.getMSTenantId()) || !PCHelperConstant.getMSTenantId().matches("^[0-9a-fA-F-]{36}$")) {
            return null;
        }
        GraphServiceClient graphClient = null;
        if (!StringUtils.isEmpty((Object)PCHelperConstant.getProxyHost()) && PCHelperConstant.getProxyPort() != 0) {
            logger.debug("....using proxy latest......");
            InetSocketAddress proxyInetAddress = new InetSocketAddress(PCHelperConstant.getProxyHost(), PCHelperConstant.getProxyPort());
            logger.debug("....using proxy latest before createDefault 1bb......" + PCHelperConstant.getProxyHost() + "..pwd..." + PCHelperConstant.getProxyPort());
            ProxyOptions proxyOptions = new ProxyOptions(ProxyOptions.Type.HTTP, new InetSocketAddress(PCHelperConstant.getProxyHost(), PCHelperConstant.getProxyPort()));
            HttpClientOptions clientOptions = new HttpClientOptions();
            clientOptions.setProxyOptions(proxyOptions);
            logger.debug("....using proxy latest before createDefault 2a with host latest");
            ClientSecretCredential clientSecretCredential = ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().clientId(PCHelperConstant.getMSClientId())).clientSecret(PCHelperConstant.getMSClientSecret()).tenantId(PCHelperConstant.getMSTenantId())).proxyOptions(proxyOptions)).authorityHost(authorityHost)).build();
            ArrayList<String> scopes = new ArrayList<String>();
            scopes.add("https://graph.microsoft.com/.default");
            TokenCredentialAuthProvider tokenCredAuthProvider = new TokenCredentialAuthProvider(scopes, (TokenCredential)clientSecretCredential);
            OkHttpClient httpClient = null;
            Proxy proxy = new Proxy(Proxy.Type.HTTP, proxyInetAddress);
            logger.debug("....using proxy latest before createDefault 3a");
            httpClient = HttpClients.createDefault((IAuthenticationProvider)tokenCredAuthProvider).newBuilder().proxy(proxy).build();
            logger.debug("....using proxy latest before createDefault 4");
            graphClient = GraphServiceClient.builder().authenticationProvider((IAuthenticationProvider)tokenCredAuthProvider).httpClient((Object)httpClient).buildClient();
            logger.debug("....using proxy latest before createDefault 5");
        } else {
            ClientSecretCredential clientSecretCredential = ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().clientId(PCHelperConstant.getMSClientId())).clientSecret(PCHelperConstant.getMSClientSecret()).tenantId(PCHelperConstant.getMSTenantId())).authorityHost(authorityHost)).build();
            ArrayList<String> scopes = new ArrayList<String>();
            scopes.add("https://graph.microsoft.com/.default");
            TokenCredentialAuthProvider tokenCredAuthProvider = new TokenCredentialAuthProvider(scopes, (TokenCredential)clientSecretCredential);
            OkHttpClient okhttpClient = HttpClients.createDefault((IAuthenticationProvider)tokenCredAuthProvider).newBuilder().connectTimeout(Duration.ofMinutes(PCHelperConstant.getGraphTimeoutInMins())).readTimeout(Duration.ofMinutes(PCHelperConstant.getGraphTimeoutInMins())).callTimeout(Duration.ofMinutes(PCHelperConstant.getGraphTimeoutInMins())).writeTimeout(Duration.ofMinutes(PCHelperConstant.getGraphTimeoutInMins())).retryOnConnectionFailure(true).build();
            graphClient = GraphServiceClient.builder().authenticationProvider((IAuthenticationProvider)tokenCredAuthProvider).httpClient((Object)okhttpClient).buildClient();
        }
        return graphClient;
    }

    public static void setGraphClient(GraphServiceClient<Request> graphClient) {
        Graph.graphClient = graphClient;
    }

    public GraphServiceClient<Request> getGraphClient() {
        return graphClient;
    }

    public static OkHttpClient getOkHttpClientFromGraph() {
        if (org.apache.commons.lang.StringUtils.isEmpty((String)PCHelperConstant.getMSClientId())) {
            return null;
        }
        if (org.apache.commons.lang.StringUtils.isEmpty((String)PCHelperConstant.getMSTenantId()) || !PCHelperConstant.getMSTenantId().matches("^[0-9a-fA-F-]{36}$")) {
            return null;
        }
        String authorityHost = "https://login.microsoftonline.com";
        OkHttpClient httpClient = null;
        if (!StringUtils.isEmpty((Object)PCHelperConstant.getProxyHost()) && PCHelperConstant.getProxyPort() != 0) {
            Authenticator proxyAuthenticator = new Authenticator(){

                public Request authenticate(Route route, Response response) throws IOException {
                    String credential = Credentials.basic((String)PCHelperConstant.getProxyUserName(), (String)PCHelperConstant.getProxyPassword());
                    return response.request().newBuilder().header("Proxy-Authorization", credential).build();
                }
            };
            ProxyOptions proxyOptions = new ProxyOptions(ProxyOptions.Type.HTTP, new InetSocketAddress(PCHelperConstant.getProxyHost(), PCHelperConstant.getProxyPort()));
            ClientSecretCredential clientSecretCredential = ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().clientId(PCHelperConstant.getMSClientId())).clientSecret(PCHelperConstant.getMSClientSecret()).tenantId(PCHelperConstant.getMSTenantId())).proxyOptions(proxyOptions)).authorityHost(authorityHost)).build();
            ArrayList<String> scopes = new ArrayList<String>();
            scopes.add("https://graph.microsoft.com/.default");
            TokenCredentialAuthProvider tokenCredAuthProvider = new TokenCredentialAuthProvider(scopes, (TokenCredential)clientSecretCredential);
            httpClient = HttpClients.createDefault((IAuthenticationProvider)tokenCredAuthProvider).newBuilder().proxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(PCHelperConstant.getProxyHost(), PCHelperConstant.getProxyPort()))).proxyAuthenticator(proxyAuthenticator).build();
        } else {
            ClientSecretCredential clientSecretCredential = ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().clientId(PCHelperConstant.getMSClientId())).clientSecret(PCHelperConstant.getMSClientSecret()).tenantId(PCHelperConstant.getMSTenantId())).authorityHost(authorityHost)).build();
            ArrayList<String> scopes = new ArrayList<String>();
            scopes.add("https://graph.microsoft.com/.default");
            TokenCredentialAuthProvider tokenCredAuthProvider = new TokenCredentialAuthProvider(scopes, (TokenCredential)clientSecretCredential);
            httpClient = HttpClients.createDefault((IAuthenticationProvider)tokenCredAuthProvider).newBuilder().build();
            OkHttpClient okhttpClient = HttpClients.createDefault((IAuthenticationProvider)tokenCredAuthProvider).newBuilder().connectTimeout(Duration.ofMinutes(PCHelperConstant.getGraphTimeoutInMins())).readTimeout(Duration.ofMinutes(PCHelperConstant.getGraphTimeoutInMins())).callTimeout(Duration.ofMinutes(PCHelperConstant.getGraphTimeoutInMins())).writeTimeout(Duration.ofMinutes(PCHelperConstant.getGraphTimeoutInMins())).retryOnConnectionFailure(true).build();
            graphClient = GraphServiceClient.builder().authenticationProvider((IAuthenticationProvider)tokenCredAuthProvider).httpClient((Object)okhttpClient).buildClient();
        }
        return httpClient;
    }

    public OkHttpClient getOkHttpClient() {
        return okHttpClient;
    }

    public static void setOkHttpClient(OkHttpClient okHttpClient) {
        Graph.okHttpClient = okHttpClient;
    }
}

