/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pcbd.dao.impl;

import com.parablu.pcbd.dao.PciAuthorizationTokensDao;
import com.parablu.pcbd.domain.CloudStorageType;
import com.parablu.pcbd.domain.MSGTokens;
import com.parablu.pcbd.domain.PciAuthorizationTokens;
import com.parablu.pcbd.domain.User;
import com.pg.factory.BlukryptMongoFactoryUtils;
import java.util.List;
import java.util.regex.Pattern;
import org.bson.types.ObjectId;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;

public class PciAuthorizationTokensDaoImpl
implements PciAuthorizationTokensDao {
    public static final String CONTENT_TYPE = "Content-Type";
    BlukryptMongoFactoryUtils blukryptMongoFactoryUtils;

    public BlukryptMongoFactoryUtils getBlukryptMongoFactoryUtils() {
        return this.blukryptMongoFactoryUtils;
    }

    public void setBlukryptMongoFactoryUtils(BlukryptMongoFactoryUtils blukryptMongoFactoryUtils) {
        this.blukryptMongoFactoryUtils = blukryptMongoFactoryUtils;
    }

    @Override
    public void savePciAuthorizationTokens(int cloudId, String cloudName, PciAuthorizationTokens pciAuthorizationTokens) {
        this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId).save((Object)pciAuthorizationTokens);
    }

    @Override
    public PciAuthorizationTokens getPciAuthorizationTokensForUserId(int cloudId, String cloudName, ObjectId userId) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"userId").is((Object)userId));
        return (PciAuthorizationTokens)this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId).findOne(query, PciAuthorizationTokens.class);
    }

    @Override
    public void saveCloudStorageType(int cloudId, String cloudName, CloudStorageType cloudStorageType) {
        this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId).save((Object)cloudStorageType);
    }

    @Override
    public CloudStorageType getCloudStorageTypeByName(int cloudId, String cloudName, String name) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"name").is((Object)name));
        return (CloudStorageType)this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId).findOne(query, CloudStorageType.class);
    }

    @Override
    public PciAuthorizationTokens getPciAuthorizationTokensForServiceAccount(int cloudId, String cloudName) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"serviceAccount").is((Object)true));
        return (PciAuthorizationTokens)this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId).findOne(query, PciAuthorizationTokens.class);
    }

    @Override
    public List<PciAuthorizationTokens> getAllPciAuthorizationTokens(int cloudId, String cloudName) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.findAll(PciAuthorizationTokens.class);
    }

    @Override
    public void deletePciAuthorizationTokensForUserId(int cloudId, String cloudName, ObjectId userId) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"userId").is((Object)userId));
        this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId).remove(query, PciAuthorizationTokens.class);
    }

    @Override
    public void updatePciAuthorizationTokensForUserId(int cloudId, String cloudName, ObjectId userId, String accessToken, String refreshToken) {
        Criteria criteria = Criteria.where((String)"userId").is((Object)userId);
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("accessToken", (Object)accessToken);
        update.set("refreshToken", (Object)refreshToken);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.updateFirst(query, update, PciAuthorizationTokens.class);
    }

    @Override
    public PciAuthorizationTokens getPciAuthorizationTokensForUserName(int cloudId, String userName) {
        PciAuthorizationTokens pciAuthorizationTokens = null;
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"userName").regex(Pattern.compile("^" + userName + "$", 2)), criteria.orOperator(new Criteria[]{Criteria.where((String)"deleted").is((Object)false), Criteria.where((String)"deleted").exists(false)})});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        User user = (User)paracloudMongoTemplate.findOne(query, User.class);
        if (user != null) {
            query = new Query((CriteriaDefinition)Criteria.where((String)"userId").is((Object)user.getUserId()));
            pciAuthorizationTokens = (PciAuthorizationTokens)this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId).findOne(query, PciAuthorizationTokens.class);
        }
        return pciAuthorizationTokens;
    }

    @Override
    public String getAccessTokenForODBBackup(int cloudId) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        MSGTokens msgToken = (MSGTokens)mongoTemplate.findOne(new Query(), MSGTokens.class);
        String accessToken = null;
        if (msgToken != null) {
            accessToken = msgToken.getAccessToken();
        }
        return accessToken;
    }

    @Override
    public MSGTokens getMSGTokens(int cloudId) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (MSGTokens)mongoTemplate.findOne(new Query(), MSGTokens.class);
    }
}

