/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pcbd.dao.impl;

import com.parablu.pcbd.dao.BackupPolicyDao;
import com.parablu.pcbd.domain.BackupPolicy;
import com.parablu.pcbd.domain.OPWS;
import com.pg.factory.BlukryptMongoFactoryUtils;
import java.util.Collection;
import java.util.List;
import org.bson.types.ObjectId;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.util.CollectionUtils;

public class BackupPolicyDaoImpl
implements BackupPolicyDao {
    BlukryptMongoFactoryUtils blukryptMongoFactoryUtils;

    public BlukryptMongoFactoryUtils getBlukryptMongoFactoryUtils() {
        return this.blukryptMongoFactoryUtils;
    }

    public void setBlukryptMongoFactoryUtils(BlukryptMongoFactoryUtils blukryptMongoFactoryUtils) {
        this.blukryptMongoFactoryUtils = blukryptMongoFactoryUtils;
    }

    @Override
    public void saveBackupPolicy(int cloudId, String cloudName, BackupPolicy backupPolicy) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.save((Object)backupPolicy);
    }

    @Override
    public BackupPolicy getBackupPolicy(int cloudId, String cloudName, String policyName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"policyName").is((Object)policyName)});
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (BackupPolicy)mongoTemplate.findOne(new Query((CriteriaDefinition)criteria), BackupPolicy.class);
    }

    @Override
    public List<BackupPolicy> getAllBackupPolicies(int cloudId, String cloudName) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.findAll(BackupPolicy.class);
    }

    @Override
    public Boolean getBackupPolicy(int cloudId, String cloudName, String policyName, long lastModifiedTime) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"policyName").is((Object)policyName), Criteria.where((String)"lastModifiedTimestamp").is((Object)lastModifiedTime)});
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        BackupPolicy backupPolicy = (BackupPolicy)mongoTemplate.findOne(new Query((CriteriaDefinition)criteria), BackupPolicy.class);
        if (backupPolicy != null) {
            return true;
        }
        return false;
    }

    @Override
    public List<BackupPolicy> getBackupPolicyForFilterName(int cloudId, String cloudName, ObjectId id) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"inclusionFilter.$id").is((Object)id)});
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(new Query((CriteriaDefinition)criteria), BackupPolicy.class);
    }

    @Override
    public void saveOPWS(int cloudId, String cloudName, OPWS opws) {
        List list;
        String tableName = "opws_" + cloudName;
        tableName = tableName.toUpperCase();
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        if (!mongoTemplate.collectionExists(tableName)) {
            mongoTemplate.createCollection(tableName);
        }
        if (!CollectionUtils.isEmpty((Collection)(list = mongoTemplate.findAll(OPWS.class, tableName)))) {
            Query query = new Query();
            Update update = new Update();
            update.set("threadSize", (Object)opws.getThreadSize());
            mongoTemplate.updateFirst(query, update, OPWS.class, tableName);
        } else {
            mongoTemplate.insert((Object)opws, tableName);
        }
    }

    @Override
    public long getThreadSize(int cloudId, String cloudName) {
        Query query;
        OPWS opws;
        String tableName = "opws_" + cloudName;
        tableName = tableName.toUpperCase();
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        if (!mongoTemplate.collectionExists(tableName)) {
            mongoTemplate.createCollection(tableName);
        }
        if ((opws = (OPWS)mongoTemplate.findOne(query = new Query(), OPWS.class, tableName)) != null) {
            return opws.getThreadSize();
        }
        return 0L;
    }

    @Override
    public List<BackupPolicy> getAllLegalHoldBackupPolicies(int cloudId, String cloudName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"legalHoldEnabled").is((Object)true)});
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(new Query((CriteriaDefinition)criteria), BackupPolicy.class);
    }
}

