/*
 * Decompiled with CFR 0.152.
 */
package com.pg.timer;

import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.EventHub;
import com.pg.service.MSService;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;
import org.quartz.SchedulerException;
import org.springframework.scheduling.quartz.QuartzJobBean;

@PersistJobDataAfterExecution
@DisallowConcurrentExecution
public class DeleteOldEventsJob
extends QuartzJobBean
implements Job {
    private MSService msService;
    private static Logger logger = LogManager.getLogger(DeleteOldEventsJob.class);

    public void setMsService(MSService msService) {
        this.msService = msService;
    }

    protected void executeInternal(JobExecutionContext arg0) throws JobExecutionException {
        try {
            List jobs = arg0.getScheduler().getCurrentlyExecutingJobs();
            if (jobs != null && !jobs.isEmpty()) {
                for (JobExecutionContext job : jobs) {
                    if (!job.getTrigger().equals((Object)arg0.getTrigger()) || job.getJobInstance().equals((Object)this)) continue;
                    logger.debug("There's another instance running,SO skipping>>>>>>>>>>>>> : " + (Object)((Object)this));
                    return;
                }
            }
        }
        catch (SchedulerException e) {
            logger.debug("" + (Object)((Object)e));
            logger.error("" + e.getCause());
        }
        logger.debug("....DeleteOldEventsJob job started...");
        try {
            int cloudId = 1;
            Cloud cloud = this.msService.getCloud(cloudId);
            List<EventHub> eventsToProcess = this.getEventsToProcess(cloud);
            for (EventHub eventHub : eventsToProcess) {
                long currentTime = System.currentTimeMillis();
                long eventTime = eventHub.getLastUpdatedTime();
                logger.debug(eventHub.getId().toString() + ".....event time..... " + currentTime + "..." + eventTime);
                if (eventTime == 0L) {
                    logger.debug(eventHub.getActionToUserName() + "..user.." + eventHub.getId().toString() + "*********************EVETHUB-DATE..........." + DeleteOldEventsJob.convertToTimestampFrom(eventHub.getId().toString()));
                }
                if (eventTime <= 0L || currentTime - eventTime <= 0L) continue;
                long diffSec = (currentTime - eventTime) / 1000L;
                long min = diffSec / 60L;
                logger.debug("......diff in time...." + min);
                if (min <= 60L) continue;
                logger.debug(".....deleting event...." + eventHub.getId().toString());
                this.msService.deleteEventHub(cloudId, eventHub.getId());
            }
        }
        catch (Exception e) {
            logger.error(" exception in DeleteOldEventsJob job......." + e.getMessage());
            logger.trace("exception in DeleteOldEventsJob job ......." + e);
        }
        logger.debug("....DeleteOldEventsJob job ended...");
    }

    private synchronized List<EventHub> getEventsToProcess(Cloud cloud) {
        List<EventHub> eventHubList = this.msService.getStartBackupEventHubListForBlukrypt(cloud.getCloudId());
        return eventHubList;
    }

    public static Instant convertToInstantFrom(String objectId) {
        return DeleteOldEventsJob.convertToDateFrom(objectId).toInstant();
    }

    public static Date convertToDateFrom(String objectId) {
        return new Date(DeleteOldEventsJob.convertToTimestampFrom(objectId));
    }

    public static long convertToTimestampFrom(String objectId) {
        return Long.parseLong(objectId.substring(0, 8), 16) * 1000L;
    }
}

