/*
 * Decompiled with CFR 0.152.
 */
package com.pg.dao.impl;

import com.pg.dao.OneDriveDao;
import com.pg.element.PciAuthorizationTokenElement;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class OneDriveDaoImpl
implements OneDriveDao {
    private static Logger logger = LogManager.getLogger(OneDriveDaoImpl.class);
    private static final Client CLIENT = Client.create();

    @Override
    public String getOneDriveAccessToken(PciAuthorizationTokenElement element) {
        String url = "https://login.live.com/oauth20_token.srf?client_id=" + element.getClientId() + "&redirect_uri=" + element.getRedirectUri() + "&client_secret=" + element.getClientSecret() + "&refresh_token=" + element.getRefreshToken() + "&grant_type=refresh_token";
        WebResource webResource = CLIENT.resource(url);
        ClientResponse response = (ClientResponse)webResource.get(ClientResponse.class);
        String output = OneDriveDaoImpl.printResponse(response);
        String accessToken = "";
        try {
            JSONObject json = new JSONObject(output);
            accessToken = json.get("access_token").toString();
        }
        catch (JSONException e) {
            logger.trace("" + (Object)((Object)e));
            logger.debug(" !@#!@#!@#! ERROR fetching access token :" + e.getMessage());
        }
        return accessToken;
    }

    private static String printResponse(ClientResponse response) {
        if (response.getStatus() == 201) {
            logger.debug("Created folder..");
        } else {
            if (response.getStatus() == 204) {
                logger.debug("Delete operation successful..");
                return "204";
            }
            if (response.getStatus() != 200) {
                return Integer.toString(response.getStatus());
            }
        }
        return (String)response.getEntity(String.class);
    }

    @Override
    public String getOrCreateParaBluFolderId(String accessToken) {
        String parabluFolderId = this.getParabluFolderId(accessToken);
        if (StringUtils.isEmpty((String)parabluFolderId)) {
            parabluFolderId = this.createParabluFolder(accessToken);
        }
        return parabluFolderId;
    }

    private String getParabluFolderId(String accessToken) {
        String url = "https://apis.live.net/v5.0/me/skydrive?access_token=" + accessToken;
        WebResource webResource = CLIENT.resource(url);
        ClientResponse response = (ClientResponse)webResource.get(ClientResponse.class);
        String output = OneDriveDaoImpl.printResponse(response);
        String parabluFolderId = "";
        try {
            JSONObject json = new JSONObject(output);
            String rootFolderId = json.get("id").toString();
            url = "https://apis.live.net/v5.0/" + rootFolderId + "/files?access_token=" + accessToken;
            webResource = CLIENT.resource(url);
            response = (ClientResponse)webResource.get(ClientResponse.class);
            output = OneDriveDaoImpl.printResponse(response);
            JSONObject array = new JSONObject(output);
            JSONArray jsonArray = array.getJSONArray("data");
            if (jsonArray != null) {
                parabluFolderId = this.getParabluFolderId(jsonArray);
            }
        }
        catch (JSONException e) {
            logger.debug(" ERROR fetching getParabluFolderId :" + (Object)((Object)e));
        }
        return parabluFolderId;
    }

    private String getParabluFolderId(JSONArray jsonArray) {
        String parabluFolderId = "";
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            if (!"ParaBlu".equals(jsonObject.get("name"))) continue;
            parabluFolderId = jsonObject.getString("id");
        }
        return parabluFolderId;
    }

    private String createParabluFolder(String accessToken) {
        WebResource webResource = CLIENT.resource("https://apis.live.net/v5.0/me/albums?access_token=" + accessToken);
        String folderNameVal = "{\"name\":\"ParaBlu\",\"description\":\"Parablu Folder.\"}";
        ClientResponse response = (ClientResponse)webResource.type("application/json").post(ClientResponse.class, (Object)folderNameVal);
        String output = OneDriveDaoImpl.printResponse(response);
        String folderId = null;
        try {
            JSONObject json = new JSONObject(output);
            folderId = json.get("id").toString();
        }
        catch (JSONException e) {
            logger.debug(" ERROR fetching createParabluFolder :" + (Object)((Object)e));
        }
        return folderId;
    }
}

