/*
 * Decompiled with CFR 0.152.
 */
package com.pg.dao.impl;

import com.pg.dao.CleanAndMovePGInfoDao;
import com.pg.element.PGInfoElement;
import com.pg.helper.constant.PCHelperConstant;
import com.pg.helper.utils.CacheHelper;
import com.pg.httpclient.util.HttpClientUtil;
import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class CleanAndMovePGInfoDaoImpl
implements CleanAndMovePGInfoDao {
    private static Logger logger = LogManager.getLogger(CleanAndMovePGInfoDaoImpl.class);
    private static final String PRIVACY_GETEWAY = "privacy_gateway_";
    private static final String BACKUP = "_backup";
    private static final String OD = "od_";
    private static final String BLOB = "blob_";

    @Override
    public void getInfoFromLocalPGAndSaveToMainDB(String cloudName, String gatewayName) {
        try {
            String cloudNameVar = cloudName.toLowerCase();
            String key = PRIVACY_GETEWAY + cloudName.toLowerCase() + BACKUP;
            Long filesSizeInPg = (Long)CacheHelper.getInstance().getValueFromCache(key);
            logger.debug("File size for today.......... " + filesSizeInPg);
            this.savePGInfoInMainDB(cloudNameVar, gatewayName, filesSizeInPg.longValue());
            CacheHelper.getInstance().removeKeyFromCache(key);
        }
        catch (Exception e) {
            logger.error(" !!!!! ERROR TRYING TO GET EBMS to PG size ...." + e);
        }
    }

    private void savePGInfoInMainDB(String cloudName, String gatewayName, double pgSizeInMB) throws Exception {
        logger.debug("pgSize in mb:" + pgSizeInMB);
        String tableName = "pginfo_trends";
        this.updateDb(cloudName, gatewayName, pgSizeInMB, tableName);
    }

    private void updateDb(String cloudName, String gatewayName, double pgSizeInMB, String tableName) throws Exception {
        PGInfoElement infoElement = new PGInfoElement();
        infoElement.setGatewayName(gatewayName);
        infoElement.setSizeInMB(pgSizeInMB);
        infoElement.setTimeStamp(Long.valueOf(System.currentTimeMillis()));
        HttpComponentsClientHttpRequestFactory reqFactory = HttpClientUtil.getHttpRequestFactory();
        RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)reqFactory);
        ArrayList<MappingJackson2HttpMessageConverter> messageConverters = new ArrayList<MappingJackson2HttpMessageConverter>();
        messageConverters.add(new MappingJackson2HttpMessageConverter());
        restTemplate.setMessageConverters(messageConverters);
        HttpHeaders headers = new HttpHeaders();
        headers.add("tableName", tableName);
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity entity = new HttpEntity((Object)infoElement, (MultiValueMap)headers);
        String url = PCHelperConstant.getPropertyFileValueForParacloudUrl() + "/paracloud/cloud/" + cloudName + "/save/pginfo/";
        restTemplate.put(url, (Object)entity, new Object[0]);
        reqFactory.destroy();
    }

    @Override
    public void getInfoFromLocalODPGAndSaveToMainDB(String cloudName, String gatewayName) {
        try {
            String key = OD + cloudName.toLowerCase() + BACKUP;
            Double filesSizeInCloud = (Double)CacheHelper.getInstance().getValueFromCache(key);
            this.saveExternalPGInfoInMainDB(cloudName.toLowerCase(), gatewayName, filesSizeInCloud, "od");
            CacheHelper.getInstance().removeKeyFromCache(key);
        }
        catch (Exception e) {
            logger.error(" !!!!! ERROR TRYING TO GET OD PG size ...." + e);
        }
    }

    @Override
    public void getSizeOfBlobPGAndSaveToMainDB(String cloudNameparam, String gatewayName) {
        try {
            String cloudName = cloudNameparam.toLowerCase();
            String storagePlace = "blob";
            String key = BLOB + cloudName.toLowerCase() + BACKUP;
            Double filesSizeInCloud = (Double)CacheHelper.getInstance().getValueFromCache(key);
            this.saveExternalPGInfoInMainDB(cloudName.toLowerCase(), gatewayName, filesSizeInCloud, "blob");
            CacheHelper.getInstance().removeKeyFromCache(key);
        }
        catch (Exception e) {
            logger.error(" !!!!! ERROR TRYING TO GET OD PG size ...." + e);
        }
    }

    private void saveExternalPGInfoInMainDB(String cloudName, String gatewayName, double pgSizeInMB, String storagePlace) throws Exception {
        logger.debug("pgSize in mb:" + pgSizeInMB);
        String tableName = storagePlace + "info_trends";
        this.updateDb(cloudName, gatewayName, pgSizeInMB, tableName);
    }
}

