/*
 * Decompiled with CFR 0.152.
 */
package com.pg.odb.util;

import com.parablu.pcbd.domain.User;
import com.pg.element.FileStatusElement;
import com.pg.element.PciAuthorizationTokenElement;
import com.pg.helper.constant.PCHelperConstant;
import com.pg.service.GoogleDriveService;
import com.pg.service.UtilService;
import java.io.BufferedInputStream;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

public class GoogleDriveUtil {
    private static final int MAX_FILE_COUNT = 5000;
    Map<String, UserOdbElement> userCountMap = new ConcurrentHashMap<String, UserOdbElement>();
    Map<String, Object> userObjectMap = new ConcurrentHashMap<String, Object>();
    @Autowired
    private UtilService utilService;
    @Autowired
    private GoogleDriveService googleDriveService;
    private static GoogleDriveUtil singleton = new GoogleDriveUtil();
    private static Logger logger = LogManager.getLogger(GoogleDriveUtil.class);

    private GoogleDriveUtil() {
    }

    public void setUtilService(UtilService utilService) {
        this.utilService = utilService;
    }

    public void setGoogleDriveService(GoogleDriveService googleDriveService) {
        this.googleDriveService = googleDriveService;
    }

    public static GoogleDriveUtil getInstance() {
        return singleton;
    }

    public boolean isGDCountApiCallReq(String userName) {
        boolean isODBCountApiCallReq = true;
        if (this.userCountMap.get(userName) != null) {
            logger.debug("...isGDCountApiCallReq.." + this.userCountMap.get(userName) + "....." + this.userCountMap.get(userName).getCount() + "...mod .... " + this.userCountMap.get(userName).getCount() % PCHelperConstant.getODBCallFrequency());
        }
        if (this.userCountMap.get(userName) != null && this.userCountMap.get(userName).getCount() < 5000 && this.userCountMap.get(userName).getCount() % PCHelperConstant.getODBCallFrequency() != 0) {
            isODBCountApiCallReq = false;
        }
        return isODBCountApiCallReq;
    }

    private synchronized void setUserElement(PciAuthorizationTokenElement pciTokenElement, boolean isSync, String emailId, User user, String deviceUUID, String actualUserName, String gdParentFolderId) {
        logger.error("MAP-VAL................" + this.userCountMap + "...." + emailId);
        if (this.userCountMap.get(actualUserName) == null) {
            logger.debug("inside getUserElement nulll " + actualUserName);
            String lastCloudStoragePath = this.checkGoogleDriveStoragePath(pciTokenElement.getCloudName(), user, isSync);
            int count = this.getCountOFFilesInFolder(pciTokenElement, lastCloudStoragePath, deviceUUID, user.getUserName(), gdParentFolderId);
            logger.debug(".......folder count before assigning setuserElement..... " + count);
            while (count >= 5000) {
                ArrayList<Integer> folderNameList = this.splitPathAndGetFolderDepth(lastCloudStoragePath);
                lastCloudStoragePath = this.checkGoogleDriveStoragePathAndCount(folderNameList, count);
                logger.debug("......count >= MAX_FILE_COUNT.....");
                count = this.getCountOFFilesInFolder(pciTokenElement, lastCloudStoragePath, deviceUUID, user.getUserName(), "");
                if (count >= 5000) continue;
                break;
            }
            logger.debug(".......folder count after assigning setuserElement..... " + count + "......." + lastCloudStoragePath);
            UserOdbElement userOdbElement = new UserOdbElement(count, System.currentTimeMillis(), lastCloudStoragePath);
            this.userCountMap.put(actualUserName, userOdbElement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCountForUser(PciAuthorizationTokenElement pciTokenElement, boolean isSync, String userName, boolean isOdbApiCallRequired, String emailId, String deviceUUID, String actualUserName, String gdParentFolderId) {
        if (!this.userObjectMap.containsKey(emailId)) {
            Object object = new Object();
            this.userObjectMap.put(emailId, object);
        }
        Object obj = this.userObjectMap.get(emailId);
        logger.debug(obj + "..... obj synchronized ....." + emailId + "......" + this.userCountMap.get(actualUserName).getCount());
        if (isOdbApiCallRequired) {
            Object object = obj;
            synchronized (object) {
                if (this.isGDCountApiCallReq(actualUserName)) {
                    int count = this.getCountOFFilesInFolder(pciTokenElement, this.userCountMap.get(actualUserName).getPath(), deviceUUID, actualUserName, gdParentFolderId);
                    if (count <= 0) {
                        count = this.userCountMap.get(actualUserName).getCount();
                    }
                    this.updateGDCount(isSync, userName, count, emailId, pciTokenElement, deviceUUID, actualUserName, gdParentFolderId);
                } else {
                    this.updateGDCount(isSync, userName, this.userCountMap.get(actualUserName).getCount(), emailId, pciTokenElement, deviceUUID, actualUserName, gdParentFolderId);
                }
            }
            logger.debug("INSID isOdbApiCallRequired.....");
        } else {
            this.updateGDCount(isSync, userName, this.userCountMap.get(actualUserName).getCount(), emailId, pciTokenElement, deviceUUID, actualUserName, gdParentFolderId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateGDCount(boolean isSync, String userName, int count, String emailId, PciAuthorizationTokenElement pciTokenElement, String deviceUUID, String actualUserName, String gdParentFolderId) {
        if (this.userCountMap.get(actualUserName).getCount() >= 5000) {
            ArrayList<Integer> folderNameList = this.splitPathAndGetFolderDepth(this.userCountMap.get(actualUserName).getPath());
            String cloudStoragePath = this.checkGoogleDriveStoragePathAndCount(folderNameList, this.userCountMap.get(actualUserName).getCount());
            int filesInFoldercount = this.getCountOFFilesInFolder(pciTokenElement, cloudStoragePath, deviceUUID, actualUserName, "");
            logger.debug(".......folder count before assigning..... " + cloudStoragePath + ".....filescount...." + filesInFoldercount);
            if (filesInFoldercount != 0 && filesInFoldercount < 5000) {
                this.userCountMap.get(actualUserName).setCount(filesInFoldercount + 1);
            } else {
                String string = cloudStoragePath;
                synchronized (string) {
                    while (filesInFoldercount >= 5000) {
                        logger.error("...greater than 4000.....check here... " + emailId);
                        folderNameList = this.splitPathAndGetFolderDepth(cloudStoragePath);
                        filesInFoldercount = this.getCountOFFilesInFolder(pciTokenElement, cloudStoragePath = this.checkGoogleDriveStoragePathAndCount(folderNameList, filesInFoldercount), deviceUUID, actualUserName, "");
                        if (filesInFoldercount >= 5000) continue;
                    }
                    logger.debug(".......folder count after finding correct path..... " + cloudStoragePath + ".....filescount...." + filesInFoldercount);
                    this.userCountMap.get(actualUserName).setCount(1);
                    this.userCountMap.get(actualUserName).setPath(cloudStoragePath);
                    this.utilService.updateUserStoragePath(1, userName, this.userCountMap.get(actualUserName).getPath(), isSync);
                }
            }
        } else {
            this.userCountMap.get(actualUserName).setCount(count + 1);
        }
    }

    public FileStatusElement uploadToGD(PciAuthorizationTokenElement pciTokenElement, boolean isSync, FileStatusElement fileStatusElement, File encryptedFile, String lastStoragePathForSameFile, String cloudChunkName, String deviceUUID, User user) {
        String emailId = user.getOdbLoginId();
        if (StringUtils.isEmpty((Object)emailId)) {
            emailId = user.getEmailId();
        }
        logger.debug("Email Id>>>>>" + emailId + "....user name:" + user.getUserName());
        boolean isOdbApiCallRequired = this.isGDCountApiCallReq(emailId);
        isOdbApiCallRequired = false;
        if (this.userCountMap.get(user.getUserName()) == null) {
            this.setUserElement(pciTokenElement, isSync, emailId, user, deviceUUID, user.getUserName(), user.getGdParentFolderId());
        } else {
            this.setCountForUser(pciTokenElement, isSync, pciTokenElement.getUserName(), isOdbApiCallRequired, emailId, deviceUUID, user.getUserName(), user.getGdParentFolderId());
        }
        logger.debug(emailId + " before  setCountForUser.......... " + isOdbApiCallRequired);
        user = this.utilService.getUserInfoByName(1, user.getUserName());
        String gdParentFolderId = user.getGdParentFolderId();
        logger.debug("....gd parentFolder id ....." + gdParentFolderId);
        String userStoragepath = this.userCountMap.get(user.getUserName()).getPath();
        userStoragepath = isSync ? user.getCloudSyncStoragePath() : user.getCloudBkpStoragePath();
        if (StringUtils.isEmpty((Object)userStoragepath)) {
            userStoragepath = "1";
        }
        logger.debug("....user storagepath for user ..." + user.getUserName() + "....path...." + userStoragepath);
        logger.error(userStoragepath + " latest COUNT>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> " + this.userCountMap.get(user.getUserName()).getCount());
        String encodedFileName = this.googleDriveService.uploadFileToGD(pciTokenElement.getAccessToken(), pciTokenElement, encryptedFile, userStoragepath, cloudChunkName, deviceUUID, gdParentFolderId);
        logger.debug(" END OF next file ..... " + userStoragepath);
        fileStatusElement.setCloudStoragePath(userStoragepath);
        fileStatusElement.setUploadStatus(true);
        fileStatusElement.setFileId(encodedFileName);
        if (StringUtils.isEmpty((Object)encodedFileName)) {
            fileStatusElement.setUploadStatus(false);
        }
        return fileStatusElement;
    }

    private int getCountOFFilesInFolder(PciAuthorizationTokenElement pciTokenElement, String lastCloudStoragePath, String deviceUUID, String userName, String gdParentFolderId) {
        return this.googleDriveService.getCountOfFilesInFolder(pciTokenElement, lastCloudStoragePath, deviceUUID, userName, gdParentFolderId);
    }

    private synchronized String checkGoogleDriveStoragePath(String cloudName, User user, boolean isSync) {
        String cloudStoragePath = "1";
        if (isSync) {
            if (!StringUtils.isEmpty((Object)user.getCloudSyncStoragePath())) {
                cloudStoragePath = user.getCloudSyncStoragePath();
            }
        } else if (!StringUtils.isEmpty((Object)user.getCloudBkpStoragePath())) {
            cloudStoragePath = user.getCloudBkpStoragePath();
        }
        if (StringUtils.isEmpty((Object)cloudStoragePath)) {
            cloudStoragePath = "1";
        }
        logger.debug(user.getUserName() + "Inside check google drive path>>>>>>>>>>>>" + cloudStoragePath);
        return cloudStoragePath;
    }

    private synchronized String checkGoogleDriveStoragePathAndCount(ArrayList<Integer> folderNameList, int count) {
        int countTemp = count;
        String cloudStoragePath = "";
        int folderDepthSize = folderNameList.size();
        if (folderDepthSize == 1) {
            int folderValue = folderNameList.get(0);
            logger.debug("Folder DEpth Size 1 folder value>>>>>>" + folderValue);
            if (folderValue <= 900) {
                if (countTemp < 5000) {
                    cloudStoragePath = String.valueOf(folderValue);
                    logger.debug("Folder DEpth Size 1 folder value count less than 500>>>>>>." + countTemp);
                } else if (folderValue < 900) {
                    countTemp = 0;
                    folderNameList.set(0, folderValue + 1);
                    cloudStoragePath = String.valueOf(folderValue + 1);
                    logger.debug("count >= MAX_FILE_COUNT ........... " + cloudStoragePath);
                } else if (folderValue >= 900) {
                    folderNameList.clear();
                    countTemp = 0;
                    folderNameList.add(0, 1);
                    folderNameList.add(1, 1);
                    cloudStoragePath = "1/1";
                    logger.debug("folderValue >= 900 ........... " + cloudStoragePath);
                }
            }
            ++countTemp;
        } else {
            int lastFolder = folderNameList.get(folderDepthSize - 1);
            int previousFolder = folderNameList.get(folderDepthSize - 2);
            if (lastFolder <= 900) {
                if (countTemp < 5000) {
                    cloudStoragePath = String.valueOf(previousFolder + "/" + lastFolder);
                    logger.debug("else count < MAX_FILE_COUNT ........... " + cloudStoragePath);
                } else if (lastFolder < 900) {
                    countTemp = 0;
                    folderNameList.set(folderDepthSize - 1, lastFolder + 1);
                    cloudStoragePath = String.valueOf(previousFolder + "/" + ++lastFolder);
                    logger.debug("else count >= MAX_FILE_COUNT ........... " + cloudStoragePath);
                } else if (lastFolder >= 900) {
                    countTemp = 0;
                    folderNameList.set(folderDepthSize - 1, 1);
                    folderNameList.set(folderDepthSize - 2, previousFolder + 1);
                    cloudStoragePath = ++previousFolder + "/1";
                    logger.debug("else lastFolder >= 900 ........... " + cloudStoragePath);
                }
            }
            ++countTemp;
        }
        logger.debug("5000 max size " + cloudStoragePath + " endo of method ........" + countTemp);
        return cloudStoragePath;
    }

    private ArrayList<Integer> splitPathAndGetFolderDepth(String cloudStoragePath) {
        ArrayList<Integer> pathListNumbers = new ArrayList<Integer>();
        if (!StringUtils.isEmpty((Object)cloudStoragePath)) {
            String[] pathList;
            for (String path : pathList = cloudStoragePath.split("/")) {
                pathListNumbers.add(Integer.parseInt(path));
            }
        }
        return pathListNumbers;
    }

    public BufferedInputStream downloadFileFromGD(PciAuthorizationTokenElement pciTokenElement, String fileNameToDownload, boolean isGDServiceAcctEnabled) {
        return this.googleDriveService.downloadFileFromGD(pciTokenElement, fileNameToDownload, isGDServiceAcctEnabled);
    }

    public boolean deleteFromGD(PciAuthorizationTokenElement pciTokenElement, String fileNameToDownload, boolean isGDServiceAcctEnabled) {
        return this.googleDriveService.deleteFromGD(pciTokenElement, fileNameToDownload, isGDServiceAcctEnabled);
    }

    public class UserOdbElement {
        Integer count;
        Long timeMillis;
        String path;

        public UserOdbElement(Integer count, Long timeMillis, String path) {
            this.count = count;
            this.timeMillis = timeMillis;
            this.path = path;
        }

        public Integer getCount() {
            return this.count;
        }

        public void setCount(Integer count) {
            this.count = count;
        }

        public Long getTimeMillis() {
            return this.timeMillis;
        }

        public void setTimeMillis(Long timeMillis) {
            this.timeMillis = timeMillis;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }
    }
}

