source ./infoFile.conf

# patchFunction
function patch_jars()
{
	base1=$1
	base2=$2
	if [[ ! -z ${base1} ]]; then
		for file1 in ${base1}; do
			# echo ${base1}
			echo ${file1} >>  $patchInfoFile/$patchVersion
			if [[ -f $patchNewPath/${file1} ]]; then
				file1=$(echo $file1 | rev | cut -c10- | rev)
				mv ${base2}/$file1* $patchOldPath 2> /dev/null
			fi
		done
	fi
	for file in ${base1}; do
		ext="${file%.*}"
		parts=(${ext//-/ })
		for process1 in $parts; do
			# echo ${base2}
			cp $patchNewPath/$ext.jar ${base2} 2> /dev/null
			chown tomcat:tomcat ${base2}/$process1* 2> /dev/null
		done
	done
}
# revokeJarFunction
function revoke_jar()
{
	base1=$1
	base2=$2
	for file in ${base1}; do
		# echo ${base1}
		ext="${file%.*}"
		parts=(${ext//-/ })
		for process1 in $parts; do
			# echo ${base2}
			mv $patchOldPath/$process1* ${base2} 2> /dev/null
			chown tomcat:tomcat ${base2}/$process1* 2> /dev/null
		done
	done
}

# credentialsFunction
function patch_properties()
{
	base1=$1
	base2=$2
	base3=$3
	if [[ ! -z ${base1} ]]; then
		echo ${base1} >>  $patchInfoFile/$patchVersion
		cp ${base2} $patchOldPath/"$base3" 2> /dev/null
	fi
	for file in ${base1}; do
		parts=(${file//=/ })
		if grep -q "$parts" ${base2}
		then
			sed -i "/$parts/d" ${base2} 2> /dev/null
			sed -i "$ a\ $file" ${base2} 2> /dev/null
			sed -i 's/^[ \t]*//' ${base2} 2> /dev/null
		else
			sed -i "$ a\ $file" ${base2} 2> /dev/null
			sed -i 's/^[ \t]*//' ${base2} 2> /dev/null
		fi
	done
}
# revokePropertiesFunction
function revoke_properties()
{
	base1=$1
	base2=$2
	base3=$3
	if [[ ! -z ${base1} ]]; then
		mv $patchOldPath/"$base3" $base2 2> /dev/null
	fi
}

# portalFunction
function portal_patch_full()
{
	base1=$1
	base2=$2
	if [[ ! -z ${base1} ]] && [[ -f $patchNewPath/${base1} ]]; then
		echo ${base1} >>  $patchInfoFile/$patchVersion
		mv ${base2} $patchOldPath/ 2> /dev/null
		
	fi
	for file in ${base1}; do
		mkdir ${base2} 2> /dev/null
		unzip $patchNewPath/$file -d ${base2}/ 2> /dev/null
		cp $patchOldPath/portal/index.php ${base2}/index.php 2> /dev/null
		cp $patchOldPath/portal/app/Core/Config.php ${base2}/app/Core/Config.php  2> /dev/null
                chmod -R 777 ${base2}
	done
}
# portalRevokeFunction
function portal_revoke()
{
	base1=$1
	base2=$2
	if [[ ! -z ${base1} ]]; then
		mv $patchOldPath/portal ${base2} 2> /dev/null
	fi
}

#portalConfig Function
function portal_patch_config()
{
	base1=$1
	base2=$2
	base3=$3
	if [[ ! -z ${base1} ]]; then
		echo ${base1} >>  $patchInfoFile/$patchVersion
		cp ${base2} $patchOldPath/"$base3" 2> /dev/null
	fi
	for file in ${base1}; do
		parts=(${file//=/ })
		if grep -q "$parts" ${base2}
		then
			sed -i "/$parts/d" ${base2} 2> /dev/null
			sed -i "$ a\ $file" ${base2} 2> /dev/null
			sed -i 's/^[ \t]*//' ${base2} 2> /dev/null
		else
			sed -i "$ a\ $file" ${base2} 2> /dev/null
			sed -i 's/^[ \t]*//' ${base2} 2> /dev/null
		fi
	done
}

function fullDeploy_war()
{
	base1=$1
	base2=$2
	if [[ ! -z ${base1} ]]; then
		echo ${base1} >>  $patchInfoFile/$fullDeployVersion
		mv ${base2}/${base1} $fullDeployOldPath/ 2> /dev/null
		cp $patchNewPath/${base1}.war ${base2} 2> /dev/null
	fi
}


