#/bin/bash

if [[ $EUID -ne 0 ]]; then
   tput clear
   tput cup 5 20
   echo "This script must be run as a root user"
   echo ""
   exit 1
fi


version=$1

source ./infoFile.conf 2> /dev/null
source ./incrementInfo.conf 2> /dev/null
source ./onlyFunctions.sh 2> /dev/null



dns_user="paracloud-support@dns.parablu.com"
dns_path="/var/www/latest_files/dev_testing/"$zipFilename-$version.zip""
dns_pass="ParaCloud5*"

if [ "$version" == "" ]; then
echo "Make sure you have the patch ready in ../ directory"
read -p "Enter the correct version number[mandatory] :" version
#else
#sshpass -p "$dns_pass" scp $dns_user:$dns_path ../
fi

sed -i -e "s/<ver>/$version/g" incrementInfo.conf
echo "Updated the incrementInfo File to reflect the correct version $version"

#source ./infoFile.conf 2> /dev/null
#source ./incrementInfo.conf 2> /dev/null
#source ./onlyFunctions.sh 2> /dev/null

# stoping the server for patch
./serverStop.sh 2> /dev/null
patchPath=""$patchPath"-v"$version""
patchNewPath="$patchPath/new"
patchOldPath="$patchPath/old"

rm -r $patchPath

# Create the folder with version name.
if [ ! -d "$patchPath" ]; 
then
	mkdir $patchPath 2>&1
else
        sed -i -e "s/$version/<ver>/g" incrementInfo.conf
	echo "$patchPath already exist"
	exit 
fi
mkdir $patchNewPath 2>&1
mkdir $patchOldPath 2>&1

# creating the file for version information
touch $patchInfoFile/$patchVersion
echo "\n" >> $patchInfoFile/$patchVersion

# unZip the VersionZipFile to patchNewFolder
zipFilename="$zipFilename-$version"
unzip $zipFilePath/$zipFilename -d $patchNewPath 2> /dev/null

# paracloudJars Patch
paracloudfileline=`awk '/paracloudJarsStart/ {flag=1;next} /paracloudJarsEnd/{flag=0} flag {print}' incrementInfo.conf 2> /dev/null`
patch_jars "$paracloudfileline" "$tomcat_paracloud_jar_path"
echo $path_jars

# supportJars Patch
supportjarsline=`awk '/supportJarsStart/ {flag=1;next} /supportJarsEnd/{flag=0} flag {print}' incrementInfo.conf 2> /dev/null`
patch_jars "$supportjarsline" "$tomcat_support_jar_path"

# paramailJars Patch
paramailjarsline=`awk '/paramailJarsStart/ {flag=1;next} /paramailJarsEnd/{flag=0} flag {print}' incrementInfo.conf 2> /dev/null`
patch_jars "$paramailjarsline" "$tomcat_paramail_jar_path"

# ParacloudSearchJars Patch
paracloudsearchline=`awk '/ParacloudSearchJarsStart/ {flag=1;next} /ParacloudSearchJarsEnd/{flag=0} flag {print}' incrementInfo.conf 2> /dev/null`
patch_jars "$paracloudsearchline" "$tomcat_paracloudSearch_jar_path"

# paracloudJobJars Patch
paracloudjobline=`awk '/paracloudJobJarsStart/ {flag=1;next} /paracloudJobJarsEnd/{flag=0} flag {print}' incrementInfo.conf 2> /dev/null`
patch_jars "$paracloudjobline" "$tomcat_paracloudJob_jar_path"

# BluKryptBuilderJars Patch
bluKryptbuilderline=`awk '/BluKryptBuilderJarsStart/ {flag=1;next} /BluKryptBuilderJarsEnd/{flag=0} flag {print}' incrementInfo.conf 2> /dev/null`
patch_jars "$bluKryptbuilderline" "$tomcat_blukrypt_jar_path"

# BluKryptJobJars Patch
blukryptjobline=`awk '/BluKryptJobJarsStart/ {flag=1;next} /BluKryptJobJarsEnd/{flag=0} flag {print}' incrementInfo.conf 2> /dev/null`
patch_jars "$blukryptjobline" "$tomcat_blukryptJob_jar_path"

# paracloudPb-credentials Patch
paracloudPbcredentialsline=`awk '/paracloudConfigurationFilesStartPBCredentials/ {flag=1;next} /paracloudConfigurationFilesEndPBCredentials/{flag=0} flag {print}' incrementInfo.conf 2> /dev/null`
patch_properties "$paracloudPbcredentialsline" "$tomcat_paracloud_pbcre_file" "paracloudPbcredentials"

# paracloudPb-cloudproperties Patch
paracloudPbcloudline=`awk '/paracloudConfigurationFilesStartPBCloud/ {flag=1;next} /paracloudConfigurationFilesEndPBCloud/{flag=0} flag {print}' incrementInfo.conf 2> /dev/null`
patch_properties "$paracloudPbcloudline" "$tomcat_paracloud_pbcloud_file" "paracloudPbcloudproperties"

# supportPb-credentials Patch
supportPbcredentialsline=`awk '/supportConfigurationFilesStartPBCredentials/ {flag=1;next} /supportConfigurationFilesEndPBCredentials/{flag=0} flag {print}' incrementInfo.conf 2> /dev/null`
patch_properties "$supportPbcredentialsline" "$tomcat_support_pbcre_file" "supportPbcredentials"

# paramailPb-credentials Patch
paramailPbcredentialsline=`awk '/paramailConfigurationFilesStartPBCredentials/ {flag=1;next} /paramailConfigurationFilesEndPBCredentials/{flag=0} flag {print}' incrementInfo.conf 2> /dev/null`
patch_properties "$paramailPbcredentialsline" "$tomcat_paramail_pbcre_file" "paramailPbcredentials"

# paracloudsearchPb-credentials Patch
paracloudSearchPbcredentialsline=`awk '/paracloudSearchConfigurationFilesStartPBCredentials/ {flag=1;next} /paracloudSearchConfigurationFilesEndPBCredentials/{flag=0} flag {print}' incrementInfo.conf 2> /dev/null`
patch_properties "$paracloudSearchPbcredentialsline" "$tomcat_paracloudsearch_pbcre_file" "paracloudSearchPbcredentials"

# paracloudsearchPb-cloudproperties Patch
paracloudsearchPbcloudline=`awk '/paracloudSearchConfigurationFilesStartPBCloud/ {flag=1;next} /paracloudSearchConfigurationFilesEndPBCloud/{flag=0} flag {print}' incrementInfo.conf 2> /dev/null`
patch_properties "$paracloudsearchPbcloudline" "$tomcat_paracloudsearch_pbcloud_file" "paracloudsearchPbcloudproperties"

# paracloudjobPb-credentials Patch
paracloudJobPbcredentialsline=`awk '/paracloudjobConfigurationFilesStartPBCredentials/ {flag=1;next} /paracloudjobConfigurationFilesEndPBCredentials/{flag=0} flag {print}' incrementInfo.conf 2> /dev/null`
patch_properties "$paracloudJobPbcredentialsline" "$tomcat_paracloudjob_pbcre_file" "paracloudJobPbcredentials"

# blukryptPb-credentials Patch
blukryptPbcredentialsline=`awk '/blukryptConfigurationFilesStartPBCredentials/ {flag=1;next} /blukryptConfigurationFilesEndPBCredentials/{flag=0} flag {print}' incrementInfo.conf 2> /dev/null`
patch_properties "$blukryptPbcredentialsline" "$tomcat_blukrypt_pbcre_file" "blukryptPbcredentials"

# blukryptJobPb-credentials Patch
blukryptJobPbcredentialsline=`awk '/blukryptjobConfigurationFilesStartPBCredentials/ {flag=1;next} /blukryptjobConfigurationFilesEndPBCredentials/{flag=0} flag {print}' incrementInfo.conf 2> /dev/null`
patch_properties "$blukryptJobPbcredentialsline" "$tomcat_blukryptjob_pbcre_file" "blukryptJobPbcredentials"

# portal war deploy
portaluiline=`awk '/uiPortalStart/ {flag=1;next} /uiPortalEnd/{flag=0} flag {print}' incrementInfo.conf 2> /dev/null`
portal_patch_full "$portaluiline" "$ui_path"

# portalConfig Patch
portalconfline=`awk '/uiPortalConfStart/ {flag=1;next} /uiPortalConfEnd/{flag=0} flag {print}' incrementInfo.conf 2> /dev/null`
portal_patch_config "$portalconfline" "$uiPortalConf_file" "portalconfig"

sed -i -e "s/$version/<ver>/g" incrementInfo.conf

./serverStart.sh 2> /dev/null

sed -i -e "s/$version/<ver>/g" incrementInfo.conf
