#!/bin/bash -e

git_url="http://192.168.7.22/ParaBlu"
git config --global credential.helper 'cache --timeout 3600'

jars=('LibrarySupport' 'BluKryptHelper' 'GeneralHelper' 'ParacloudHelper' 'ParacloudPersistence' 'SecurityBroker' 'ResourceFunnel'  'ParacloudStatisticsCollector' 'MigrationToolAPI' 'ParacloudStorageManagement' 'AHAPI' 'ParaMailAPI' 'UDCAPI' 'EncryptionAPI'  'ParacloudMedia'  'BackupAPI' 'ReportAPI'  'BackupPolicyAPI' 'SyncAPI' 'TopologyGovernence' 'ShareAPI'  'SettingsAPI' 'IpUpdater' 'Upnp' 'BluKryptPersistence' 'PciBusAPI' 'BluKryptJobAPI' 'portal')

#declare -A jarwarmap=( ["GeneralHelper"]="BluKryptJars|ParacloudJars" ["ParacloudHelper"]="BluKryptJars")

declare -A jarwarmap=( ["AHAPI"]="Paracloudjobjars|Paracloudjars|ParacloudSearchjars" ["BackupAPI"]="Paracloudjobjars|Paracloudjars|ParacloudSearchjars" ["BackupPolicyAPI"]="Paracloudjobjars|Paracloudjars|ParacloudSearchjars" ["EncryptionAPI"]="Paracloudjobjars|Paracloudjars|Blukryptjobjars|Blukryptbuilderjars|ParacloudSearchjars" ["GeneralHelper"]="Paracloudjobjars|Paracloudjars|paramailjars|ParacloudSearchjars" ["ParacloudHelper"]="Paracloudjobjars|Paracloudjars|paramailjars|ParacloudSearchjars" ["ParacloudMedia"]="Paracloudjobjars|Paracloudjars|ParacloudSearchjars" ["ParacloudPersistence"]="Paracloudjobjars|Paracloudjars|Blukryptjobjars|Blukryptbuilderjars|ParacloudSearchjars" ["ParacloudStatisticsCollector"]="Paracloudjobjars|Paracloudjars|ParacloudSearchjars" ["ParacloudStorageManagement"]="Paracloudjobjars|Paracloudjars|ParacloudSearchjars" ["ParaMailAPI"]="Paracloudjobjars|Paracloudjars|paramailjars|ParacloudSearchjars" ["ReportAPI"]="Paracloudjobjars|Paracloudjars|ParacloudSearchjars" ["ResourceFunnel"]="Paracloudjobjars|Paracloudjars|ParacloudSearchjars" ["SecurityBroker"]="Paracloudjobjars|Paracloudjars|ParacloudSearchjars" ["SettingsAPI"]="Paracloudjobjars|Paracloudjars|ParacloudSearchjars" ["ShareAPI"]="Paracloudjobjars|Paracloudjars|ParacloudSearchjars" ["SyncAPI"]="Paracloudjobjars|Paracloudjars|ParacloudSearchjars" ["TopologyGovernence"]="Paracloudjobjars|Paracloudjars|ParacloudSearchjars" ["UDCAPI"]="Paracloudjobjars|Paracloudjars|ParacloudSearchjars" ["MigrationToolAPI"]="Paracloudjobjars|Paracloudjars|ParacloudSearchjars" ["BluKryptHelper"]="Blukryptjobjars|Blukryptbuilderjars" ["BluKryptJobAPI"]="Blukryptjobjars" ["BluKryptPersistence"]="Blukryptjobjars|Blukryptbuilderjars" ["PciBusAPI"]="Blukryptjobjars|Blukryptbuilderjars") 


wars=('BluKryptBuilder' 'BluKryptJob' 'ParacloudBuilder' 'ParacloudJob' 'ParaMail' 'ParacloudSearch' 'SupportAPI')

revision="2.0.0-SNAPSHOT"

read -p "Enter the git tag name to build :" tagName
	
if [ "$tagName" = "" ]; then
	echo "Please run the script with tag name to build"
	exit 1
fi

read -p "Enter output folder name : " destF

if [ "$destF" = "" ]; then
	destF=$tagName
	#echo "Please run the script with build name(Destination folder)"
	#exit 1
fi
read -p "Jars to build > { ALL : to build all or Space seperated names Ex: ParacloudPersistance BluKryptPersistance } : " buildJars

read -p "Wars to build > { ALL : to Build all or Space seperated names Ex : BluKryptBuilder BluKryptJob } : " buildWars


if [[ ("$buildJars" = "ALL") || ("$buildJars" = "all") ]]; then
	echo "inside if "$jars
elif [ "$buildJars" = "" ]; then
	jars=()
else
	jars=($buildJars)
	echo "inside else "$jars
fi

if [ "$buildWars" = "" ]; then
	wars=()
elif [[ ("$buildWars" = "ALL") || ("$buildWars" = "all") ]]; then
	echo "Building all wars"
else
	wars=($buildWars)	
fi

if [ -d "$destF" ]; then
	rm -rf "$destF"
fi
if mkdir "$destF"; then
	echo "Build folder created"
else
	exit 1
fi
	
if [ -d "tempworkspace" ]; then
	rm -rf tempworkspace
fi
if mkdir tempworkspace; then
	echo "temp workspace created"
else 
	exit 1
fi
	
cd tempworkspace/ 

for i in ${jars[@]}; do

	if git clone $git_url/$i.git; then
		cd $i
	else
		exit 1
	fi
	git checkout "$tagName"

	if [ -f ../../"$destF"/README.txt ]; then
		echo "README PRESENT"
	else
		echo $(eval pwd)
		git tag -l $tagName -n > ../../"$destF"/README.txt 2>&1
	fi

	if [ -d "ant" ]; then
		cd ant
		if [ "$i" = "portal" ]; then
			ant build

                      	if [ -d ../../../"$destF"/"$tagName"/ ]; then
                                echo "Destination Folder Exists"
                        else
                                mkdir ../../../"$destF"/"$tagName"/
                        fi


			#mkdir ../../../"$destF"/"$tagName"/portal
			cp ../build/portal.zip ../../../"$destF"/"$tagName"/
			#cd ../../../"$destF"/"$tagName"/portal
			#unzip portal.zip
			#rm portal.zip
			#cd ../../../tempworkspace/portal/ant
			#cd ..
		else
			ant deploy
			parentFolders=${jarwarmap["$i"]}
			pfarr=$(echo $parentFolders | tr "|" "\n")	
			#for parentFolder in $pfarr
			#do
				#if [ -d ../../../"$destF"/"$parentFolder"/ ]; then
				#	echo "Parent folder present already"
				#else
				#	mkdir ../../../"$destF"/"$parentFolder"/
				#fi			
				#cp ../build/"$i".jar ../../../"$destF"/"$parentFolder"/
				#mv ../../../$destF/"$parentFolder"/"$i".jar ../../../$destF/"$parentFolder"/"$i"-"$revision".jar
			#done
			if [ -d ../../../"$destF"/"$tagName"/ ]; then
				echo "Destination Folder Exists"
			else
				mkdir ../../../"$destF"/"$tagName"/
			fi
			cp ../build/"$i".jar ../../../"$destF"/"$tagName"/
			mv ../../../$destF/"$tagName"/"$i".jar ../../../$destF/"$tagName"/"$i"-"$revision".jar		

		fi
		cd ..
	fi
	cd ..	 
done

for j in ${wars[@]}; do
       if git clone $git_url/$j.git; then
                cd $j
        else
                exit 1
        fi
        git checkout "$tagName"
        cd ant
        ant publish-war
	mv ../dist-publish/* ../../../"$destF"
	cd ../.. 
done
if [ -d ../"$destF"/"$tagName" ]; then
	cd ../"$destF"/"$tagName"/
	zip -r $tagName.zip *
	mv "$tagName".zip ../
	cd ../
	rm -rf "$tagName"	
else
	echo "No jars for update"
fi
git clone $git_url/DeployScripts.git
cd DeployScripts
rm -rf .git
sed -i '/zipFilename="patchFiles_v_1.2.8"/c\zipFilename='\""$tagName\"" infoFile.conf
#mv  DeployScripts ../"$destF"
cd ../../
sudo rm -rf tempworkspace 
zip -r "$destF".zip "$destF"
rm -rf "$destF"/
echo "Build completed!" 
