#!/bin/bash 
#==================================== PARABLU INC===========================================
#Created By: Abhirup Version: v1.8  Date: 12/01/2016

#Description: 
# This Script will capture information from infoFile.conf, such as Git url, username and password
# and run maven build on projects: BluKrypt, Paracloud, ParaCloudSearch, ParaMail, PlatformAPI, portal, EndPoints'.
# This then will generate a ZIP file with all the available jar Files.
# The script can be used in two ways: 
#           One with command line argument(Input as ./createPatch.sh <tagName> <jar version name>). This will build all the projects
#  OR without any arguments to input manually

#DEPENDENCIES
apt-get install expect

source ./infoFile.conf 2> /dev/null
source ./mavenFunctions.sh 2> /dev/null
source ./mavenjarselect.sh 2> /dev/null 

destF="$zipFilename-$tagName"
script_dir=$(pwd)

#######Assign Variables
cd ..
cur_dir=$(pwd)
jars=('BluKrypt' 'Paracloud' 'ParaCloudSearch' 'ParaMail' 'PlatformAPI' 'portal')
products="BluKrypt Paracloud ParaCloudSearch ParaMail PlatformAPI portal PGJars PCBJars Agent"

######################FUNCTION:: TO SELECT TAGNAME, JAR-DESTINATION & PRODUCT###
select_tagname_type (){
	#Get the branch to be cloned from user input
        tput clear
 	echo "Important**-You should have GIT, MAVEN installed in your system, if not, Install it using *apt-get install*"
        echo ""
	read -p "Enter the git tag name to build [ Ex. dev, master, 2.0, 2.1 etc ] :" tagName
	#get the Tagname-branch of the project
	if [ -z "$tagName" ];then
        echo "Please run the script with correct tag name to build"
        exit 1
        else
    	echo "                                GIT CLONE WILL HAPPEN USING THE TAG : $tagName"
        echo "                                =============================================="      
	destF="$zipFilename-$tagName"
	jar_version="$tagName"
	fi
}

update_incrementInfo (){
	read -p "Enter the correct version number[mandatory] :" version
	sed -i -e "s/<ver>/$version/g" $script_dir/incrementInfo.conf
	echo "Updated the incrementInfo File to reflect the correct version"
}
clear_zip_file (){
	rm -rf "$destF"
	rm -rf "$destF.zip"
	echo "Cleared ZipFile <$destF.zip> from current directory, if present"
	mkdir "$destF"
	echo "Created New Directory <$destF>"
}

hybrid_jar_option (){
       	echo "                        Enter Option.[Multiple selection not allowed]"
	echo "                        1.Build patch based on Selective Jar or project wise." 
	echo "                        2.Build patch based on Selective WAR."
	echo "                        3.Build patch for All Jars."
	echo "                        4.Build patch for All WARs."
	read -p "                        Please enter the option:-  " hybrid_option
		if [ "$hybrid_option" = 2 ]; then
			select_product_type
			elif [ "$hybrid_option" = 1 ]; then
			option_jar
			elif [ "$hybrid_option" = 3 ]; then
			echo "Patch Script will create all the jars for you"
			buildJars="$products"
        		elif [ "$hybrid_option" = 4 ]; then
        		echo "Patch Script will create all the WARS for you"
        		buildJars="$products"
        		buildWars="1 2 3 4 5 6 7 8 9 10 11"
        		war=yes
		else
			echo "Invalid Option: Please select the correct Option and Retry"
			exit 1
		fi
}

select_product_type ()
{
#Enter the Product to build maven
        	tput cup 10 15
       		echo "Choose from below options to build the war file?"
        	tput cup 12 15
            	tput el
            	tput cup 13 20
            	echo "1. BluKryptBuilder"
            	tput cup 14 20
            	echo "2. BluKryptJob";
            	tput cup 15 20
            	echo "3. paracloud";
            	tput cup 16 20
            	echo "4. paracloudjob"
            	tput cup 17 20
            	echo "5. ParaCloudSearch"
            	tput cup 18 20
            	echo "6. ParaMail"
            	tput cup 19 20
            	echo "7. PlatformAPI"
            	tput cup 20 20
            	echo "8. portal" 
                tput cup 21 20
                echo "9. PGJars"  
                tput cup 22 19
                echo "10. PCBJars"
	        tput cup 23 19
                echo "11. Agent"
            	tput cup 24 20
            	echo "To select multiple option, Enter option number seperated by space Ex: 1 2 3 and hit Enter "              
            	tput cup 25 15
            	echo "Enter your choice number:"
            	tput cup 25 45
            	read buildWars
	war="yes"
	buildJars="$buildWars"

##check if the input is valid
	for a in ${buildJars[@]}
		do
		if [ "$a" -gt 11 ]; then
		echo "Invalid Input: Select the correct option and run the setup again"
		exit 1
		fi
	done

buildJars=$(echo $buildJars | 
sed -e 's/\b1\b/BluKrypt/' |
sed -e 's/\b2\b/BluKrypt/' | 
sed -e 's/\b3\b/Paracloud/' |
sed -e 's/\b4\b/Paracloud/' | 
sed -e 's/\b5\b/ParaCloudSearch/' | 
sed -e 's/\b6\b/ParaMail/' | 
sed -e 's/\b7\b/PlatformAPI/' | 
sed -e 's/\b8\b/portal/' | 
sed -e 's/\b9\b/PGJars/' |
sed -e 's/\b10\b/PCBJars/' |
sed -e 's/\b11\b/Agent/')
echo "Building Jars..... $buildJars"         
}

############# FUNCTION:: AUTOMATED GIT LOGIN ################
git_login(){
 /usr/bin/expect << EOF 
    spawn git clone -b $tagName $git_url/$git_folder.git
    expect "Username"
    send "$username\r"
    expect "Password"
    send "$password\r"
    set timeout -1   
    expect "Checking out files: 100%"
    set timeout -1
    expect "Checking connectivity... done."
EOF
}
############## FUNCTION::CLEAN PROJECT FOLDERS #############  
cleanProjectFolders(){
	for k in ${jars[@]}; do
	rm -rf $k
	done
}

################# FUNCTION::  COPY ##################################
#This script will copy all *.JAR files from target folder to destination Folder
#The script will be executed after all jar files are created

jar_target() {
for flag in ${opt_jar[@]};do

case "$flag" in
   1) jar_target1="blukrypt-services-helper" ;;
   2) jar_target2="blukrypt-services-encryption" ;;
   3) jar_target3="blukrypt-services-persistence" ;;
   4) jar_target4="blukrypt-services-pcibus" ;;
   5) jar_target5="blukrypt-jobapi" ;;
   6) jar_target6="paracloud-services-alert-history" ;;
   7) jar_target7="paracloud-services-helper" ;;
   8) jar_target8="paracloud-services-migration" ;;
   9) jar_target9="paracloud-services-paramail" ;;
  10) jar_target10="paracloud-services-persistence" ;;
  11) jar_target11="paracloud-services-report" ;;
  12) jar_target12="paracloud-services-security-broker" ;;
  13) jar_target13="paracloud-services-settings" ;;
  14) jar_target14="paracloud-services-share" ;;
  15) jar_target15="paracloud-services-statistics-collector" ;;
  16) jar_target16="paracloud-services-storage-management" ;;
  17) jar_target17="paracloud-services-user-device-cloud-management" ;;
  18) jar_target18="paracloud-sync-resource-funnel" ;;
  19) jar_target19="paracloud-sync-sync" ;;
  20) jar_target20="paracloud-backup-backup.jar" ;;
  21) jar_target21="paracloud-backup-backup-policy" ;;
  22) jar_target22="paracloud-services-helper" ;;
  23) jar_target23="paracloud-services-helper" ;;
esac
done

jar_target="$jar_target1 $jar_target2 $jar_target3 $jar_target4 $jar_target5 $jar_target6 $jar_target7 $jar_target8 $jar_target9 $jar_target10 $jar_target11 $jar_target12 $jar_target13 $jar_target14 $jar_target15 $jar_target16 $jar_target17 $jar_target18 $jar_target19 $jar_target20 $jar_target21 $jar_target22 $jar_target23 $jar_target24"

buildJars=$(echo "$buildJars" | xargs -n1 | sort -u | xargs)
}
#
war_select () {
for flag in ${buildWars[@]};do
case "$flag" in
   1) war_target1="BluKryptBuilder.war" ;;
   2) war_target2="BluKryptJob.war" ;;
   3) war_target3="paracloud.war" ;;
   4) war_target4="paracloudjob.war" ;;
   5) war_target5="ParacloudSearch.war" ;;
   6) war_target6="paramail.war" ;;
   7) war_target7="support.war" ;;
   8) war_target8="portal" ;;
   9) war_target9="PGJars" ;;
   10) war_target10="PCBJars" ;;
   11) war_target11="Agent" ;;
esac
done
buildWars="$war_target1 $war_target2 $war_target3 $war_target4 $war_target5 $war_target6 $war_target7 $war_target8 $war_target9 $war_target10 $war_target11"
}

move()
{
        echo $(pwd)
        jar_target
        war_select  
##The below flow will come into picture only if you select the individual jar
        if [ ! -z "$opt_jar_func" ]; then
 	 	for flag in ${jar_target[@]}; do
         		target_jar=$(find . -name *.jar | grep $flag)
              		mv $target_jar "$cur_dir"/$destF  
        	done        
        	elif [ ! -z "$war" ]; then
           		for flagwar in ${buildWars[@]}; do
           			target_war=$(find . -name $flagwar | grep $flagwar)
          			cp -rf $target_war "$cur_dir"/$destF
           		done 
######## The below block is for Project wise jar selection
        else
        	target_jar_folder=$(find . -name *.jar | grep target) 
        fi

	for j in ${target_jar_folder[@]}; do
####Copy only the blukrypt-services
                 echo $j | grep blukrypt-
                 if [ $? == 0 ]; then 
	         mv $j "$cur_dir"/$destF

                 echo "Moving....  $j"
                 fi
####Copy only the blukrypt-services
                 echo $j | grep paracloud-
                 if [ $? == 0 ]; then
                 echo "Moving....  $j"
                 mv $j "$cur_dir"/$destF
                 fi
	done
        target_jar_folder=$(find . -name portal.zip && find . -name pgjars*jars.zip && find . -name pcbjars*jars.zip)
        mv $target_jar_folder "$cur_dir"/$destF  &> /dev/null
        #cp -r "$cur_dir"/CreatePatch/ "$cur_dir"/$destF

}

rename(){
files=$(find blukrypt-*.jar paracloud-*.jar)
 for f in ${files[@]}; do
        echo "Renaming....  $f to reflect correct version"
        if [ -z "$jar_version" ];then
        echo "Doing no change in Jar files"
        else
        new_file_name=$(echo $f | sed 's/[0-9]*//g' | sed 's/jar//g' | tr -d '.')
        new_file_name="$new_file_name-"
        new_file_name=$(echo $new_file_name | sed 's/--/-/')
        mv $f "$new_file_name$jar_version.jar"
        fi
        done
}

jar_filter() {
	count=1
	total_no_jar=$(ls -1 | grep .jar | wc -w)
	total_no_jar=`expr $total_no_jar \* 2`
		while [ $count -le "$total_no_jar" ]
		do
		dup_found="no"
#jar_inital=$(ls -1 | awk NR==$count | awk -F'-' '{print $1"-"$2"-"$3}')
		jar_inital=$(ls -1 | awk NR==$count | sed 's/[0-9]*//g' | sed 's/jar//g' | tr -d '.')
		part_version=$(echo $jar_version | awk -F'.' '{print $1}')
		jar_names=$(ls -1 | grep $jar_inital-$part_version)
		num_of_sim_jar=$(echo $jar_names | wc -w)
	if [ $num_of_sim_jar -gt  1 ]; then
   		jar1=$(echo $jar_names | awk '{print $1}')
   		jar_word_count1=$(echo $jar1 | wc -c)
   		jar2=$(echo $jar_names | awk '{print $2}')
   		jar_word_count2=$(echo $jar2 | wc -c)
   		dup_found="yes"
	fi

		if [ $dup_found == "yes" ] && [ $jar_word_count1 -gt $jar_word_count2 ]; then
			rm $jar1 > /dev/null/
		elif [ $dup_found == "yes" ] && [ $jar_word_count2 -gt $jar_word_count1 ]; then
			rm $jar2 > /dev/null
		fi
	count=`expr $count + 1`
done

echo "JAR FILTER $(pwd)"
}

# Make sure only root can run our script
check_root(){
if [[ $EUID -ne 0 ]]; then
   tput clear
   tput cup 5 20
   echo "This script must be run as a root user"
   echo ""
   exit 1
fi
}

#**********************MAIN PROGRAM ********************************** 
tagName=$1
jar_version=$2
if [ "$tagName" = "" ];then #If it is blank it means that the flow is manual
	check_root
	select_tagname_type
	hybrid_jar_option
	sleep 5
else
	tagName=$1
	buildJars="$products"
	destF="$zipFilename-$jar_version"
fi

cleanProjectFolders
clear_zip_file
#This block is for Individual jar
echo $opt_jar_func | grep blukrypt_services
if [ $? == 0 ]; then
	blukrypt
fi

echo $opt_jar_func | grep paracloud_services
if [ $? == 0 ]; then
	paracloud
fi


#***********************
rm "$cur_dir"/output.log
buildJars=$(echo "$buildJars" | xargs -n1 | sort -u | xargs)
for i in ${buildJars[@]}; do
	echo "            ========================STARTED  BUILDING:::$i====================================        "
	echo " PLEASE WAIT .. while the script finishes building maven for.. $i"
	build=$(echo $i)
#the below <$build> is a FUNCTION, based on the project selected, it will call the functions in the file mavenFunctions.sh
	exec >> output.log
	$build
	exec > /dev/tty

	echo "            ========================COMPLETED BUILDING:::$i====================================        "
	move
done

#Remove any past zip if present with the same name
	cd "$cur_dir"/"$destF"
	rename
	jar_filter
	zip -r ../$destF.zip *
	cd ..
	rm -rf $destF
	echo $(pwd)
	cat output.log | grep "BUILD FAILURE"

if [ $? == 0 ]; then
	echo "                                 [BUILD FAILURE:] One of the Maven build has failed"
	echo "                                           Please review output.log"
	echo "                                   It is recommended not to use the PATCH to upgrade"
else 
	echo "                                 		[BUILD SUCCESS]"
	echo ""
	echo ""
	echo "Copying Patch $destF.zip file to DNS....."
	PATCH_FILE="$destF.zip"
	PATCH_SIZE=`du -h "$PATCH_FILE" | cut -f1`
	scp $PATCH_FILE  paracloud-support@172.104.183.87:/var/www/parablu_installables/release	
	echo "Patch \"$tagName\" created successfully" | mail -s "Patch $tagName Created Successfully : $PATCH_SIZE" inbaraj@parablu.com karthick@parablu.com
	BACKBLAZE_ID="14cf87ec3a67"
	APPLICATION_KEY="00066055d8f4b83d31775758b2f06f06f9cfd04baf"
	BACKBLAZE_BUCKET="PatchBackups"
	
	b2 authorize-account $BACKBLAZE_ID $APPLICATION_KEY
	b2 upload-file  $BACKBLAZE_BUCKET $PATCH_FILE $PATCH_FILE
fi

