/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.common.service.backup;

import com.parablu.epa.common.dao.BackUpFolderDAOImpl;
import com.parablu.epa.common.dao.BackUpImageDAOImpl;
import com.parablu.epa.common.dao.BackupCrawlDAOImpl;
import com.parablu.epa.common.dao.BackupStatisticsDAOImpl;
import com.parablu.epa.common.service.backup.FilesBeSkippedAsPerPolicy;
import com.parablu.epa.common.service.backup.NewBackUpJob;
import com.parablu.epa.common.service.notification.NotificationHelper;
import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.core.adapter.pcb.BackupAdapter;
import com.parablu.epa.core.constant.StringLiterals;
import com.parablu.epa.core.element.BackupElement;
import com.parablu.epa.core.element.BackupValidationElement;
import com.parablu.epa.core.element.FileElement;
import com.parablu.epa.core.element.FileListElement;
import com.parablu.epa.core.exception.CrawlAdapterException;
import com.parablu.epa.core.helper.ObjectUtils;
import com.parablu.epa.core.helper.enumeration.BackupFoldersToBeSkipped;
import com.parablu.epa.core.service.transformer.CreateXmlObject;
import com.parablu.epa.core.to.BackUpCrawlFileTO;
import com.parablu.epa.core.to.BackupFolderTO;
import com.parablu.epa.core.to.BackupTO;
import com.parablu.epa.helper.exceptions.BaseException;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatisticsCollectorJob
extends Thread {
    private Logger logger = LoggerFactory.getLogger(StatisticsCollectorJob.class);
    private BackUpFolderDAOImpl backUpFolderDAOImpl = null;
    private BackUpImageDAOImpl backUpImageDAOImpl = null;
    private BackupAdapter backupAdapter = null;
    boolean isFirstTimeCrawl = true;
    protected String currentIP = null;
    public boolean jobsucceeded = true;
    protected Integer currentPort = null;
    Set<File> crawledFileList = new HashSet<File>();
    private static final int CRAWL_LIMIT = 5000;
    private int noOfDBWritesForCrawlFileLimit = 0;
    BackupCrawlDAOImpl backupCrawlDAOImpl = new BackupCrawlDAOImpl(SettingHelper.getBackUpCrawlDbUrl());
    BackupStatisticsDAOImpl backupStatisticsDAOImpl = new BackupStatisticsDAOImpl(SettingHelper.getBackUpDbUrl());
    private static final String FILES_TOBE_INSERTED = "Files to be inserted ";
    private List<String> macBackupFoldersToBeSkippedList;

    public StatisticsCollectorJob() {
        this.backUpFolderDAOImpl = new BackUpFolderDAOImpl(SettingHelper.getBackUpDbUrl());
        this.backUpImageDAOImpl = new BackUpImageDAOImpl(SettingHelper.getBackUpDbUrl());
        this.backupAdapter = new BackupAdapter(SettingHelper.getCloudName(), SettingHelper.getKeystorePath());
    }

    @Override
    public void run() {
        try {
            if (NotificationHelper.backUpStarted) {
                this.logger.debug("Back Up Started:" + NotificationHelper.backUpStarted);
                return;
            }
            List<BackupFolderTO> listOfFolder = this.backUpFolderDAOImpl.getAllFolderToBackUpFiles();
            HashSet<BackupTO> backUpSet = new HashSet<BackupTO>();
            HashSet<BackupTO> deletedSet = new HashSet<BackupTO>();
            this.createTablesIfNotExist();
            this.scanFileSystem(listOfFolder);
            List<BackUpCrawlFileTO> crawlFileTOs = this.backupCrawlDAOImpl.getBackupStatCrawlBackUpFiles();
            this.getFilesFromCrawlTable(backUpSet, crawlFileTOs);
            this.chunkBackupFilesAndCallForUpload(backUpSet, deletedSet);
            this.backupCrawlDAOImpl.clearEntireBackupStatCrawlTable();
            this.jobsucceeded = true;
            return;
        }
        catch (BaseException baseException) {
            this.logger.error("Base Exception ", (Throwable)baseException);
        }
        catch (Exception e) {
            this.logger.trace("" + e);
            this.logger.error("Unkown Exception :", (Object)e.getMessage());
        }
        this.jobsucceeded = true;
    }

    private void chunkBackupFilesAndCallForUpload(Set<BackupTO> backUpList, Set<BackupTO> deletedSet) throws CrawlAdapterException, InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        HashSet<BackupTO> chunkBackupFilesTOSet = new HashSet<BackupTO>();
        HashSet<BackupTO> chunkDeletedFilesTOSet = new HashSet<BackupTO>();
        Iterator<BackupTO> iterator = backUpList.iterator();
        boolean requestAtFirstTime = true;
        while (iterator.hasNext()) {
            chunkBackupFilesTOSet.add(iterator.next());
            if (chunkBackupFilesTOSet.size() != 5000) continue;
            this.createAndSendRequestAndUpdatedatabase(chunkBackupFilesTOSet, new HashSet<BackupTO>(), requestAtFirstTime);
            chunkBackupFilesTOSet.clear();
            requestAtFirstTime = false;
        }
        iterator = deletedSet.iterator();
        while (iterator.hasNext()) {
            chunkDeletedFilesTOSet.add(iterator.next());
            if (chunkBackupFilesTOSet.size() != 5000) continue;
            this.createAndSendRequestAndUpdatedatabase(new HashSet<BackupTO>(), chunkDeletedFilesTOSet, requestAtFirstTime);
            chunkDeletedFilesTOSet.clear();
            requestAtFirstTime = false;
        }
        this.createAndSendRequestAndUpdatedatabase(chunkBackupFilesTOSet, chunkDeletedFilesTOSet, requestAtFirstTime);
        chunkBackupFilesTOSet.clear();
        this.logger.debug("Final Statistics list size:" + backUpList.size());
    }

    private void createAndSendRequestAndUpdatedatabase(Set<BackupTO> backUpList, Set<BackupTO> deletedSet, boolean requestAtFirstTime) throws CrawlAdapterException, InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        byte[] bs = this.createWebRequest(backUpList, deletedSet);
        if (bs == null) {
            throw new BaseException("gzip byte array is null,serialization failed");
        }
        this.sendWebRequest(bs, requestAtFirstTime);
    }

    private byte[] createWebRequest(Set<BackupTO> backUpList, Set<BackupTO> deletedSet) {
        ArrayList<FileElement> newBackupFileElements = new ArrayList<FileElement>();
        ArrayList<FileElement> deletedBackupFileElements = new ArrayList<FileElement>();
        this.convertBackupTOListToBackupElementList(backUpList, newBackupFileElements);
        this.convertBackupTOListToBackupElementList(deletedSet, deletedBackupFileElements);
        FileListElement newBackupFileListElement = new FileListElement();
        FileListElement deletedBackupFileListElement = new FileListElement();
        newBackupFileListElement.setFileElementList(newBackupFileElements);
        deletedBackupFileListElement.setFileElementList(deletedBackupFileElements);
        BackupValidationElement backupValidationElement = new BackupValidationElement();
        backupValidationElement.setFilesToAddList(newBackupFileListElement);
        backupValidationElement.setFilesToDeleteList(deletedBackupFileListElement);
        byte[] bs = CreateXmlObject.createGzipByteArrayForValidateBackUpRequest((BackupValidationElement)backupValidationElement);
        return bs;
    }

    private void sendWebRequest(byte[] bs, boolean requestAtFirstTime) throws CrawlAdapterException, InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        this.currentIP = SettingHelper.getCurrentCloudIpAddress();
        if (SettingHelper.getCurrentHttpsPort() != null) {
            this.currentPort = Integer.valueOf(SettingHelper.getCurrentHttpsPort());
        }
        try {
            if ("true".equalsIgnoreCase(SettingHelper.getIsStatisticsEnabled())) {
                this.backupAdapter.sendBackupStatistics(bs, this.currentIP, null, requestAtFirstTime, SettingHelper.readTokenFromFile());
            }
        }
        catch (Exception e) {
            this.logger.trace("" + e);
            this.logger.error("send statistics error." + e.getMessage());
            throw new CrawlAdapterException(" Server Error: ");
        }
    }

    private void convertBackupTOListToBackupElementList(Set<BackupTO> fileTOList, List<FileElement> fileElementList) {
        for (BackupTO fileTO : fileTOList) {
            BackupElement fileElement = new BackupElement();
            ObjectUtils.copyBackupTOtoFileElement((BackupTO)fileTO, (FileElement)fileElement);
            fileElementList.add((FileElement)fileElement);
        }
    }

    private void createTablesIfNotExist() {
        this.backUpFolderDAOImpl.createBackUpTable();
        this.backUpImageDAOImpl.createTable();
        this.backupCrawlDAOImpl.createBackUpStatisticsCrawlTable();
    }

    private void scanFileSystem(List<BackupFolderTO> files) throws InterruptedException, InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        this.backupCrawlDAOImpl.clearEntireBackupStatCrawlTable();
        if (!files.isEmpty()) {
            this.logger.debug("Sending crawl statistic started " + System.currentTimeMillis());
            for (BackupFolderTO file : files) {
                try {
                    this.scanFileSystemByTypeAndStartUpload(file.getFolderPath(), null);
                    if (this.crawledFileList.isEmpty()) continue;
                    ++this.noOfDBWritesForCrawlFileLimit;
                    this.logger.debug(FILES_TOBE_INSERTED + this.crawledFileList.size());
                    ArrayList<File> fileList = new ArrayList<File>();
                    this.logger.debug(FILES_TOBE_INSERTED + this.crawledFileList.size());
                    fileList.addAll(this.crawledFileList);
                    this.backupCrawlDAOImpl.insertListOfFileNamesIntoBackupStatCrawlTable(fileList);
                    this.crawledFileList.clear();
                    fileList.clear();
                }
                catch (Exception e) {
                    this.logger.trace("" + e);
                    this.logger.error("exception while crawl" + e.getMessage());
                }
            }
            this.logger.debug("Sending crawl statistic ended " + System.currentTimeMillis());
            this.logger.debug("Number Of DB writes for crawl file limit:## " + this.noOfDBWritesForCrawlFileLimit);
        }
    }

    private void getFilesFromCrawlTable(Set<BackupTO> backupSet, List<BackUpCrawlFileTO> crawlFileTOs) {
        List list = ObjectUtils.createBackupElementForFileNames(crawlFileTOs);
        if (list != null) {
            backupSet.addAll(list);
        }
    }

    private List<File> scanFileSystemByTypeAndStartUpload(String completeParentPath, Map<String, Long> fileHashMap) throws InterruptedException, InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        List<File> files = null;
        if (this.crawledFileList.size() > 5000) {
            this.logger.debug(FILES_TOBE_INSERTED + this.crawledFileList.size());
            ++this.noOfDBWritesForCrawlFileLimit;
            ArrayList<File> fileList = new ArrayList<File>();
            fileList.addAll(this.crawledFileList);
            this.backupCrawlDAOImpl.insertListOfFileNamesIntoBackupStatCrawlTable(fileList);
            this.crawledFileList.clear();
            fileList.clear();
        }
        Boolean checkList = true;
        String recivedCompleteParentPath = this.checkForMacBasePath(completeParentPath);
        File currentFolder = new File(recivedCompleteParentPath);
        File[] childFileAndFolderNames = currentFolder.listFiles();
        if (childFileAndFolderNames == null) {
            return files;
        }
        int noOfChildFilesAndFolders = childFileAndFolderNames.length;
        if (fileHashMap == null || fileHashMap.isEmpty()) {
            checkList = false;
        }
        for (int i = 0; i < noOfChildFilesAndFolders; ++i) {
            List<File> currentFolderCrawlFileTOList;
            Long prevModifiedValue;
            File currentProcessingFile = childFileAndFolderNames[i];
            if (currentProcessingFile.getName().startsWith(".pbsdn")) {
                currentProcessingFile.delete();
                continue;
            }
            boolean isfileHidden = currentProcessingFile.getName().equals("CHUNK") || currentProcessingFile.isHidden();
            boolean fileToBeSkipped = this.isFileToBeSkipped(currentProcessingFile.getName());
            boolean isFileToBeSkippedAsperPolicy = false;
            if (isfileHidden || fileToBeSkipped || isFileToBeSkippedAsperPolicy) continue;
            boolean isFileADirectory = currentProcessingFile.isDirectory();
            String absPath = currentProcessingFile.getAbsolutePath();
            if (checkList.booleanValue() && !isFileADirectory && (prevModifiedValue = fileHashMap.get(absPath)) != null && prevModifiedValue.equals(currentProcessingFile.lastModified())) continue;
            this.crawledFileList.add(currentProcessingFile);
            if (!isFileADirectory || (currentFolderCrawlFileTOList = this.scanFileSystemByTypeAndStartUpload(currentProcessingFile.getAbsolutePath(), fileHashMap)) == null) continue;
            this.crawledFileList.addAll(currentFolderCrawlFileTOList);
        }
        if (this.crawledFileList.size() > 5000) {
            ++this.noOfDBWritesForCrawlFileLimit;
            ArrayList<File> fileList = new ArrayList<File>();
            fileList.addAll(this.crawledFileList);
            this.logger.debug(FILES_TOBE_INSERTED + this.crawledFileList.size());
            this.backupCrawlDAOImpl.insertListOfFileNamesIntoBackupStatCrawlTable(fileList);
            this.crawledFileList.clear();
        }
        ArrayList<File> fileList = new ArrayList<File>();
        fileList.addAll(this.crawledFileList);
        return fileList;
    }

    private boolean isFileToBeSkipped(String fileName) {
        if (FilesBeSkippedAsPerPolicy.isBackupSystemFilesEnabled()) {
            return false;
        }
        String rootDirectory = NewBackUpJob.rootDirectory().toLowerCase();
        if (SettingHelper.getOsName().toLowerCase().contains("win")) {
            for (BackupFoldersToBeSkipped.WindowsBackupFoldersToBeSkipped beSkipped : BackupFoldersToBeSkipped.WindowsBackupFoldersToBeSkipped.values()) {
                String folderBeSkipped = (rootDirectory + beSkipped.value()).toLowerCase();
                String currentFolder = fileName.toLowerCase();
                if (!currentFolder.contains(folderBeSkipped) && !currentFolder.contains(rootDirectory + "program files")) continue;
                return true;
            }
        } else {
            this.getMacFolderPathsToBeSkipped(rootDirectory);
            for (String beSkipped : this.macBackupFoldersToBeSkippedList) {
                String currentFolder = fileName.toLowerCase();
                this.logger.debug("currentFolder : " + currentFolder + " beSkipped : " + beSkipped + " Starts ? " + currentFolder.toLowerCase().startsWith(beSkipped));
                if (!currentFolder.toLowerCase().startsWith(beSkipped)) continue;
                return true;
            }
        }
        return false;
    }

    private String checkForMacBasePath(String completeParentPath) {
        String mac = "Macintosh";
        if (completeParentPath.startsWith("Macintosh" + StringLiterals.FILE_SEPARATOR)) {
            return completeParentPath.substring(9);
        }
        return completeParentPath;
    }

    private void getMacFolderPathsToBeSkipped(String rootDirectory) {
        if (this.macBackupFoldersToBeSkippedList == null || this.macBackupFoldersToBeSkippedList.isEmpty()) {
            this.macBackupFoldersToBeSkippedList = new ArrayList<String>();
            File[] usersFolders = new File(new File(SettingHelper.getUserHome()).getParent()).listFiles();
            for (BackupFoldersToBeSkipped.MacBackupFoldersToBeSkipped macBackupFoldersToBeSkipped : BackupFoldersToBeSkipped.MacBackupFoldersToBeSkipped.values()) {
                for (File userFolder : usersFolders) {
                    String userfolderBeSkipped = (userFolder.getAbsolutePath() + macBackupFoldersToBeSkipped.value()).toLowerCase();
                    this.macBackupFoldersToBeSkippedList.add(userfolderBeSkipped);
                }
            }
            for (BackupFoldersToBeSkipped.MacBackupFoldersToBeSkipped macBackupFoldersToBeSkipped : BackupFoldersToBeSkipped.MacBackupFoldersToBeSkippedFromRoot.values()) {
                String folderBeSkipped = (rootDirectory + macBackupFoldersToBeSkipped.value()).toLowerCase();
                this.macBackupFoldersToBeSkippedList.add(folderBeSkipped);
            }
        }
    }
}

