/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.common.service.backup;

import com.parablu.epa.common.constants.BackupLifeCycle;
import com.parablu.epa.common.constants.SyncConstants;
import com.parablu.epa.common.dao.BackUpFolderDAOImpl;
import com.parablu.epa.common.dao.BackUpImageDAOImpl;
import com.parablu.epa.common.dao.BackupActivityHistoryDAOImpl;
import com.parablu.epa.common.dao.BackupCrawlDAOImpl;
import com.parablu.epa.common.dao.BackupPolicyDAOImpl;
import com.parablu.epa.common.dao.BackupStatisticsDAOImpl;
import com.parablu.epa.common.dao.FullBackupInfoTableDAOImpl;
import com.parablu.epa.common.dao.NewBackUpCrawlDAOImpl;
import com.parablu.epa.common.dao.NewBackupImageDAOImpl;
import com.parablu.epa.common.service.backup.FilesBeSkippedAsPerPolicy;
import com.parablu.epa.common.service.notification.NotificationHelper;
import com.parablu.epa.common.service.settings.BackupHelper;
import com.parablu.epa.common.service.settings.BluVaultIPHelper;
import com.parablu.epa.common.service.settings.HashChecker;
import com.parablu.epa.common.service.settings.PolicyManagementServerHelper;
import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.core.adapter.pcb.BackupAdapter;
import com.parablu.epa.core.adapter.tcp.ListnerAdapter;
import com.parablu.epa.core.constant.CrawlLifecycle;
import com.parablu.epa.core.constant.StringLiterals;
import com.parablu.epa.core.element.BackupElement;
import com.parablu.epa.core.element.BackupListResponseElement;
import com.parablu.epa.core.element.BackupStatusElement;
import com.parablu.epa.core.element.BackupValidationElement;
import com.parablu.epa.core.element.FileElement;
import com.parablu.epa.core.element.FileListElement;
import com.parablu.epa.core.element.ProxyElement;
import com.parablu.epa.core.exception.CrawlAdapterException;
import com.parablu.epa.core.helper.ObjectUtils;
import com.parablu.epa.core.service.sync.BaseJob;
import com.parablu.epa.core.service.transformer.CreateXmlObject;
import com.parablu.epa.core.service.transformer.Xmlparser;
import com.parablu.epa.core.to.BackUpCrawlFileTO;
import com.parablu.epa.core.to.BackupActivityTO;
import com.parablu.epa.core.to.BackupFolderTO;
import com.parablu.epa.core.to.BackupOrRestoreStatusTo;
import com.parablu.epa.core.to.BackupPolicyTO;
import com.parablu.epa.core.to.BackupResultTO;
import com.parablu.epa.core.to.BackupTO;
import com.parablu.epa.core.to.BluVaultTO;
import com.parablu.epa.core.to.DedupTO;
import com.parablu.epa.core.to.FullBackupInfoTO;
import com.parablu.epa.core.to.GzipTO;
import com.parablu.epa.helper.exceptions.BaseException;
import com.parablu.epa.helper.utils.PBCountDownTimer;
import com.parablu.epa.helper.utils.ParabluFileSystemUtils;
import com.parablu.epa.helper.utils.RegistryUtils;
import com.parablu.epa.helper.utils.SnapShotHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NewBackUpJob
extends BaseJob {
    private static Logger logger = LoggerFactory.getLogger(NewBackUpJob.class);
    private static Logger failedFileLog = LoggerFactory.getLogger((String)"failedFileLogger");
    private BackUpFolderDAOImpl backUpFolderDAOImpl = null;
    private BackUpImageDAOImpl backUpImageDAOImpl = null;
    private BackupAdapter backupAdapter = null;
    boolean isFirstTimeCrawl = true;
    protected String currentIP = SettingHelper.getCurrentCloudIpAddress();
    boolean manual = false;
    protected Integer currentPort = null;
    boolean doDataBaseChanges = true;
    Set<File> crawledFileList = new HashSet<File>();
    private Set<File> backupImageList = new HashSet<File>();
    private final int crawlFileLimit = this.getCrawlLimit();
    private static final int CRAWL_LIMIT_FOR_DB_INSERT = 5000;
    private int noOfDBWritesForCrawlFileLimit = 0;
    Set<DedupTO> dedupToSet = new HashSet<DedupTO>();
    private String backupType = "INCREMENTAL";
    BackupCrawlDAOImpl backupCrawlDAOImpl = new BackupCrawlDAOImpl(SettingHelper.getBackUpCrawlDbUrl());
    BackupStatisticsDAOImpl backupStatisticsDAOImpl = new BackupStatisticsDAOImpl(SettingHelper.getBackUpDbUrl());
    NewBackUpCrawlDAOImpl newBackUpCrawlDAOImpl = new NewBackUpCrawlDAOImpl(SettingHelper.getBackUpCrawlDbUrl());
    NewBackupImageDAOImpl newBackupImageDAOImpl = new NewBackupImageDAOImpl(SettingHelper.getBackUpDbUrl());
    BackupStatusElement backupStatusElement = null;
    protected String crawlTimeStamp;
    boolean restart = false;
    long restartId = 0L;
    private static List<BackupFolderTO> bkpFolderList = new ArrayList<BackupFolderTO>();
    private static final String BEFORE_CALLING_DELETE = "Before calling delete";
    private static final String COMPLETED = "COMPLETED";
    private static final String STARTED_COMPLETED = "STARTED/COMPLETED";
    private static final String BACKUP = "BACKUP";
    public boolean isFullBackup;
    private ListnerAdapter listnerAdapter = null;
    private String batchId;
    private static FullBackupInfoTableDAOImpl fullBackupInfoTableDAOImpl = new FullBackupInfoTableDAOImpl(SettingHelper.getBackUpDbUrl());
    private List<String> macBackupFoldersToBeSkippedList;
    private static final String SYSTEM_ROOT = "system.root";
    private static final String WIN = "win" + System.getProperty("file.separator");
    private static final String MAC = "mac/";
    private static final NewBackUpJob newBackUpJob = null;
    BackupPolicyTO currentPolicy = null;
    Set<BackupTO> deletedSet = new HashSet<BackupTO>();
    long totalSizeToUpload = 0L;
    private boolean isCasesensitiveFolderCheckEnabled = true;
    private boolean isScanInterrupted = false;
    boolean fullBackup = false;
    BackupPolicyDAOImpl backupPolicyDAOImpl = new BackupPolicyDAOImpl(SettingHelper.getBackUpDbUrl());
    private String previoiusBackupSnapIds = "";
    private String firstBackupStartTime;
    private boolean usePreviousBatchId = false;

    public NewBackUpJob(boolean manualVal, boolean isFullBackup) {
        this.backUpFolderDAOImpl = new BackUpFolderDAOImpl(SettingHelper.getBackUpDbUrl());
        this.backUpImageDAOImpl = new BackUpImageDAOImpl(SettingHelper.getBackUpDbUrl());
        this.backupAdapter = new BackupAdapter(SettingHelper.getCloudName(), SettingHelper.getKeystorePath());
        this.manual = manualVal;
        this.fullBackup = isFullBackup;
    }

    public abstract void updateSystrayImageAccordingToStage(String var1);

    protected abstract void scanFileSystemByType(BackupFolderTO var1);

    public void run() {
        BackupActivityTO backupActivityTO = new BackupActivityTO();
        BackupActivityHistoryDAOImpl backupActivityHistoryDAOImpl = new BackupActivityHistoryDAOImpl(SettingHelper.getActivityDBUrl());
        try {
            String totalSize;
            int crawlFileCount;
            long lastSuccessfullCrawlTime;
            if (NotificationHelper.backUpStarted) {
                logger.debug("backUpStarted so reset the flag:" + NotificationHelper.backUpStarted);
                logger.debug("Thread kiled but values are not reset..");
                NotificationHelper.setBackUpStarted(false);
                logger.debug("Thiss means that backup thread died but falg is not reset so set to false");
                NotificationHelper.policyRefreshStarted = false;
            }
            NotificationHelper.setBackupStatus(1);
            NotificationHelper.backUpStarted = true;
            NotificationHelper.setTotalBackupCount(0);
            NotificationHelper.setNoOfFilesToBeBackedUp(0);
            NotificationHelper.setTotalUploadSize(0L);
            NotificationHelper.setBackupRestartId(0L);
            NotificationHelper.setTotalBackupFilesSkippedCount(0);
            NotificationHelper.setBackupChunkFileDetails("");
            ParabluFileSystemUtils.setSnapIdMap(new HashMap());
            this.startBackupPolicyRefresh();
            List<BackupFolderTO> listOfFolderFromPolicy = HashChecker.getAllFolderToBackUpFiles();
            List<BackupFolderTO> exceptionsToExclusionListFromPolicy = HashChecker.getAllExceptionsToExclusion();
            List<BackupFolderTO> listOfFolder = new ArrayList<BackupFolderTO>();
            List<BackupFolderTO> exceptionsToExclusions = new ArrayList<BackupFolderTO>();
            ArrayList<BackupFolderTO> totalInclusionsForSnapshot = new ArrayList<BackupFolderTO>();
            boolean noFolderExists = false;
            if (listOfFolderFromPolicy.isEmpty()) {
                noFolderExists = true;
            }
            if (noFolderExists) {
                BackupFolderTO backupFolderTO = new BackupFolderTO();
                backupFolderTO.setFolderPath("parablu");
                backupFolderTO.setCreateBy("IA");
                backupFolderTO.setPolicyName("");
                listOfFolderFromPolicy.add(backupFolderTO);
            }
            if (SettingHelper.getOsName().toLowerCase().contains("win")) {
                this.listnerAdapter = new ListnerAdapter();
                if (!this.listnerAdapter.checkForService()) {
                    logger.debug("service is not running so open the named pipe...");
                    this.openNamedPipeNClose();
                }
            }
            this.createTablesIfNotExist();
            this.validatePreviousBackupCrawlStatus();
            this.usePreviousBatchId = false;
            this.validatePreviousBackupStatus(false);
            listOfFolder = this.getRealPath(listOfFolderFromPolicy, listOfFolder);
            exceptionsToExclusions = this.getRealPathForExceptionsToExclusion(exceptionsToExclusionListFromPolicy, exceptionsToExclusions);
            logger.debug("........" + listOfFolder.size());
            logger.debug("........" + exceptionsToExclusions.size());
            totalInclusionsForSnapshot.addAll(listOfFolder);
            totalInclusionsForSnapshot.addAll(exceptionsToExclusions);
            List<FullBackupInfoTO> fullBackupInfos = fullBackupInfoTableDAOImpl.getBackupInfoDetails();
            FullBackupInfoTO fullBackupInfo = null;
            if (fullBackupInfos != null && !fullBackupInfos.isEmpty()) {
                logger.debug("Inside getting full backup info details...");
                fullBackupInfo = fullBackupInfos.get(0);
            }
            if (fullBackupInfo != null && fullBackupInfo.isFullBackup()) {
                this.clearTablesForFullBackupOnDemand();
                this.isFullBackup = true;
                this.restart = false;
                fullBackupInfo.setFullBackup(false);
                fullBackupInfoTableDAOImpl.clearEntireTable();
                fullBackupInfoTableDAOImpl.insertIntoBackupInfoTable(fullBackupInfo);
            }
            logger.debug("Device Blocked: " + SettingHelper.isDeviceBlocked());
            logger.debug("After validating previous backup.");
            int totalCrawlcount = 0;
            int previousUploadedFiles = 0;
            if (this.fullBackup) {
                logger.debug("inside full backup if true.............. ");
                lastSuccessfullCrawlTime = 0L;
            } else {
                lastSuccessfullCrawlTime = this.backupStatusElement.getLastSuccessfulCrawlTimeStamp();
            }
            this.batchId = this.backupStatusElement.getBatchId();
            if (lastSuccessfullCrawlTime == 0L) {
                this.backupType = "FULL";
            }
            logger.debug("os " + SettingHelper.getOsName().toLowerCase());
            logger.debug("VSS ENABLED " + SettingHelper.getIsVssEnabled());
            if (!this.restart) {
                boolean result;
                boolean updateBackupBatch;
                String status;
                BackupHelper.deleteContentOfFailedfilesLog();
                ParabluFileSystemUtils.setSnapshotValid((boolean)false);
                this.currentPolicy = PolicyManagementServerHelper.getCurrentBackupPolicy();
                String preScanCommand = this.currentPolicy.getPreScanCommand();
                logger.debug("before calling pre scan.." + this.currentPolicy.isPreScanCommandEnabled() + "...." + preScanCommand);
                if (!this.usePreviousBatchId) {
                    logger.debug("....... new batch entry..........");
                    this.batchId = "";
                }
                if (this.currentPolicy.isPreScanCommandEnabled() && StringUtils.isNotEmpty((String)preScanCommand)) {
                    status = CrawlLifecycle.PRESCAN_COMMAND_EXECUTION.toString();
                    this.batchId = this.backupBatchInitiated(status, this.batchId, 0, backupActivityTO.getFailCode(), 0L, "0/0", 0, this.crawlTimeStamp, this.totalSizeToUpload);
                    logger.debug("<<<<<<<<<pre scanning>>>>>>>>>" + this.batchId);
                    updateBackupBatch = this.updateBackupBatchId(backupActivityTO, backupActivityHistoryDAOImpl, false);
                    if (!updateBackupBatch) {
                        return;
                    }
                    backupActivityTO.setBackupActivityStatus(CrawlLifecycle.PRESCAN_COMMAND_EXECUTION.toString());
                    backupActivityTO.setBackupActivityTimeStamp(String.valueOf(System.currentTimeMillis()));
                    backupActivityTO.setBatchId("-1");
                    backupActivityTO.setFullBackup(Boolean.toString(this.isFullBackup));
                    backupActivityTO.setBatchStatus(status);
                    backupActivityTO.setBackupActivityID(backupActivityHistoryDAOImpl.addEventToBackupActivityHistoryTable(backupActivityTO));
                    logger.debug(this.crawlTimeStamp + "<<<<<<<<<pre scanning>>>>>>>>>" + backupActivityTO.getBatchStatus() + backupActivityTO.getFailCode());
                    this.updateBackupBatchId(backupActivityTO, backupActivityHistoryDAOImpl, true);
                    logger.debug("before calling service and pre scan..");
                    if (SettingHelper.getOsName().toLowerCase().contains("win") && this.listnerAdapter.checkForService()) {
                        NotificationHelper.setBackupStatus(8);
                        logger.debug("before calling service to rum cmd..");
                        boolean result2 = this.runCommandUsingService(preScanCommand, "preScanCommand.bat");
                        if (!result2) {
                            logger.debug("failed to run pre scan cmd");
                            if (!this.currentPolicy.isContinueOnPreScan()) {
                                backupActivityTO.setFailCode(1211);
                                backupActivityHistoryDAOImpl.updateFailCodeToBackupActivityHistoryTable(backupActivityTO);
                                this.abort(listOfFolder);
                                return;
                            }
                        }
                        listOfFolder = this.getRealPath(listOfFolderFromPolicy, listOfFolder);
                        exceptionsToExclusions = this.getRealPathForExceptionsToExclusion(exceptionsToExclusionListFromPolicy, exceptionsToExclusions);
                        logger.debug(".....list of folder size....." + listOfFolder.size());
                        logger.debug("....." + exceptionsToExclusions.size());
                    }
                }
                logger.debug("after calling copyFilesUsingService.." + this.batchId);
                logger.debug("Inside restart False.");
                bkpFolderList = listOfFolder;
                NotificationHelper.setBackupStatus(7);
                this.createSnapshotifNotExist(totalInclusionsForSnapshot);
                NotificationHelper.setBackupStatus(2);
                status = BackupLifeCycle.SCANNING.toString();
                this.batchId = this.backupBatchInitiated(status, this.batchId, 0, 0, 0L, "0/0", 0, this.crawlTimeStamp, this.totalSizeToUpload);
                updateBackupBatch = this.updateBackupBatchId(backupActivityTO, backupActivityHistoryDAOImpl, false);
                if (!updateBackupBatch) {
                    return;
                }
                if (StringUtils.isNotEmpty((String)backupActivityTO.getBackupActivityStatus()) && backupActivityTO.getBackupActivityStatus().equalsIgnoreCase(BackupLifeCycle.PRESCAN_COMMAND_EXECUTION.toString())) {
                    backupActivityTO.setBackupActivityStatus(CrawlLifecycle.SCANNING.toString());
                    backupActivityTO.setBatchStatus(status);
                    backupActivityHistoryDAOImpl.updateEventToBackupActivityHistoryTable(backupActivityTO);
                } else {
                    backupActivityTO.setBackupActivityStatus(BackupLifeCycle.SCANNING.toString());
                    backupActivityTO.setBackupActivityTimeStamp(String.valueOf(System.currentTimeMillis()));
                    backupActivityTO.setBatchId("-1");
                    backupActivityTO.setFullBackup(Boolean.toString(this.isFullBackup));
                    backupActivityTO.setBatchStatus(status);
                    backupActivityTO.setBackupActivityID(backupActivityHistoryDAOImpl.addEventToBackupActivityHistoryTable(backupActivityTO));
                }
                this.updateBackupBatchId(backupActivityTO, backupActivityHistoryDAOImpl, true);
                logger.debug("<<<<<<<<<scanning>>>>>>>>>" + backupActivityTO.getBatchStatus());
                for (BackupFolderTO backupFolderTO : listOfFolder) {
                    this.checkFolderAccessibility(backupFolderTO.getFolderPath(), false);
                }
                this.scanFileSystem(listOfFolder, exceptionsToExclusions, lastSuccessfullCrawlTime);
                if (this.isScanInterrupted) {
                    logger.debug("Inside stop scan....");
                    this.abortScan(totalInclusionsForSnapshot);
                    return;
                }
                this.renameBackupCrawlAndBackupImageTable();
                if (Thread.currentThread().isInterrupted()) {
                    logger.debug("Current thread is interrupted so retruning");
                    this.abortScan(totalInclusionsForSnapshot);
                    return;
                }
                this.updateCrawlTableAndGetDeletedFiles();
                crawlFileCount = this.newBackUpCrawlDAOImpl.getCountOfTable(false);
                logger.debug("count from crawl table is:" + crawlFileCount);
                totalSize = String.valueOf(crawlFileCount);
                this.totalSizeToUpload = this.newBackUpCrawlDAOImpl.getTotalUploadSize();
                if (crawlFileCount == 0) {
                    logger.debug("Backup List is zero");
                    backupActivityTO.setBackupActivityStatus(CrawlLifecycle.FINISHED.toString());
                    backupActivityHistoryDAOImpl.updateEventToBackupActivityHistoryTable(backupActivityTO);
                    this.sendDeletedFilesToServer(lastSuccessfullCrawlTime, this.deletedSet);
                    BackupActivityTO backupActivityTO1 = backupActivityHistoryDAOImpl.getCurrentStatusFromBackupActivityHistoryTable();
                    backupActivityTO1.setFailCode(0);
                    this.backupBatchInitiated(STARTED_COMPLETED, this.batchId, 0, backupActivityTO1.getFailCode(), backupActivityTO1.getTotalUploadSize(), backupActivityTO1.getBackupUploadCount(), crawlFileCount, backupActivityTO1.getBackupActivityTimeStamp(), this.totalSizeToUpload);
                    if (SettingHelper.getOsName().toLowerCase().contains("win") && SettingHelper.getIsVssEnabled() != null && "true".equalsIgnoreCase(SettingHelper.getIsVssEnabled())) {
                        this.listnerAdapter = new ListnerAdapter();
                        if (this.listnerAdapter.checkForService()) {
                            logger.debug(BEFORE_CALLING_DELETE);
                            this.deleteVsnapshot(totalInclusionsForSnapshot);
                        }
                        RegistryUtils.setRegistryValue((String)"HKCU", (String)"Software\\ParaBlu\\BluSync", (String)"OldPath", (String)SettingHelper.getInstallationDir());
                        ParabluFileSystemUtils.setOldInstallationDir((String)SettingHelper.getInstallationDir());
                    }
                    NotificationHelper.backUpStarted = false;
                    this.updateSystrayImageAccordingToStage(SyncConstants.PARABLU_IMAGE);
                    return;
                }
                logger.debug("before running pre backup command .......");
                this.currentPolicy = PolicyManagementServerHelper.getCurrentBackupPolicy();
                String prebackupCommand = this.currentPolicy.getPreBackupCommand();
                if (this.currentPolicy.isPreBackupCommandEnabled() && StringUtils.isNotEmpty((String)prebackupCommand) && SettingHelper.getOsName().toLowerCase().contains("win") && this.listnerAdapter.checkForService() && !(result = this.runCommandUsingService(prebackupCommand, "prebackup.bat"))) {
                    logger.debug("failed to run pre backup cmd");
                    if (!this.currentPolicy.isContinueOnPreBkp()) {
                        backupActivityTO.setFailCode(1210);
                        backupActivityHistoryDAOImpl.updateFailCodeToBackupActivityHistoryTable(backupActivityTO);
                        this.abort(listOfFolder);
                        return;
                    }
                }
                logger.debug("after running pre backup command .......");
                NotificationHelper.setNoOfFilesToBeBackedUp(crawlFileCount);
                logger.debug("BACKUPLIST SIZE :" + totalSize);
            } else {
                this.validatePreviousRestartId();
                crawlFileCount = this.newBackUpCrawlDAOImpl.getCountOfTableForGivenId((int)this.restartId);
                totalCrawlcount = this.newBackUpCrawlDAOImpl.getCountOfTable(false);
                previousUploadedFiles = totalCrawlcount - crawlFileCount;
                logger.debug("CRAWL COUNT : " + crawlFileCount + "crawlcount " + totalCrawlcount);
                NotificationHelper.setNoOfFilesToBeBackedUp(totalCrawlcount);
                NotificationHelper.setTotalBackupCount(previousUploadedFiles);
                totalSize = String.valueOf(crawlFileCount);
                List<DedupTO> dedupTOs = this.newBackupImageDAOImpl.getListOfDedupsFromTable();
                if (dedupTOs != null) {
                    this.dedupToSet.addAll(dedupTOs);
                }
                if (crawlFileCount == 0) {
                    logger.debug("BACKUP LIST IS ZERO");
                    backupActivityTO.setBackupActivityStatus(CrawlLifecycle.FINISHED.toString());
                    backupActivityHistoryDAOImpl.updateEventToBackupActivityHistoryTable(backupActivityTO);
                    BackupActivityTO backupActivityTO1 = backupActivityHistoryDAOImpl.getCurrentStatusFromBackupActivityHistoryTable();
                    backupActivityTO1.setFailCode(0);
                    this.backupBatchInitiated(COMPLETED, this.backupStatusElement.getBatchId(), 0, backupActivityTO1.getFailCode(), backupActivityTO1.getTotalUploadSize(), backupActivityTO1.getBackupUploadCount(), crawlFileCount, backupActivityTO1.getBackupActivityTimeStamp(), this.totalSizeToUpload);
                    if (SettingHelper.getOsName().toLowerCase().contains("win") && SettingHelper.getIsVssEnabled() != null && "true".equalsIgnoreCase(SettingHelper.getIsVssEnabled())) {
                        this.listnerAdapter = new ListnerAdapter();
                        if (this.listnerAdapter.checkForService()) {
                            logger.debug(BEFORE_CALLING_DELETE);
                            this.deleteVsnapshot(totalInclusionsForSnapshot);
                        }
                        RegistryUtils.setRegistryValue((String)"HKCU", (String)"Software\\ParaBlu\\BluSync", (String)"OldPath", (String)SettingHelper.getInstallationDir());
                        ParabluFileSystemUtils.setOldInstallationDir((String)SettingHelper.getInstallationDir());
                    }
                    NotificationHelper.backUpStarted = false;
                    this.updateSystrayImageAccordingToStage(SyncConstants.PARABLU_IMAGE);
                    return;
                }
                NotificationHelper.setBackupStatus(7);
                this.createSnapshotifNotExist(totalInclusionsForSnapshot);
                backupActivityTO.setBackupActivityStatus(CrawlLifecycle.INPROGRESS.toString());
                backupActivityTO.setBackupActivityTimeStamp(String.valueOf(System.currentTimeMillis()));
                backupActivityTO.setBatchId("-1");
                backupActivityTO.setFullBackup(Boolean.toString(this.isFullBackup));
                backupActivityTO.setBackupActivityID(backupActivityHistoryDAOImpl.addEventToBackupActivityHistoryTable(backupActivityTO));
                backupActivityTO.setRestartID(this.restartId);
                backupActivityHistoryDAOImpl.updateRestartIdINBackupActivityHistoryTable(backupActivityTO);
            }
            NotificationHelper.setBackupStatus(3);
            String status = BackupLifeCycle.STARTED.toString();
            backupActivityTO.setBatchStatus(status);
            this.batchId = this.backupBatchInitiated(status, this.batchId, 0, backupActivityTO.getFailCode(), 0L, previousUploadedFiles + "/" + totalSize, crawlFileCount, this.crawlTimeStamp, this.totalSizeToUpload);
            boolean updateBackupBatch = this.updateBackupBatchId(backupActivityTO, backupActivityHistoryDAOImpl, true);
            if (!updateBackupBatch) {
                return;
            }
            backupActivityTO.setBackupActivityStatus(CrawlLifecycle.INPROGRESS.toString());
            backupActivityTO.setBackupActivityTimeStamp(this.crawlTimeStamp);
            backupActivityTO.setBackupUploadCount("0/" + totalSize);
            if (SettingHelper.getOsName().toLowerCase().startsWith("win")) {
                backupActivityTO.setSnapId(RegistryUtils.getRegistryValueSet((String)"HKLM", (String)"SOFTWARE\\WOW6432Node\\ParaBlu\\SnapId").toString());
            } else {
                backupActivityTO.setSnapId("0");
            }
            backupActivityHistoryDAOImpl.updateEventToBackupActivityHistoryTable(backupActivityTO);
            logger.debug("BEFORE STARTING BACKUP THREAD");
            this.backupType = this.backupType + "|" + this.manual;
            NotificationHelper.setBackupRestartId(this.restartId);
            this.startBackUpThread(this.dedupToSet, this.restart, this.restartId, this.backupType);
            Thread.sleep(1000L);
            this.dedupToSet = null;
            logger.debug("BACKUP FINISHED");
            SettingHelper.setLastSuccessfulBackup(System.currentTimeMillis());
            if (NotificationHelper.getTotalBackupCount() == (crawlFileCount -= NotificationHelper.getTotalBackupFilesSkippedCount())) {
                backupActivityTO.setBackupActivityStatus(CrawlLifecycle.FINISHED.toString());
            } else {
                backupActivityTO.setBackupActivityStatus(CrawlLifecycle.STOPPED.toString());
            }
            backupActivityTO.setBackupUploadCount(NotificationHelper.getTotalBackupCount() + "/" + crawlFileCount);
            backupActivityTO.setTotalUploadSize(NotificationHelper.getTotalUploadSize());
            backupActivityHistoryDAOImpl.updateEventToBackupActivityHistoryTable(backupActivityTO);
            int totalFilesUploaded = NotificationHelper.getTotalBackupCount();
            logger.debug("TOTAL FILES UPLOADED " + totalFilesUploaded);
            logger.debug("TOTAL COUNT " + crawlFileCount);
            int lastRecordId = this.newBackUpCrawlDAOImpl.getLastRecordIdFromTable();
            long backupRestartId = NotificationHelper.getBackupRestartId();
            logger.debug("last record id>>>" + lastRecordId + ">>backup restart id" + backupRestartId);
            if ((long)lastRecordId == backupRestartId) {
                boolean result;
                logger.debug("before running post backup command .......");
                this.currentPolicy = PolicyManagementServerHelper.getCurrentBackupPolicy();
                String postbackupCommand = this.currentPolicy.getPostBackupCommand();
                if (this.currentPolicy.isPostBackupCommandEnabled() && StringUtils.isNotEmpty((String)postbackupCommand) && SettingHelper.getOsName().toLowerCase().contains("win") && this.listnerAdapter.checkForService() && !(result = this.runCommandUsingService(postbackupCommand, "postbackup.bat"))) {
                    logger.debug("failed to run post backup cmd");
                }
                logger.debug("after running post backup command .......");
                this.sendDeletedFilesToServer(lastSuccessfullCrawlTime, this.deletedSet);
                status = BackupLifeCycle.COMPLETED.toString();
                backupActivityTO.setBatchStatus(status);
                backupActivityTO.setFailCode(0);
                long totalUploadSize = backupActivityTO.getTotalUploadSize();
                String uploadedList = backupActivityTO.getBackupUploadCount();
                int errorCode = backupActivityTO.getFailCode();
                this.batchId = this.backupBatchInitiated(status, this.batchId, NotificationHelper.getTotalBackupCount(), errorCode, totalUploadSize, uploadedList, crawlFileCount, backupActivityTO.getBackupActivityTimeStamp(), this.totalSizeToUpload);
                if (!"-1".equals(this.batchId)) {
                    logger.debug("BATCH ID FOR THIS BACKUP IS : " + this.batchId + "STATUS : " + status);
                    backupActivityTO.setBatchId(this.batchId);
                    backupActivityHistoryDAOImpl.updateEventToBackupActivityHistoryTable(backupActivityTO);
                    if (SettingHelper.getOsName().toLowerCase().contains("win") && SettingHelper.getIsVssEnabled() != null && "true".equalsIgnoreCase(SettingHelper.getIsVssEnabled())) {
                        this.listnerAdapter = new ListnerAdapter();
                        if (this.listnerAdapter.checkForService()) {
                            logger.debug(BEFORE_CALLING_DELETE);
                            this.deleteVsnapshot(totalInclusionsForSnapshot);
                        }
                        RegistryUtils.setRegistryValue((String)"HKCU", (String)"Software\\ParaBlu\\BluSync", (String)"OldPath", (String)SettingHelper.getInstallationDir());
                        ParabluFileSystemUtils.setOldInstallationDir((String)SettingHelper.getInstallationDir());
                    }
                }
            } else {
                this.jobSucceded = false;
                BackupActivityTO backupActivityTO1 = backupActivityHistoryDAOImpl.getCurrentStatusFromBackupActivityHistoryTable();
                if (backupActivityTO1.getFailCode() != 912 && backupActivityTO1.getFailCode() != 1992 && backupActivityTO1.getFailCode() != 1981 && backupActivityTO1.getFailCode() != 1996 && backupActivityTO1.getFailCode() != 911 && backupActivityTO1.getFailCode() != 1207 && backupActivityTO1.getFailCode() != 1209 && backupActivityTO1.getFailCode() != 1208) {
                    int response = this.backupAdapter.pingParacloud(this.currentIP);
                    this.jobStatusCode = backupActivityTO1.getFailCode();
                    if (response == 400) {
                        logger.debug("Backup Fail code>>>>>$$$$" + backupActivityTO1.getFailCode());
                        if (backupActivityTO1.getFailCode() == 2304) {
                            PolicyManagementServerHelper.updateFailCodeToActivityHistory(2304);
                        } else if (backupActivityTO1.getFailCode() == 909) {
                            PolicyManagementServerHelper.updateFailCodeToActivityHistory(909);
                        } else if (backupActivityTO1.getFailCode() == 543) {
                            PolicyManagementServerHelper.updateFailCodeToActivityHistory(543);
                        } else {
                            this.jobStatusCode = 913;
                            PolicyManagementServerHelper.updateFailCodeToActivityHistory(909);
                        }
                        PolicyManagementServerHelper.sendCurrentStatisticsToServerBeforeExit(BackupLifeCycle.INTERRUPTED.toString(), true);
                    }
                } else if (backupActivityTO1.getFailCode() == 1992 || backupActivityTO1.getFailCode() == 1981 || backupActivityTO1.getFailCode() == 1996 || backupActivityTO1.getFailCode() == 1208) {
                    this.jobStatusCode = backupActivityTO1.getFailCode();
                    PolicyManagementServerHelper.sendCurrentStatisticsToServerBeforeExit(BackupLifeCycle.STOPPED.toString(), true);
                } else if (backupActivityTO1.getFailCode() == 1207 || backupActivityTO1.getFailCode() == 1209) {
                    this.jobStatusCode = backupActivityTO1.getFailCode();
                    PolicyManagementServerHelper.sendCurrentStatisticsToServerBeforeExit(BackupLifeCycle.ABORTED.toString(), true);
                    if (SettingHelper.getOsName().toLowerCase().contains("win") && SettingHelper.getIsVssEnabled() != null && "true".equalsIgnoreCase(SettingHelper.getIsVssEnabled())) {
                        if (this.listnerAdapter == null) {
                            this.listnerAdapter = new ListnerAdapter();
                        }
                        if (this.listnerAdapter.checkForService()) {
                            logger.debug(BEFORE_CALLING_DELETE);
                            this.deleteVsnapshot(totalInclusionsForSnapshot);
                        }
                        RegistryUtils.setRegistryValue((String)"HKCU", (String)"Software\\ParaBlu\\BluSync", (String)"OldPath", (String)SettingHelper.getInstallationDir());
                        ParabluFileSystemUtils.setOldInstallationDir((String)SettingHelper.getInstallationDir());
                    }
                }
            }
            NotificationHelper.backUpStarted = false;
            this.updateSystrayImageAccordingToStage(SyncConstants.PARABLU_IMAGE);
            this.pauseBackup(false, false, newBackUpJob, false);
            return;
        }
        catch (CrawlAdapterException e) {
            if (e.getMessage().contains("Operation not permitted")) {
                this.sendBackupStatusToServer(1212);
            }
            logger.debug("crawladapterexception:", (Throwable)e);
            logger.error("Unkown Exception :" + e.getMessage());
            logger.error("Unkown Exception :", (Object)e.getMessage());
            backupActivityTO.setBackupActivityStatus(CrawlLifecycle.ABORTED.toString());
            backupActivityHistoryDAOImpl.updateEventToBackupActivityHistoryTable(backupActivityTO);
            this.updateSystrayImageAccordingToStage(SyncConstants.PARABLU_NOINTERNET_ICON);
            NotificationHelper.setBackupStatus(0);
        }
        catch (BaseException baseException) {
            logger.error("baseException ", (Throwable)baseException);
            backupActivityTO.setBackupActivityStatus(CrawlLifecycle.ABORTED.toString());
            backupActivityHistoryDAOImpl.updateEventToBackupActivityHistoryTable(backupActivityTO);
            this.updateSystrayImageAccordingToStage(SyncConstants.PARABLU_NOINTERNET_ICON);
            NotificationHelper.setBackupStatus(0);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            logger.trace("" + e);
            logger.error("Exception :", (Throwable)e);
        }
        catch (Exception e) {
            logger.trace("", (Throwable)e);
            logger.error("Unkown Exception :" + e.getMessage());
            logger.error("Unkown Exception :", (Object)e.getMessage());
            backupActivityTO.setBackupActivityStatus(CrawlLifecycle.ABORTED.toString());
            backupActivityHistoryDAOImpl.updateEventToBackupActivityHistoryTable(backupActivityTO);
            this.updateSystrayImageAccordingToStage(SyncConstants.PARABLU_NOINTERNET_ICON);
            NotificationHelper.setBackupStatus(0);
        }
        this.jobSucceded = false;
        NotificationHelper.backUpStarted = false;
    }

    private List<BackupFolderTO> getRealPathForExceptionsToExclusion(List<BackupFolderTO> exceptionsToExclusionListFromPolicy, List<BackupFolderTO> exceptionsToExclusions) {
        exceptionsToExclusions = new ArrayList<BackupFolderTO>();
        for (BackupFolderTO exceptionalBackupFolderTO : exceptionsToExclusionListFromPolicy) {
            if (this.isCasesensitiveFolderCheckEnabled) {
                logger.debug("case check enabled inside exceptional BackupFolderTO............");
                exceptionalBackupFolderTO.setFolderPath(PolicyManagementServerHelper.getrealPath(exceptionalBackupFolderTO.getFolderPath()));
            }
            exceptionsToExclusions.add(exceptionalBackupFolderTO);
        }
        return exceptionsToExclusions;
    }

    private List<BackupFolderTO> getRealPath(List<BackupFolderTO> listOfFolderFromPolicy, List<BackupFolderTO> listOfFolder) {
        listOfFolder = new ArrayList<BackupFolderTO>();
        for (BackupFolderTO backupFolderTO : listOfFolderFromPolicy) {
            if (this.isCasesensitiveFolderCheckEnabled) {
                logger.debug("case check enabled............");
                backupFolderTO.setFolderPath(PolicyManagementServerHelper.getrealPath(backupFolderTO.getFolderPath()));
            }
            listOfFolder.add(backupFolderTO);
        }
        return listOfFolder;
    }

    private boolean updateBackupBatchId(BackupActivityTO backupActivityTO, BackupActivityHistoryDAOImpl backupActivityHistoryDAOImpl, boolean updateBatchId) {
        if (!"".equals(this.batchId) && !"-1".equals(this.batchId)) {
            if (updateBatchId) {
                backupActivityTO.setBatchId(this.batchId);
                backupActivityHistoryDAOImpl.updateEventToBackupActivityHistoryTable(backupActivityTO);
            }
            return true;
        }
        backupActivityTO.setBackupActivityStatus(CrawlLifecycle.ABORTED.toString());
        backupActivityHistoryDAOImpl.updateEventToBackupActivityHistoryTable(backupActivityTO);
        this.updateSystrayImageAccordingToStage(SyncConstants.PARABLU_NOINTERNET_ICON);
        NotificationHelper.setBackupStatus(0);
        NotificationHelper.setCurrentContainerJobId("0");
        NotificationHelper.backUpStarted = false;
        return false;
    }

    private void abortScan(List<BackupFolderTO> listOfFolder) {
        this.jobSucceded = false;
        this.updateAbortedStatus(listOfFolder);
        NotificationHelper.backUpStarted = false;
        this.updateSystrayImageAccordingToStage(SyncConstants.PARABLU_IMAGE);
        this.pauseBackup(false, false, newBackUpJob, false);
    }

    private void abort(List<BackupFolderTO> listOfFolder) {
        this.jobSucceded = false;
        NotificationHelper.backUpStarted = false;
        this.pauseBackup(false, false, newBackUpJob, false);
        this.updateAbortedStatus(listOfFolder);
        this.updateSystrayImageAccordingToStage(SyncConstants.PARABLU_IMAGE);
    }

    private void updateAbortedStatus(List<BackupFolderTO> listOfFolder) {
        PolicyManagementServerHelper.sendCurrentStatisticsToServerBeforeExit(BackupLifeCycle.ABORTED.toString(), true);
        if (SettingHelper.getOsName().toLowerCase().contains("win") && SettingHelper.getIsVssEnabled() != null && "true".equalsIgnoreCase(SettingHelper.getIsVssEnabled())) {
            if (this.listnerAdapter == null) {
                this.listnerAdapter = new ListnerAdapter();
            }
            if (this.listnerAdapter.checkForService()) {
                logger.debug(BEFORE_CALLING_DELETE);
                this.deleteVsnapshot(listOfFolder);
            }
            RegistryUtils.setRegistryValue((String)"HKCU", (String)"Software\\ParaBlu\\BluSync", (String)"OldPath", (String)SettingHelper.getInstallationDir());
            ParabluFileSystemUtils.setOldInstallationDir((String)SettingHelper.getInstallationDir());
        }
    }

    private void sendDeletedFilesToServer(long lastSuccessfullCrawlTime, Set<BackupTO> deletedSet) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        if (lastSuccessfullCrawlTime != 0L || this.fullBackup) {
            this.getDeletedFilesFromTable(deletedSet);
            if (!deletedSet.isEmpty()) {
                this.chunkBackupFilesAndCallForUpload(deletedSet);
            }
        }
    }

    private void renameBackupCrawlAndBackupImageTable() {
        logger.debug("Before renaming the backup temp table..");
        boolean success = this.newBackUpCrawlDAOImpl.renameTable("NewBkupCrawl_Temp", "NewBkupCrawl");
        logger.debug("Before renaming the backup crawl temp table.. success :" + success);
        success = this.newBackupImageDAOImpl.renameTable("NEWBKITABLE_TEMP", "NEWBKITABLE");
        logger.debug("Before renaming the backup temp table.. success :" + success);
    }

    private void createSnapshotifNotExist(List<BackupFolderTO> listOfAllFolder) {
        if (SettingHelper.getOsName().toLowerCase().contains("win") && SettingHelper.getIsVssEnabled() != null && "true".equalsIgnoreCase(SettingHelper.getIsVssEnabled())) {
            this.listnerAdapter = new ListnerAdapter();
            logger.debug("outside checkForService.");
            if (this.listnerAdapter.checkForService()) {
                logger.debug("Inside checkForService.");
                this.validateAndCreateSnapshot(listOfAllFolder);
            }
        }
    }

    private void validateAndCreateSnapshot(List<BackupFolderTO> listOfFolder) {
        int retryCount = 0;
        List<BackupFolderTO> validPaths = this.getValidPaths(listOfFolder, false);
        if (!this.restart) {
            boolean retry;
            do {
                retry = false;
                logger.debug(BEFORE_CALLING_DELETE);
                this.deleteVsnapshot(validPaths);
                logger.debug("Before calling create after delete");
                if (!this.createVsnapshot(validPaths)) {
                    logger.debug("After creating snapshot");
                    retry = true;
                    logger.debug("snap shot creation failed so retry pathCount: snap path:");
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e) {
                        logger.error("thread interrupted while sleep in create snapshot");
                    }
                    continue;
                }
                ParabluFileSystemUtils.setSnapshotValid((boolean)true);
            } while (retry && ++retryCount < 3);
        } else {
            List<BackupFolderTO> listOfAllSnapshotFolders = this.backupCrawlDAOImpl.getSnapshotCrawlBackUpFiles(this.batchId);
            ArrayList<BackupFolderTO> snapValidPaths = new ArrayList();
            snapValidPaths = this.getValidPaths(listOfAllSnapshotFolders, false);
            logger.debug("BEFORE_CALLING_CREATE folder size:" + listOfAllSnapshotFolders.size());
            int failedPathCount = this.getValidPaths(snapValidPaths, true).size();
            if (failedPathCount != 0) {
                boolean retry;
                do {
                    retry = false;
                    logger.debug("Before calling delete insidde restart part");
                    this.deleteVsnapshot(snapValidPaths);
                    logger.debug("Before calling create after delete");
                    if (!this.createVsnapshot(snapValidPaths)) {
                        retry = true;
                        logger.debug("snap shot creation failed during restart so retry pathCount: snap path:" + snapValidPaths.size());
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException e) {
                            logger.error("thread interrupted while sleep in create snapshot in retsart mode");
                        }
                        continue;
                    }
                    ParabluFileSystemUtils.setSnapshotValid((boolean)true);
                } while (retry && ++retryCount < 3);
            } else {
                ParabluFileSystemUtils.setSnapshotValid((boolean)true);
                logger.debug("Snap shot  is exist");
            }
        }
    }

    private List<BackupFolderTO> getValidPaths(List<BackupFolderTO> listOfFolder, boolean checkForSnapshot) {
        ArrayList<BackupFolderTO> validPaths = new ArrayList<BackupFolderTO>();
        if (checkForSnapshot) {
            logger.debug("Before checking for snapshot paths exists folderpath list size:" + listOfFolder.size());
            this.checkSnapShotExists(listOfFolder, validPaths);
            logger.debug("After checking for snapshot paths exists");
        } else {
            logger.debug("Before checking for configured paths exists");
            for (BackupFolderTO backupFolderTO : listOfFolder) {
                if (!StringUtils.isNotEmpty((String)backupFolderTO.getFolderPath()) || !new File(backupFolderTO.getFolderPath()).exists()) continue;
                validPaths.add(backupFolderTO);
            }
            logger.debug("After checking for configured paths exists");
        }
        return validPaths;
    }

    private void checkSnapShotExists(List<BackupFolderTO> listOfFolder, List<BackupFolderTO> validPaths) {
        for (BackupFolderTO backupFolderTO : listOfFolder) {
            logger.debug("folder name to check snapshot path:" + backupFolderTO.getFolderPath());
            String snapPath = ObjectUtils.getSnapShotPath((String)backupFolderTO.getFolderPath());
            logger.debug("snapshot path:" + backupFolderTO.getFolderPath());
            File snapFile = new File(snapPath);
            if (snapPath.isEmpty() || snapFile.exists()) continue;
            logger.debug("snap shot path doesn't exist" + snapFile.getAbsolutePath());
            validPaths.add(backupFolderTO);
        }
    }

    private void clearTablesForFullBackupOnDemand() {
        logger.debug("cleared tables for full backup again");
        this.newBackUpCrawlDAOImpl.deleteEntireTable();
        this.newBackUpCrawlDAOImpl.deleteEntirePrevCrawlTable();
        this.newBackUpCrawlDAOImpl.deleteEntireOldBackpCrawlTable();
        this.newBackupImageDAOImpl.clearEntireTable();
        this.newBackupImageDAOImpl.clearEntirePrevBackupImageTable();
        this.newBackupImageDAOImpl.clearEntireOldBackupImageTable();
    }

    private void validatePreviousBackupCrawlStatus() {
        logger.debug("Validating previous backup crawl status.");
        BackupActivityHistoryDAOImpl backupActivityHistoryDAOImpl = new BackupActivityHistoryDAOImpl(SettingHelper.getActivityDBUrl());
        BackupActivityTO activityTO = backupActivityHistoryDAOImpl.getScanStatusFromBackupActivityHistoryTable();
        this.currentPolicy = PolicyManagementServerHelper.getCurrentBackupPolicy();
        if (activityTO != null && activityTO.getSnapId() != null && this.currentPolicy.isClientDedupEnabled() && SettingHelper.getOsName().toLowerCase().contains("win")) {
            this.previoiusBackupSnapIds = activityTO.getSnapId();
            ParabluFileSystemUtils.convertMapString2Map((String)this.previoiusBackupSnapIds);
            logger.debug("previoiusBackupSnapIds:" + this.previoiusBackupSnapIds);
        }
        if (activityTO != null && activityTO.getBackupActivityStatus().contentEquals(CrawlLifecycle.SCANNING.toString())) {
            logger.debug("INSIDE ROLL BACK PREVIOUS CRAWL");
            this.doDataBaseChanges = false;
            logger.debug("cleaning up old tables");
            this.newBackUpCrawlDAOImpl.dropTable("NewBkupCrawl");
            this.newBackupImageDAOImpl.dropTable("NEWBKITABLE");
            activityTO.setBackupActivityStatus(CrawlLifecycle.ABORTED.toString());
            backupActivityHistoryDAOImpl.updateEventToBackupActivityHistoryTable(activityTO);
        }
    }

    private void validatePreviousBackupStatus(boolean isLastSuccessfulBackup) {
        this.backupStatusElement = this.getStatusOfBackup(isLastSuccessfulBackup);
        logger.debug("After validate previous backup status");
        if (this.backupStatusElement.getFirstBkpStartTime() != null) {
            this.firstBackupStartTime = this.backupStatusElement.getFirstBkpStartTime();
            this.getValueForcaseCheck();
        }
        if (this.backupStatusElement != null && this.backupStatusElement.getResponseCode() == 200) {
            if (!"".equals(this.backupStatusElement.getBatchId()) && this.backupStatusElement.getLastSuccessfulCrawlTimeStamp() != 0L) {
                this.crawlTimeStamp = String.valueOf(this.backupStatusElement.getLastSuccessfulCrawlTimeStamp());
                if (this.backupStatusElement.getStatus().equalsIgnoreCase(BackupLifeCycle.ABORTED.toString()) || this.backupStatusElement.getStatus().equalsIgnoreCase(BackupLifeCycle.SCANNING.toString())) {
                    logger.debug(".........................." + this.backupStatusElement.getBackupLogElement());
                    if (!this.backupStatusElement.getErrorCode().equalsIgnoreCase("543")) {
                        this.newBackUpCrawlDAOImpl.dropTable("NewBkupCrawl");
                        this.newBackupImageDAOImpl.dropTable("NEWBKITABLE");
                        this.doDataBaseChanges = false;
                    } else if (this.backupStatusElement.getErrorCode().equalsIgnoreCase("543")) {
                        this.usePreviousBatchId = true;
                    }
                    isLastSuccessfulBackup = true;
                    this.validatePreviousBackupStatus(isLastSuccessfulBackup);
                } else if (!this.backupStatusElement.getStatus().equalsIgnoreCase(BackupLifeCycle.COMPLETED.toString()) && !this.backupStatusElement.getStatus().equalsIgnoreCase(BackupLifeCycle.PRESCAN_COMMAND_EXECUTION.toString())) {
                    this.crawlTimeStamp = String.valueOf(this.backupStatusElement.getLastSuccessfulCrawlTimeStamp());
                    boolean success = this.getBackupCrawlTableStatus();
                    if (success) {
                        this.restart = true;
                        this.isFullBackup = this.backupStatusElement.isFullBackup();
                    } else {
                        this.backupStatusElement.setLastSuccessfulCrawlTimeStamp(0L);
                    }
                    this.totalSizeToUpload = this.backupStatusElement.getTotalSizeToUpload();
                }
            } else if (!"".equals(this.backupStatusElement.getBatchId()) && this.backupStatusElement.getLastSuccessfulCrawlTimeStamp() == 0L) {
                logger.debug("inside crawl time stamp 0 so take it from local activity");
                BackupActivityHistoryDAOImpl backupActivityHistoryDAOImpl = new BackupActivityHistoryDAOImpl(SettingHelper.getActivityDBUrl());
                BackupActivityTO backupActivityTO = backupActivityHistoryDAOImpl.getCurrentStatusFromBackupActivityHistoryTable();
                if (backupActivityTO != null && !backupActivityTO.getBatchStatus().equalsIgnoreCase(BackupLifeCycle.PRESCAN_COMMAND_EXECUTION.toString()) && !backupActivityTO.getBatchStatus().equalsIgnoreCase(BackupLifeCycle.SCANNING.toString())) {
                    this.backupStatusElement.setLastSuccessfulCrawlTimeStamp(Long.valueOf(backupActivityTO.getBackupActivityTimeStamp()).longValue());
                    logger.debug("local activity activity timestamp..." + this.backupStatusElement.getLastSuccessfulCrawlTimeStamp());
                    this.createPrevBKITFromOldBkpImage();
                    logger.debug("After creating the prev bkit with old table");
                    this.restart = false;
                }
            } else {
                this.backupStatusElement.setLastSuccessfulCrawlTimeStamp(0L);
                this.restart = false;
            }
        } else {
            throw new CrawlAdapterException("Get backup status failed");
        }
    }

    private void createPrevBKITFromOldBkpImage() {
        List<BackupTO> backUpFileTOs = this.backUpImageDAOImpl.readAllEntriesFromBackupImageTable();
        if (backUpFileTOs != null) {
            this.newBackupImageDAOImpl.insertListOfBackupTOsIntoTable(backUpFileTOs);
        }
    }

    private boolean getBackupCrawlTableStatus() {
        int count = this.newBackUpCrawlDAOImpl.getCountOfRemainingFilesForBackup(true);
        return count != 0;
    }

    private void updateCrawlTableAndGetDeletedFiles() {
        if (this.backupStatusElement.getLastSuccessfulCrawlTimeStamp() == 0L) {
            return;
        }
        logger.debug("Before getting added files from bkit");
        List<BackUpCrawlFileTO> backupCrawlTOs = this.newBackupImageDAOImpl.getAddedORDeletedFilesByComparing("ADDED");
        List backupTOs = null;
        logger.debug("After getting ADDED files from bkit");
        logger.debug("Before getting backupCrawlTOs for added files from objectutils");
        if (backupCrawlTOs != null) {
            try {
                logger.debug("backupCrawlTOs size" + backupCrawlTOs.size());
                while (backupCrawlTOs.size() != 0) {
                    logger.debug("backupCrawlTOs size" + backupCrawlTOs.size());
                    if (backupCrawlTOs.size() <= 1000) {
                        backupTOs = ObjectUtils.createBackupElementForFileNames(backupCrawlTOs);
                        if (backupTOs != null) {
                            this.newBackUpCrawlDAOImpl.checkFileExistsAndInsertFiles(backupTOs);
                        }
                        backupCrawlTOs.removeAll(backupCrawlTOs);
                        logger.debug("backupCrawlTOs size " + backupCrawlTOs.size());
                        continue;
                    }
                    List<Object> backUpCrawlFileTOTmp = new ArrayList();
                    ArrayList<BackupTO> backupTOsTmp = new ArrayList();
                    backUpCrawlFileTOTmp = backupCrawlTOs.subList(0, 1000);
                    logger.debug("backupCrawlTOs size" + backUpCrawlFileTOTmp.size());
                    backupTOsTmp = ObjectUtils.createBackupElementForFileNames(backUpCrawlFileTOTmp);
                    if (backupTOsTmp != null) {
                        this.newBackUpCrawlDAOImpl.checkFileExistsAndInsertFiles(backupTOsTmp);
                    }
                    backupCrawlTOs.removeAll(backUpCrawlFileTOTmp);
                    logger.debug("backupCrawlTOs size" + backupCrawlTOs.size());
                }
            }
            catch (Exception e) {
                logger.debug("Exception " + e.getMessage());
            }
        }
        ArrayList<BackupTO> failedFromPrevBkupFiles = new ArrayList<BackupTO>();
        List failedFilesFromPrevBkup = new ArrayList();
        if (this.backupStatusElement.getBackupLogElement() != null && this.backupStatusElement.getBackupLogElement().getFailedFiles() != null) {
            failedFilesFromPrevBkup = this.backupStatusElement.getBackupLogElement().getFailedFiles();
        }
        for (FileElement backupElement : failedFilesFromPrevBkup) {
            BackupTO backupTO = new BackupTO();
            if (StringUtils.isEmpty((String)backupElement.getMd5checksum())) {
                backupElement.setMd5checksum("null");
            }
            if (this.isCasesensitiveFolderCheckEnabled) {
                logger.debug("case check enabled............");
                backupElement.setFileCompletePath(PolicyManagementServerHelper.getrealPath(backupElement.getFileCompletePath()));
                File file = new File(backupElement.getFileCompletePath() + File.separator + backupElement.getFileName());
                backupElement.setSize("0");
                if (file.exists()) {
                    backupElement.setSize("" + file.length());
                    backupElement.setLastModifiedTimestamp(file.lastModified());
                }
            }
            ObjectUtils.copyFileElemenToBackupTO((FileElement)backupElement, (BackupTO)backupTO);
            failedFromPrevBkupFiles.add(backupTO);
        }
        if (!failedFromPrevBkupFiles.isEmpty()) {
            this.newBackUpCrawlDAOImpl.checkFileExistsAndInsertFiles(failedFromPrevBkupFiles);
        }
    }

    private void getDeletedFilesFromTable(Set<BackupTO> deletedSet) {
        logger.debug("Before getting deleted files from bkit");
        List<BackUpCrawlFileTO> deletedFiles = this.newBackupImageDAOImpl.getAddedORDeletedFilesByComparing("DELETED");
        logger.debug("After getting deleted files from bkit");
        if (deletedFiles != null) {
            logger.debug("Before getting deletedList set from objectutils");
            List deletedList = ObjectUtils.createBackupElementForDeletedFiles(deletedFiles);
            logger.debug("After getting deletedList set from objectutils");
            deletedSet.addAll(deletedList);
            logger.debug("DELETED SET SIZE:" + deletedSet.size());
        }
    }

    private BackupStatusElement getStatusOfBackup(boolean isLastSuccessfulBackup) {
        BackupStatusElement statusElement = null;
        try {
            statusElement = this.backupAdapter.getBackupStatus(SettingHelper.getCurrentCloudIpAddress(), SettingHelper.readTokenFromFile(), BACKUP, SettingHelper.getDeviceName(), SettingHelper.getDeviceUUId(), SettingHelper.getUserName(), isLastSuccessfulBackup);
            if (this.isBadRequest(statusElement) || this.isServerDown(statusElement)) {
                statusElement = this.retryBackupStatusUsingUpdatedIp(isLastSuccessfulBackup);
            } else {
                if (statusElement.getResponseCode() == 421) {
                    this.sessionExpired = true;
                    throw new CrawlAdapterException("Session Expired");
                }
                if (statusElement.getResponseCode() == 420) {
                    this.deviceBlocked = true;
                    throw new CrawlAdapterException(" User Device Blocked");
                }
                if (statusElement.getResponseCode() == 543) {
                    this.sendBackupStatusToServer(543);
                    throw new CrawlAdapterException(" target is not assigned....");
                }
            }
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("Error in get backup status...." + e.getClass().getCanonicalName());
            if (e.getClass().getName().equalsIgnoreCase("com.parablu.epa.core.exception.CrawlAdapterException")) {
                throw new CrawlAdapterException(e.getMessage());
            }
            statusElement = this.retryBackupStatusUsingUpdatedIp(isLastSuccessfulBackup);
        }
        return statusElement;
    }

    private void sendBackupStatusToServer(int statusCode) {
        logger.debug("....HTTP_BACKUP_TARGET_NOT_ASSIGNED..");
        BackupActivityTO backupActivityTO = new BackupActivityTO();
        backupActivityTO.setBackupActivityStatus(CrawlLifecycle.FINISHED.toString());
        backupActivityTO.setBackupActivityTimeStamp(String.valueOf(System.currentTimeMillis()));
        backupActivityTO.setBatchId("-1");
        backupActivityTO.setFullBackup(Boolean.toString(this.isFullBackup));
        backupActivityTO.setBatchStatus(CrawlLifecycle.FINISHED.toString());
        backupActivityTO.setFailCode(statusCode);
        BackupActivityHistoryDAOImpl backupActivityHistoryDAOImpl = new BackupActivityHistoryDAOImpl(SettingHelper.getActivityDBUrl());
        backupActivityTO.setBackupActivityID(backupActivityHistoryDAOImpl.addEventToBackupActivityHistoryTable(backupActivityTO));
        this.batchId = this.backupBatchInitiated(STARTED_COMPLETED, this.batchId, 0, backupActivityTO.getFailCode(), backupActivityTO.getTotalUploadSize(), backupActivityTO.getBackupUploadCount(), 0, backupActivityTO.getBackupActivityTimeStamp(), this.totalSizeToUpload);
        backupActivityTO.setBatchId(this.batchId);
        backupActivityHistoryDAOImpl.updateEventToBackupActivityHistoryTable(backupActivityTO);
    }

    private boolean isBadRequest(BackupStatusElement statusElement) {
        return statusElement == null || statusElement.getResponseCode() == 404;
    }

    private boolean isServerDown(BackupStatusElement statusElement) {
        return statusElement.getResponseCode() == 400 || statusElement.getResponseCode() == 503 || statusElement.getResponseCode() == 500;
    }

    private BackupStatusElement retryBackupStatusUsingUpdatedIp(boolean isLastSuccessfullBackup) {
        boolean retry;
        BackupStatusElement statusElement = null;
        int retryCount = 0;
        int sleepMultiplier = 1;
        long sleepTime = 60000L * (long)sleepMultiplier;
        String currentIp = SettingHelper.getCurrentCloudIpAddress();
        BluVaultIPHelper bluVaultIPHelper = new BluVaultIPHelper();
        BackupPolicyDAOImpl backupPolicyDAOImpl = new BackupPolicyDAOImpl(SettingHelper.getBackUpDbUrl());
        List<BluVaultTO> ebmsList = bluVaultIPHelper.getEbmsList(backupPolicyDAOImpl);
        do {
            retry = false;
            try {
                logger.debug("Before retry Backup Status Using UpdatedIp....");
                this.backupAdapter.resetClientConnection(SettingHelper.getCloudName(), SettingHelper.getKeystorePath());
                ebmsList = this.removeCurrentIp(ebmsList, currentIp);
                logger.debug("ebms list size after removing the current ip:" + ebmsList.size());
                if (ebmsList.isEmpty()) {
                    logger.debug("inside ebms list empty cycle finished so sleep and reset");
                    ++retryCount;
                    sleepTime = this.sleepForGivenTime(statusElement, sleepTime, retry);
                    ebmsList = bluVaultIPHelper.getEbmsList(backupPolicyDAOImpl);
                }
                if (!ebmsList.isEmpty()) {
                    currentIp = ebmsList.get(0).getBluVaultName();
                }
                NotificationHelper.setBackupStatus(1);
                statusElement = this.backupAdapter.getBackupStatus(currentIp, SettingHelper.readTokenFromFile(), BACKUP, SettingHelper.getDeviceName(), SettingHelper.getDeviceUUId(), SettingHelper.getUserName(), isLastSuccessfullBackup);
                if (this.isBadRequest(statusElement) || this.isServerDown(statusElement)) {
                    retry = true;
                } else if (statusElement.getResponseCode() == 200) {
                    if (!StringUtils.isEmpty((String)currentIp)) {
                        SettingHelper.setGaeLocalIpAddress(currentIp);
                        SettingHelper.setPublicIpAddress(currentIp);
                        SettingHelper.setCurrentCloudIpAddress(currentIp);
                        ProxyElement.setIp((String)currentIp);
                        SettingHelper.applyChangesToSharedPreferences(false);
                    }
                    return statusElement;
                }
            }
            catch (CrawlAdapterException e) {
                logger.trace("" + e);
                logger.error("Crawl Exception  getting backup status so retry.." + e.getMessage());
                retry = true;
            }
            catch (Exception e) {
                logger.trace("" + e);
                logger.error("Error while getting backup status" + e.getMessage());
            }
            if (retryCount < 4) continue;
            retry = true;
            sleepTime = 1800000L;
        } while (retry);
        return statusElement;
    }

    private long sleepForGivenTime(BackupStatusElement statusElement, long sleepTime, boolean retry) {
        long sleepTimeTemp = sleepTime;
        try {
            logger.debug("SleepTime is" + sleepTimeTemp);
            PBCountDownTimer countDownTimer = new PBCountDownTimer();
            if (statusElement != null) {
                logger.debug("response code:" + statusElement.getResponseCode());
            }
            countDownTimer.startCountDownTimer((int)sleepTimeTemp / 60000);
            logger.debug("after starting timer/....");
            NotificationHelper.setBackupStatus(6);
            Thread.sleep(sleepTimeTemp);
            int sleepMultiplier = 2;
            sleepTimeTemp *= (long)sleepMultiplier;
        }
        catch (InterruptedException e1) {
            logger.error("Sleeper Thread interupted error");
        }
        return sleepTimeTemp;
    }

    public void checkIfPathExists(List<BackupFolderTO> listOfFolder) {
        ArrayList<String> listOfNotExistingFolders = new ArrayList<String>();
        StringBuilder buffer = new StringBuilder();
        for (BackupFolderTO backupFolder : listOfFolder) {
            String actualPath = SettingHelper.getOsName().toLowerCase().contains("mac") ? this.checkForMacBasePath(backupFolder.getFolderPath()) : backupFolder.getFolderPath();
            File file = new File(actualPath);
            if (file.exists()) continue;
            listOfNotExistingFolders.add(backupFolder.getFolderPath());
            buffer.append(backupFolder.getFolderPath());
            buffer.append("\n");
        }
        if (!listOfNotExistingFolders.isEmpty()) {
            String toolTipMessage = "Following folder or drive does not exist";
            String toolTipmessage1 = buffer.toString();
            this.updateSystrayToolTipNotification(toolTipMessage, toolTipmessage1);
        }
    }

    private void validatePreviousBackupActivity(BackupActivityHistoryDAOImpl backupActivityHistoryDAOImpl) {
        BackupActivityTO backupActivityTO = backupActivityHistoryDAOImpl.getCurrentStatusFromBackupActivityHistoryTable();
        if (backupActivityTO != null && backupActivityTO.getBatchStatus().equals(BackupLifeCycle.STARTED.toString())) {
            backupActivityTO.setBatchStatus(BackupLifeCycle.INTERRUPTED.toString());
            backupActivityHistoryDAOImpl.updateEventToBackupActivityHistoryTable(backupActivityTO);
        }
        if (backupActivityTO != null && backupActivityTO.getBackupActivityStatus().equals(CrawlLifecycle.INPROGRESS.toString())) {
            backupActivityTO.setBackupActivityStatus(CrawlLifecycle.ABORTED.toString());
            backupActivityHistoryDAOImpl.updateEventToBackupActivityHistoryTable(backupActivityTO);
        }
    }

    private void validatePreviousRestartId() {
        if (this.backupStatusElement.getBackupLogElement() != null) {
            this.restartId = this.backupStatusElement.getBackupLogElement().getRestartId();
            logger.debug("Restart Id is: " + this.restartId);
        }
    }

    public abstract void startBackUpThread(Set<DedupTO> var1, boolean var2, long var3, String var5) throws InterruptedException, InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException;

    public abstract void pauseBackup(boolean var1, boolean var2, NewBackUpJob var3, boolean var4);

    private void chunkBackupFilesAndCallForUpload(Set<BackupTO> deletedSet) throws CrawlAdapterException, InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        HashSet<BackupTO> chunkDeletedFilesTOSet = new HashSet<BackupTO>();
        Iterator<BackupTO> iterator = deletedSet.iterator();
        while (iterator.hasNext()) {
            chunkDeletedFilesTOSet.add(iterator.next());
            if (chunkDeletedFilesTOSet.size() != this.crawlFileLimit) continue;
            this.createAndSendRequestAndUpdatedatabase(chunkDeletedFilesTOSet);
            chunkDeletedFilesTOSet.clear();
        }
        this.createAndSendRequestAndUpdatedatabase(chunkDeletedFilesTOSet);
    }

    private void createAndSendRequestAndUpdatedatabase(Set<BackupTO> deletedSet) throws CrawlAdapterException, InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        byte[] bs = this.createWebRequest(deletedSet);
        if (bs == null) {
            throw new BaseException("gzip byte array is null,serialization failed");
        }
        this.sendWebRequest(bs);
    }

    private byte[] createWebRequest(Set<BackupTO> deletedSet) {
        ArrayList<FileElement> deletedBackupFileElements = new ArrayList<FileElement>();
        this.convertBackupTOListToBackupElementList(deletedSet, deletedBackupFileElements);
        FileListElement newBackupFileListElement = new FileListElement();
        FileListElement deletedBackupFileListElement = new FileListElement();
        deletedBackupFileListElement.setFileElementList(deletedBackupFileElements);
        BackupValidationElement backupValidationElement = new BackupValidationElement();
        backupValidationElement.setFilesToAddList(newBackupFileListElement);
        backupValidationElement.setFilesToDeleteList(deletedBackupFileListElement);
        byte[] bs = CreateXmlObject.createGzipByteArrayForValidateBackUpRequest((BackupValidationElement)backupValidationElement);
        return bs;
    }

    private List<BackupTO> sendWebRequest(byte[] bs) throws CrawlAdapterException, InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        GzipTO gzipResponse;
        this.currentIP = SettingHelper.getCurrentCloudIpAddress();
        if (SettingHelper.getCurrentHttpsPort() != null) {
            this.currentPort = Integer.valueOf(SettingHelper.getCurrentHttpsPort());
        }
        if ((gzipResponse = this.backupAdapter.validateDeltaForBackUp(bs, this.currentIP, null, false, SettingHelper.readTokenFromFile())) == null || gzipResponse.getResponseCode() == 404 || gzipResponse.getResponseCode() == 400 || gzipResponse.getResponseCode() == 503) {
            gzipResponse = this.retryUsingUpdatedIp(bs, gzipResponse);
        }
        if (gzipResponse == null) {
            throw new CrawlAdapterException(" null gzipResponse (connection error)");
        }
        int responseCode = gzipResponse.getResponseCode();
        if (responseCode == 400 || responseCode == 404) {
            throw new CrawlAdapterException(" HTTP_DEVICE_SESSION_EXPIRED or HTTP_BAD_REQUEST or HTTP_NOT_FOUND:" + responseCode);
        }
        if (responseCode == 416) {
            this.licenseExpired = true;
            throw new CrawlAdapterException(" License Expired");
        }
        if (responseCode == 420) {
            this.deviceBlocked = true;
            throw new CrawlAdapterException(" User Device Blocked");
        }
        if (responseCode == 417) {
            throw new CrawlAdapterException("User Limit Reached");
        }
        if (responseCode == 421) {
            this.sessionExpired = true;
            throw new CrawlAdapterException("Session Expired");
        }
        if (responseCode == 401) {
            throw new CrawlAdapterException("Unauthorized");
        }
        if (responseCode != 200) {
            throw new CrawlAdapterException(" Server Error: " + responseCode);
        }
        byte[] responseByte = gzipResponse.getResponse();
        BackupListResponseElement backupListResponseElement = Xmlparser.parseBackupListResponse((byte[])responseByte);
        if (backupListResponseElement == null) {
            throw new CrawlAdapterException(" backupListResponseElement; parsed response null");
        }
        List<DedupTO> dedupTOs = this.getDedupListFromResponse(backupListResponseElement);
        logger.debug("Dedup list is: " + dedupTOs.size());
        this.insertDedupIntoTable(dedupTOs);
        return ObjectUtils.convertFileElementToBackupTO((List)backupListResponseElement.getFilesNotToAddList().getFileElementList(), (String)"0");
    }

    private void insertDedupIntoTable(List<DedupTO> dedupTOs) {
        if (dedupTOs != null && !dedupTOs.isEmpty()) {
            try {
                this.newBackupImageDAOImpl.insertListOfDedupsIntoTable(dedupTOs);
            }
            catch (Exception e) {
                logger.trace("" + e);
                logger.error("Error in insert dedup entries" + e.getMessage());
            }
        }
    }

    private List<DedupTO> getDedupListFromResponse(BackupListResponseElement backupListResponseElement) {
        List dedupTOs = ObjectUtils.convertKeyValueElementToDedupTO((List)backupListResponseElement.getFilesNotToAddList().getMd5AndDedupedIdList());
        return dedupTOs;
    }

    private GzipTO retryUsingUpdatedIp(byte[] bs, GzipTO gzipRes) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        SettingHelper.checkAndUpdateIpAddress();
        GzipTO gzipResponse = gzipRes;
        if (gzipResponse == null || gzipResponse.getResponseCode() == 404 || gzipResponse.getResponseCode() == 400) {
            this.currentIP = SettingHelper.getGaeLocalIpAddress();
            this.currentPort = null;
            this.backupAdapter.resetClientConnection(SettingHelper.getCloudName(), SettingHelper.getKeystorePath());
            gzipResponse = this.backupAdapter.validateDeltaForBackUp(bs, this.currentIP, this.currentPort, this.isFirstTimeCrawl, SettingHelper.readTokenFromFile());
        }
        if (gzipResponse == null || gzipResponse.getResponseCode() == 404 || gzipResponse.getResponseCode() == 400) {
            this.currentIP = SettingHelper.getPublicIpAddress();
            this.currentPort = null;
            this.backupAdapter.resetClientConnection(SettingHelper.getCloudName(), SettingHelper.getKeystorePath());
            gzipResponse = this.backupAdapter.validateDeltaForBackUp(bs, this.currentIP, this.currentPort, this.isFirstTimeCrawl, SettingHelper.readTokenFromFile());
        }
        if (gzipResponse == null || gzipResponse.getResponseCode() == 404 || gzipResponse.getResponseCode() == 400 && SettingHelper.getHttpsPort() != null) {
            this.currentIP = SettingHelper.getPublicIpAddress();
            this.currentPort = Integer.valueOf(SettingHelper.getHttpsPort());
            this.backupAdapter.resetClientConnection(SettingHelper.getCloudName(), SettingHelper.getKeystorePath());
            gzipResponse = this.backupAdapter.validateDeltaForBackUp(bs, this.currentIP, this.currentPort, this.isFirstTimeCrawl, SettingHelper.readTokenFromFile());
        }
        if (gzipResponse != null && gzipResponse.getResponseCode() != 404 && gzipResponse.getResponseCode() != 400) {
            SettingHelper.setCurrentHttpsPort(this.currentPort == null ? null : String.valueOf(this.currentPort));
            SettingHelper.setCurrentCloudIpAddress(this.currentIP);
            ProxyElement.setIp((String)this.currentIP);
            SettingHelper.applyChangesToSharedPreferences(false);
        }
        return gzipResponse;
    }

    private void convertBackupTOListToBackupElementList(Set<BackupTO> fileTOList, List<FileElement> fileElementList) {
        for (BackupTO fileTO : fileTOList) {
            BackupElement fileElement = new BackupElement();
            ObjectUtils.copyBackupTOtoFileElement((BackupTO)fileTO, (FileElement)fileElement);
            fileElementList.add((FileElement)fileElement);
        }
    }

    private void createTablesIfNotExist() {
        logger.debug("inside create table  if not exists..");
        this.backUpFolderDAOImpl.createBackUpTable();
        this.backUpImageDAOImpl.createTable();
        this.newBackUpCrawlDAOImpl.createTable();
        this.newBackupImageDAOImpl.createNewBackUpImageTable();
        this.newBackupImageDAOImpl.createNewPrevBackUpImageTable();
        this.newBackUpCrawlDAOImpl.createNewPrevBackupCrawlTable();
        this.newBackupImageDAOImpl.createDedupTable();
        this.newBackupImageDAOImpl.createOldPrevBackUpImageTable();
        this.newBackUpCrawlDAOImpl.createOldBackupCrawlTable();
        this.backupPolicyDAOImpl.createPolicyExceptionsTOExclusionTable();
    }

    private void scanFileSystem(List<BackupFolderTO> files, List<BackupFolderTO> excptionsToExclusions, long lastSuccessfullCrawlTime) throws InterruptedException, InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        boolean success = this.doDataBaseChanges();
        boolean includeExclusions = true;
        logger.debug("Database changes done" + success);
        if (!files.isEmpty()) {
            List<String> excludedFoldersFromPolicy = null;
            logger.debug("START CRAWL " + System.currentTimeMillis());
            if (SettingHelper.getBackupLicenced().contentEquals("true")) {
                FilesBeSkippedAsPerPolicy.setLegalHoldDetails();
                FilesBeSkippedAsPerPolicy.allowedSize = FilesBeSkippedAsPerPolicy.getCurrentPolicyMaxSize();
                this.setFilterDetails();
                FilesBeSkippedAsPerPolicy.setSkipHiddenFile();
                excludedFoldersFromPolicy = HashChecker.getExcludedFoldersList();
                excludedFoldersFromPolicy.forEach(System.out::println);
                FilesBeSkippedAsPerPolicy.setFilterExludedFoldresFromPolicy();
                FilesBeSkippedAsPerPolicy.setRootexclusionfoldersFromPolicy();
            }
            this.crawlTimeStamp = Long.toString(System.currentTimeMillis());
            this.scanFiles(files, lastSuccessfullCrawlTime, excludedFoldersFromPolicy, includeExclusions);
            if (this.isScanInterrupted) {
                return;
            }
            if (!excptionsToExclusions.isEmpty()) {
                includeExclusions = false;
                this.scanFiles(excptionsToExclusions, lastSuccessfullCrawlTime, excludedFoldersFromPolicy, includeExclusions);
                if (this.isScanInterrupted) {
                    return;
                }
            }
            logger.debug("END CRAWL" + System.currentTimeMillis());
            logger.debug("noOfDBWritesForCrawlFileLimit:## " + this.noOfDBWritesForCrawlFileLimit);
        }
    }

    private void scanFiles(List<BackupFolderTO> files, long lastSuccessfullCrawlTime, List<String> excludedFoldersFromPolicy, boolean includeExclusions) {
        for (BackupFolderTO file : files) {
            if (Thread.currentThread().isInterrupted()) {
                logger.debug("Current Thread interrupted");
                this.isScanInterrupted = true;
                return;
            }
            try {
                ArrayList<File> fileList;
                if (excludedFoldersFromPolicy != null && !excludedFoldersFromPolicy.isEmpty() && FilesBeSkippedAsPerPolicy.skipExcludedFolders(FilesBeSkippedAsPerPolicy.getFilterExludedFoldresFromPolicy(), file.getFolderPath(), includeExclusions)) continue;
                this.scanFileSystemByType(file.getFolderPath(), lastSuccessfullCrawlTime, includeExclusions);
                if (this.isScanInterrupted) {
                    return;
                }
                if (!this.backupImageList.isEmpty()) {
                    logger.debug(" Files to be inserted in backupimage table" + this.backupImageList.size());
                    ++this.noOfDBWritesForCrawlFileLimit;
                    fileList = new ArrayList<File>();
                    fileList.addAll(this.backupImageList);
                    this.newBackupImageDAOImpl.insertListOfFileNamesIntoTable(fileList);
                    this.backupImageList.clear();
                    fileList.clear();
                }
                if (this.crawledFileList.isEmpty()) continue;
                logger.debug("#1 Files to be inserted in crawl table " + this.crawledFileList.size());
                ++this.noOfDBWritesForCrawlFileLimit;
                fileList = new ArrayList();
                fileList.addAll(this.crawledFileList);
                List backupTOs = ObjectUtils.createBackupElementForFiles(fileList);
                this.newBackUpCrawlDAOImpl.insertListIntoTable(backupTOs);
                this.crawledFileList.clear();
                fileList.clear();
            }
            catch (IOException e) {
                logger.error("error message:" + e.getMessage());
                logger.error("exception while crawl", (Throwable)e);
                if (!e.getMessage().contains("Operation not permitted")) continue;
                throw new CrawlAdapterException("crawl stopped because of permission issue..");
            }
            catch (Exception e) {
                logger.error("error message:" + e.getMessage());
                logger.error("exception while crawl", (Throwable)e);
            }
        }
    }

    private void setFilterDetails() {
        Map<String, String> exclusionMap = this.backUpFolderDAOImpl.getInclusionExtensions();
        if (exclusionMap != null && !exclusionMap.isEmpty()) {
            FilesBeSkippedAsPerPolicy.extensions = exclusionMap.get("extensionName");
            String filterType = exclusionMap.get("filterType");
            FilesBeSkippedAsPerPolicy.filterType = StringUtils.isEmpty((String)filterType) ? "inclusion" : filterType;
        }
    }

    private boolean doDataBaseChanges() {
        this.newBackUpCrawlDAOImpl.clearEntireTempTable();
        this.newBackupImageDAOImpl.clearEntireTempTable();
        if (!this.doDataBaseChanges) {
            logger.debug("database changes not needed so return");
            return true;
        }
        boolean success = false;
        this.newBackUpCrawlDAOImpl.createTempTable();
        this.newBackupImageDAOImpl.createNewBackUpImageTempTable();
        this.newBackUpCrawlDAOImpl.deleteEntireOldBackpCrawlTable();
        boolean delSuccess = this.newBackUpCrawlDAOImpl.dropTable("NewPrev_BkupCrawl");
        boolean copySuccess = false;
        if (delSuccess) {
            copySuccess = this.newBackUpCrawlDAOImpl.renameTable("NewBkupCrawl", "NewPrev_BkupCrawl");
        }
        if (copySuccess) {
            this.newBackUpCrawlDAOImpl.dropTable("NewBkupCrawl");
        }
        copySuccess = false;
        delSuccess = this.newBackupImageDAOImpl.dropTable("NEWPREV_BKITABLE");
        if (delSuccess) {
            copySuccess = this.newBackupImageDAOImpl.renameTable("NEWBKITABLE", "NEWPREV_BKITABLE");
        }
        if (copySuccess) {
            this.newBackupImageDAOImpl.dropTable("NEWBKITABLE");
        }
        if (delSuccess && copySuccess) {
            success = true;
        }
        return success;
    }

    public String backupBatchInitiated(String batchStatus, String batchId, int totalCount, int errorCode, long totalUploadSize, String totalUploadedCount, int crawlCount, String crawlTimeStamp, long totalSizeToUpload) {
        String recivedBatchId;
        boolean retry;
        String jobType = BACKUP;
        String originalBatchId = batchId;
        int retryCount = 0;
        int sleepMultiplier = 1;
        long sleepTime = 60000L * (long)sleepMultiplier;
        BackupPolicyDAOImpl backupPolicyDAOImpl = new BackupPolicyDAOImpl(SettingHelper.getBackUpDbUrl());
        String currentIPToUse = SettingHelper.getCurrentCloudIpAddress();
        BluVaultIPHelper bluVaultIPHelper = new BluVaultIPHelper();
        List<BluVaultTO> ebmsList = bluVaultIPHelper.getEbmsList(backupPolicyDAOImpl);
        do {
            retry = false;
            logger.debug("Retrying to update backup status.");
            try {
                logger.debug("the STATUS:" + batchStatus);
                BackupOrRestoreStatusTo backupOrRestoreStatusTo = new BackupOrRestoreStatusTo();
                backupOrRestoreStatusTo.setStatus(batchStatus);
                backupOrRestoreStatusTo.setIp(currentIPToUse);
                backupOrRestoreStatusTo.setToken(SettingHelper.readTokenFromFile());
                backupOrRestoreStatusTo.setBatchId(originalBatchId);
                backupOrRestoreStatusTo.setJobType(jobType);
                backupOrRestoreStatusTo.setDeviceName(SettingHelper.getDeviceName());
                backupOrRestoreStatusTo.setTotalCount(totalCount);
                backupOrRestoreStatusTo.setErrorCode(errorCode);
                backupOrRestoreStatusTo.setDeviceUUID(SettingHelper.getDeviceUUId());
                backupOrRestoreStatusTo.setTotalUploadSize(totalUploadSize);
                backupOrRestoreStatusTo.setTotalUploadedCount(totalUploadedCount);
                backupOrRestoreStatusTo.setCrawlCount(crawlCount);
                backupOrRestoreStatusTo.setCrawlTimeStamp(crawlTimeStamp);
                backupOrRestoreStatusTo.setFullBackup(this.isFullBackup);
                backupOrRestoreStatusTo.setDiskSpaceDetails(new ParabluFileSystemUtils().getSystemSpace());
                backupOrRestoreStatusTo.setPolicyConfiguredFolders(this.getConfiguredBackupFolders());
                backupOrRestoreStatusTo.setTotalSizeToUpload(totalSizeToUpload);
                if (!backupOrRestoreStatusTo.getStatus().startsWith("STARTED")) {
                    backupOrRestoreStatusTo.setFailedFileslogFile(BackupHelper.getFailedFilesLogFile());
                }
                this.backupAdapter.resetClientConnection(SettingHelper.getCloudName(), SettingHelper.getKeystorePath());
                recivedBatchId = this.backupAdapter.sendEmailNotification(backupOrRestoreStatusTo);
            }
            catch (Exception e) {
                recivedBatchId = "-1";
                logger.trace("" + e);
                logger.error(" Exception inside  put batch " + e.getMessage());
            }
            if (!"-1".equalsIgnoreCase(recivedBatchId)) continue;
            retry = true;
            ebmsList = this.removeCurrentIp(ebmsList, currentIPToUse);
            logger.debug("ebms list size after removing the current ip:" + ebmsList.size());
            if (ebmsList.isEmpty()) {
                logger.debug("inside ebms list empty cycle finished so sleep and reset");
                sleepTime = ParabluFileSystemUtils.sleepForGivenTime((long)sleepTime);
                ++retryCount;
                ebmsList = bluVaultIPHelper.getEbmsList(backupPolicyDAOImpl);
            }
            if (ebmsList.isEmpty()) continue;
            currentIPToUse = ebmsList.get(0).getBluVaultName();
        } while (retry && retryCount < 4);
        return recivedBatchId;
    }

    private List<BluVaultTO> removeCurrentIp(List<BluVaultTO> ebmsList, String currentIP) {
        List<Object> ebmsList1 = new ArrayList<BluVaultTO>();
        if (ebmsList == null) {
            ArrayList<BluVaultTO> ebsList = new ArrayList<BluVaultTO>();
            return ebsList;
        }
        if (StringUtils.isEmpty((String)currentIP)) {
            return ebmsList;
        }
        try {
            ebmsList1 = ebmsList.stream().filter(p -> !p.getBluVaultName().equalsIgnoreCase(currentIP)).collect(Collectors.toList());
            logger.debug("After removing the ip size:" + ebmsList1.size() + "  current Ip:" + currentIP);
        }
        catch (Exception e) {
            logger.error("error happened while removing current ip..", (Throwable)e);
        }
        return ebmsList1;
    }

    private BackupResultTO scanFileSystemByType(String completeParentPath, long lastSuccessfullCrawlTime, boolean includeExclusions) throws InterruptedException, InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException, IOException {
        ArrayList<File> fileList;
        String recivedCompleteParentPath = completeParentPath;
        if (this.backupImageList.size() > 5000) {
            logger.debug("Files to be inserted in backupimage table" + this.backupImageList.size());
            ++this.noOfDBWritesForCrawlFileLimit;
            fileList = new ArrayList<File>();
            fileList.addAll(this.backupImageList);
            this.newBackupImageDAOImpl.insertListOfFileNamesIntoTable(fileList);
            this.backupImageList.clear();
            fileList.clear();
        }
        if (this.crawledFileList.size() > 5000) {
            logger.debug("Files to be inserted in crawl table " + this.crawledFileList.size());
            ++this.noOfDBWritesForCrawlFileLimit;
            fileList = new ArrayList();
            fileList.addAll(this.crawledFileList);
            List backupTOs = ObjectUtils.createBackupElementForFiles(fileList);
            this.newBackUpCrawlDAOImpl.insertListIntoTable(backupTOs);
            this.crawledFileList.clear();
            fileList.clear();
        }
        if (SettingHelper.getOsName().toLowerCase().startsWith("win") && ParabluFileSystemUtils.isSnapshotValid()) {
            recivedCompleteParentPath = ObjectUtils.getSnapShotPath((String)recivedCompleteParentPath);
        }
        recivedCompleteParentPath = this.checkForMacBasePath(recivedCompleteParentPath);
        File currentFolder = new File(recivedCompleteParentPath);
        this.checkFolderAccessibility(recivedCompleteParentPath, true);
        File[] childFileAndFolderNames = currentFolder.listFiles();
        if (childFileAndFolderNames == null) {
            return null;
        }
        int noOfChildFilesAndFolders = childFileAndFolderNames.length;
        logger.debug(currentFolder.getAbsolutePath() + "childFileAndFolderNames......." + childFileAndFolderNames.length);
        logger.debug("recivedCompleteParentPath......." + recivedCompleteParentPath);
        for (int i = 0; i < noOfChildFilesAndFolders; ++i) {
            if (Thread.currentThread().isInterrupted()) {
                logger.debug("current thread is interrupted so return ");
                this.isScanInterrupted = true;
                break;
            }
            String currentProcessingFilePath = SnapShotHelper.getOriginalPathFromSnapshotPath((String)childFileAndFolderNames[i].getAbsolutePath());
            File currentProcessingFile = new File(currentProcessingFilePath);
            if (currentProcessingFile.getName().startsWith(".pbsdn")) {
                currentProcessingFile.delete();
                continue;
            }
            if (currentProcessingFile.getName().startsWith("pbchnkz") || currentProcessingFile.getName().startsWith(".pbchnkz") || currentProcessingFile.getName().startsWith("CHUNK")) {
                if (currentProcessingFile.isDirectory()) {
                    String[] children = currentProcessingFile.list();
                    for (int j = 0; j < children.length; ++j) {
                        new File(currentProcessingFile, children[j]).delete();
                    }
                }
                currentProcessingFile.delete();
                continue;
            }
            if (currentProcessingFile.getName().startsWith("rpbchnkz") || currentProcessingFile.getName().startsWith(".rpbchnkz")) continue;
            boolean isParabluAppDir = false;
            if (this.isParaBluAppDirectory(currentProcessingFile)) {
                isParabluAppDir = true;
            }
            boolean fileToBeSkipped = this.isFileToBeSkipped(currentProcessingFile.getAbsolutePath(), includeExclusions);
            boolean isFileToBeSkippedAsperPolicy = !currentProcessingFile.isDirectory() && SettingHelper.getBackupLicenced().contentEquals("true") ? FilesBeSkippedAsPerPolicy.checkVariousPolicies(currentProcessingFile, includeExclusions) : FilesBeSkippedAsPerPolicy.checkExcludeFolders(currentProcessingFile, includeExclusions);
            boolean isSkipHiddenFile = FilesBeSkippedAsPerPolicy.skipHiddenFile(currentProcessingFile);
            if (fileToBeSkipped || isFileToBeSkippedAsperPolicy || isParabluAppDir || isSkipHiddenFile) continue;
            boolean isFileADirectory = currentProcessingFile.isDirectory();
            this.backupImageList.add(currentProcessingFile);
            if (currentProcessingFile.lastModified() > lastSuccessfullCrawlTime) {
                this.crawledFileList.add(currentProcessingFile);
            }
            if (!isFileADirectory) continue;
            BackupResultTO backupResult = this.scanFileSystemByType(currentProcessingFile.getAbsolutePath(), lastSuccessfullCrawlTime, includeExclusions);
            if (backupResult != null && backupResult.getCrawledFileList() != null) {
                this.crawledFileList.addAll(backupResult.getCrawledFileList());
            }
            if (backupResult == null || backupResult.getBackupImageList() == null) continue;
            this.backupImageList.addAll(backupResult.getBackupImageList());
        }
        if (this.backupImageList.size() > 5000) {
            ++this.noOfDBWritesForCrawlFileLimit;
            ArrayList<File> fileList2 = new ArrayList<File>();
            fileList2.addAll(this.backupImageList);
            logger.debug("Files to be inserted " + this.backupImageList.size());
            this.newBackupImageDAOImpl.insertListOfFileNamesIntoTable(fileList2);
            this.backupImageList.clear();
        }
        if (this.crawledFileList.size() > 5000) {
            logger.debug("Files to be inserted " + this.crawledFileList.size());
            ++this.noOfDBWritesForCrawlFileLimit;
            ArrayList<File> fileList3 = new ArrayList<File>();
            fileList3.addAll(this.crawledFileList);
            List backupTOs = ObjectUtils.createBackupElementForFiles(fileList3);
            this.newBackUpCrawlDAOImpl.insertListIntoTable(backupTOs);
            this.crawledFileList.clear();
            fileList3.clear();
        }
        BackupResultTO backupResult = new BackupResultTO();
        backupResult.setBackupImageList(this.backupImageList);
        backupResult.setCrawledFileList(this.crawledFileList);
        return backupResult;
    }

    public boolean isPotentialValidLink(File file) {
        int minimumLength = 100;
        boolean isPotentiallyValid = false;
        try (FileInputStream fis = new FileInputStream(file);){
            isPotentiallyValid = file.isFile() && file.getName().toLowerCase().endsWith(".lnk") && ((InputStream)fis).available() >= 100;
        }
        catch (IOException e) {
            logger.trace("" + e);
            logger.error("exception while reading file" + e.getMessage());
        }
        return isPotentiallyValid;
    }

    private boolean isParaBluAppDirectory(File currentProcessingFile) {
        boolean isAppDir = false;
        if (SettingHelper.getOsName().toLowerCase().contains("win")) {
            String paraBluDir = SettingHelper.getUserHome() + StringLiterals.FILE_SEPARATOR + "AppData" + StringLiterals.FILE_SEPARATOR + "Roaming" + StringLiterals.CONSTANTS_FILE_SEPARATOR + "ParaBlu";
            String paraBluDirNew = SettingHelper.getInstallationDir();
            if (currentProcessingFile.getAbsolutePath().toLowerCase().contains(paraBluDir.toLowerCase())) {
                isAppDir = true;
            }
            if (currentProcessingFile.getAbsolutePath().toLowerCase().contains(paraBluDirNew.toLowerCase())) {
                isAppDir = true;
            }
        }
        return isAppDir;
    }

    public static String rootDirectory() {
        return File.listRoots()[0].getAbsolutePath();
    }

    private boolean isFileToBeSkipped(String fileName, boolean includeExclusions) {
        String rootDirectory = NewBackUpJob.rootDirectory().toLowerCase();
        ArrayList<String> MacBackupFoldersToBeSkippedFromRoot1 = new ArrayList<String>();
        ArrayList<String> MacBackupFoldersToBeSkipped1 = new ArrayList<String>();
        if (FilesBeSkippedAsPerPolicy.isBackupSystemFilesEnabled() || !includeExclusions) {
            return false;
        }
        if (SettingHelper.getOsName().toLowerCase().contains("win")) {
            for (String folderPathElement : FilesBeSkippedAsPerPolicy.getRootexclusionfoldersFromPolicy()) {
                String currentFolder = fileName.toLowerCase();
                if (folderPathElement.startsWith("{") && folderPathElement.endsWith("}")) {
                    folderPathElement = folderPathElement.replaceAll("[{}]", "");
                }
                if (folderPathElement.contains(WIN)) {
                    folderPathElement = folderPathElement.replace(WIN, "");
                }
                if (folderPathElement.contains(SYSTEM_ROOT)) {
                    folderPathElement = folderPathElement.replace(SYSTEM_ROOT, System.getenv("SystemDrive"));
                }
                if (!currentFolder.startsWith(folderPathElement.toLowerCase()) && !currentFolder.equalsIgnoreCase(folderPathElement.toLowerCase())) continue;
                return true;
            }
        } else {
            for (String beSkipped : FilesBeSkippedAsPerPolicy.getRootexclusionfoldersFromPolicy()) {
                if (beSkipped.startsWith("{") && beSkipped.endsWith("}")) {
                    beSkipped = beSkipped.replaceAll("[{}]", "");
                }
                if (beSkipped.contains(MAC)) {
                    beSkipped = beSkipped.replace(MAC, "");
                }
                if (beSkipped.contains(SYSTEM_ROOT)) {
                    beSkipped = beSkipped.replace("system.root/", "");
                    MacBackupFoldersToBeSkippedFromRoot1.add(beSkipped);
                    continue;
                }
                MacBackupFoldersToBeSkipped1.add(beSkipped);
            }
            this.getMacFolderPathsToBeSkipped(rootDirectory, MacBackupFoldersToBeSkippedFromRoot1, MacBackupFoldersToBeSkipped1);
            for (String beSkipped : this.macBackupFoldersToBeSkippedList) {
                String currentFolder = fileName.toLowerCase();
                if (!currentFolder.equalsIgnoreCase(beSkipped.toLowerCase()) && !currentFolder.toLowerCase().startsWith(beSkipped.toLowerCase())) continue;
                return true;
            }
        }
        return false;
    }

    private String checkForMacBasePath(String completeParentPath) {
        String mac = "Macintosh";
        if (completeParentPath.startsWith("Macintosh" + StringLiterals.FILE_SEPARATOR)) {
            return completeParentPath.substring(9);
        }
        return completeParentPath;
    }

    private int getCrawlLimit() {
        if (!StringUtils.isEmpty((String)SettingHelper.getBackupCrawlLimit())) {
            logger.debug("returning crawl limit" + SettingHelper.getBackupCrawlLimit());
            return Integer.valueOf(SettingHelper.getBackupCrawlLimit());
        }
        return 500;
    }

    private String getConfiguredBackupFolders() {
        StringBuilder backupFolders = new StringBuilder("");
        if (!bkpFolderList.isEmpty()) {
            for (BackupFolderTO backupFolderTO : bkpFolderList) {
                backupFolders.append(backupFolderTO.getFolderPath()).append("; ");
            }
        }
        return backupFolders.toString();
    }

    private void getMacFolderPathsToBeSkipped(String rootDirectory, List<String> MacBackupFoldersToBeSkippedFromRoot1, List<String> MacBackupFoldersToBeSkipped1) {
        if (this.macBackupFoldersToBeSkippedList == null || this.macBackupFoldersToBeSkippedList.isEmpty()) {
            this.macBackupFoldersToBeSkippedList = new ArrayList<String>();
            File[] usersFolders = new File(new File(SettingHelper.getUserHome()).getParent()).listFiles();
            for (String beSkipped1 : MacBackupFoldersToBeSkipped1) {
                for (File userFolder : usersFolders) {
                    String userfolderBeSkipped = (userFolder.getAbsolutePath() + StringLiterals.FILE_SEPARATOR + beSkipped1).toLowerCase();
                    this.macBackupFoldersToBeSkippedList.add(userfolderBeSkipped);
                }
            }
            for (String beSkipped1 : MacBackupFoldersToBeSkippedFromRoot1) {
                String folderBeSkipped = (rootDirectory + beSkipped1).toLowerCase();
                this.macBackupFoldersToBeSkippedList.add(folderBeSkipped);
            }
        }
    }

    private void openNamedPipeNClose() {
        try {
            logger.debug("opening the named pipe...");
            RandomAccessFile pipe = new RandomAccessFile("\\\\.\\pipe\\ParabluSvcNAmedPipe", "rw");
            logger.debug("wait for one sec and close...");
            Thread.sleep(1000L);
            pipe.close();
        }
        catch (Exception e) {
            logger.error("Exception in open named pipe.." + e.getMessage());
        }
    }

    private boolean getValueForcaseCheck() {
        try {
            if (this.firstBackupStartTime == null) {
                return true;
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MMM-yyyy hh:mm:ss");
            Date parsedDate = dateFormat.parse(this.firstBackupStartTime);
            Timestamp timestamp = new Timestamp(parsedDate.getTime());
            Timestamp timeStamptoCheck = Timestamp.valueOf("2020-01-01 12:00:00");
            logger.debug("timestamp value for case check:" + timestamp.getTime() + "..time stamp to verify:" + timeStamptoCheck.getTime());
            this.isCasesensitiveFolderCheckEnabled = timestamp.after(timeStamptoCheck);
            logger.debug("first backup start time enabled and case check is:" + this.isCasesensitiveFolderCheckEnabled);
        }
        catch (Exception e) {
            logger.error("error getting the value from registry:" + e);
        }
        return true;
    }

    private Stream<Path> checkFolderAccessibility(String recivedCompleteParentPath, boolean skipException) {
        Stream<Path> files;
        block8: {
            files = null;
            try {
                recivedCompleteParentPath = this.checkForMacBasePath(recivedCompleteParentPath);
                Path path = Paths.get(recivedCompleteParentPath, new String[0]);
                files = Files.list(path);
                files.close();
            }
            catch (AccessDeniedException e) {
                logger.error("AccessDeniedException:Exception accessing folder:", (Throwable)e);
                if (skipException) {
                    logger.error("Error accessing the file/Folder:" + e.getMessage());
                    File currentProcessingFile = new File(recivedCompleteParentPath);
                    this.crawledFileList.add(currentProcessingFile);
                    this.backupImageList.add(currentProcessingFile);
                    failedFileLog.error("Error accessing the file/Folder:" + e.getMessage());
                }
                throw new CrawlAdapterException("Exception:" + e.getMessage());
            }
            catch (FileSystemException e) {
                logger.error("FileSystemException:Exception accessing folder:", (Throwable)e);
                if (!e.getMessage().contains("Operation not permitted")) break block8;
                if (skipException) {
                    logger.error("Error accessing the file/Folder:" + e.getMessage());
                    File currentProcessingFile = new File(recivedCompleteParentPath);
                    this.crawledFileList.add(currentProcessingFile);
                    this.backupImageList.add(currentProcessingFile);
                    failedFileLog.error("Error accessing the file/Folder:" + e.getMessage());
                }
                throw new CrawlAdapterException("Exception:" + e.getMessage());
            }
            catch (IOException e) {
                logger.error("Exception accessing folder:", (Throwable)e);
                if (!e.getMessage().contains("Operation not permitted")) break block8;
                if (skipException) {
                    File currentProcessingFile = new File(recivedCompleteParentPath);
                    this.crawledFileList.add(currentProcessingFile);
                    this.backupImageList.add(currentProcessingFile);
                    logger.error("Error accessing the file/Folder:" + e.getMessage());
                    failedFileLog.error("Error accessing the file/Folder:" + e.getMessage());
                }
                throw new CrawlAdapterException("Exception:" + e.getMessage());
            }
            catch (Exception e) {
                logger.error("Exception accessing folder:", (Throwable)e);
                failedFileLog.error("Error accessing the file/Folder:" + recivedCompleteParentPath);
            }
        }
        return files;
    }

    public abstract void deleteVsnapshot(List<BackupFolderTO> var1);

    public abstract boolean createVsnapshot(List<BackupFolderTO> var1);

    public abstract boolean runScripts(String var1, boolean var2);

    public abstract void startBackupPolicyRefresh();

    public abstract void updateSystrayToolTipNotification();

    public abstract boolean runCommandUsingService(String var1, String var2);
}

