/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.common.dao;

import com.parablu.epa.common.dao.BaseDAO;
import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.core.constant.BluSyncSQLConstants;
import com.parablu.epa.core.constant.StringLiterals;
import com.parablu.epa.core.dao.BackUpFolderDAO;
import com.parablu.epa.core.helper.ParabluStringUtils;
import com.parablu.epa.core.to.BackupFolderTO;
import com.parablu.epa.core.to.GatewayTO;
import com.parablu.epa.core.to.InclusionTO;
import com.parablu.epa.core.to.NWThrottlingTO;
import com.parablu.epa.core.to.ScheduleTO;
import com.parablu.epa.core.to.ScriptTo;
import com.parablu.epa.helper.utils.MD5Generator;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackUpFolderDAOImpl
extends BaseDAO
implements BackUpFolderDAO {
    private Logger logger = LoggerFactory.getLogger(BackUpFolderDAOImpl.class);
    private static final String DELETEFROM = "delete from ";
    private static final String SQLEXCEPTION_WHILE_CREATINGBACKUP = "SQLException while creating";
    private static final String SQLEXCEPTION_WHILE_INSERTING_PARENTFOLDER = "SQLException while inserting parent folder";
    private static final String VALUES = ") values(?,?);";
    private static final String VALUES_WITH_FOUR_PLACEHOLDERS = ") values(?,?,?,?);";
    private static final String VALUES_TWO_INPUTS = ") values(?,?);";
    private static final String DROP_TABLE = "drop table ";

    public BackUpFolderDAOImpl(String uRL) {
        super(uRL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean clearTable() {
        BackUpFolderDAOImpl backUpFolderDAOImpl = this;
        synchronized (backUpFolderDAOImpl) {
            String query = "delete from BKFT";
            boolean success = false;
            this.statement = null;
            if (this.getConnection()) {
                try {
                    this.statement = this.conn.prepareStatement("delete from BKFT");
                    this.statement.execute();
                    success = true;
                }
                catch (SQLException exception) {
                    this.logger.error("SQLException while deleting  from backp table", (Throwable)exception);
                }
                catch (RuntimeException e) {
                    this.logger.error("Runtime Exception...", (Object)e.getMessage());
                }
                finally {
                    this.closeConnection();
                }
            }
            return success;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createBackUpTable() {
        BackUpFolderDAOImpl backUpFolderDAOImpl = this;
        synchronized (backUpFolderDAOImpl) {
            String query = BluSyncSQLConstants.CREATE_BACKUP_FOLDER_TABLE_QUERY;
            boolean success = false;
            this.statement = null;
            if (this.getConnection()) {
                try {
                    this.statement = this.conn.prepareStatement(query);
                    this.statement.execute();
                    success = true;
                }
                catch (SQLException exception) {
                    this.logger.trace("" + exception);
                    this.logger.error("SQLException while creating Backup table ", (Object)exception.getMessage());
                }
                catch (RuntimeException e) {
                    this.logger.error("Runtime Exception...", (Object)e.getMessage());
                }
                finally {
                    this.closeConnection();
                }
            }
            return success;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createHashTable() {
        BackUpFolderDAOImpl backUpFolderDAOImpl = this;
        synchronized (backUpFolderDAOImpl) {
            String query = BluSyncSQLConstants.CREATE_HASH_TABLE_QUERY;
            boolean success = false;
            this.statement = null;
            if (this.getConnection()) {
                try {
                    this.statement = this.conn.prepareStatement(query);
                    this.statement.execute();
                    success = true;
                }
                catch (SQLException exception) {
                    exception.printStackTrace();
                    this.logger.trace("" + exception);
                    this.logger.error("SQLException while creating hash table", (Object)exception.getMessage());
                }
                catch (RuntimeException e) {
                    this.logger.error("Runtime Exception...", (Object)e.getMessage());
                }
                finally {
                    this.closeConnection();
                }
            }
            return success;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getInclusionExtensions() {
        BackUpFolderDAOImpl backUpFolderDAOImpl = this;
        synchronized (backUpFolderDAOImpl) {
            String query = "select * from INCLUSIONS";
            HashMap<String, String> filterMap = null;
            this.statement = null;
            ResultSet resultSet = null;
            if (this.getConnection()) {
                try {
                    this.statement = this.conn.prepareStatement("select * from INCLUSIONS");
                    resultSet = this.statement.executeQuery();
                    if (resultSet != null) {
                        filterMap = new HashMap<String, String>();
                        while (resultSet.next()) {
                            filterMap.put("extensionName", String.valueOf(resultSet.getString("extensionName")));
                            filterMap.put("filterType", resultSet.getString("filterType"));
                        }
                    }
                }
                catch (SQLException exception) {
                    this.logger.error("SQLException while selecting from Inclusions ", (Throwable)exception);
                }
                catch (RuntimeException e) {
                    this.logger.error("Runtime Exception...", (Object)e.getMessage());
                }
                finally {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (SQLException e) {
                            this.logger.error("SQLException while closing result set for geting Previous Image Table Name" + e);
                        }
                        catch (RuntimeException e) {
                            this.logger.error("Runtime Exception...", (Object)e.getMessage());
                        }
                    }
                    this.closeConnection();
                }
            }
            return filterMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BackupFolderTO> getAllFolderToBackUpFiles() {
        BackUpFolderDAOImpl backUpFolderDAOImpl = this;
        synchronized (backUpFolderDAOImpl) {
            String query = "select * from BKFT";
            ArrayList<BackupFolderTO> files = null;
            this.statement = null;
            ResultSet resultSet = null;
            if (this.getConnection()) {
                try {
                    this.statement = this.conn.prepareStatement("select * from BKFT");
                    resultSet = this.statement.executeQuery();
                    files = new ArrayList<BackupFolderTO>();
                    if (resultSet != null) {
                        while (resultSet.next()) {
                            BackupFolderTO backupFolderTO = new BackupFolderTO();
                            String filePath = resultSet.getString("completefolderpath");
                            long lastSyncTime = resultSet.getLong("lastBackup");
                            int id = resultSet.getInt("id");
                            String createdBy = resultSet.getString("createdBy");
                            String policyName = resultSet.getString("policyGroupName");
                            backupFolderTO.setFolderPath(filePath);
                            backupFolderTO.setLastSyncTime(lastSyncTime);
                            backupFolderTO.setId(id);
                            backupFolderTO.setCreateBy(createdBy);
                            backupFolderTO.setPolicyName(policyName);
                            files.add(backupFolderTO);
                        }
                    }
                }
                catch (SQLException exception) {
                    this.logger.error("SQLException while selcting from backup", (Throwable)exception);
                }
                catch (RuntimeException e) {
                    this.logger.error("Runtime Exception...", (Object)e.getMessage());
                }
                finally {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (SQLException e) {
                            this.logger.error("SQLException while closing result set for geting folders to backup" + e);
                        }
                        catch (RuntimeException e) {
                            this.logger.error("Runtime Exception...", (Object)e.getMessage());
                        }
                    }
                    this.closeConnection();
                }
            }
            return files;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insertAParentFolder(BackupFolderTO file) {
        BackUpFolderDAOImpl backUpFolderDAOImpl = this;
        synchronized (backUpFolderDAOImpl) {
            String query = "insert into BKFT(completefolderpath,lastBackup,createdBy,policyGroupName) values(?,?,?,?);";
            boolean success = false;
            this.statement = null;
            StringBuilder strBuilder = new StringBuilder();
            if (this.getConnection()) {
                try {
                    this.statement = this.conn.prepareStatement("insert into BKFT(completefolderpath,lastBackup,createdBy,policyGroupName) values(?,?,?,?);");
                    this.statement.setString(1, file.getFolderPath());
                    this.statement.setLong(2, file.getLastSyncTime());
                    this.statement.setString(3, file.getCreateBy());
                    this.statement.setString(4, file.getPolicyName());
                    this.statement.execute();
                    this.closeConnection();
                    this.setTableId(strBuilder, "BKFT");
                    success = true;
                }
                catch (SQLException exception) {
                    this.logger.error(SQLEXCEPTION_WHILE_INSERTING_PARENTFOLDER, (Throwable)exception);
                }
                catch (RuntimeException e) {
                    this.logger.error("Runtime Exception...", (Object)e.getMessage());
                }
                finally {
                    this.closeConnection();
                }
            }
            return success;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insertListOfBackupFolders(List<BackupFolderTO> backupFolderList) {
        BackUpFolderDAOImpl backUpFolderDAOImpl = this;
        synchronized (backUpFolderDAOImpl) {
            String query = "insert into BKFT(completefolderpath,lastBackup,createdBy,policyGroupName) values(?,?,?,?);";
            boolean success = false;
            this.statement = null;
            StringBuilder strBuilder = new StringBuilder();
            if (this.getConnection()) {
                try {
                    this.statement = this.conn.prepareStatement("insert into BKFT(completefolderpath,lastBackup,createdBy,policyGroupName) values(?,?,?,?);");
                    int listsize = backupFolderList.size();
                    this.logger.debug("backupFolderList......." + backupFolderList.size());
                    this.conn.setAutoCommit(false);
                    this.statement = this.conn.prepareStatement("insert into BKFT(completefolderpath,lastBackup,createdBy,policyGroupName) values(?,?,?,?);");
                    for (int recordCount = 0; recordCount < listsize; ++recordCount) {
                        this.statement.setString(1, backupFolderList.get(recordCount).getFolderPath());
                        this.statement.setLong(2, backupFolderList.get(recordCount).getLastSyncTime());
                        this.statement.setString(3, backupFolderList.get(recordCount).getCreateBy());
                        this.statement.setString(4, backupFolderList.get(recordCount).getPolicyName());
                        this.logger.debug("backupFolderList folderpath......." + backupFolderList.get(recordCount).getFolderPath());
                        this.statement.addBatch();
                        if (recordCount % 1000 != 0) continue;
                        this.logger.debug("Inside recordCount reach 1000...");
                        this.statement.executeBatch();
                        this.statement.clearBatch();
                    }
                    this.statement.executeBatch();
                    this.conn.commit();
                    this.closeConnection();
                    ParabluStringUtils.createCommaSeparatedStringForBackupFolderToList((StringBuilder)strBuilder, backupFolderList);
                    this.setTableId(strBuilder, "BKFT");
                    success = true;
                }
                catch (SQLException exception) {
                    this.logger.error("SQLException while inserting list of parent folders", (Throwable)exception);
                }
                catch (RuntimeException e) {
                    this.logger.error("Runtime Exception...", (Object)e.getMessage());
                }
                finally {
                    this.closeConnection();
                }
            }
            return success;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insertNetworkThrottling(NWThrottlingTO nwThrottlingTO) {
        BackUpFolderDAOImpl backUpFolderDAOImpl = this;
        synchronized (backUpFolderDAOImpl) {
            String query = "insert into NETWORKTHROTTLING(NTName,maxSpeed,uploadSpeed,downloadSpeed,startTime,endTime) values(?,?,?,?,?,?);";
            boolean success = false;
            this.statement = null;
            if (this.getConnection()) {
                try {
                    this.statement = this.conn.prepareStatement("insert into NETWORKTHROTTLING(NTName,maxSpeed,uploadSpeed,downloadSpeed,startTime,endTime) values(?,?,?,?,?,?);");
                    this.statement.setString(1, nwThrottlingTO.getNwName());
                    this.statement.setString(2, nwThrottlingTO.getMaxSpeed());
                    this.statement.setString(3, nwThrottlingTO.getUploadSpeed());
                    this.statement.setString(4, nwThrottlingTO.getDownloadSpeed());
                    this.statement.setString(5, nwThrottlingTO.getStartTime());
                    this.statement.setString(6, nwThrottlingTO.getEndTime());
                    this.statement.execute();
                    success = true;
                }
                catch (SQLException exception) {
                    this.logger.error(SQLEXCEPTION_WHILE_INSERTING_PARENTFOLDER, (Throwable)exception);
                }
                catch (RuntimeException e) {
                    this.logger.error("Runtime Exception...", (Object)e.getMessage());
                }
                finally {
                    this.closeConnection();
                }
            }
            return success;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insertSchedules(List<ScheduleTO> scheduleTOList) {
        BackUpFolderDAOImpl backUpFolderDAOImpl = this;
        synchronized (backUpFolderDAOImpl) {
            String query = "insert into SCHEDULES(scheduleName,startTime,dayArray,backupType,containerName) values(?,?,?,?,?);";
            boolean success = false;
            this.statement = null;
            StringBuilder strBuilder = new StringBuilder();
            if (this.getConnection()) {
                try {
                    this.statement = this.conn.prepareStatement("insert into SCHEDULES(scheduleName,startTime,dayArray,backupType,containerName) values(?,?,?,?,?);");
                    int listsize = scheduleTOList.size();
                    this.conn.setAutoCommit(false);
                    for (int recordCount = 0; recordCount < listsize; ++recordCount) {
                        this.statement.setString(1, scheduleTOList.get(recordCount).getScheduleName());
                        this.statement.setString(2, scheduleTOList.get(recordCount).getStartTime());
                        this.statement.setString(3, scheduleTOList.get(recordCount).getDayArray());
                        this.statement.setString(4, scheduleTOList.get(recordCount).getBackupType());
                        this.statement.setString(5, scheduleTOList.get(recordCount).getContainerName());
                        this.statement.addBatch();
                        if (recordCount % 1000 != 0) continue;
                        this.statement.executeBatch();
                        this.statement.clearBatch();
                    }
                    this.statement.executeBatch();
                    this.conn.commit();
                    this.closeConnection();
                    ParabluStringUtils.createCommaSeparatedStringForScheduleTOList((StringBuilder)strBuilder, scheduleTOList);
                    this.setTableId(strBuilder, "SCHEDULES");
                    success = true;
                }
                catch (SQLException exception) {
                    this.logger.error("SQLException while inserting Schedules", (Throwable)exception);
                }
                catch (RuntimeException e) {
                    this.logger.error("Runtime Exception...", (Object)e.getMessage());
                }
                finally {
                    this.closeConnection();
                }
            }
            return success;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insertInclusions(List<InclusionTO> inclusionTOList) {
        BackUpFolderDAOImpl backUpFolderDAOImpl = this;
        synchronized (backUpFolderDAOImpl) {
            String query = "insert into INCLUSIONS(filterName,extensionName,policyGroupName,filterType) values(?,?,?,?);";
            boolean success = false;
            this.statement = null;
            StringBuilder strBuilder = new StringBuilder();
            if (this.getConnection()) {
                try {
                    this.statement = this.conn.prepareStatement("insert into INCLUSIONS(filterName,extensionName,policyGroupName,filterType) values(?,?,?,?);");
                    int listsize = inclusionTOList.size();
                    this.conn.setAutoCommit(false);
                    for (int recordCount = 0; recordCount < listsize; ++recordCount) {
                        this.statement.setString(1, inclusionTOList.get(recordCount).getFilterName());
                        this.statement.setString(2, inclusionTOList.get(recordCount).getExtensionName());
                        this.statement.setString(3, inclusionTOList.get(recordCount).getPolicyName());
                        this.statement.setString(4, inclusionTOList.get(recordCount).getFilterType());
                        this.statement.addBatch();
                        if (recordCount % 1000 != 0) continue;
                        this.statement.executeBatch();
                        this.statement.clearBatch();
                    }
                    this.statement.executeBatch();
                    this.conn.commit();
                    this.closeConnection();
                    ParabluStringUtils.createCommaSeparatedStringForInclusionTOList((StringBuilder)strBuilder, inclusionTOList);
                    this.setTableId(strBuilder, "INCLUSIONS");
                    success = true;
                }
                catch (SQLException exception) {
                    this.logger.error(SQLEXCEPTION_WHILE_INSERTING_PARENTFOLDER, (Throwable)exception);
                }
                catch (RuntimeException e) {
                    this.logger.error("Runtime Exception...", (Object)e.getMessage());
                }
                finally {
                    this.closeConnection();
                }
            }
            return success;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insertListOfParentFoldersToTable(List<BackupFolderTO> files) {
        BackUpFolderDAOImpl backUpFolderDAOImpl = this;
        synchronized (backUpFolderDAOImpl) {
            String query = "insert into BKFT(completefolderpath,lastBackup) values(?,?);";
            boolean success = false;
            this.statement = null;
            if (this.getConnection()) {
                try {
                    this.statement = this.conn.prepareStatement("insert into BKFT(completefolderpath,lastBackup) values(?,?);");
                    int listsize = files.size();
                    this.conn.setAutoCommit(false);
                    for (int recordCount = 0; recordCount < listsize; ++recordCount) {
                        this.statement.setString(1, files.get(recordCount).getFolderPath());
                        this.statement.setLong(2, files.get(recordCount).getLastSyncTime());
                        this.statement.addBatch();
                        if (recordCount % 1000 != 0) continue;
                        this.statement.executeBatch();
                        this.statement.clearBatch();
                    }
                    this.statement.executeBatch();
                    this.conn.commit();
                    success = true;
                }
                catch (SQLException exception) {
                    this.logger.error("SQLException while inserting list of parent folders", (Throwable)exception);
                }
                catch (RuntimeException e) {
                    this.logger.error("Runtime Exception...", (Object)e.getMessage());
                }
                finally {
                    this.closeConnection();
                }
            }
            return success;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAParentFolder(BackupFolderTO file) {
        BackUpFolderDAOImpl backUpFolderDAOImpl = this;
        synchronized (backUpFolderDAOImpl) {
            String query = "delete from BKFT where completefolderpath= ?;";
            String query2 = "delete from BKIT where filepath like ? or filepath like ?;";
            boolean success = false;
            this.statement = null;
            Statement statement2 = null;
            if (this.getConnection()) {
                try {
                    this.conn.setAutoCommit(false);
                    this.statement = this.conn.prepareStatement("delete from BKFT where completefolderpath= ?;");
                    this.statement.setString(1, file.getFolderPath());
                    this.statement.execute();
                    statement2 = this.conn.prepareStatement("delete from BKIT where filepath like ? or filepath like ?;");
                    statement2.setString(1, file.getFolderPath());
                    statement2.setString(2, file.getFolderPath() + StringLiterals.FILE_SEPARATOR + "%");
                    statement2.execute();
                    this.conn.commit();
                    success = true;
                }
                catch (SQLException exception) {
                    this.logger.trace("" + exception);
                    this.logger.error("SQLException while deleting parent folder", (Object)exception.getMessage());
                }
                catch (RuntimeException e) {
                    this.logger.error("Runtime Exception...", (Object)e.getMessage());
                }
                finally {
                    if (statement2 != null) {
                        try {
                            statement2.close();
                        }
                        catch (SQLException e) {
                            this.logger.trace("" + e);
                            this.logger.error("SQLException while deleting parent folder", (Object)e.getMessage());
                        }
                        catch (RuntimeException e) {
                            this.logger.error("Runtime Exception...", (Object)e.getMessage());
                        }
                    }
                    this.closeConnection();
                }
            }
            return success;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeListOfFolderFromTable(List<BackupFolderTO> files) {
        BackUpFolderDAOImpl backUpFolderDAOImpl = this;
        synchronized (backUpFolderDAOImpl) {
            String query = "delete from BKFT where completefolderpath=?;";
            boolean success = false;
            this.statement = null;
            if (this.getConnection()) {
                try {
                    this.statement = this.conn.prepareStatement("delete from BKFT where completefolderpath=?;");
                    int listsize = files.size();
                    this.conn.setAutoCommit(false);
                    for (int recordCount = 0; recordCount < listsize; ++recordCount) {
                        this.statement.setString(1, files.get(recordCount).getFolderPath());
                        this.statement.addBatch();
                        if (recordCount % 1000 != 0) continue;
                        this.statement.executeBatch();
                        this.statement.clearBatch();
                    }
                    this.statement.executeBatch();
                    this.conn.commit();
                    success = true;
                }
                catch (SQLException exception) {
                    this.logger.error("SQLException while removeListOfFolderFromTable", (Throwable)exception);
                }
                catch (RuntimeException e) {
                    this.logger.error("Runtime Exception...", (Object)e.getMessage());
                }
                finally {
                    this.closeConnection();
                }
            }
            return success;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAll(List<BackupFolderTO> files) {
        BackUpFolderDAOImpl backUpFolderDAOImpl = this;
        synchronized (backUpFolderDAOImpl) {
            String query = "update BKFT set lastBackup=? where id=?;";
            this.statement = null;
            if (this.getConnection()) {
                try {
                    this.statement = this.conn.prepareStatement("update BKFT set lastBackup=? where id=?;");
                    int listsize = files.size();
                    this.conn.setAutoCommit(false);
                    for (int recordCount = 0; recordCount < listsize; ++recordCount) {
                        this.statement.setLong(1, files.get(recordCount).getLastSyncTime());
                        this.statement.setInt(2, files.get(recordCount).getId());
                        this.statement.addBatch();
                        if (recordCount % 1000 != 0) continue;
                        this.statement.executeBatch();
                        this.statement.clearBatch();
                    }
                    this.statement.executeBatch();
                    this.conn.commit();
                }
                catch (SQLException exception) {
                    this.logger.error("SQLException while updateAll", (Throwable)exception);
                }
                catch (RuntimeException e) {
                    this.logger.error("Runtime Exception...", (Object)e.getMessage());
                }
                finally {
                    this.closeConnection();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insertGatewayNames(List<GatewayTO> gatewayTOList) {
        BackUpFolderDAOImpl backUpFolderDAOImpl = this;
        synchronized (backUpFolderDAOImpl) {
            String query = "insert into GATEWAYLIST(GatewayName,Type,policyGroupName,ProductType) values(?,?,?,?);";
            boolean success = false;
            this.statement = null;
            StringBuilder strBuilder = new StringBuilder();
            if (this.getConnection()) {
                try {
                    this.statement = this.conn.prepareStatement("insert into GATEWAYLIST(GatewayName,Type,policyGroupName,ProductType) values(?,?,?,?);");
                    int listsize = gatewayTOList.size();
                    this.conn.setAutoCommit(false);
                    for (int recordCount = 0; recordCount < listsize; ++recordCount) {
                        this.statement.setString(1, gatewayTOList.get(recordCount).getGatewayName());
                        this.statement.setString(2, gatewayTOList.get(recordCount).getType());
                        this.statement.setString(3, gatewayTOList.get(recordCount).getPolicyName());
                        this.statement.setString(4, gatewayTOList.get(recordCount).getProductType());
                        this.statement.addBatch();
                        if (recordCount % 1000 != 0) continue;
                        this.statement.executeBatch();
                        this.statement.clearBatch();
                    }
                    this.statement.executeBatch();
                    this.conn.commit();
                    this.closeConnection();
                    ParabluStringUtils.createCommaSeparatedGatewayTOList((StringBuilder)strBuilder, gatewayTOList);
                    this.setTableId(strBuilder, "GATEWAYLIST");
                    success = true;
                }
                catch (SQLException exception) {
                    this.logger.error("SQLException while insert parent folder", (Throwable)exception);
                }
                catch (RuntimeException e) {
                    this.logger.error("Runtime Exception...", (Object)e.getMessage());
                }
                finally {
                    this.closeConnection();
                }
            }
            return success;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setTableId(StringBuilder stringBuilder, String tableName) throws SQLException {
        BackUpFolderDAOImpl backUpFolderDAOImpl = this;
        synchronized (backUpFolderDAOImpl) {
            boolean success;
            block12: {
                String stringToEncrypt = SettingHelper.getDeviceUUId() + "," + stringBuilder.toString();
                String shaValue = MD5Generator.getSHA1hash((String)stringToEncrypt);
                this.logger.debug("String of policyyyyy............" + stringToEncrypt + "\nsha value:" + shaValue);
                success = false;
                try {
                    String query = "insert into TableIDs(TableName,tableId) values(?,?);";
                    this.statement = null;
                    if (!this.getConnection()) break block12;
                    try {
                        this.statement = this.conn.prepareStatement("insert into TableIDs(TableName,tableId) values(?,?);");
                        this.statement.setString(1, tableName);
                        this.statement.setString(2, shaValue);
                        this.statement.execute();
                        this.statement.close();
                        success = true;
                    }
                    catch (SQLException e) {
                        this.logger.error("SQLException while Detaching Image Table", (Throwable)e);
                    }
                    catch (RuntimeException e) {
                        this.logger.error("Runtime Exception...", (Object)e.getMessage());
                    }
                    finally {
                        this.closeConnection();
                    }
                }
                catch (Exception e) {
                    this.logger.error("Error in getting the  connection ", (Throwable)e);
                }
            }
            return success;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateHitTime(GatewayTO gatewayTO) {
        BackUpFolderDAOImpl backUpFolderDAOImpl = this;
        synchronized (backUpFolderDAOImpl) {
            String query = "update GATEWAYLIST set HitTime=? where GatewayName=?;";
            this.statement = null;
            if (this.getConnection()) {
                try {
                    this.statement = this.conn.prepareStatement("update GATEWAYLIST set HitTime=? where GatewayName=?;");
                    this.conn.setAutoCommit(false);
                    this.statement.setLong(1, gatewayTO.getHitTime());
                    this.statement.setString(2, gatewayTO.getGatewayName());
                    this.statement.addBatch();
                    this.statement.executeBatch();
                    this.conn.commit();
                }
                catch (SQLException exception) {
                    this.logger.error("SQLException while updating Privacy gateway", (Throwable)exception);
                }
                catch (RuntimeException e) {
                    this.logger.error("Runtime Exception...", (Object)e.getMessage());
                }
                finally {
                    this.closeConnection();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createCalloutScriptTable() {
        BackUpFolderDAOImpl backUpFolderDAOImpl = this;
        synchronized (backUpFolderDAOImpl) {
            String query = BluSyncSQLConstants.CREATE_CALLOUT_SCRIPT_TABLE_QUERY;
            boolean success = false;
            this.statement = null;
            if (this.getConnection()) {
                try {
                    this.statement = this.conn.prepareStatement(query);
                    this.statement.execute();
                    success = true;
                }
                catch (SQLException exception) {
                    this.logger.trace("" + exception);
                    this.logger.error(SQLEXCEPTION_WHILE_CREATINGBACKUP, (Object)exception.getMessage());
                }
                catch (RuntimeException e) {
                    this.logger.error("Runtime Exception...", (Object)e.getMessage());
                }
                finally {
                    this.closeConnection();
                }
            }
            return success;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insertScripts(ScriptTo scriptTo) {
        BackUpFolderDAOImpl backUpFolderDAOImpl = this;
        synchronized (backUpFolderDAOImpl) {
            String query = "insert into SCRIPTS(scriptname,type,arguments,timestamp) values(?,?,?,?);";
            boolean success = false;
            this.statement = null;
            if (this.getConnection()) {
                try {
                    this.statement = this.conn.prepareStatement("insert into SCRIPTS(scriptname,type,arguments,timestamp) values(?,?,?,?);");
                    this.statement.setString(1, scriptTo.getScriptName());
                    this.statement.setString(2, scriptTo.getScriptType());
                    this.statement.setString(3, scriptTo.getScriptArgs().toString());
                    this.statement.setString(4, scriptTo.getScriptTimestamp());
                    this.statement.execute();
                    success = true;
                }
                catch (SQLException exception) {
                    this.logger.error(SQLEXCEPTION_WHILE_INSERTING_PARENTFOLDER, (Throwable)exception);
                }
                catch (RuntimeException e) {
                    this.logger.error("Runtime Exception...", (Object)e.getMessage());
                }
                finally {
                    this.closeConnection();
                }
            }
            return success;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createFullBackupScheduleTable() {
        BackUpFolderDAOImpl backUpFolderDAOImpl = this;
        synchronized (backUpFolderDAOImpl) {
            String query = BluSyncSQLConstants.CREATE_FULL_BACKUP_SCHEDULES_TABLE_QUERY;
            boolean success = false;
            this.statement = null;
            if (this.getConnection()) {
                try {
                    this.statement = this.conn.prepareStatement(query);
                    this.statement.execute();
                    success = true;
                }
                catch (SQLException exception) {
                    this.logger.trace("" + exception);
                    this.logger.error(SQLEXCEPTION_WHILE_CREATINGBACKUP, (Object)exception.getMessage());
                }
                catch (RuntimeException e) {
                    this.logger.error("Runtime Exception...", (Object)e.getMessage());
                }
                finally {
                    this.closeConnection();
                }
            }
            return success;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insertFullBackupSchedule(String scriptSchedules) {
        BackUpFolderDAOImpl backUpFolderDAOImpl = this;
        synchronized (backUpFolderDAOImpl) {
            String query = "insert into SCRIPTSCHEDULE (id , schedules) values(?,?);";
            boolean success = false;
            this.statement = null;
            if (this.getConnection()) {
                try {
                    this.statement = this.conn.prepareStatement("insert into SCRIPTSCHEDULE (id , schedules) values(?,?);");
                    this.statement.setInt(1, 1);
                    this.statement.setString(2, scriptSchedules);
                    success = this.statement.execute();
                }
                catch (SQLException exception) {
                    this.logger.trace("" + exception);
                    this.logger.error(SQLEXCEPTION_WHILE_INSERTING_PARENTFOLDER, (Object)exception.getMessage());
                }
                catch (RuntimeException e) {
                    this.logger.error("Runtime Exception...", (Object)e.getMessage());
                }
                finally {
                    this.closeConnection();
                }
            }
            return success;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getHashValueFoeTable(String tableName) {
        String query = "select tableId from TableIDs where TableName = \"" + tableName + "\";";
        BackUpFolderDAOImpl backUpFolderDAOImpl = this;
        synchronized (backUpFolderDAOImpl) {
            this.logger.debug("Query>>>>>>" + query + "  tableName" + tableName);
            String hashValue = null;
            ResultSet resultSet = null;
            boolean gotConnection = this.getConnection();
            if (gotConnection) {
                try {
                    this.statement = this.conn.prepareStatement(query);
                    resultSet = this.statement.executeQuery();
                    while (resultSet != null && resultSet.next()) {
                        hashValue = resultSet.getString("tableId");
                        this.logger.debug(" hash value for table " + tableName + " is:" + hashValue);
                    }
                }
                catch (SQLException e) {
                    this.logger.trace("" + e);
                    this.logger.error("Exception wile getting table id:" + e.getMessage());
                }
                catch (RuntimeException e) {
                    this.logger.error("Runtime Exception...", (Object)e.getMessage());
                }
                finally {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (SQLException e) {
                            this.logger.error("Exception while getting table id:" + e);
                        }
                        catch (RuntimeException e) {
                            this.logger.error("Runtime Exception...", (Object)e.getMessage());
                        }
                    }
                    this.closeConnection();
                }
            }
            return hashValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dropTable() {
        BackUpFolderDAOImpl backUpFolderDAOImpl = this;
        synchronized (backUpFolderDAOImpl) {
            String query = "drop table BKFT";
            boolean success = false;
            this.statement = null;
            if (this.getConnection()) {
                try {
                    this.statement = this.conn.prepareStatement("drop table BKFT");
                    this.statement.execute();
                    success = true;
                }
                catch (SQLException exception) {
                    this.logger.error("SQLException while dropping   backup table", (Throwable)exception);
                }
                catch (RuntimeException e) {
                    this.logger.error("Runtime Exception...", (Object)e.getMessage());
                }
                finally {
                    this.closeConnection();
                }
            }
            return success;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean alterTable() {
        BackUpFolderDAOImpl backUpFolderDAOImpl = this;
        synchronized (backUpFolderDAOImpl) {
            this.statement = null;
            boolean success = false;
            if (this.getConnection()) {
                try {
                    this.statement = this.conn.prepareStatement("ALTER table BKFT ADD COLUMN policyGroupName TEXT;");
                    this.statement.execute();
                    this.statement.close();
                }
                catch (SQLException e) {
                    this.logger.trace("" + e);
                    this.logger.info("ALTER table TABLE_NAME_SCHEDULES ADD COLUMN COLUMN_BP_GROUP_NAME" + e.getMessage());
                }
                catch (RuntimeException e) {
                    this.logger.error("Runtime Exception...", (Object)e.getMessage());
                }
                return true;
            }
            return success;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insertIntoExceptionsToExclusions(List<BackupFolderTO> exceptionsToExclusionFolderList) {
        BackUpFolderDAOImpl backUpFolderDAOImpl = this;
        synchronized (backUpFolderDAOImpl) {
            this.statement = null;
            String query = "insert into exceptionsToExclusions(completefolderpath,lastBackup,createdBy,policyGroupName) values(?,?,?,?);";
            boolean result = false;
            StringBuilder strBuilder = new StringBuilder();
            if (this.getConnection()) {
                try {
                    this.statement = this.conn.prepareStatement(query);
                    int listsize = exceptionsToExclusionFolderList.size();
                    this.logger.debug("exceptionsToExclusionFolderList......." + exceptionsToExclusionFolderList.size());
                    this.conn.setAutoCommit(false);
                    this.statement = this.conn.prepareStatement(query);
                    for (int recordCount = 0; recordCount < listsize; ++recordCount) {
                        this.statement.setString(1, exceptionsToExclusionFolderList.get(recordCount).getFolderPath());
                        this.statement.setLong(2, exceptionsToExclusionFolderList.get(recordCount).getLastSyncTime());
                        this.statement.setString(3, exceptionsToExclusionFolderList.get(recordCount).getCreateBy());
                        this.statement.setString(4, exceptionsToExclusionFolderList.get(recordCount).getPolicyName());
                        this.logger.debug("backupFolderList folderpath......." + exceptionsToExclusionFolderList.get(recordCount).getFolderPath());
                        this.statement.addBatch();
                        if (recordCount % 1000 != 0) continue;
                        this.logger.debug("Inside recordCount reach 1000...");
                        this.statement.executeBatch();
                        this.statement.clearBatch();
                    }
                    this.statement.executeBatch();
                    this.conn.commit();
                    this.closeConnection();
                    ParabluStringUtils.createCommaSeparatedExceptionsToExclusionList((StringBuilder)strBuilder, exceptionsToExclusionFolderList);
                    this.setTableId(strBuilder, "exceptionsToExclusions");
                    result = true;
                }
                catch (Exception e) {
                    this.logger.error(SQLEXCEPTION_WHILE_INSERTING_PARENTFOLDER, (Object)e.getMessage());
                }
                finally {
                    this.closeConnection();
                }
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BackupFolderTO> getAllExceptionsToExclusions() {
        BackUpFolderDAOImpl backUpFolderDAOImpl = this;
        synchronized (backUpFolderDAOImpl) {
            String query = "select * from exceptionsToExclusions";
            ArrayList<BackupFolderTO> files = null;
            this.statement = null;
            ResultSet resultSet = null;
            if (this.getConnection()) {
                try {
                    this.statement = this.conn.prepareStatement("select * from exceptionsToExclusions");
                    resultSet = this.statement.executeQuery();
                    files = new ArrayList<BackupFolderTO>();
                    if (resultSet != null) {
                        while (resultSet.next()) {
                            BackupFolderTO backupFolderTO = new BackupFolderTO();
                            String filePath = resultSet.getString("completefolderpath");
                            long lastSyncTime = resultSet.getLong("lastBackup");
                            int id = resultSet.getInt("id");
                            String createdBy = resultSet.getString("createdBy");
                            String policyName = resultSet.getString("policyGroupName");
                            backupFolderTO.setFolderPath(filePath);
                            backupFolderTO.setLastSyncTime(lastSyncTime);
                            backupFolderTO.setId(id);
                            backupFolderTO.setCreateBy(createdBy);
                            backupFolderTO.setPolicyName(policyName);
                            files.add(backupFolderTO);
                        }
                    }
                }
                catch (SQLException exception) {
                    this.logger.error("SQLException while selcting from backup", (Throwable)exception);
                }
                catch (RuntimeException e) {
                    this.logger.error("Runtime Exception...", (Object)e.getMessage());
                }
                finally {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (SQLException e) {
                            this.logger.error("SQLException while closing result set for geting folders to backup" + e);
                        }
                        catch (RuntimeException e) {
                            this.logger.error("Runtime Exception...", (Object)e.getMessage());
                        }
                    }
                    this.closeConnection();
                }
            }
            return files;
        }
    }
}

