/*
 * Decompiled with CFR 0.152.
 */
package com.pg.dao.impl;

import com.pg.dao.BackupLogsDao;
import com.pg.domain.BackupLog;
import com.pg.factory.BlukryptMongoFactoryUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;

public class BackupLogsDaoImpl
implements BackupLogsDao {
    private static Logger logger = LoggerFactory.getLogger(BackupLogsDaoImpl.class);
    BlukryptMongoFactoryUtils blukryptMongoFactoryUtils;

    public BlukryptMongoFactoryUtils getBlukryptMongoFactoryUtils() {
        return this.blukryptMongoFactoryUtils;
    }

    public void setBlukryptMongoFactoryUtils(BlukryptMongoFactoryUtils blukryptMongoFactoryUtils) {
        this.blukryptMongoFactoryUtils = blukryptMongoFactoryUtils;
    }

    @Override
    public void saveBackupLog(int cloudId, String cloudName, BackupLog backupLog) {
        Criteria criteria = Criteria.where((String)"id").is((Object)backupLog.getId());
        Query query = new Query((CriteriaDefinition)criteria);
        this.getBackupLogforId(cloudId, backupLog);
        Update update = new Update();
        update.set("restartId", (Object)backupLog.getRestartId());
        update.set("failedFiles", backupLog.getFailedFiles());
        update.set("deviceUUID", (Object)backupLog.getDeviceUUID());
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.upsert(query, update, BackupLog.class);
    }

    private void getBackupLogforId(int cloudId, BackupLog backupLog) {
        Criteria criteria = Criteria.where((String)"id").is((Object)backupLog.getId());
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        BackupLog backupLog2 = (BackupLog)mongoTemplate.findOne(query, BackupLog.class);
        if (backupLog2 != null) {
            backupLog.getFailedFiles().addAll(backupLog2.getFailedFiles());
        }
    }
}

