/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pcbd.dao.impl;

import com.parablu.pcbd.dao.PciAuthorizationTokensDao;
import com.parablu.pcbd.domain.CloudStorageType;
import com.parablu.pcbd.domain.MSGTokens;
import com.parablu.pcbd.domain.PciAuthorizationTokens;
import com.parablu.pcbd.domain.User;
import com.pg.factory.BlukryptMongoFactoryUtils;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.List;
import java.util.regex.Pattern;
import org.bson.types.ObjectId;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;

public class PciAuthorizationTokensDaoImpl
implements PciAuthorizationTokensDao {
    private static Logger logger = LoggerFactory.getLogger(PciAuthorizationTokensDaoImpl.class);
    private static final String TOKEN_URL = "https://login.windows.net/common/oauth2/token";
    private static final String UTF_8 = "UTF-8";
    private static final String REFRESH_TOKEN = "refresh_token";
    public static final String CONTENT_TYPE = "Content-Type";
    private static final String EXCEPTION = " Exception  :";
    BlukryptMongoFactoryUtils blukryptMongoFactoryUtils;

    public BlukryptMongoFactoryUtils getBlukryptMongoFactoryUtils() {
        return this.blukryptMongoFactoryUtils;
    }

    public void setBlukryptMongoFactoryUtils(BlukryptMongoFactoryUtils blukryptMongoFactoryUtils) {
        this.blukryptMongoFactoryUtils = blukryptMongoFactoryUtils;
    }

    @Override
    public void savePciAuthorizationTokens(int cloudId, String cloudName, PciAuthorizationTokens pciAuthorizationTokens) {
        this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId).save((Object)pciAuthorizationTokens);
    }

    @Override
    public PciAuthorizationTokens getPciAuthorizationTokensForUserId(int cloudId, String cloudName, ObjectId userId) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"userId").is((Object)userId));
        return (PciAuthorizationTokens)this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId).findOne(query, PciAuthorizationTokens.class);
    }

    @Override
    public void saveCloudStorageType(int cloudId, String cloudName, CloudStorageType cloudStorageType) {
        this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId).save((Object)cloudStorageType);
    }

    @Override
    public CloudStorageType getCloudStorageTypeByName(int cloudId, String cloudName, String name) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"name").is((Object)name));
        return (CloudStorageType)this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId).findOne(query, CloudStorageType.class);
    }

    @Override
    public PciAuthorizationTokens getPciAuthorizationTokensForServiceAccount(int cloudId, String cloudName) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"serviceAccount").is((Object)true));
        return (PciAuthorizationTokens)this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId).findOne(query, PciAuthorizationTokens.class);
    }

    @Override
    public List<PciAuthorizationTokens> getAllPciAuthorizationTokens(int cloudId, String cloudName) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.findAll(PciAuthorizationTokens.class);
    }

    @Override
    public void deletePciAuthorizationTokensForUserId(int cloudId, String cloudName, ObjectId userId) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"userId").is((Object)userId));
        this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId).remove(query, PciAuthorizationTokens.class);
    }

    @Override
    public void updatePciAuthorizationTokensForUserId(int cloudId, String cloudName, ObjectId userId, String accessToken, String refreshToken) {
        Criteria criteria = Criteria.where((String)"userId").is((Object)userId);
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("accessToken", (Object)accessToken);
        update.set("refreshToken", (Object)refreshToken);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.updateFirst(query, update, PciAuthorizationTokens.class);
    }

    @Override
    public PciAuthorizationTokens getPciAuthorizationTokensForUserName(int cloudId, String userName) {
        PciAuthorizationTokens pciAuthorizationTokens = null;
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"userName").regex(Pattern.compile("^" + userName + "$", 2)), criteria.orOperator(new Criteria[]{Criteria.where((String)"deleted").is((Object)false), Criteria.where((String)"deleted").exists(false)})});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        User user = (User)paracloudMongoTemplate.findOne(query, User.class);
        if (user != null) {
            query = new Query((CriteriaDefinition)Criteria.where((String)"userId").is((Object)user.getUserId()));
            pciAuthorizationTokens = (PciAuthorizationTokens)this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId).findOne(query, PciAuthorizationTokens.class);
        }
        return pciAuthorizationTokens;
    }

    @Override
    public String getAccessTokenForODBBackup(int cloudId) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        MSGTokens msgToken = (MSGTokens)mongoTemplate.findOne(new Query(), MSGTokens.class);
        String accessToken = null;
        if (msgToken != null) {
            accessToken = msgToken.getAccessToken();
        }
        return accessToken;
    }

    @Override
    public String updateTokenForODBBackup(int cloudId) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        MSGTokens msgToken = (MSGTokens)mongoTemplate.findOne(new Query(), MSGTokens.class);
        if (msgToken == null) {
            logger.error("....no token available.........");
            return "";
        }
        String accessToken = "";
        String refreshToken = "";
        URL url = null;
        URLConnection conn = null;
        String data = null;
        logger.debug("  getAccessToken............HttpURLConnection.............................");
        try {
            String line;
            data = URLEncoder.encode("grant_type", UTF_8) + "=" + URLEncoder.encode(REFRESH_TOKEN, UTF_8);
            data = data + "&" + URLEncoder.encode(REFRESH_TOKEN, UTF_8) + "=" + URLEncoder.encode(msgToken.getRefreshToken(), UTF_8);
            data = data + "&" + URLEncoder.encode("client_id", UTF_8) + "=" + URLEncoder.encode(msgToken.getClientId(), UTF_8);
            data = data + "&" + URLEncoder.encode("client_secret", UTF_8) + "=" + URLEncoder.encode(msgToken.getClientSecret(), UTF_8);
            url = new URL(TOKEN_URL);
            conn = url.openConnection();
            conn.setDoOutput(true);
            conn.setConnectTimeout(1800000);
            OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());
            wr.write(data);
            wr.flush();
            HttpURLConnection connection = (HttpURLConnection)conn;
            if (connection.getResponseCode() == 400) {
                logger.error("TOKEN has expired for user ...... ");
                return "";
            }
            BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            StringBuilder response = new StringBuilder("");
            while ((line = rd.readLine()) != null) {
                response.append(line);
            }
            wr.close();
            rd.close();
            JSONObject jsonObject = new JSONObject(response.toString());
            accessToken = jsonObject.optString("access_token");
            refreshToken = jsonObject.optString(REFRESH_TOKEN);
            logger.debug("....got token.... " + accessToken);
            this.updateMSGToken(cloudId, accessToken, refreshToken);
        }
        catch (Exception e) {
            logger.error("...unable to update access token........." + e.getMessage());
        }
        return accessToken;
    }

    private void updateMSGToken(int cloudId, String accessToken, String refreshToken) {
        Query query = new Query();
        Update update = new Update();
        update.set("accessToken", (Object)accessToken);
        update.set("refreshToken", (Object)refreshToken);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.updateFirst(query, update, MSGTokens.class);
    }

    @Override
    public MSGTokens getMSGTokens(int cloudId) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (MSGTokens)mongoTemplate.findOne(new Query(), MSGTokens.class);
    }
}

