/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pcbd.dao.impl;

import com.parablu.pcbd.dao.DeleteExternalStorageDao;
import com.parablu.pcbd.domain.DeletedBackUpImage;
import com.pg.factory.BlukryptMongoFactoryUtils;
import java.util.List;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;

public class DeleteExternalStorageDaoImpl
implements DeleteExternalStorageDao {
    BlukryptMongoFactoryUtils blukryptMongoFactoryUtils;

    public BlukryptMongoFactoryUtils getBlukryptMongoFactoryUtils() {
        return this.blukryptMongoFactoryUtils;
    }

    public void setBlukryptMongoFactoryUtils(BlukryptMongoFactoryUtils blukryptMongoFactoryUtils) {
        this.blukryptMongoFactoryUtils = blukryptMongoFactoryUtils;
    }

    @Override
    public void saveImageToBackUpDao(int cloudId, String cloudName, DeletedBackUpImage backUpImage) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.save((Object)backUpImage);
    }

    @Override
    public List<DeletedBackUpImage> getAllDeletedBackupImages(int cloudId) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.findAll(DeletedBackUpImage.class);
    }

    @Override
    public void insertBackupFileForDeletion(int cloudId, String chunkFileName, String userName, String md5) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        DeletedBackUpImage backUpImage = new DeletedBackUpImage();
        backUpImage.setFileName(chunkFileName);
        backUpImage.setUserName(userName);
        backUpImage.setMd5(md5);
        mongoTemplate.save((Object)backUpImage);
    }

    @Override
    public void deleteBackupFile(int cloudId, DeletedBackUpImage backUpImage) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)backUpImage.getId())});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.remove(query, DeletedBackUpImage.class);
    }
}

