/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pcbd.dao.impl;

import com.parablu.pcbd.dao.BackupOverViewDao;
import com.parablu.pcbd.domain.BackupOverView;
import com.parablu.pcbd.domain.DeviceBackupOverView;
import com.parablu.pcbd.domain.LatestDeviceBackupInfo;
import com.pg.factory.BlukryptMongoFactoryUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;

public class BackupOverViewDaoImpl
implements BackupOverViewDao {
    private static Logger logger = LoggerFactory.getLogger(BackupOverViewDaoImpl.class);
    BlukryptMongoFactoryUtils blukryptMongoFactoryUtils;

    private void logMessage(String logMessage) {
        logger.trace(logMessage);
    }

    public BlukryptMongoFactoryUtils getBlukryptMongoFactoryUtils() {
        return this.blukryptMongoFactoryUtils;
    }

    public void setBlukryptMongoFactoryUtils(BlukryptMongoFactoryUtils blukryptMongoFactoryUtils) {
        this.blukryptMongoFactoryUtils = blukryptMongoFactoryUtils;
    }

    @Override
    public void saveBackupOverView(int cloudId, BackupOverView backupOverView) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.save((Object)backupOverView);
    }

    @Override
    public BackupOverView getBackupOverView(int cloudId, String deviceUserName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceUserName").is((Object)deviceUserName)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (BackupOverView)mongoTemplate.findOne(query, BackupOverView.class);
    }

    @Override
    public void saveDeviceBackupOverView(int cloudId, DeviceBackupOverView backupOverView) {
        this.logMessage("@@@@Before saving device backup overview@@@");
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.save((Object)backupOverView);
        this.logMessage("@@@@After saving device backup overview@@@");
    }

    @Override
    public DeviceBackupOverView getDeviceBkpOverviewForDeviceUUID(int cloudId, String deviceUUID) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceUUID").is((Object)deviceUUID)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (DeviceBackupOverView)mongoTemplate.findOne(query, DeviceBackupOverView.class);
    }

    @Override
    public void updateSizeDeviceBackupOverView(int cloudId, String deviceUUID, Long storageUtilized, Long sizeInCloud, Long latestVersionChange, Long pgCompressedSize) {
        if (storageUtilized != null || sizeInCloud != null || latestVersionChange != null || pgCompressedSize != null) {
            Criteria criteria = Criteria.where((String)"deviceUUID").is((Object)deviceUUID);
            Query query = new Query((CriteriaDefinition)criteria);
            Update update = new Update();
            if (storageUtilized != null) {
                update.inc("storageUtilized", (Number)storageUtilized);
            }
            if (sizeInCloud != null) {
                update.inc("storageUtilizedInCloud", (Number)sizeInCloud);
            }
            if (pgCompressedSize != null) {
                update.inc("storageUtilizedInPg", (Number)pgCompressedSize);
            }
            MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
            mongoTemplate.updateFirst(query, update, DeviceBackupOverView.class);
            criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceUUID").is((Object)deviceUUID), Criteria.where((String)"isDecoupled").is((Object)false)});
            query = new Query((CriteriaDefinition)criteria);
            if (latestVersionChange != null) {
                update.inc("latestVersionsSize", (Number)latestVersionChange);
            }
            mongoTemplate.updateFirst(query, update, LatestDeviceBackupInfo.class);
        }
    }

    @Override
    public void updateFilesRemainingInDeviceBackupOverView(int cloudId, String deviceUUID, String noOfFilesRemaining) {
        Criteria criteria = Criteria.where((String)"deviceUUID").is((Object)deviceUUID);
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("noOfFilesRemaining", (Object)noOfFilesRemaining);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.updateFirst(query, update, DeviceBackupOverView.class);
    }
}

