/*
 * Decompiled with CFR 0.152.
 */
package com.pg.service.impl;

import com.parablu.paracloud.element.CloudPropertyElement;
import com.parablu.paracloud.element.RestoreEventsElement;
import com.parablu.pcbd.dao.BackUpImageDao;
import com.parablu.pcbd.dao.BackupOverViewDao;
import com.parablu.pcbd.dao.BackupPolicyDao;
import com.parablu.pcbd.dao.BlackListUserDao;
import com.parablu.pcbd.dao.CloudDao;
import com.parablu.pcbd.dao.ComponentDao;
import com.parablu.pcbd.dao.DailyUserBackupOverviewDao;
import com.parablu.pcbd.dao.DeleteExternalStorageDao;
import com.parablu.pcbd.dao.DeletedUserDao;
import com.parablu.pcbd.dao.DeviceDao;
import com.parablu.pcbd.dao.ExternalStorageBackupFileDao;
import com.parablu.pcbd.dao.FileRevisionDao;
import com.parablu.pcbd.dao.MSUtilDao;
import com.parablu.pcbd.dao.NetworkThrottlingDao;
import com.parablu.pcbd.dao.PciAuthorizationTokensDao;
import com.parablu.pcbd.dao.SearchIndexDao;
import com.parablu.pcbd.dao.SharedFileImageDao;
import com.parablu.pcbd.dao.SyncPolicyDao;
import com.parablu.pcbd.dao.UserDao;
import com.parablu.pcbd.dao.UserSyncOverViewDao;
import com.parablu.pcbd.domain.AuditHistory;
import com.parablu.pcbd.domain.BackUpImage;
import com.parablu.pcbd.domain.BackupBatch;
import com.parablu.pcbd.domain.BackupFile;
import com.parablu.pcbd.domain.BackupPolicy;
import com.parablu.pcbd.domain.BlackListUser;
import com.parablu.pcbd.domain.ChunkDetail;
import com.parablu.pcbd.domain.ChunkFile;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.CloudCustomisableDetails;
import com.parablu.pcbd.domain.CloudProperties;
import com.parablu.pcbd.domain.CloudSettings;
import com.parablu.pcbd.domain.Components;
import com.parablu.pcbd.domain.DailySyncOverView;
import com.parablu.pcbd.domain.DailyUserBackupOverView;
import com.parablu.pcbd.domain.DeletedBackUpImage;
import com.parablu.pcbd.domain.DeletedBackupFile;
import com.parablu.pcbd.domain.DeletedUser;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.DeviceBackupOverView;
import com.parablu.pcbd.domain.EWSAppSetting;
import com.parablu.pcbd.domain.EncryptionKey;
import com.parablu.pcbd.domain.EventHub;
import com.parablu.pcbd.domain.FailedFileInfo;
import com.parablu.pcbd.domain.FileRevision;
import com.parablu.pcbd.domain.MSGTokens;
import com.parablu.pcbd.domain.MailBackupBatch;
import com.parablu.pcbd.domain.NetworkThrottling;
import com.parablu.pcbd.domain.O365BlackListUser;
import com.parablu.pcbd.domain.ODBBackupBatch;
import com.parablu.pcbd.domain.OfficeBackupPolicy;
import com.parablu.pcbd.domain.PciAuthorizationTokens;
import com.parablu.pcbd.domain.PrivacyGatewayMapping;
import com.parablu.pcbd.domain.ReBackUpImage;
import com.parablu.pcbd.domain.RestoreEvents;
import com.parablu.pcbd.domain.RestoreHistory;
import com.parablu.pcbd.domain.RestoreProgressEvents;
import com.parablu.pcbd.domain.SearchIndex;
import com.parablu.pcbd.domain.SyncOverView;
import com.parablu.pcbd.domain.SyncPolicy;
import com.parablu.pcbd.domain.User;
import com.parablu.pcbd.domain.UserSyncOverView;
import com.pg.dao.BackupFileDao;
import com.pg.dao.BackupLogsDao;
import com.pg.dao.FileDao;
import com.pg.dao.Office365Dao;
import com.pg.dao.UtilDao;
import com.pg.domain.BackupAttempt;
import com.pg.domain.BackupLog;
import com.pg.domain.DriveFileInfo;
import com.pg.domain.FileInfo;
import com.pg.domain.MailRestoreFileInfo;
import com.pg.domain.OfficeRestoreFileInfo;
import com.pg.element.CloudUsersElement;
import com.pg.element.DeletedUsersElement;
import com.pg.element.FileElement;
import com.pg.element.NetworkThrottlingElement;
import com.pg.element.PciAuthorizationTokenElement;
import com.pg.helper.constant.GeneralHelperConstant;
import com.pg.helper.constant.PCHelperConstant;
import com.pg.odb.util.OneDriveUtil;
import com.pg.service.UtilService;
import com.pg.service.impl.BaseUploadService;
import java.io.File;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UtilServiceImpl
extends BaseUploadService
implements UtilService {
    private static Logger logger = LoggerFactory.getLogger(UtilServiceImpl.class);
    @Autowired
    private UtilDao utilDao;
    private UserDao userDao;
    private NetworkThrottlingDao networkThrottlingDao;
    private MSUtilDao msUtilDao;
    private DeviceDao deviceDao;
    private CloudDao cloudDao;
    private BackupPolicyDao backupPolicyDao;
    private BackUpImageDao backUpImageDao;
    private ExternalStorageBackupFileDao externalStorageBackupFileDao;
    private PciAuthorizationTokensDao pciAuthorizationTokensDao;
    private DeleteExternalStorageDao deleteExternalStorageDao;
    private SearchIndexDao searchIndexDao;
    private DeletedUserDao deletedUserDao;
    private BackupLogsDao backupLogsDao;
    private SyncPolicyDao syncPolicyDao;
    private SharedFileImageDao sharedFileImageDao;
    private CloudSettings cloudSettings;
    @Autowired
    private BackupOverViewDao backupOverViewDao;
    @Autowired
    private FileDao fileDao;
    @Autowired
    private DailyUserBackupOverviewDao dailyUserBackupOverviewDao;
    @Autowired
    private BackupFileDao backupFileDao;
    private FileRevisionDao fileRevisionDao;
    private UserSyncOverViewDao userSyncOverViewDao;
    @Autowired
    private Office365Dao office365Dao;
    private BlackListUserDao blackListUserDao;
    private ComponentDao componentDao;
    private static final String UPLOAD = "/upload/";
    public static final String ENCRYPTED = "/encrypted/";
    public static final String CHUNK = "/chunk/";

    public ComponentDao getComponentDao() {
        return this.componentDao;
    }

    public void setComponentDao(ComponentDao componentDao) {
        this.componentDao = componentDao;
    }

    public void setOffice365Dao(Office365Dao office365Dao) {
        this.office365Dao = office365Dao;
    }

    public void setDailyUserBackupOverviewDao(DailyUserBackupOverviewDao dailyUserBackupOverviewDao) {
        this.dailyUserBackupOverviewDao = dailyUserBackupOverviewDao;
    }

    public void setUserSyncOverViewDao(UserSyncOverViewDao userSyncOverViewDao) {
        this.userSyncOverViewDao = userSyncOverViewDao;
    }

    public void setBackupLogsDao(BackupLogsDao backupLogsDao) {
        this.backupLogsDao = backupLogsDao;
    }

    public void setFileRevisionDao(FileRevisionDao fileRevisionDao) {
        this.fileRevisionDao = fileRevisionDao;
    }

    public void setUtilDao(UtilDao utilDao) {
        this.utilDao = utilDao;
    }

    public void setBackupFileDao(BackupFileDao backupFileDao) {
        this.backupFileDao = backupFileDao;
    }

    public void setSearchIndexDao(SearchIndexDao searchIndexDao) {
        this.searchIndexDao = searchIndexDao;
    }

    public void setExternalStorageBackupFileDao(ExternalStorageBackupFileDao externalStorageBackupFileDao) {
        this.externalStorageBackupFileDao = externalStorageBackupFileDao;
    }

    public void setBackUpImageDao(BackUpImageDao backUpImageDao) {
        this.backUpImageDao = backUpImageDao;
    }

    public void setBackupPolicyDao(BackupPolicyDao backupPolicyDao) {
        this.backupPolicyDao = backupPolicyDao;
    }

    public void setCloudDao(CloudDao cloudDao) {
        this.cloudDao = cloudDao;
    }

    public void setUserDao(UserDao userDao) {
        this.userDao = userDao;
    }

    public void setDeviceDao(DeviceDao deviceDao) {
        this.deviceDao = deviceDao;
    }

    public void setFileDao(FileDao fileDao) {
        this.fileDao = fileDao;
    }

    public void setMsUtilDao(MSUtilDao msUtilDao) {
        this.msUtilDao = msUtilDao;
    }

    public void setNetworkThrottlingDao(NetworkThrottlingDao networkThrottlingDao) {
        this.networkThrottlingDao = networkThrottlingDao;
    }

    public void setPciAuthorizationTokensDao(PciAuthorizationTokensDao pciAuthorizationTokensDao) {
        this.pciAuthorizationTokensDao = pciAuthorizationTokensDao;
    }

    public BlackListUserDao getBlackListUserDao() {
        return this.blackListUserDao;
    }

    public void setBlackListUserDao(BlackListUserDao blackListUserDao) {
        this.blackListUserDao = blackListUserDao;
    }

    public SharedFileImageDao getSharedFileImageDao() {
        return this.sharedFileImageDao;
    }

    public void setSharedFileImageDao(SharedFileImageDao sharedFileImageDao) {
        this.sharedFileImageDao = sharedFileImageDao;
    }

    public SyncPolicyDao getSyncPolicyDao() {
        return this.syncPolicyDao;
    }

    public void setSyncPolicyDao(SyncPolicyDao syncPolicyDao) {
        this.syncPolicyDao = syncPolicyDao;
    }

    @Override
    public String getEncryptionKey(int cloudId, String productType) {
        EncryptionKey encryptionKey = this.utilDao.getEncryptionKey(cloudId, productType);
        String encryptionKeyVal = "";
        if (encryptionKey != null) {
            encryptionKeyVal = encryptionKey.getSaltKey();
        }
        return encryptionKeyVal;
    }

    @Override
    public List<NetworkThrottlingElement> getAllNetworkThrottlingForPGByType(int cloudId, String cloudName, String pgName, String type) {
        List networkThrottlingList = this.networkThrottlingDao.getNetworkThrottlingsByType(cloudId, cloudName, pgName, type);
        ArrayList<NetworkThrottlingElement> elements = new ArrayList<NetworkThrottlingElement>();
        for (NetworkThrottling networkThrottling : networkThrottlingList) {
            NetworkThrottlingElement element = this.getNetworkThrottlingElement(networkThrottling);
            elements.add(element);
        }
        return elements;
    }

    private NetworkThrottlingElement getNetworkThrottlingElement(NetworkThrottling networkThrottling) {
        NetworkThrottlingElement element = null;
        if (networkThrottling != null) {
            element = new NetworkThrottlingElement();
            element.setNetworkThrottlingName(networkThrottling.getNetworkThrottlingName());
            element.setEndTime(String.valueOf(networkThrottling.getEndTime()));
            element.setUploadSpeed(networkThrottling.getUploadSpeed());
            element.setDownloadSpeed(networkThrottling.getDownloadSpeed());
            element.setStartTime(String.valueOf(networkThrottling.getStartTime()));
            element.setPrivacyGatewayName(networkThrottling.getPrivacyGatewayName());
            element.setId(networkThrottling.getId().toString());
            element.setThrottleType(networkThrottling.getThrottleType());
        }
        return element;
    }

    @Override
    public boolean isUserStorageLimitReached(int cloudId, double newFileSizeAllowed, User user, String deviceUUID) {
        if (user != null && !StringUtils.isEmpty((String)user.getPolicyName())) {
            Long sizeUsedForUser = new Long(0L);
            BackupPolicy backupPolicy = this.getBackupPolicy(cloudId, user.getPolicyName());
            if (backupPolicy.isLegalHoldEnabled() || backupPolicy.getUserSizeAllowed() == -1) {
                return false;
            }
            DeviceBackupOverView deviceBackupOverView = this.deviceDao.getDeviceBkpOverviewForDeviceUUID(cloudId, deviceUUID);
            if (deviceBackupOverView != null) {
                sizeUsedForUser = deviceBackupOverView.getStorageUtilized();
            }
            logger.debug(" Size for device user from pg ...... " + sizeUsedForUser);
            int userSizeAllowed = backupPolicy.getUserSizeAllowed();
            double sizeUsedByUserInMb = UtilServiceImpl.getSizeinMb(sizeUsedForUser);
            double userSizeAllowedInMb = UtilServiceImpl.getGBSizeinMb(userSizeAllowed);
            if (sizeUsedByUserInMb + newFileSizeAllowed > userSizeAllowedInMb) {
                logger.error(sizeUsedByUserInMb + "DISK will be FULL  for user ........ " + userSizeAllowedInMb);
                return true;
            }
        }
        return false;
    }

    @Override
    public double userStorageLimit(int cloudId, String userName, Device device) {
        User user = this.userDao.getUserByName(cloudId, device.getUserName());
        BackupPolicy backupPolicy = this.getBackupPolicy(cloudId, user.getPolicyName());
        return backupPolicy.getUserSizeAllowed();
    }

    @Override
    public double userSyncStorageLimit(int cloudId, String userName) {
        User user = this.userDao.getUserByName(cloudId, userName);
        SyncPolicy syncPolicy = this.getSyncPolicy(cloudId, user.getSyncPolicyName());
        return syncPolicy.getUserSizeAllowed();
    }

    @Override
    public Device getDeviceForUUID(int cloudId, String deviceUUID) {
        return this.deviceDao.getDeviceInfoByUUID(cloudId, "", deviceUUID);
    }

    public static double getSizeinMb(long size) {
        double m = (double)size / 1024.0;
        DecimalFormat dec = new DecimalFormat("0.00");
        return Double.parseDouble(dec.format(m));
    }

    public static double getSizeinMbForSync(double size) {
        double m = size / 1024.0;
        DecimalFormat dec = new DecimalFormat("0.00");
        return Double.parseDouble(dec.format(m));
    }

    public static double getGBSizeinMb(long size) {
        double m = (double)size * 1024.0;
        DecimalFormat dec = new DecimalFormat("0.00");
        return Double.parseDouble(dec.format(m));
    }

    @Override
    public List<CloudUsersElement> getAllUsers(int cloudId) {
        ArrayList<CloudUsersElement> list = new ArrayList<CloudUsersElement>();
        List cloudsList = this.cloudDao.getAllClouds();
        for (Cloud cl : cloudsList) {
            CloudUsersElement cloudUsersElement = new CloudUsersElement();
            cloudUsersElement.setCloudName(cl.getCloudName());
            cloudUsersElement.setCloudId(cl.getCloudId());
            ArrayList<String> users = new ArrayList<String>();
            List usersList = this.userDao.getAllUsers(cl.getCloudId(), cl.getCloudName());
            for (User user : usersList) {
                if (user == null || !user.isActive()) continue;
                users.add(user.getUserName());
            }
            cloudUsersElement.setUsers(users);
            list.add(cloudUsersElement);
        }
        return list;
    }

    @Override
    public long getThreadSize(int cloudId, String cloudName) {
        return this.backupPolicyDao.getThreadSize(cloudId, cloudName);
    }

    @Override
    public void updateBackupImageTable(String backupId, String storagePlace, Device device) {
        this.backUpImageDao.updateAzureFileStatusinBackupImageTable(1, "", new ObjectId(backupId), storagePlace, device);
    }

    @Override
    public void saveBackupFileInfoInMainDB(int cloudId, com.pg.domain.BackupFile backupFile, String cloudName, String userName, String gatewayName, boolean isFullBackup, Device device) {
        BackupFile backupFileObj = new BackupFile();
        BeanUtils.copyProperties((Object)backupFile, (Object)backupFileObj);
        backupFileObj.setId(backupFile.getBackupId());
        logger.debug("Is compresed>>>>" + backupFile.isCompressed() + "copying object" + backupFileObj.isCompressed());
        ArrayList<ChunkFile> chunkFiles = new ArrayList<ChunkFile>();
        long actualSizeInServer = 0L;
        for (com.pg.domain.ChunkFile chunkFile : backupFile.getChunkFiles()) {
            actualSizeInServer += chunkFile.getSize().longValue();
            ChunkFile file = new ChunkFile();
            logger.debug(" save chunks for .... " + chunkFile.getCloudStoragePath());
            BeanUtils.copyProperties((Object)chunkFile, (Object)file);
            chunkFiles.add(file);
        }
        actualSizeInServer /= 1024L;
        BackUpImage bkpImage = this.externalStorageBackupFileDao.saveChunksForBackup(1, backupFile.getBackupId(), chunkFiles, backupFile.isCompressed());
        if (bkpImage != null) {
            OneDriveUtil.getInstance().updateSizeInDeviceBackupOverview(cloudId, backupFile.getDeviceUUID(), null, actualSizeInServer, actualSizeInServer, null);
        } else {
            try {
                String containerName = this.checkPreConditionForCreateContainer(userName);
                User user = this.userDao.getUserByName(cloudId, userName);
                String dedupVal = this.getDedupValue(cloudId, user.getPolicyName());
                if (!CollectionUtils.isEmpty(chunkFiles)) {
                    for (ChunkFile chunk : chunkFiles) {
                        this.updateChunksRefForFailedChunks(chunk, this.externalStorageBackupFileDao, containerName, dedupVal, userName, isFullBackup, true, device.getDeviceUUID());
                    }
                }
            }
            catch (Exception e) {
                logger.error("Exception while updateChunksRefForFailedChunks while backup image not found case... ");
            }
        }
    }

    private String getDedupValue(int cloudId, String backupPolicyName) {
        String dedupVal = null;
        if (backupPolicyName != null) {
            BackupPolicy backupPolicy = this.getBackupPolicy(cloudId, backupPolicyName);
            dedupVal = backupPolicy.getDedup();
        }
        return dedupVal;
    }

    private String checkPreConditionForCreateContainer(String userName) {
        String userNameTemp = userName;
        StringBuilder sb = new StringBuilder();
        if (!StringUtils.isEmpty((String)userNameTemp)) {
            if (userNameTemp.length() < 3) {
                userNameTemp = userNameTemp + "-parablu";
            }
            userNameTemp = userNameTemp.replaceAll("[^A-Za-z0-9,]", "-");
            sb.append(userNameTemp);
            return sb.toString();
        }
        return userNameTemp;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void saveChunksAndUpdateStorageForBackup(Cloud cloud, com.pg.domain.BackupFile backupFile, String cloudName, String userName, String gatewayName, boolean isFullBackup, Device device, long storageInCloud, long storageInPG, FileInfo fileInfo) {
        BackupFile backupFileObj = new BackupFile();
        BeanUtils.copyProperties((Object)backupFile, (Object)backupFileObj);
        backupFileObj.setId(backupFile.getBackupId());
        logger.debug("Is compresed>>>>" + backupFile.isCompressed() + "copying object" + backupFileObj.isCompressed());
        ArrayList<ChunkFile> chunkFiles = new ArrayList<ChunkFile>();
        long actualSizeInServer = 0L;
        if (!CollectionUtils.isEmpty((Collection)backupFile.getChunkFiles())) {
            for (com.pg.domain.ChunkFile chunkFile : backupFile.getChunkFiles()) {
                actualSizeInServer += chunkFile.getSize().longValue();
                ChunkFile file = new ChunkFile();
                logger.debug(" save chunks for .... " + chunkFile.getFileName());
                Object chunkName = chunkFile.getFileName();
                if (chunkFile.getFileName().contains("_")) {
                    String charContaingSpecialChar = "";
                    charContaingSpecialChar = ((String)chunkName).startsWith("part") ? ((String)chunkName).substring(((String)chunkName).indexOf("_"), ((String)chunkName).indexOf(".", ((String)chunkName).indexOf(".") + 1)) : ((String)chunkName).substring(((String)chunkName).indexOf("_"), ((String)chunkName).indexOf("."));
                    logger.debug(" charContaingSpecialChar.... " + charContaingSpecialChar);
                    chunkName = ((String)chunkName).replaceAll(charContaingSpecialChar, "");
                    logger.debug((String)chunkName);
                }
                chunkFile.setFileName((String)chunkName);
                BeanUtils.copyProperties((Object)chunkFile, (Object)file);
                chunkFiles.add(file);
            }
            actualSizeInServer /= 1024L;
        } else {
            logger.debug("Chunk is empty so get chunk from MD5" + backupFile.getMd5());
            BackUpImage parentBkpImage = this.utilDao.getParentBackupImageForMd5(cloud.getCloudId(), backupFile.getMd5(), device);
            logger.debug("Chunk is empty so get chunk from MD5" + parentBkpImage);
            if (parentBkpImage != null && !CollectionUtils.isEmpty((Collection)parentBkpImage.getChunkFiles())) {
                chunkFiles.addAll(parentBkpImage.getChunkFiles());
            } else {
                logger.debug("Chunk is empty .." + backupFile.getMd5());
            }
        }
        if (!CollectionUtils.isEmpty(chunkFiles)) {
            BackUpImage bkpImage = this.externalStorageBackupFileDao.saveChunksAndUpdateStorageForBackup(1, backupFile.getBackupId(), chunkFiles, backupFile.isCompressed(), device);
            if (bkpImage != null) {
                long chunksSize = 0L;
                for (String name : fileInfo.getChunkFiles()) {
                    int occurance = StringUtils.countMatches((String)name, (String)".");
                    if (occurance > 1) {
                        name = name.substring(0, name.lastIndexOf(46));
                    }
                    chunksSize += this.getChunksSize(fileInfo.getDeviceUUID(), cloud.getCloudName(), name, fileInfo.getBatchId(), fileInfo.getFileName());
                }
                logger.debug(storageInPG + "...filesizereduction before..." + chunksSize);
                if (chunksSize == 0L) {
                    chunksSize = storageInPG;
                }
                logger.debug(storageInPG + "...filesizereduction after..." + chunksSize);
                if (chunksSize == 0L) return;
                long fileUplaodedSize = -storageInPG;
                long storageSizeInCloud = storageInCloud;
                logger.debug("file size in bytes..." + chunksSize + ".........updateSizeInDeviceBackupOverview....." + fileUplaodedSize + "....storageSizeInCloud ..." + storageSizeInCloud);
                OneDriveUtil.getInstance().updateSizeInDeviceBackupOverview(cloud.getCloudId(), backupFile.getDeviceUUID(), null, storageSizeInCloud, null, fileUplaodedSize);
                return;
            } else {
                try {
                    logger.debug("...File move to cloud but no entry in backup so reduce storage size in pg");
                    long fileUplaodedSize = -storageInPG;
                    logger.debug(storageInCloud + ".........updateSizeInDeviceBackupOverview for backup image not found....." + fileUplaodedSize);
                    OneDriveUtil.getInstance().updateSizeInDeviceBackupOverview(cloud.getCloudId(), backupFile.getDeviceUUID(), null, storageInCloud, null, fileUplaodedSize);
                    String containerName = this.checkPreConditionForCreateContainer(userName);
                    User user = this.userDao.getUserByName(1, userName);
                    String dedupVal = this.getDedupValue(user);
                    if (CollectionUtils.isEmpty(chunkFiles)) return;
                    for (ChunkFile chunk : chunkFiles) {
                        this.updateChunksRefForFailedChunks(chunk, this.externalStorageBackupFileDao, containerName, dedupVal, userName, isFullBackup, true, device.getDeviceUUID());
                    }
                    return;
                }
                catch (Exception e) {
                    logger.error("Exception while updateChunksRefForFailedChunks while backup image not found case... ");
                    return;
                }
            }
        }
        ReBackUpImage reBackUpImage = new ReBackUpImage();
        reBackUpImage.setFileName(backupFileObj.getFileName());
        reBackUpImage.setDevicePath(backupFileObj.getFilePath());
        reBackUpImage.setUserName(backupFileObj.getUserName());
        reBackUpImage.setDeviceId(device.getId().toString());
        this.utilDao.saveReBackupImage(cloud.getCloudId(), reBackUpImage);
        try {
            if (backupFile.getBackupId() != null) {
                this.backUpImageDao.deleteBackupFile(cloud.getCloudId(), cloudName, backupFile.getBackupId(), device);
            }
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("Exception while deleting backup files with backupId:" + e.getMessage());
        }
        OneDriveUtil.getInstance().updateBkpOverviewForDeletedFiles(cloud.getCloudId(), backupFile.getDeviceUUID(), backupFile.getSize());
    }

    private long getChunksSize(String deviceUUID, String cloudName, String name, String batchId, String fileName) {
        long chunksSize = 0L;
        if (!StringUtils.isEmpty((String)deviceUUID)) {
            String parabluBaseMountFolder = PCHelperConstant.getParabluFolderBasePath();
            String chunkPath = parabluBaseMountFolder + cloudName + UPLOAD + deviceUUID + CHUNK;
            if (!StringUtils.isEmpty((String)batchId)) {
                chunkPath = parabluBaseMountFolder + cloudName + UPLOAD + deviceUUID + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + batchId + CHUNK;
            }
            try {
                File deleteChunkFile = new File(chunkPath + name);
                if (deleteChunkFile.exists()) {
                    chunksSize += deleteChunkFile.length();
                }
            }
            catch (Exception e) {
                logger.error("Error trying to clean files ..... " + e.getMessage());
                logger.trace("" + e);
            }
        }
        return chunksSize;
    }

    private String getDedupValue(User user) {
        String dedupVal = null;
        if (user != null && StringUtils.isNotEmpty((String)user.getPolicyName())) {
            BackupPolicy backupPolicy = this.userDao.getBackupPolicyByPolicyName(1, user.getPolicyName());
            dedupVal = backupPolicy.getDedup();
        }
        return dedupVal;
    }

    @Override
    public void updateStorageUtilized(int cloudId, String deviceUUID, long storageUtilized, Long latestVersionSize, Long pgCompressedSize) {
        OneDriveUtil.getInstance().updateSizeInDeviceBackupOverview(cloudId, deviceUUID, storageUtilized, null, latestVersionSize, pgCompressedSize);
    }

    @Override
    public void updateBkpOverviewForDeletedFiles(int cloudId, String deviceUUID, Long deletedFileSize) {
        DeviceBackupOverView backupOverView = this.deviceDao.getDeviceBkpOverviewForDeviceUUID(cloudId, deviceUUID);
        if (backupOverView != null) {
            long storageUtilize = backupOverView.getStorageUtilized();
            long updatedSize = storageUtilize - deletedFileSize;
            backupOverView.setStorageUtilized(updatedSize);
            this.backupOverViewDao.saveDeviceBackupOverView(cloudId, backupOverView);
        }
    }

    @Override
    public boolean checkBackupFileExistForUserByName(String userName) {
        List devices = this.deviceDao.getDeviceByUserNameWithRegex(1, userName);
        for (Device device : devices) {
            BackupFile backupFile = this.externalStorageBackupFileDao.getBackupFileBydeviceUUID(1, device);
            if (backupFile == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<com.pg.domain.ChunkFile> getBackupFileIfExists(String userName, String cloudName, String dedupBackupId, String gatewayName, Device device) {
        ArrayList<com.pg.domain.ChunkFile> chunkList;
        block4: {
            block3: {
                chunkList = new ArrayList<com.pg.domain.ChunkFile>();
                logger.debug(" Inside chunkfile dedup direct check......." + dedupBackupId);
                if (StringUtils.isEmpty((String)dedupBackupId) || dedupBackupId.equalsIgnoreCase(null)) {
                    logger.debug(" prev file does not exist.......... ");
                    return chunkList;
                }
                BackUpImage backUpImage = this.externalStorageBackupFileDao.getBackupImageForId(1, dedupBackupId, device);
                if (backUpImage == null) break block3;
                logger.debug(" Inside chunkfile dedup direct .bkp file......" + backUpImage.getFileName());
                for (ChunkFile chunkFile : backUpImage.getChunkFiles()) {
                    com.pg.domain.ChunkFile file = new com.pg.domain.ChunkFile();
                    BeanUtils.copyProperties((Object)chunkFile, (Object)file);
                    chunkList.add(file);
                }
                break block4;
            }
            BackupFile backupFile = this.externalStorageBackupFileDao.getBackupFile(1, cloudName, userName, dedupBackupId);
            if (backupFile == null) break block4;
            logger.debug(" Inside chunkfile dedup direct backupFile file......" + backupFile.getFileName());
            for (ChunkFile chunkFile : backupFile.getChunkFiles()) {
                com.pg.domain.ChunkFile file = new com.pg.domain.ChunkFile();
                BeanUtils.copyProperties((Object)chunkFile, (Object)file);
                chunkList.add(file);
            }
        }
        return chunkList;
    }

    @Override
    public Map<String, List<String>> getAllDeviceUUIDS(int cloudId) {
        Map devicesMap = this.deviceDao.getAllDevicesByUser(cloudId);
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (String userNameKey : devicesMap.keySet()) {
            if (StringUtils.isEmpty((String)userNameKey)) continue;
            List devices = (List)devicesMap.get(userNameKey);
            ArrayList<String> deviceUUIDs = new ArrayList<String>();
            for (Device device : devices) {
                if (device == null) continue;
                deviceUUIDs.add(device.getDeviceUUID());
            }
            map.put(userNameKey, deviceUUIDs);
        }
        return map;
    }

    @Override
    public void deleteBackupFiles(int cloudId, String cloudName, String userName, String backupId, String dedupedBkId, Device device) {
        try {
            if (!StringUtils.isEmpty((String)backupId)) {
                this.backUpImageDao.deleteBackupFile(cloudId, cloudName, new ObjectId(backupId), device);
            }
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("Exception while deleting backup files with backupId:" + e.getMessage());
        }
    }

    @Override
    public List<DeletedUsersElement> getAllDeletedUsers(int cloudId) {
        ArrayList<DeletedUsersElement> list = new ArrayList<DeletedUsersElement>();
        List cloudsList = this.cloudDao.getAllClouds();
        logger.debug("cloud Size>>>>>>>>>" + cloudsList.size());
        for (Cloud cl : cloudsList) {
            DeletedUsersElement cloudUsersElement = new DeletedUsersElement();
            cloudUsersElement.setCloudId(cl.getCloudId());
            cloudUsersElement.setCloudName(cl.getCloudName());
            List usersList = this.deletedUserDao.getAllDeletedUsers(cl.getCloudId(), cl.getCloudName());
            ArrayList<com.pg.element.DeletedUser> deletedUsers = new ArrayList<com.pg.element.DeletedUser>();
            for (DeletedUser user : usersList) {
                if (user == null) continue;
                com.pg.element.DeletedUser deletedUser = new com.pg.element.DeletedUser();
                BeanUtils.copyProperties((Object)user, (Object)deletedUser);
                deletedUsers.add(deletedUser);
            }
            cloudUsersElement.setDeletedUsers(deletedUsers);
            list.add(cloudUsersElement);
        }
        return list;
    }

    @Override
    public List<com.pg.domain.ChunkFile> getSyncFileIfExists(String dedupBackupId) {
        ArrayList<com.pg.domain.ChunkFile> chunkList = new ArrayList<com.pg.domain.ChunkFile>();
        logger.debug(" Inside chunkfile dedup direct .......");
        BackupFile backupFile = this.externalStorageBackupFileDao.getSyncFile(1, "", "", dedupBackupId);
        if (backupFile != null) {
            logger.debug(" Inside chunkfile dedup direct .bkp file......" + backupFile.getFileName());
            for (ChunkFile chunkFile : backupFile.getChunkFiles()) {
                com.pg.domain.ChunkFile file = new com.pg.domain.ChunkFile();
                BeanUtils.copyProperties((Object)chunkFile, (Object)file);
                chunkList.add(file);
            }
        }
        return chunkList;
    }

    @Override
    public FileInfo getFileInfo(String cloudName, String userName, String gatewayName, String dedupifiedBackupId) {
        BackupFile backupFile = this.externalStorageBackupFileDao.getBackupFile(1, cloudName, userName, dedupifiedBackupId);
        FileInfo fileInfo = new FileInfo();
        if (backupFile != null) {
            fileInfo.setFileName(backupFile.getFileName());
            fileInfo.setFilePath(backupFile.getFilePath());
            fileInfo.setSize(backupFile.getSize());
            for (ChunkFile chunkFile : backupFile.getChunkFiles()) {
                fileInfo.getChunkFiles().add(chunkFile.getFileName());
            }
            fileInfo.setDeviceUUID(backupFile.getDeviceUUID());
            fileInfo.setMd5(backupFile.getMd5());
        }
        return fileInfo;
    }

    @Override
    public boolean isDeviceFullBackup(int cloudId, String deviceUUID) {
        boolean fullBackup = true;
        DeviceBackupOverView deviceBackupOverView = this.deviceDao.getDeviceBkpOverviewForDeviceUUID(cloudId, deviceUUID);
        if (deviceBackupOverView != null && !StringUtils.isEmpty((String)deviceBackupOverView.getLastSuccessfulBkp())) {
            logger.debug(deviceUUID + " LASTSUCCESS BACKUP for device .... " + deviceBackupOverView.getLastSuccessfulBkp());
            fullBackup = false;
        } else {
            logger.debug(" @@FULL BACKUP for device .... " + deviceUUID);
        }
        return fullBackup;
    }

    @Override
    public PciAuthorizationTokenElement getPciAuthorizationTokensForServiceAccount(int cloudId, String cloudName) {
        PciAuthorizationTokens pciAuthorizationToken = this.pciAuthorizationTokensDao.getPciAuthorizationTokensForServiceAccount(cloudId, cloudName);
        return this.getTokenElement(pciAuthorizationToken);
    }

    @Override
    public void updatePciAuthorizationToken(PciAuthorizationTokenElement pciAuthorizationTokenElement, String userName) {
        String cloudName = pciAuthorizationTokenElement.getCloudName();
        Cloud cloud = this.cloudDao.getCloudDetails(cloudName);
        int cloudId = cloud.getCloudId();
        User user = this.userDao.getUserInfoByName(cloudId, cloudName, userName);
        ObjectId objectId = user.getUserId();
        String accessToken = pciAuthorizationTokenElement.getAccessToken();
        String refreshToken = pciAuthorizationTokenElement.getRefreshToken();
        this.pciAuthorizationTokensDao.updatePciAuthorizationTokensForUserId(cloudId, cloudName, objectId, accessToken, refreshToken);
    }

    private PciAuthorizationTokenElement getTokenElement(PciAuthorizationTokens pciAuthorizationTokens) {
        PciAuthorizationTokenElement tokenElement = new PciAuthorizationTokenElement();
        if (pciAuthorizationTokens == null) {
            return tokenElement;
        }
        tokenElement.setAccessToken(pciAuthorizationTokens.getAccessToken());
        tokenElement.setAuthenticationToken(pciAuthorizationTokens.getAuthenticationToken());
        tokenElement.setClientId(pciAuthorizationTokens.getClientId());
        tokenElement.setClientSecret(pciAuthorizationTokens.getClientSecret());
        tokenElement.setEmailId(pciAuthorizationTokens.getEmailId());
        tokenElement.setRedirectUri(pciAuthorizationTokens.getRedirectUri());
        tokenElement.setRefreshToken(pciAuthorizationTokens.getRefreshToken());
        tokenElement.setCloudStorageType(pciAuthorizationTokens.getCloudStorageType().getName());
        tokenElement.setAccountId(pciAuthorizationTokens.getAccountId());
        tokenElement.setSharePointUrl(pciAuthorizationTokens.getSharePointUrl());
        tokenElement.setCloudName(pciAuthorizationTokens.getCloudName());
        User user = this.userDao.getUserInfo(1, "", pciAuthorizationTokens.getUserId().toString());
        if (user != null) {
            tokenElement.setUserName(user.getUserName());
        }
        return tokenElement;
    }

    @Override
    public long getCountOfTable(int cloudId, String cloudName, String userName) {
        return this.externalStorageBackupFileDao.getCountOfTheTable(cloudId, cloudName, userName);
    }

    @Override
    public List<com.pg.domain.BackupFile> getBackupFiles(int cloudId, String cloudName, String userName, int skipValue) {
        List backupFilesList = this.externalStorageBackupFileDao.getBackupFiles(cloudId, cloudName, userName, skipValue);
        ArrayList<com.pg.domain.BackupFile> backupFiles = new ArrayList<com.pg.domain.BackupFile>();
        for (BackupFile backupFile : backupFilesList) {
            com.pg.domain.BackupFile backupFile2 = new com.pg.domain.BackupFile();
            BeanUtils.copyProperties((Object)backupFile, (Object)backupFile2);
            ArrayList<com.pg.domain.ChunkFile> chunkFilesList = new ArrayList<com.pg.domain.ChunkFile>();
            for (ChunkFile chunkFile : backupFile.getChunkFiles()) {
                com.pg.domain.ChunkFile chunkFile2 = new com.pg.domain.ChunkFile();
                chunkFile2.setFileName(chunkFile.getFileName());
                chunkFile2.setId(chunkFile.getId());
                chunkFilesList.add(chunkFile2);
            }
            backupFile2.setChunkFiles(chunkFilesList);
            backupFile2.setId(backupFile.getId().toString());
            backupFiles.add(backupFile2);
        }
        return backupFiles;
    }

    @Override
    public List<String> getDeletedBackupIds(int cloudId, String cloudName, String userName, List<String> backupIds) {
        return null;
    }

    @Override
    public List<CloudUsersElement> getAllClouds(int cloudId) {
        ArrayList<CloudUsersElement> list = new ArrayList<CloudUsersElement>();
        List cloudsList = this.cloudDao.getAllClouds();
        logger.debug("cloud Size>>>>>>>>>" + cloudsList.size());
        for (Cloud cl : cloudsList) {
            CloudUsersElement cloudUsersElement = new CloudUsersElement();
            cloudUsersElement.setCloudId(cl.getCloudId());
            cloudUsersElement.setCloudName(cl.getCloudName());
            list.add(cloudUsersElement);
        }
        return list;
    }

    @Override
    public List<DeletedBackUpImage> getAllDeletedChunksFromTrashTable(int cloudId) {
        ArrayList<DeletedBackUpImage> deletedBackUpImages = new ArrayList<DeletedBackUpImage>();
        List deletedChunks = this.deleteExternalStorageDao.getAllDeletedBackupImages(cloudId);
        for (DeletedBackUpImage deleteBackUpImage : deletedChunks) {
            DeletedBackUpImage backUpImage = new DeletedBackUpImage();
            BeanUtils.copyProperties((Object)deleteBackUpImage, (Object)backUpImage);
            deletedBackUpImages.add(backUpImage);
        }
        return deletedBackUpImages;
    }

    public void setDeleteExternalStorageDao(DeleteExternalStorageDao deleteExternalStorageDao) {
        this.deleteExternalStorageDao = deleteExternalStorageDao;
    }

    @Override
    public void addFileToTable(SearchIndex searchIndex, String cloudName) {
        searchIndex.setCloudName(cloudName);
        this.searchIndexDao.addFileToBeIndexed(searchIndex);
    }

    @Override
    public List<String> getAllDeviceByUserName(int cloudId, String userName) {
        ArrayList<String> deviceUUIDs = new ArrayList<String>();
        List allDevicesForUser = this.deviceDao.getAllDeviceByUserName(cloudId, userName);
        if (allDevicesForUser != null) {
            for (Device device : allDevicesForUser) {
                if (device == null || device.getDeviceUUID() == null) continue;
                deviceUUIDs.add(device.getDeviceUUID());
            }
        }
        return deviceUUIDs;
    }

    public void setDeletedUserDao(DeletedUserDao deletedUserDao) {
        this.deletedUserDao = deletedUserDao;
    }

    @Override
    public List<CloudCustomisableDetails> getCloudLicenseDetails(String cloudName) {
        Cloud cloud = this.cloudDao.getCloudDetails(cloudName);
        return cloud.getCloudCustomisableDetails();
    }

    @Override
    public PciAuthorizationTokenElement getPCITokenElement(int cloudId, ObjectId userId) {
        PciAuthorizationTokens authorizationTokens = this.pciAuthorizationTokensDao.getPciAuthorizationTokensForUserId(cloudId, "", userId);
        if (authorizationTokens == null) {
            return null;
        }
        return this.getTokenElement(authorizationTokens);
    }

    @Override
    public List<PciAuthorizationTokenElement> getAllPCITokenElements(int cloudId) {
        ArrayList<PciAuthorizationTokenElement> elementList = new ArrayList<PciAuthorizationTokenElement>();
        List authorizationTokens = this.pciAuthorizationTokensDao.getAllPciAuthorizationTokens(cloudId, "");
        logger.debug(" Token size for all ..." + authorizationTokens.size());
        for (PciAuthorizationTokens token : authorizationTokens) {
            PciAuthorizationTokenElement element = this.getTokenElement(token);
            User user = this.userDao.getUserInfo(cloudId, "", token.getUserId().toString());
            element.setUserName(user.getUserName());
            if (StringUtils.isEmpty((String)element.getUserName())) continue;
            elementList.add(element);
        }
        return elementList;
    }

    @Override
    public User getUserInfoByName(int cloudId, String userName) {
        return this.userDao.getUserInfoByName(cloudId, "", userName);
    }

    @Override
    public String getUserNameFromDevice(int cloudId, String deviceUUID) {
        Device device = this.getDeviceForUUID(cloudId, deviceUUID);
        String userName = "";
        if (device != null) {
            userName = device.getUserName();
        }
        return userName;
    }

    @Override
    public boolean isBackupRestoreCompletedOrFailed(int cloudId, String batchId) {
        BackupBatch backupBatch = this.backupFileDao.getBackupBatch(cloudId, "", batchId);
        return backupBatch != null && ("FAILED".equalsIgnoreCase(backupBatch.getStatus()) || "COMPLETED".equalsIgnoreCase(backupBatch.getStatus()));
    }

    @Override
    public Cloud getCloud(int cloudId) {
        List clouds = this.cloudDao.getAllClouds();
        Cloud cloud = null;
        for (Cloud cloudVal : clouds) {
            if (cloudVal.getCloudId() != cloudId) continue;
            cloud = cloudVal;
            break;
        }
        return cloud;
    }

    @Override
    public com.pg.domain.BackupFile getBackupLatestFile(int cloudId, String cloudName, String userName) {
        BackupFile backupFile = this.externalStorageBackupFileDao.getLastBackupFile(cloudId, cloudName, userName);
        ArrayList<com.pg.domain.BackupFile> backupFiles = new ArrayList<com.pg.domain.BackupFile>();
        com.pg.domain.BackupFile backupFile2 = null;
        if (backupFile != null) {
            logger.debug("Backup File is not null>>>>>>>>>>>");
            backupFile2 = new com.pg.domain.BackupFile();
            BeanUtils.copyProperties((Object)backupFile, (Object)backupFile2);
            ArrayList<com.pg.domain.ChunkFile> chunkFilesList = new ArrayList<com.pg.domain.ChunkFile>();
            for (ChunkFile chunkFile : backupFile.getChunkFiles()) {
                com.pg.domain.ChunkFile chunkFile2 = new com.pg.domain.ChunkFile();
                chunkFile2.setFileName(chunkFile.getFileName());
                chunkFile2.setId(chunkFile.getId());
                chunkFilesList.add(chunkFile2);
            }
            backupFile2.setChunkFiles(chunkFilesList);
            backupFile2.setId(backupFile.getId().toString());
            backupFiles.add(backupFile2);
        }
        return backupFile2;
    }

    @Override
    public int getchunkFileCountForGivenPath(int cloudId, String cloudName, String userName, String cloudStoragePath) {
        return this.externalStorageBackupFileDao.getchunkFileCountForGivenPath(cloudId, cloudName, userName, cloudStoragePath);
    }

    @Override
    public void saveSyncFileInfo(int cloudId, String cloudName, String userName, com.pg.domain.BackupFile backupFile) {
        BackupFile backupFile2 = new BackupFile();
        BeanUtils.copyProperties((Object)backupFile, (Object)backupFile2);
        backupFile2.setId(backupFile.getBackupId());
        backupFile2.setUserName(userName);
        this.externalStorageBackupFileDao.saveSyncFileInfo(cloudId, cloudName, userName, backupFile2);
    }

    @Override
    public com.pg.domain.BackupFile getSyncFile(int cloudId, String cloudName, String userName, String id) {
        BackupFile backupFile = this.externalStorageBackupFileDao.getSyncFile(cloudId, cloudName, userName, id);
        com.pg.domain.BackupFile backupFileObj = null;
        if (backupFile != null) {
            logger.debug(backupFile.getFileName() + "Backup File is not null>>>>>>>>>>>" + backupFile.getCloudStoragePath());
            backupFileObj = new com.pg.domain.BackupFile();
            BeanUtils.copyProperties((Object)backupFile, (Object)backupFileObj);
            ArrayList<com.pg.domain.ChunkFile> chunkFilesList = new ArrayList<com.pg.domain.ChunkFile>();
            for (ChunkFile chunkFile : backupFile.getChunkFiles()) {
                com.pg.domain.ChunkFile chunkFile2 = new com.pg.domain.ChunkFile();
                BeanUtils.copyProperties((Object)chunkFile, (Object)chunkFile2);
                chunkFile2.setFileName(chunkFile.getFileName());
                chunkFile2.setId(chunkFile.getId());
                chunkFilesList.add(chunkFile2);
            }
            backupFileObj.setChunkFiles(chunkFilesList);
            backupFileObj.setId(backupFile.getId().toString());
            backupFileObj.setBackupId(backupFile.getId());
        }
        return backupFileObj;
    }

    @Override
    public com.pg.domain.BackupFile getSyncFile(int cloudId, String cloudName, String userName, String fileName, String filePath) {
        BackupFile backupFile = this.externalStorageBackupFileDao.getSyncFile(cloudId, cloudName, userName, fileName, filePath);
        com.pg.domain.BackupFile backupFileObj = null;
        if (backupFile != null) {
            logger.debug(backupFile.getFileName() + "Backup File is not null>>>>>>>>>>>" + backupFile.getCloudStoragePath());
            backupFileObj = new com.pg.domain.BackupFile();
            BeanUtils.copyProperties((Object)backupFile, (Object)backupFileObj);
            ArrayList<com.pg.domain.ChunkFile> chunkFilesList = new ArrayList<com.pg.domain.ChunkFile>();
            for (ChunkFile chunkFile : backupFile.getChunkFiles()) {
                com.pg.domain.ChunkFile chunkFile2 = new com.pg.domain.ChunkFile();
                BeanUtils.copyProperties((Object)chunkFile, (Object)chunkFile2);
                chunkFile2.setFileName(chunkFile.getFileName());
                chunkFile2.setId(chunkFile.getId());
                chunkFilesList.add(chunkFile2);
            }
            backupFileObj.setChunkFiles(chunkFilesList);
            backupFileObj.setId(backupFile.getId().toString());
            backupFileObj.setBackupId(backupFile.getId());
        }
        return backupFileObj;
    }

    @Override
    public void deleteSyncFile(int cloudId, String cloudName, String userName, String fileName, String filePath) {
        this.externalStorageBackupFileDao.deleteSyncFile(cloudId, cloudName, userName, fileName, filePath);
    }

    @Override
    public void updateBackupLog(int cloudId, String cloudName, BackupLog backupLog) {
        this.backupLogsDao.saveBackupLog(cloudId, cloudName, backupLog);
    }

    @Override
    public String getBackupIDForMd5(int cloudId, String userName, String md5checksum) {
        return this.backUpImageDao.getBackupIDForMd5(cloudId, userName, md5checksum);
    }

    @Override
    public void deleteUnReferencedChunks(int cloudId) {
        this.externalStorageBackupFileDao.deleteUnReferencedChunks(cloudId);
    }

    @Override
    public void saveSyncOverview(int cloudId, long totalSizeUploaded, long totalSizeDownloaded, long filesShared, long filesDownloaded) {
        SyncOverView syncOverview = this.fileRevisionDao.getSyncOverview(cloudId);
        if (syncOverview == null) {
            syncOverview = new SyncOverView();
            syncOverview.setTotalFilesShared(filesShared);
            syncOverview.setTotalFilesDownloaded(totalSizeDownloaded);
            syncOverview.setTotalSizeUploaded(totalSizeUploaded);
            syncOverview.setTotalSizeDownloaded(totalSizeDownloaded);
        } else {
            syncOverview.setTotalFilesShared(syncOverview.getTotalFilesShared() + filesShared);
            syncOverview.setTotalFilesDownloaded(syncOverview.getTotalFilesDownloaded() + filesDownloaded);
            syncOverview.setTotalSizeUploaded(syncOverview.getTotalSizeUploaded() + totalSizeUploaded);
            syncOverview.setTotalSizeDownloaded(syncOverview.getTotalSizeDownloaded() + totalSizeDownloaded);
        }
        this.fileRevisionDao.saveSyncOverview(cloudId, syncOverview);
        long currentTimeMillis = UtilServiceImpl.getStartofDay(System.currentTimeMillis());
        DailySyncOverView dailySyncOverview = this.fileRevisionDao.getDailySyncOverview(cloudId, currentTimeMillis);
        if (dailySyncOverview == null) {
            dailySyncOverview = new DailySyncOverView();
            dailySyncOverview.setTotalFilesShared(filesShared);
            dailySyncOverview.setTotalFilesDownloaded(totalSizeDownloaded);
            dailySyncOverview.setTotalSizeUploaded(totalSizeUploaded);
            dailySyncOverview.setTotalSizeDownloaded(totalSizeDownloaded);
            dailySyncOverview.setOverViewDate(UtilServiceImpl.getStartofDay(currentTimeMillis));
        } else {
            dailySyncOverview.setTotalFilesShared(dailySyncOverview.getTotalFilesShared() + filesShared);
            dailySyncOverview.setTotalFilesDownloaded(dailySyncOverview.getTotalFilesDownloaded() + filesDownloaded);
            dailySyncOverview.setTotalSizeUploaded(dailySyncOverview.getTotalSizeUploaded() + totalSizeUploaded);
            dailySyncOverview.setTotalSizeDownloaded(dailySyncOverview.getTotalSizeDownloaded() + totalSizeDownloaded);
            dailySyncOverview.setOverViewDate(UtilServiceImpl.getStartofDay(currentTimeMillis));
        }
        this.fileRevisionDao.saveDailySyncOverview(cloudId, dailySyncOverview);
    }

    private static long getStartofDay(long millis) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(millis);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTimeInMillis();
    }

    @Override
    public boolean isSyncUserStorageLimitReached(int cloudId, double newFileSizeAllowed, String userName, String cloudName) {
        User user = this.getUserInfoByName(cloudId, userName);
        Double sizeUsedForUser = new Double(0.0);
        SyncPolicy syncPolicy = this.getSyncPolicy(cloudId, user.getSyncPolicyName());
        logger.debug("$$$$$ syncPolicy $$$$$ " + syncPolicy);
        if (syncPolicy.getUserSizeAllowed() == -1) {
            return false;
        }
        if (user != null) {
            UserSyncOverView userSyncOverView = user.getUserSyncOverView();
            if (userSyncOverView != null) {
                sizeUsedForUser = userSyncOverView.getStorageUtilized();
            } else {
                userSyncOverView = new UserSyncOverView();
                userSyncOverView.setStorageUtilized(0.0);
                user.setUserSyncOverView(userSyncOverView);
                this.userSyncOverViewDao.saveUserSyncOverViewToDB(cloudId, userSyncOverView);
                this.userDao.saveUser(cloudId, cloudName, user);
            }
        }
        logger.debug(" new coming file size ...... " + newFileSizeAllowed);
        int userSizeAllowed = syncPolicy.getUserSizeAllowed();
        double sizeUsedByUserInMb = UtilServiceImpl.getSizeinMbForSync(sizeUsedForUser);
        logger.debug(" Size for device user from pg ...... " + sizeUsedByUserInMb);
        double userSizeAllowedInMb = UtilServiceImpl.getGBSizeinMb(userSizeAllowed);
        logger.debug(" Size Allowed ...... " + userSizeAllowedInMb);
        if (sizeUsedByUserInMb + newFileSizeAllowed > userSizeAllowedInMb) {
            logger.error(sizeUsedByUserInMb + "DISK will be FULL  for user ........ " + userSizeAllowedInMb);
            return true;
        }
        return false;
    }

    @Override
    public List<FileRevision> getAllFilesTobeDeleted(int cloudId, long filesExpiredDate) {
        return this.fileRevisionDao.getAllFilesTobeDeleted(cloudId, filesExpiredDate);
    }

    @Override
    public void deleteRevision(int cloudId, FileRevision fileRevision) {
        this.fileRevisionDao.deleteRevision(cloudId, "", fileRevision);
    }

    @Override
    public void saveDailyUserBackupOverView(int cloudId, DailyUserBackupOverView userBackupOverView) {
        this.dailyUserBackupOverviewDao.saveDailyUserBackupOverView(cloudId, userBackupOverView);
    }

    @Override
    public Map<String, List<Device>> getAllDeviceForUser(int cloudId) {
        return this.deviceDao.getAllDevicesByUser(cloudId);
    }

    @Override
    public void updateUserStoragePath(int cloudId, String userName, String path, boolean isSync) {
        this.userDao.updateUserStoragePath(cloudId, userName, path, isSync);
    }

    @Override
    public boolean saveFileInfo(FileInfo fileInfo, boolean isBackup, String cloudName) {
        return this.fileDao.saveFileInfo(fileInfo, isBackup, cloudName);
    }

    @Override
    public void deleteRevision(int cloudId, String syncRevisionId, String consolidatedImageId) {
        this.fileRevisionDao.deleteRevision(cloudId, syncRevisionId, consolidatedImageId);
    }

    @Override
    public void deleteBackupFile(int cloudId, String backupId, Device device) {
        if (StringUtils.isEmpty((String)backupId)) {
            return;
        }
        this.backUpImageDao.deleteBackupFile(cloudId, "", new ObjectId(backupId), device);
    }

    @Override
    public void updateBackBatchAndOverview(int cloudId, String backupBatchId, int totalNoOfFiles, long totalSize, String deviceUUID, long totalSizeToUpload) {
        this.utilDao.updateBackBatch(cloudId, backupBatchId, totalNoOfFiles, totalSize);
        this.deviceDao.updateUplodedFilesInBackupOverView(cloudId, deviceUUID, totalNoOfFiles, totalSize, totalSizeToUpload);
    }

    @Override
    public boolean restoreQueue(FileInfo fileInfo, Cloud cloud) {
        return this.fileDao.restoreQueue(fileInfo, cloud);
    }

    @Override
    public void updateGatewayInBackupImage(String backupId, String gateWayName) {
        this.backUpImageDao.updateGatewayInBackupImage(1, new ObjectId(backupId), gateWayName);
    }

    @Override
    public FileInfo getPgFileFromMongo(int cloudId, String cloudName, String backupId, boolean isBackup) {
        return this.fileDao.getPgFileFromMongo(cloudId, cloudName, backupId, isBackup);
    }

    @Override
    public void removeBackupFromTempDb(Cloud cloud, ObjectId backupId, boolean isBackup) {
        this.fileDao.removeBackupFromTempDb(cloud.getCloudId(), cloud.getCloudName(), backupId, isBackup);
    }

    @Override
    public boolean restoreSyncQueue(FileInfo fileInfo, Cloud cloud) {
        return this.fileDao.restoreSyncQueue(fileInfo, cloud);
    }

    @Override
    public void updateInterruptedBackBatch(int cloudId, String deviceUUID) {
        this.utilDao.updateInterruptedBackBatch(cloudId, deviceUUID);
    }

    @Override
    public BackUpImage getBackupImageFile(int cloudId, String backupId, Device device) {
        return this.externalStorageBackupFileDao.getBackupImageForId(1, backupId, device);
    }

    @Override
    public List<FailedFileInfo> getFailedFiles(int cloudId, String userName) {
        return this.utilDao.getFailedFiles(cloudId, userName);
    }

    @Override
    public void deleteFailedFile(int cloudId, String fileInfoId) {
        this.utilDao.deleteFailedFile(cloudId, fileInfoId);
    }

    @Override
    public void saveFailedFile(int cloudId, FileInfo fileInfo) {
        FailedFileInfo failedFileInfo = new FailedFileInfo();
        BeanUtils.copyProperties((Object)fileInfo, (Object)failedFileInfo);
        failedFileInfo.setId(new ObjectId(fileInfo.getId()));
        this.utilDao.saveFailedFile(cloudId, failedFileInfo);
    }

    @Override
    public List<String> getUnMappedUsersForOneDrive(int cloudId) {
        return this.utilDao.getUnMappedUsersForOneDrive(cloudId);
    }

    @Override
    public List<FailedFileInfo> getSyncFailedFiles(int cloudId, String userName) {
        return this.utilDao.getSyncFailedFiles(cloudId, userName);
    }

    @Override
    public void deleteSyncFailedFile(int cloudId, String fileInfoId) {
        this.utilDao.deleteSyncFailedFile(cloudId, fileInfoId);
    }

    @Override
    public List<String> getUnMappedSyncUsersForOneDrive(int cloudId) {
        return this.utilDao.getUnMappedSyncUsersForOneDrive(cloudId);
    }

    @Override
    public boolean saveFileInfoInMongo(FileInfo fileInfo) {
        return this.fileDao.saveFileInfoInMongo(fileInfo);
    }

    @Override
    public FileInfo getFileInfoFromMongo(int cloudId, String cloudName, String backupId) {
        return this.fileDao.getFileFromMainMongoDb(cloudId, cloudName, backupId);
    }

    @Override
    public DeviceBackupOverView getDeviceBkpOverviewForDeviceUUID(int cloudId, String deviceUUID) {
        return this.deviceDao.getDeviceBkpOverviewForDeviceUUID(cloudId, deviceUUID);
    }

    @Override
    public void saveAudit(int cloudId, AuditHistory saveAudit) {
        this.utilDao.saveAudit(cloudId, saveAudit);
    }

    @Override
    public void updateServiceAcctPciAuthorizationToken(PciAuthorizationTokenElement element) {
        this.office365Dao.updatePciAuthorizationTokensForServiceAcct(1, element.getAccessToken(), element.getRefreshToken());
    }

    @Override
    public void updateDeviceBackupOverView(int cloudId, String batchId, int uploadedFiles, DeviceBackupOverView backupOverView) {
        try {
            BackupBatch backupBatch = this.backupFileDao.getBackupBatch(cloudId, "", batchId);
            String[] parts = backupBatch.getUploadedFiles().split("/");
            int prevBkpFiles = Integer.parseInt(parts[0]);
            int totalNoOfFiles = Integer.parseInt(parts[1]);
            int noOfFilesRemaining = totalNoOfFiles - prevBkpFiles;
            if (noOfFilesRemaining < 0) {
                noOfFilesRemaining = 0;
            }
            backupOverView.setNoOfFilesRemaining(noOfFilesRemaining + "");
            logger.debug("noOfFilesRemaining---->" + noOfFilesRemaining);
            this.backupOverViewDao.updateFilesRemainingInDeviceBackupOverView(cloudId, backupOverView.getDeviceUUID(), backupOverView.getNoOfFilesRemaining());
        }
        catch (Exception e) {
            logger.debug("unable to update device backup overview" + e.getMessage());
            logger.error("Exception.." + e.getMessage());
            logger.error("Exception.." + e);
        }
    }

    @Override
    public void deleteAllDeletedBackupFiles(int cloudId) {
        List deletedBackupFolder = this.utilDao.getAllDeletedBackupFiles(cloudId, true);
        for (DeletedBackupFile deletedBackupFile : deletedBackupFolder) {
            Device device = this.utilDao.getDeviceInfoByUUID(cloudId, deletedBackupFile.getDeviceUUID());
            boolean isDeletedBkpFileNotEmpty = true;
            while (isDeletedBkpFileNotEmpty) {
                List<BackUpImage> backupImageFileList = new ArrayList();
                backupImageFileList = !StringUtils.isEmpty((String)deletedBackupFile.getDevicePath()) ? this.utilDao.getAllChildFilesOfFolder(cloudId, deletedBackupFile.getDevicePath() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + deletedBackupFile.getFileName(), device) : this.utilDao.getAllChildFilesOfFolder(cloudId, deletedBackupFile.getFileName(), device);
                if (CollectionUtils.isEmpty(backupImageFileList)) break;
                logger.debug("backupImageFile List -------" + backupImageFileList.size());
                this.deleteBackupImageForDeletedFile(cloudId, backupImageFileList, device);
            }
            this.removeDeletedBackupFile(cloudId, deletedBackupFile);
        }
        List deletedBackupFiles = this.utilDao.getAllDeletedBackupFiles(cloudId, false);
        for (DeletedBackupFile deletedBkpFile : deletedBackupFiles) {
            this.deleteBackupFileTrigger(cloudId, deletedBkpFile);
        }
    }

    private void deleteBackupImageForDeletedFile(int cloudId, List<BackUpImage> backupImageFileList, Device device) {
        List<BackUpImage> filteredBackupImageList = this.getFilteredBackupImageList(backupImageFileList);
        this.deleteLatestVerFiles(cloudId, backupImageFileList, device, filteredBackupImageList);
        this.deleteAllFiles(cloudId, backupImageFileList, device);
    }

    private void deleteAllFiles(int cloudId, List<BackUpImage> backupImageFileList, Device device) {
        long storageUtilized = 0L;
        for (BackUpImage backupImage : backupImageFileList) {
            DeletedBackupFile deletedBkpFile = new DeletedBackupFile();
            BeanUtils.copyProperties((Object)backupImage, (Object)deletedBkpFile);
            this.deleteBackupImage(cloudId, backupImage.getId(), device);
            this.dereferenceChunkDetails(deletedBkpFile);
            storageUtilized += backupImage.getSize();
        }
        storageUtilized = -storageUtilized;
        logger.debug("...Updating size..." + storageUtilized);
        this.backupOverViewDao.updateSizeDeviceBackupOverView(cloudId, device.getDeviceUUID(), Long.valueOf(storageUtilized), null, null, null);
    }

    private void deleteLatestVerFiles(int cloudId, List<BackUpImage> backupImageFileList, Device device, List<BackUpImage> filteredBackupImageList) {
        long storageUtilized = 0L;
        long latestVersionChange = 0L;
        for (BackUpImage backupImage : filteredBackupImageList) {
            DeletedBackupFile deletedBkpFile = new DeletedBackupFile();
            BeanUtils.copyProperties((Object)backupImage, (Object)deletedBkpFile);
            this.deleteBackupImage(cloudId, backupImage.getId(), device);
            this.dereferenceChunkDetails(deletedBkpFile);
            storageUtilized += backupImage.getSize();
            latestVersionChange += backupImage.getSize();
            backupImageFileList.remove(backupImage);
        }
        storageUtilized = -storageUtilized;
        latestVersionChange = -latestVersionChange;
        logger.debug("...Updating size..." + storageUtilized + "...latestVersionChange.." + latestVersionChange);
        this.backupOverViewDao.updateSizeDeviceBackupOverView(cloudId, device.getDeviceUUID(), Long.valueOf(storageUtilized), null, Long.valueOf(latestVersionChange), null);
    }

    private List<BackUpImage> getFilteredBackupImageList(List<BackUpImage> backUpImages) {
        logger.debug("Inside getFilteredBackupImageList");
        ArrayList<BackUpImage> filteredBackUpImages = new ArrayList<BackUpImage>();
        Map<String, List<BackUpImage>> map = backUpImages.stream().collect(Collectors.groupingBy(BackUpImage::getFileName));
        for (Map.Entry<String, List<BackUpImage>> entry : map.entrySet()) {
            logger.debug(entry.getKey() + "...before..." + entry.getValue().size());
            List files = entry.getValue().stream().filter(file -> !file.getStatus().equalsIgnoreCase("DELETED")).collect(Collectors.toList());
            logger.debug(entry.getKey() + "...after..." + entry.getValue().size());
            filteredBackUpImages.add(files.stream().sorted(Comparator.comparing(BackUpImage::getLastServerModifiedTime).reversed()).findFirst().get());
        }
        return filteredBackUpImages;
    }

    private void deleteBackupImage(int cloudId, ObjectId backupId, Device device) {
        try {
            this.backUpImageDao.deleteBackupFile(cloudId, backupId, device);
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("Exception while deleting backup files with backupId:" + e.getMessage());
        }
    }

    private void deleteBackupFileTrigger(int cloudId, DeletedBackupFile deletedBkpFile) {
        this.dereferenceChunkDetails(deletedBkpFile);
        this.removeDeletedBackupFile(cloudId, deletedBkpFile);
    }

    private void dereferenceChunkDetails(DeletedBackupFile deletedBkpFile) {
        try {
            this.dereferenceChunkDetailsFromDeletedBackupFiles(deletedBkpFile);
        }
        catch (Exception e) {
            logger.debug("unable to delete chunk details from deleted backup file");
            logger.trace("Exception" + e);
            logger.error("Exception for deleting chunk details" + e.getMessage());
        }
    }

    private void removeDeletedBackupFile(int cloudId, DeletedBackupFile deletedBkpFile) {
        try {
            this.utilDao.deleteBackupFile(cloudId, deletedBkpFile);
        }
        catch (Exception e) {
            logger.debug("deleted backup file");
            logger.trace("Exception" + e);
            logger.error("Exception for deleted backup file" + e.getMessage());
        }
    }

    private void dereferenceChunkDetailsFromDeletedBackupFiles(DeletedBackupFile deletedBackupFile) {
        if (deletedBackupFile.getChunkFiles() != null && !CollectionUtils.isEmpty((Collection)deletedBackupFile.getChunkFiles()) && "CLOUD".equalsIgnoreCase(deletedBackupFile.getStoragePlace())) {
            User user = this.userDao.getUserByName(1, deletedBackupFile.getUserName());
            String dedupVal = this.getDedupValue(1, user.getPolicyName());
            for (ChunkFile chunkFile : deletedBackupFile.getChunkFiles()) {
                if (StringUtils.isEmpty((String)chunkFile.getMd5())) continue;
                ChunkDetail chunkDetail = null;
                List chunkDetailList = this.externalStorageBackupFileDao.getChunkDetailForMd5ForRestore(1, chunkFile.getMd5(), dedupVal, deletedBackupFile.getUserName(), true, false);
                if (CollectionUtils.isEmpty((Collection)chunkDetailList)) {
                    logger.debug("................chunk detail is empty for userName " + deletedBackupFile.getUserName() + " so search with userName case insesitive...........");
                    chunkDetailList = this.externalStorageBackupFileDao.getChunkDetailForMd5ForRestore(1, chunkFile.getMd5(), dedupVal, deletedBackupFile.getUserName(), true, true);
                }
                if (!CollectionUtils.isEmpty((Collection)chunkDetailList)) {
                    for (ChunkDetail detailFromDB : chunkDetailList) {
                        if (detailFromDB.getRefCount() <= 0) continue;
                        chunkDetail = detailFromDB;
                    }
                }
                if (chunkDetail == null) continue;
                try {
                    chunkDetail.setRefCount(chunkDetail.getRefCount() - 1);
                    this.externalStorageBackupFileDao.saveChunkDetail(1, chunkDetail);
                    logger.debug(" Chunk updated succcessfully for delete backup image..........");
                }
                catch (OptimisticLockingFailureException e) {
                    logger.trace("" + (Object)((Object)e));
                    logger.error("Exception while removing chunk details :" + e.getMessage());
                    int count = 0;
                    int maxTries = PCHelperConstant.getMaxRetryForChunkUpdate();
                    this.retryDereferenceChunkForDeleteBkpFile(chunkFile, count, maxTries, deletedBackupFile.getUserName(), dedupVal);
                }
            }
        }
    }

    private void retryDereferenceChunkForDeleteBkpFile(ChunkFile chunkFile, int count1, int maxTries, String userName, String dedupVal) {
        int count = count1;
        while (true) {
            try {
                ChunkDetail chunkDetailObj;
                do {
                    logger.debug(" retry chunk update ..............." + chunkFile.getMd5());
                    chunkDetailObj = null;
                    List chunkDetailList = this.externalStorageBackupFileDao.getChunkDetailForMd5ForRestore(1, chunkFile.getMd5(), dedupVal, userName, true, false);
                    if (CollectionUtils.isEmpty((Collection)chunkDetailList)) {
                        logger.debug("................chunk detail is empty for userName " + userName + " so search with userName case insesitive...........");
                        chunkDetailList = this.externalStorageBackupFileDao.getChunkDetailForMd5ForRestore(1, chunkFile.getMd5(), dedupVal, userName, true, true);
                    }
                    if (CollectionUtils.isEmpty((Collection)chunkDetailList)) continue;
                    for (ChunkDetail detailFromDB : chunkDetailList) {
                        if (detailFromDB.getRefCount() <= 0) continue;
                        chunkDetailObj = detailFromDB;
                    }
                } while (chunkDetailObj == null);
                chunkDetailObj.setRefCount(chunkDetailObj.getRefCount() - 1);
                logger.debug(chunkFile.getMd5() + " @@@@@@ ................ retry count " + count);
                this.externalStorageBackupFileDao.saveChunkDetail(1, chunkDetailObj);
            }
            catch (Exception ex) {
                logger.trace("" + ex);
                logger.error(" ex ..." + ex.getMessage());
                if (++count != maxTries) continue;
            }
            break;
        }
    }

    @Override
    public void saveBlackListUser(int cloudId, BlackListUser blackListUser) {
        this.blackListUserDao.saveBlackListUser(cloudId, blackListUser);
    }

    @Override
    public List<BlackListUser> getAllBlackListUsers(int cloudId) {
        return this.blackListUserDao.getAllBlackListUsers(cloudId);
    }

    @Override
    public BlackListUser getBlackListUserbyNameAndLocalHost(int cloudId, String userName, String localHost) {
        return this.blackListUserDao.getBlackListUserbyName(cloudId, userName, localHost);
    }

    @Override
    public void deleteBlackListUser(int cloudId, String useName, String localHost) {
        this.blackListUserDao.deleteBlackListUser(cloudId, useName, localHost);
    }

    @Override
    public void deleteBlackListUserByUserName(int cloudId, String userName) {
        logger.debug("..Removing blacklist user for userName :" + userName);
        this.blackListUserDao.deleteBlackListUserByUserName(cloudId, userName);
    }

    @Override
    public List<String> getAllBlackListUserNames(int cloudId) {
        ArrayList<String> userNames = new ArrayList<String>();
        for (BlackListUser blackListUser : this.blackListUserDao.getAllBlackListUsers(cloudId)) {
            userNames.add(blackListUser.getUserName());
        }
        return userNames;
    }

    @Override
    public List<User> getAllUser(int cloudId) {
        return this.userDao.getAllUser(cloudId);
    }

    @Override
    public SyncPolicy getSyncpolicyByName(int cloudId, String policyName) {
        return this.syncPolicyDao.getSyncPolicy(cloudId, policyName);
    }

    @Override
    public List<FileRevision> getAllSyncFilesToBeDeletedByUserName(int cloudId, long filesExpiredDate, String userName) {
        return this.fileRevisionDao.getAllSyncFilesToBeDeletedByUserName(cloudId, filesExpiredDate, userName);
    }

    @Override
    public void deleteSharedFileImage(String devicePath, String fileName, String userName) {
        this.sharedFileImageDao.deleteSharedFileImage(devicePath, fileName, userName);
    }

    @Override
    public void dereferanceSyncTable(int cloudId, String cloudName, String userName, String fileName, String filePath) {
        BackupFile backUpImage = this.externalStorageBackupFileDao.getSyncFile(cloudId, cloudName, userName, fileName, filePath);
        ObjectId objectId = backUpImage.getId();
        if (backUpImage.getChunkFiles() != null && !CollectionUtils.isEmpty((Collection)backUpImage.getChunkFiles())) {
            for (ChunkFile chunkFile : backUpImage.getChunkFiles()) {
                ChunkDetail chunkDetail = this.externalStorageBackupFileDao.getChunkDetailForMd5UserNameAndProductType(1, chunkFile.getMd5(), userName, "SYNC");
                if (chunkDetail == null) continue;
                try {
                    chunkDetail.setRefCount(chunkDetail.getRefCount() - 1);
                    this.externalStorageBackupFileDao.saveChunkDetail(1, chunkDetail);
                    logger.debug(" Chunk updated succcessfully for delete ..........");
                }
                catch (OptimisticLockingFailureException e) {
                    logger.trace("" + (Object)((Object)e));
                    logger.error("Exception while removing backup image :" + e.getMessage());
                    int count = 0;
                    int maxTries = PCHelperConstant.getMaxRetryForChunkUpdate();
                    this.retryDereferenceChunk(chunkFile, count, maxTries, userName, "SYNC");
                }
            }
        }
        this.externalStorageBackupFileDao.deleteSyncFiles(cloudId, objectId, cloudName);
    }

    private void retryDereferenceChunk(ChunkFile chunkFile, int count1, int maxTries, String userName, String productType) {
        int count = count1;
        while (true) {
            try {
                logger.debug(" retry chunk update ..............." + chunkFile.getMd5());
                ChunkDetail chunkDetailObj = this.externalStorageBackupFileDao.getChunkDetailForMd5UserNameAndProductType(1, chunkFile.getMd5(), userName, productType);
                chunkDetailObj.setRefCount(chunkDetailObj.getRefCount() - 1);
                logger.debug(chunkFile.getMd5() + " @@@@@@ ................ retry count " + count);
                this.externalStorageBackupFileDao.saveChunkDetail(1, chunkDetailObj);
            }
            catch (Exception ex) {
                logger.trace("" + ex);
                logger.error(" ex ..." + ex.getMessage());
                if (++count != maxTries) continue;
            }
            break;
        }
    }

    @Override
    public void updateUserSyncOverview(String userName, double fileSize) {
        int cloudId = 1;
        User user = this.userDao.getUserByName(cloudId, userName);
        double total = user.getUserSyncOverView().getStorageUtilized();
        double actual = total - fileSize;
        UserSyncOverView userSyncOverView = user.getUserSyncOverView();
        userSyncOverView.setStorageUtilized(actual);
        this.userSyncOverViewDao.saveUserSyncOverViewToDB(cloudId, userSyncOverView);
    }

    @Override
    public void updateSyncOverview(double fileSize) {
        int cloudId = 1;
        SyncOverView syncOverview = this.fileRevisionDao.getSyncOverview(cloudId);
        double total = syncOverview.getTotalSizeUploaded();
        double actual = total - fileSize;
        syncOverview.setTotalSizeUploaded(Long.parseLong(String.valueOf(actual)));
        this.fileRevisionDao.saveSyncOverview(cloudId, syncOverview);
    }

    @Override
    public BackupBatch getBackupBatchById(int cloudId, String batchId) {
        return this.backUpImageDao.getBackupBatchById(cloudId, batchId);
    }

    @Override
    public List<User> getAllUsersForPolicy(int cloudId, String policyName) {
        return this.userDao.getAllUsersForPolicy(cloudId, policyName);
    }

    @Override
    public List<Device> getAllDevicesforUser(int cloudId, String userName) {
        return this.deviceDao.getAllDeviceByUserName(cloudId, userName);
    }

    @Override
    public List<DriveFileInfo> getDriveFileInfoList() {
        return this.msUtilDao.getDriveFileInfoList();
    }

    @Override
    public String getAccessTokenForODBBackup(int cloudId) {
        return this.pciAuthorizationTokensDao.getAccessTokenForODBBackup(cloudId);
    }

    @Override
    public void deleteBatchFromOdServer(ObjectId id, String policyName) {
        this.msUtilDao.deleteBatchFromOdServer(id, policyName);
    }

    @Override
    public List<ODBBackupBatch> getODBBatchList(String policyName) {
        return this.msUtilDao.getBatchList(policyName);
    }

    @Override
    public List<DriveFileInfo> getDriveFileInfoFromListForBatchId(String batchId) {
        return this.msUtilDao.getDriveFileInfoFromListForBatchId(batchId);
    }

    @Override
    public void saveBackupBatch(int cloudId, BackupBatch backupBatch) {
        this.utilDao.saveBackupBatch(cloudId, backupBatch);
    }

    @Override
    public void updateDeviceBackupOverView(int cloudId, DeviceBackupOverView overView) {
        this.utilDao.updateDeviceBackupOverView(cloudId, overView);
    }

    @Override
    public void saveDeviceBackupOverView(int cloudId, Device device) {
        DeviceBackupOverView backupOverView = new DeviceBackupOverView();
        User user = this.userDao.getUserByName(cloudId, device.getUserName());
        ObjectId deviceId = device.getId();
        Object[] arr = this.utilDao.getBackupDateHistoryElement(cloudId, "", device.getUserName(), device.getDeviceUUID());
        if (arr[0] != null) {
            String lastSuccessfulBkp = this.getDateInFormat((Long)arr[0]);
            backupOverView.setLastSuccessfulBkp(lastSuccessfulBkp);
        }
        if (arr[1] != null) {
            String firstSuccessfulBkp = this.getDateInFormat((Long)arr[1]);
            backupOverView.setFirstBkpStartTime(firstSuccessfulBkp);
        }
        if (arr[2] != null) {
            backupOverView.setLastBkpStatus(arr[2].toString());
            backupOverView.setReason(arr[3].toString());
            backupOverView.setLastBkpStartTime(this.getDateInFormat((Long)arr[4]));
        }
        backupOverView.setTotalNoOfFiles(arr[5].toString());
        backupOverView.setNoOfFilesRemaining(arr[6].toString());
        String userName = user.getUserName();
        long storageUsed = this.backUpImageDao.getTotalSizeUsedByUserForDevice(cloudId, userName, deviceId);
        if (StringUtils.isEmpty((String)user.getPolicyName())) {
            BackupPolicy policy = this.userDao.getBackupPolicyByPolicyName(1, user.getPolicyName());
            if (!StringUtils.isEmpty((String)user.getPolicyName())) {
                // empty if block
            }
        }
        backupOverView.setStorageUtilized(storageUsed);
        Object[] countArr = this.utilDao.getCountForJobType(cloudId, device.getDeviceUUID(), device.getUserName());
        if (countArr[1] != null) {
            Long noOfSuccessfulBackups = (Long)countArr[1];
            logger.debug(" ############### ....  ..... " + noOfSuccessfulBackups);
            backupOverView.setNoOfSuccessfulBackups(noOfSuccessfulBackups.longValue());
        }
        if (countArr[0] != null) {
            Long noOfSuccessfulRestores = (Long)countArr[0];
            logger.debug(" #####@@@@@@######### ....  ..... " + noOfSuccessfulRestores);
            backupOverView.setNoOfSuccessfulRestores(noOfSuccessfulRestores.longValue());
        }
        device.setUserId(user.getUserId());
        device.setUserName(user.getUserName());
        backupOverView.setUserName(user.getUserName());
        backupOverView.setEmailId(user.getEmailId());
        backupOverView.setUserActive(user.isActive());
        backupOverView.setUserDeleted(user.isDeleted());
        backupOverView.setPolicyName(user.getPolicyName());
        backupOverView.setDeviceBolcked(device.isBlocked());
        backupOverView.setDeviceUUID(device.getDeviceUUID());
        backupOverView.setClientVersion(device.getClientVersion());
        backupOverView.setEpaInstallationDate(device.getDeviceCreatedDate());
        backupOverView.setDeviceName(device.getDeviceName());
        backupOverView.setDeviceDeleted(device.isDeleted());
        this.backupOverViewDao.saveDeviceBackupOverView(cloudId, backupOverView);
        this.deviceDao.updateDevice(cloudId, device);
    }

    private String getDateInFormat(Long deviceCreatedDate) {
        SimpleDateFormat df2 = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
        Date dateD = new Date(deviceCreatedDate);
        return df2.format(dateD);
    }

    @Override
    public Long getFirstBackupEndDate(int cloudId, String userName, String deviceUUID) {
        return this.utilDao.getFirstBackupEndDate(cloudId, userName, deviceUUID);
    }

    @Override
    public List<OfficeBackupPolicy> getPolicyForBluKrypt(int cloudId) {
        return this.utilDao.getPolicyForBluKrypt(cloudId);
    }

    @Override
    public void updateDailySyncOverView(int cloudId, long filesExpiredDate, double size) {
        this.fileRevisionDao.reduceUploadSizeOfUserSyncOverView(cloudId, filesExpiredDate, size);
    }

    @Override
    public void updateBackupBatch(int cloudId, String backupBatchId, int totalNoOfFiles, Long totalSize) {
        this.utilDao.updateBackBatch(cloudId, backupBatchId, totalNoOfFiles, totalSize.longValue());
    }

    @Override
    public void updateBackupBatch(int cloudId, ObjectId backupBatchId, String status) {
        this.utilDao.updateBackBatch(cloudId, backupBatchId, status);
    }

    @Override
    public void updatePrevDeviceDeltaToken(int cloudId, String deviceUUID) {
        Device device = this.deviceDao.getDeviceInfoByUUID(cloudId, "", deviceUUID);
        String prevDeltaToken = device.getPrevDeltaToken();
        this.deviceDao.updateDeviceDeltaToken(cloudId, device.getDeviceUUID(), prevDeltaToken, prevDeltaToken);
    }

    @Override
    public void updateBatchStatusInOdServer(ObjectId id, String policyName) {
        this.msUtilDao.updateBatchStatusInOdServer(id, policyName);
    }

    @Override
    public void deleteEventHubForDeviceUUID(int cloudId, String deviceUUID, String action) {
        this.msUtilDao.deleteActionBasedOnBackupBatchStatus(cloudId, deviceUUID, action);
    }

    @Override
    public void updateBackupBatch(int cloudId, ObjectId backupBatchId, String status, int errorCode) {
        this.utilDao.updateBackBatch(cloudId, backupBatchId, status, errorCode);
    }

    @Override
    public void updateUplodedFilesInBackupOverView(int cloudId, String deviceUUID, int totalNoOfFiles, long totalSize, long totalSizeToUpload) {
        this.deviceDao.updateUplodedFilesInBackupOverView(cloudId, deviceUUID, totalNoOfFiles, totalSize, totalSizeToUpload);
    }

    @Override
    public BackupPolicy getBackupPolicy(int cloudId, String policyName) {
        return this.userDao.getBackupPolicyByPolicyName(cloudId, policyName);
    }

    @Override
    public SyncPolicy getSyncPolicy(int cloudId, String policyName) {
        return this.userDao.getSyncPolicyByPolicyName(cloudId, policyName);
    }

    @Override
    public void saveSyncFailedFile(int cloudId, FileInfo fileInfo) {
        FailedFileInfo failedFileInfo = new FailedFileInfo();
        BeanUtils.copyProperties((Object)fileInfo, (Object)failedFileInfo);
        failedFileInfo.setId(new ObjectId(fileInfo.getId()));
        this.utilDao.saveSyncFailedFile(cloudId, failedFileInfo);
    }

    @Override
    public boolean isFileUploadedToday(String userName) {
        List devices = this.deviceDao.getDeviceByUserNameWithRegex(1, userName);
        for (Device device : devices) {
            logger.debug("...deviceUUID..." + device.getDeviceUUID());
            BackUpImage backupFile = this.externalStorageBackupFileDao.getLastUploadedBackupFileBydeviceUUID(1, device);
            if (backupFile == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<String> getAllUniqueBlackListUsersFromLocal(int cloudId, String cloudName) {
        return this.utilDao.getAllUniqueBlackListUsersFromLocal(cloudId, cloudName);
    }

    @Override
    public void restoreMultiFileForBlackListUser(String userName, Cloud cloud) {
        this.fileDao.restoreMultiFileForBlackListUser(userName, cloud);
    }

    @Override
    public boolean isUserO365StorageLimitReached(int cloudId, double newFileSizeAllowed, String userName, String deviceUUID) {
        User user = this.userDao.getUserByName(cloudId, userName);
        logger.debug(user + "... user for storage size... " + userName + "... " + user.getOdbPolicyName());
        if (user != null && StringUtils.isNotEmpty((String)user.getOdbPolicyName())) {
            Long sizeUsedForUser = new Long(0L);
            OfficeBackupPolicy backupPolicy = this.getO365BackupPolicy(cloudId, user.getUserName());
            logger.debug("... user for storage size2... " + backupPolicy);
            if (backupPolicy == null || backupPolicy.isLegalHoldEnabled() || backupPolicy.getMailUserSizeAllowed() == -1 || backupPolicy.getOdUserSizeAllowed() == -1) {
                return false;
            }
            DeviceBackupOverView deviceBackupOverView = this.deviceDao.getDeviceBkpOverviewForDeviceUUID(cloudId, deviceUUID);
            if (deviceBackupOverView != null) {
                sizeUsedForUser = deviceBackupOverView.getStorageUtilized();
            }
            logger.debug("... user for storage size3... " + sizeUsedForUser);
            int userSizeAllowed = 0;
            if (deviceBackupOverView.getDeviceType().equalsIgnoreCase(Device.TYPE.ONEDRIVE.name())) {
                userSizeAllowed = backupPolicy.getOdUserSizeAllowed();
            }
            if (deviceBackupOverView.getDeviceType().equalsIgnoreCase(Device.TYPE.OUTLOOK.name())) {
                userSizeAllowed = backupPolicy.getMailUserSizeAllowed();
            }
            logger.debug(userSizeAllowed + " Size for device user from pg ...... " + sizeUsedForUser);
            double sizeUsedByUserInMb = UtilServiceImpl.getSizeinMb(sizeUsedForUser);
            double userSizeAllowedInMb = UtilServiceImpl.getGBSizeinMb(userSizeAllowed);
            logger.debug(sizeUsedByUserInMb + newFileSizeAllowed + " Size for device user from pg www...... " + userSizeAllowedInMb);
            if (sizeUsedByUserInMb + newFileSizeAllowed > userSizeAllowedInMb) {
                logger.error(sizeUsedByUserInMb + "...DISK will be FULL  for user ........ " + userSizeAllowedInMb);
                return true;
            }
        }
        return false;
    }

    public OfficeBackupPolicy getO365BackupPolicy(int cloudId, String userName) {
        return this.userDao.getOfficeBackupPolicyForUserName(cloudId, userName);
    }

    @Override
    public String getBackupBatchStatusById(int cloudId, String batchId) {
        return this.backUpImageDao.getBackupBatchStatusById(cloudId, batchId);
    }

    @Override
    public Set<String> getBlukryptCollectionsName() {
        return this.fileDao.getBluKyptCollections();
    }

    @Override
    public void dropBluCollBasedonBatchstatus(String collName) {
        this.fileDao.dropBluCollBasedonBatchstatus(collName);
    }

    @Override
    public EWSAppSetting getEwsAppSettingDetail(int cloudId) {
        return this.msUtilDao.getEwsAppSettingDetail(cloudId);
    }

    @Override
    public MailBackupBatch getMailBackupBatch(int cloudId, String deviceUUID) {
        return this.utilDao.getMailBackupBatch(cloudId, deviceUUID);
    }

    @Override
    public void saveMailBackupBatch(int cloudId, MailBackupBatch backupBatch, EventHub eventHub) {
        this.utilDao.saveMailBackupBatch(cloudId, backupBatch, eventHub);
    }

    @Override
    public List<MailBackupBatch> getMailBatchList(int cloudId, String policyName) {
        return this.utilDao.getMailBatchList(cloudId, policyName);
    }

    @Override
    public List<MailRestoreFileInfo> getMailRestoreFileInfoFromListForBatchId(int cloudId, String batchId) {
        return this.utilDao.getMailRestoreFileInfoFromListForBatchId(cloudId, batchId);
    }

    @Override
    public void deleteMailRestoreBatch(int cloudId, ObjectId batchId, String policyName) {
        this.utilDao.deleteMailRestoreBatch(cloudId, batchId, policyName);
    }

    @Override
    public void removeMailRestoreItem(int cloudId, ObjectId mailBackupBatchId, String backupId) {
        this.utilDao.removeMailRestoreItem(cloudId, mailBackupBatchId, backupId);
    }

    @Override
    public void deleteEventHubRestoreForDeviceUUID(int cloudId, String deviceUUID, String action) {
        this.utilDao.deleteEventHubRestoreForDeviceUUID(cloudId, deviceUUID, action);
    }

    @Override
    public com.pg.domain.BackupFile getBackupFileForId(int cloudId, String userName, String backupId) {
        com.pg.domain.BackupFile backupFile = null;
        if (!StringUtils.isEmpty((String)backupId)) {
            logger.debug("....user and id... " + userName + "...." + backupId);
            String deviceUUID = this.backupFileDao.getDeviceUUIDForId(cloudId, "", userName, backupId);
            Device device = this.getDeviceForUUID(cloudId, deviceUUID);
            backupFile = this.backupFileDao.getBackupFilesForId(cloudId, "", userName, device, backupId);
        }
        return backupFile;
    }

    @Override
    public void saveRestoreFileInfo(int cloudId, MailRestoreFileInfo mailRestoreFileInfo) {
        this.utilDao.saveRestoreFileInfo(cloudId, mailRestoreFileInfo);
    }

    @Override
    public void saveRestoreHistory(int cloudId, RestoreHistory restoreHistoy) {
        this.utilDao.saveRestoreHistory(cloudId, restoreHistoy);
    }

    @Override
    public RestoreHistory getRestoreHistoryById(int cloudId, ObjectId batchId) {
        return this.utilDao.getRestoreHistoryById(cloudId, batchId);
    }

    @Override
    public RestoreEventsElement updateRestoreEvents(int cloudId, RestoreEventsElement restoreEventsElement, String userName) {
        RestoreEventsElement eventsElement = this.getRestoreEventByUUIDAndFolder(cloudId, restoreEventsElement.getDestinationDeviceUUID(), "");
        if (eventsElement != null) {
            logger.debug(".....eventsElement..." + eventsElement.toString());
            return eventsElement;
        }
        logger.debug(eventsElement + "...save restore first time ... " + userName);
        this.saveRestoreEvents(cloudId, restoreEventsElement, userName);
        return eventsElement;
    }

    @Override
    public void saveRestoreEvents(int cloudId, RestoreEventsElement restoreEventsElement, String userName) {
        RestoreEvents restoreEvents = new RestoreEvents();
        FileElement fileElement = restoreEventsElement.getFileElement();
        FileInfo fileInfo = new FileInfo();
        fileInfo.setId(fileElement.getBackupId());
        fileInfo.setFolder(fileElement.isFolder());
        fileInfo.setFilePath(fileElement.getFileCompletePath());
        restoreEvents.setDestinationDeviceUUID(restoreEventsElement.getDestinationDeviceUUID());
        restoreEvents.setActionOnDeviceUUID(restoreEventsElement.getActionOnDeviceUUID());
        restoreEvents.setDestinationPath(restoreEventsElement.getDestinationPath());
        restoreEvents.setActionBy(restoreEventsElement.getActionBy());
        restoreEvents.setFileInfo(fileInfo);
        restoreEvents.setInPlaceRestore(restoreEventsElement.isInPlaceRestore());
        restoreEvents.setRestoreAllVersions(restoreEventsElement.isRestoreAllVersions());
        restoreEvents.setRestoreDataBefore(restoreEventsElement.getRestoreDataBefore());
        restoreEvents.setSuspendBackup(restoreEventsElement.isSuspendBackup());
        restoreEvents.setDevice(restoreEventsElement.getFileElement().isDevice());
        restoreEvents.setStatus("QUEUE");
        RestoreEventsElement eventsElement = this.getRestoreEventByUUIDAndFolder(cloudId, restoreEventsElement.getDestinationDeviceUUID(), "");
        if (eventsElement != null) {
            // empty if block
        }
        User user = this.utilDao.getUserForName(cloudId, userName);
        restoreEvents.setOfficePolicyName(user.getOdbPolicyName());
        restoreEvents.setUserName(userName);
        this.utilDao.saveRestoreEvents(cloudId, restoreEvents);
        EventHub eventHub = new EventHub();
        eventHub.setAction(PCHelperConstant.EVENTHUB_ACTION.START_RESTORE.toString());
        eventHub.setActionToDeviceUUID(restoreEvents.getDestinationDeviceUUID());
        eventHub.setActionToUserName(userName);
        boolean checkActionIsPresent = this.checkActionIsPresent(cloudId, eventHub);
        logger.debug("....checkActionIsPresent..." + checkActionIsPresent);
        if (!checkActionIsPresent) {
            eventHub.setActionBy(restoreEventsElement.getActionBy());
            this.utilDao.saveAction(cloudId, eventHub);
        }
    }

    public boolean checkActionIsPresent(int cloudId, EventHub eventHub) {
        return this.utilDao.checkActionIsPresent(cloudId, eventHub);
    }

    @Override
    public RestoreEventsElement getRestoreEventByUUIDAndFolder(int cloudId, String deviceUUID, String destinationFolder) {
        RestoreEvents restoreEventByUUIDAndFolder = this.utilDao.getRestoreEventsByDestUUIDAndFolder(cloudId, deviceUUID, destinationFolder);
        RestoreEventsElement elements = null;
        if (restoreEventByUUIDAndFolder != null) {
            elements = new RestoreEventsElement();
            logger.debug("...Inside loop...." + restoreEventByUUIDAndFolder.getId());
            BeanUtils.copyProperties((Object)restoreEventByUUIDAndFolder, (Object)elements);
            FileElement fileElement = new FileElement();
            fileElement.setFileCompletePath(restoreEventByUUIDAndFolder.getFileInfo().getFilePath());
            fileElement.setFolder(restoreEventByUUIDAndFolder.getFileInfo().isFolder());
            fileElement.setBackupId(restoreEventByUUIDAndFolder.getFileInfo().getId());
            elements.setFileElement(fileElement);
        }
        return elements;
    }

    @Override
    public List<RestoreEvents> getRestoreEventsList(int cloudId, String policyName) {
        return this.utilDao.getRestoreEventsList(cloudId, policyName);
    }

    @Override
    public List<OfficeRestoreFileInfo> getOfficeRestoreFileInfoFromListForBatchId(int cloudId, String batchId) {
        return this.utilDao.getOfficeRestoreFileInfoFromListForBatchId(cloudId, batchId);
    }

    @Override
    public void saveOfficeRestoreFileInfo(int cloudId, OfficeRestoreFileInfo officeRestoreFileInfo) {
        this.utilDao.saveOfficeRestoreFileInfo(cloudId, officeRestoreFileInfo);
    }

    @Override
    public void removeOfficeRestoreDriveItem(int cloudId, ObjectId restoreDriveItemId) {
        this.utilDao.removeOfficeRestoreDriveItem(cloudId, restoreDriveItemId);
    }

    @Override
    public void deleteRestoreEventForDeviceUUID(int cloudId, String deviceUUID, String policyName) {
        this.utilDao.deleteRestoreEventForDeviceUUID(cloudId, deviceUUID, policyName);
    }

    @Override
    public List<BackUpImage> getAllVersionsFromBackupImage(int cloudId, String devicePath, String fileName, Device device) {
        return this.backupFileDao.getAllVersionsFromBackupImage(cloudId, devicePath, fileName, device);
    }

    @Override
    public void updateEwsId(int cloudId, String backupId, String ewsId, String destCollection) {
        this.utilDao.updateEwsId(cloudId, backupId, ewsId, destCollection);
    }

    @Override
    public RestoreProgressEvents getRestoreProgresByDeviceUUID(int cloudId, String deviceUUID, String actionBy) {
        return this.utilDao.getRestoreProgresByDeviceUUID(cloudId, deviceUUID, actionBy);
    }

    @Override
    public void saveRestoreProgressForDevice(int cloudId, RestoreProgressEvents restoreProgressEvents) {
        this.utilDao.saveRestoreProgressForDevice(cloudId, restoreProgressEvents);
    }

    @Override
    public void updateRestoreProgress(int cloudId, int restoredFiles, int restoredSize, long currentFolderRestoredFiles, String currentRestorePath, String deviceUUID, String subject, String actionBy) {
        this.utilDao.updateRestoreProgress(cloudId, restoredFiles, restoredSize, currentFolderRestoredFiles, currentRestorePath, deviceUUID, subject, actionBy);
    }

    @Override
    public void removeRestoreProgress(int cloudId, String deviceUUID) {
        this.utilDao.removeRestoreProgress(cloudId, deviceUUID);
    }

    @Override
    public RestoreProgressEvents getRestoreEventProgressByUUID(int cloudId, String deviceUUID, String loginUserName) {
        return this.utilDao.getRestoreEventProgressByUUID(cloudId, deviceUUID, loginUserName);
    }

    @Override
    public void updateCurrentRestoreProgressPath(int cloudId, long currentFolderRestoredFiles, String currentRestorePath, String deviceUUID) {
        this.utilDao.updateCurrentRestoreProgressPath(cloudId, currentFolderRestoredFiles, currentRestorePath, deviceUUID);
    }

    @Override
    public RestoreEvents getRestoreEventByUUID(int cloudId, String deviceUUID) {
        return this.utilDao.getRestoreEventByUUID(cloudId, deviceUUID);
    }

    @Override
    public long getPgFileCount(int cloudId, String cloudName, String gatewayName) {
        return this.fileDao.getPgFileCount(cloudId, cloudName, gatewayName);
    }

    @Override
    public BackupBatch getLastRestoreBatch(int cloudId, String deviceUUID) {
        return this.utilDao.getLastRestoreBatch(cloudId, deviceUUID);
    }

    @Override
    public Components getComponents(String componentName, int cloudId) {
        return this.componentDao.getComponents(componentName, cloudId);
    }

    @Override
    public void initiateCloudProperties(int cloudId) {
        try {
            Components components = this.getComponents(PCHelperConstant.getComponentName(), 1);
            logger.debug("getting components properties from db of" + components.getComponentName());
            Map componentProperties = components.getComponentsProperties();
            CloudPropertyElement cloudPropertyElement = this.getCloudPropertyElement(1);
            if (cloudPropertyElement == null) {
                logger.debug("cloud property element is null at the first time so setting default values");
                cloudPropertyElement = new CloudPropertyElement();
                logger.debug("Cloud property element vlaue adfsurl>>" + cloudPropertyElement.getAdfsUrl());
            }
            PCHelperConstant.setPropertyFileValueParacloudMountPoint((String)cloudPropertyElement.getMntParacloudPath());
            PCHelperConstant.setPropertyFileValueSslAuthEnabled((String)String.valueOf(cloudPropertyElement.getSslAuthEnabled()));
            logger.debug("Paracloud path----" + PCHelperConstant.getPropertyFileValueParacloudMountPoint());
            if (componentProperties.containsKey("encryptionEnabled")) {
                PCHelperConstant.setPropertyFileValueEncryptionEnabled((String)((String)componentProperties.get("encryptionEnabled")));
            }
            if (componentProperties.containsKey("ftpHost")) {
                PCHelperConstant.setSyncFtpHostProperty((String)((String)componentProperties.get("ftpHost")));
            }
            if (componentProperties.containsKey("syncUploadPath")) {
                PCHelperConstant.setPropertyFileValueSyncUploadPath((String)((String)componentProperties.get("syncUploadPath")));
            }
            if (componentProperties.containsKey("syncFtpEnabled")) {
                PCHelperConstant.setPropertyFileValueSyncFtpEnabled((String)((String)componentProperties.get("syncFtpEnabled")));
            }
            if (componentProperties.containsKey("localStorageEnabled")) {
                PCHelperConstant.setPropertyFileValueLocalStorageEnabled((String)((String)componentProperties.get("localStorageEnabled")));
            }
            if (componentProperties.containsKey("ftpUser")) {
                PCHelperConstant.setSyncFtpUserProperty((String)((String)componentProperties.get("ftpUser")));
            }
            if (componentProperties.containsKey("ftpPwd")) {
                PCHelperConstant.setSyncFtpPwdProperty((String)((String)componentProperties.get("ftpPwd")));
            }
            if (componentProperties.containsKey("odbFrequencyCallValue")) {
                PCHelperConstant.setODBCallFrequency((String)((String)componentProperties.get("odbFrequencyCallValue")));
            }
            if (componentProperties.containsKey("queryLimit")) {
                PCHelperConstant.setQueryLimit((String)((String)componentProperties.get("queryLimit")));
            }
            if (componentProperties.containsKey("proxyPassword")) {
                PCHelperConstant.setProxyPassword((String)((String)componentProperties.get("proxyPassword")));
            }
            if (componentProperties.containsKey("paracloudUrl")) {
                PCHelperConstant.setPropertyFileValueParacloudUrl((String)((String)componentProperties.get("paracloudUrl")));
            }
            if (componentProperties.containsKey("gatewayName")) {
                PCHelperConstant.setPropertyFileValueGatewayname((String)((String)componentProperties.get("gatewayName")));
            }
            if (componentProperties.containsKey("odbUserAgentVal")) {
                PCHelperConstant.setODBDecorationValue((String)((String)componentProperties.get("odbUserAgentVal")));
            }
            if (componentProperties.containsKey("odbRetryFolderVal")) {
                PCHelperConstant.setRetryOdbFolderValue((String)((String)componentProperties.get("odbRetryFolderVal")));
            }
            if (componentProperties.containsKey("bkpColQueryRequired")) {
                PCHelperConstant.setBackupCollectionQueryRequired((String)((String)componentProperties.get("bkpColQueryRequired")));
            }
            if (componentProperties.containsKey("chunkColQueryRequired")) {
                PCHelperConstant.setChunkCollectionQueryRequired((String)((String)componentProperties.get("chunkColQueryRequired")));
            }
            if (componentProperties.containsKey("chunkTotalBuckets")) {
                PCHelperConstant.setChunkTotalBuckets((String)((String)componentProperties.get("chunkTotalBuckets")));
            }
            if (componentProperties.containsKey("updateGatewayWhenChunkNotFound")) {
                PCHelperConstant.setPropertyFileValueUpdatepgnameWhenChunkNotFoundMultipgenv((String)((String)componentProperties.get("updateGatewayWhenChunkNotFound")));
            }
            if (componentProperties.containsKey("deleteBkpTblWhenChnkNotFound")) {
                PCHelperConstant.setPropertyFileValueDeleteBkptblWhenChunksNotFound((String)((String)componentProperties.get("deleteBkpTblWhenChnkNotFound")));
            }
            if (componentProperties.containsKey("noOfJobThreads")) {
                PCHelperConstant.setJobThreadLimit((String)((String)componentProperties.get("noOfJobThreads")));
            }
            if (componentProperties.containsKey("chunkUpdateMaxRetry")) {
                PCHelperConstant.setMaxRetryForChunkUpdate((String)((String)componentProperties.get("chunkUpdateMaxRetry")));
            }
            if (componentProperties.containsKey("proxyHost")) {
                PCHelperConstant.setProxyHost((String)((String)componentProperties.get("proxyHost")));
            }
            if (componentProperties.containsKey("proxyPort")) {
                PCHelperConstant.setProxyPort((String)((String)componentProperties.get("proxyPort")));
            }
            if (componentProperties.containsKey("proxyUserName")) {
                PCHelperConstant.setProxyUserName((String)((String)componentProperties.get("proxyUserName")));
            }
            if (componentProperties.containsKey("pgOverloadLimit")) {
                PCHelperConstant.setPGOverloadLimit((String)((String)componentProperties.get("pgOverloadLimit")));
            }
            if (componentProperties.containsKey("pgOverLoadInactivityPeriod")) {
                PCHelperConstant.setPGOverLoadInactivityPeriod((String)((String)componentProperties.get("pgOverLoadInactivityPeriod")));
            }
            if (componentProperties.containsKey("resoreQueryLimit")) {
                PCHelperConstant.setRestoreQueryLimit((String)((String)componentProperties.get("resoreQueryLimit")));
            }
            if (componentProperties.containsKey("stopJobsEnabled")) {
                PCHelperConstant.setJobsStopEnabled((String)((String)componentProperties.get("stopJobsEnabled")));
            }
            if (componentProperties.containsKey("noOfThreads")) {
                PCHelperConstant.setThreadLimit((String)((String)componentProperties.get("noOfThreads")));
            }
            if (componentProperties.containsKey("delayInUploadInSec")) {
                PCHelperConstant.setDelayInUploadInSec((String)((String)componentProperties.get("delayInUploadInSec")));
            }
            if (componentProperties.containsKey("delayIn429CaseInSec")) {
                PCHelperConstant.setDelayIn429CaseInSec((String)((String)componentProperties.get("delayIn429CaseInSec")));
            }
            if (componentProperties.containsKey("countOfContinuous429")) {
                PCHelperConstant.setCountOfContinuous429((String)((String)componentProperties.get("countOfContinuous429")));
            }
            if (componentProperties.containsKey("countOfODBFiles")) {
                PCHelperConstant.setCountOfODBFiles((String)((String)componentProperties.get("countOfODBFiles")));
            }
            if (componentProperties.containsKey("addn429WaitMultiplier")) {
                logger.debug(".... additional wait for 429 like 1x of sleep... " + (String)componentProperties.get("addn429WaitMultiplier"));
                PCHelperConstant.setAddn429WaitMultiplier((String)((String)componentProperties.get("addn429WaitMultiplier")));
            }
            logger.debug("getPGOverloadLimit..." + PCHelperConstant.getPGOverloadLimit());
        }
        catch (Exception e) {
            logger.error("  ********************EXCEPTION while trying to load " + e);
        }
    }

    @Override
    public CloudPropertyElement getCloudPropertyElement(int cloudId) {
        CloudProperties cloudProperties = this.cloudDao.getCloudProperties(cloudId);
        CloudPropertyElement cloudPropertyElement = null;
        if (cloudProperties != null) {
            cloudPropertyElement = new CloudPropertyElement();
            BeanUtils.copyProperties((Object)cloudProperties, (Object)cloudPropertyElement);
        }
        return cloudPropertyElement;
    }

    @Override
    public void updateUserBackupTargetStatus(int cloudId, String userName, int status) {
        User user = this.userDao.getUserByName(cloudId, userName);
        if (user != null) {
            logger.debug("**************..." + user.getUserName() + "....." + status);
            user.setBackupTargetAssigned(false);
            user.setBackupTargetErrorCode(status);
            this.userDao.saveUser(cloudId, "", user);
        }
    }

    @Override
    public synchronized void saveOrUpdateRestoreForEndPoint(int cloudId, RestoreProgressEvents progressEvents) {
        this.utilDao.saveOrUpdateRestoreForEndPoint(cloudId, progressEvents);
    }

    @Override
    public long getTotalFilesCountByBatchId(String batchId) {
        return this.msUtilDao.getTotalFilesCountByBatchId(batchId);
    }

    @Override
    public long getTotalFilesCountByPrevDelta(String userName) {
        return this.msUtilDao.getTotalFilesCountByPrevDelta(userName);
    }

    @Override
    public void updateTotalNoOFFiles(int cloudId, String batchId, long totalNoOfFiles) {
        this.utilDao.updateTotalNoOFFiles(cloudId, batchId, totalNoOfFiles);
    }

    @Override
    public List<DriveFileInfo> getOneDriveFileInfoFromListForBatchId(int cloudId, String batchId) {
        return this.msUtilDao.getOneDriveFileInfoFromListForBatchId(cloudId, batchId);
    }

    @Override
    public void updateBackupBatchTotalCount(int cloudId, String batchId) {
        this.utilDao.updateBackupBatchTotalCount(cloudId, batchId);
    }

    @Override
    public void savePrevItemsForMailBackup(DriveFileInfo item) {
        this.msUtilDao.savePrevItemsForMailBackup(item);
    }

    @Override
    public List<DriveFileInfo> getPrevItemsForMailBkp(String userName) {
        return this.msUtilDao.getPrevItemsForMailBkp(userName);
    }

    @Override
    public void removeFileInfoForPrevDeltaItem(String driveFileInfoId) {
        this.fileDao.removeFileInfoForPrevDeltaItem(driveFileInfoId);
    }

    @Override
    public void saveBackupAttempt(int cloudId, BackupAttempt attempt) {
        this.utilDao.saveBackupAttempt(cloudId, attempt);
    }

    @Override
    public BackupAttempt getLastBackupAttemptById(int cloudId, String backupBatchId) {
        return this.utilDao.getLastBackupAttemptById(cloudId, backupBatchId);
    }

    @Override
    public RestoreProgressEvents getProgressEvent(int cloudId, String deviceUUID) {
        return this.utilDao.getProgressEvent(cloudId, deviceUUID);
    }

    @Override
    public RestoreEvents getRestoreEvents(int cloudId, String deviceUUID) {
        return this.utilDao.getRestoreEvents(cloudId, deviceUUID);
    }

    @Override
    public void updateBlackListUserWithCode(int cloudId, String userName, String gateWayName, String code) {
        this.blackListUserDao.updateBlackListUserWithCode(cloudId, userName, gateWayName, code);
    }

    @Override
    public void saveImageToBackUp(int cloudId, BackUpImage backUpImage, Device device) {
        this.backUpImageDao.saveImageToBackUp(cloudId, backUpImage, device);
    }

    @Override
    public boolean resetBusyFlag(String cloudName) {
        return this.fileDao.resetBusyFlag(cloudName);
    }

    @Override
    public PrivacyGatewayMapping getPrivacyGatewayMapping(int cloudId, String gatewayName) {
        return this.componentDao.getPrivacyGatewayMapping(cloudId, gatewayName);
    }

    @Override
    public void updateBackupAttempt(int cloudId, String uploadedFiles, String batchId) {
        this.utilDao.updateBackupAttempt(cloudId, uploadedFiles, batchId);
    }

    @Override
    public void updateAttemptForRestart(int cloudId, ObjectId id) {
        this.utilDao.updateAttemptForRestart(cloudId, id);
    }

    @Override
    public void saveEwsAppSetting(int cloudId, EWSAppSetting appSetting) {
        this.msUtilDao.saveEwsAppSetting(cloudId, appSetting);
    }

    @Override
    public void updateGDParentFolderId(int cloudId, String userName, String parabluFolderId) {
        this.utilDao.updateGDParentFolderId(cloudId, userName, parabluFolderId);
    }

    @Override
    public void updateUserLimitMailSent(int cloudId, String deviceUUID, boolean mailSent) {
        this.utilDao.updateUserLimitMailSent(cloudId, deviceUUID, mailSent);
    }

    @Override
    public ChunkDetail getChunkDetailByBkpImageUploadTimeAndChunkUploadedTime(String userName, String dedupVal, String md5, long serverModifiedTime, ChunkDetail chunkDetail, boolean caseInsensitiveCheck) {
        List chunkDetailList = this.externalStorageBackupFileDao.getChunkDetailListForMd5(1, md5, dedupVal, userName, false, caseInsensitiveCheck);
        logger.debug("chunkDetail list:" + chunkDetailList);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)chunkDetailList)) {
            if (this.cloudSettings == null) {
                this.cloudSettings = this.externalStorageBackupFileDao.getCloudSettings(1);
            }
            if (this.cloudSettings != null && this.cloudSettings.getDedupStartTime() != 0L) {
                logger.debug(this.cloudSettings.getDedupStartTime() + "cloudSettings.getDedupStartTime()+ :backupImage.getLastServerModifiedTime() :" + serverModifiedTime);
                chunkDetail = serverModifiedTime > this.cloudSettings.getDedupStartTime() ? (ChunkDetail)chunkDetailList.stream().filter(chunkDetail1 -> chunkDetail1.getChunkCreatedTime() > this.cloudSettings.getDedupStartTime()).findFirst().orElse(null) : (ChunkDetail)chunkDetailList.stream().filter(chunkDetail1 -> chunkDetail1.getChunkCreatedTime() < this.cloudSettings.getDedupStartTime()).findFirst().orElse(null);
            } else {
                chunkDetail = (ChunkDetail)chunkDetailList.get(0);
            }
        }
        return chunkDetail;
    }

    @Override
    public void updateDeferedBatchStatusInOdServer(ObjectId id, String policyName) {
        this.msUtilDao.updateDeferedBatchStatusInOdServer(id, policyName);
    }

    @Override
    public long getTotaFailedlFilesFromPrevBackup(String deviceUUID) {
        return this.msUtilDao.getTotaFailedlFilesFromPrevBackup(deviceUUID);
    }

    @Override
    public void removeFailedFile(String itemId) {
        this.msUtilDao.removeFailedFile(itemId);
    }

    @Override
    public List<ODBBackupBatch> getODBBatchList(String policyName, int limit) {
        return this.msUtilDao.getBatchList(policyName, limit);
    }

    @Override
    public MSGTokens getMsgtoken(int cloudId) {
        return this.pciAuthorizationTokensDao.getMSGTokens(cloudId);
    }

    @Override
    public void saveDriveFileInfo(DriveFileInfo driveFileInfo) {
        this.msUtilDao.saveDriveFileInfo(driveFileInfo);
    }

    @Override
    public void saveO365BlackListUser(int cloudId, O365BlackListUser o365BlackListUser) {
        this.deviceDao.saveO365BlackListUser(cloudId, o365BlackListUser);
    }

    @Override
    public List<DriveFileInfo> getPrevBatchFailedFiles(String deviceUUID) {
        return this.msUtilDao.getPrevBatchFailedFiles(deviceUUID);
    }
}

