/*
 * Decompiled with CFR 0.152.
 */
package com.pg.service.impl;

import com.microsoft.graph.authentication.IAuthenticationProvider;
import com.microsoft.graph.http.GraphServiceException;
import com.microsoft.graph.models.extensions.Drive;
import com.microsoft.graph.models.extensions.IGraphServiceClient;
import com.microsoft.graph.requests.extensions.GraphServiceClient;
import com.microsoft.graph.requests.extensions.IDriveCollectionPage;
import com.microsoft.graph.requests.extensions.IDriveCollectionRequest;
import com.microsoft.graph.requests.extensions.IDriveCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IDriveSearchCollectionPage;
import com.microsoft.graph.requests.extensions.IUserRequestBuilder;
import com.pg.controller.Graph;
import com.pg.element.PciAuthorizationTokenElement;
import com.pg.helper.constant.PCHelperConstant;
import com.pg.httpclient.util.HttpClientUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.DefaultHttpResponseFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicStatusLine;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Office365DownloadServiceImplDataTest {
    private static final String BEARER = "Bearer ";
    private HttpResponse result;
    private PciAuthorizationTokenElement authorizationTokenElement;
    private String deviceUUID;
    private String downloadUrl;
    private String proxyUserName;
    private String password;
    private String host;
    private int port;
    private String driveId;
    private static IGraphServiceClient graphClient;
    private static Logger logger;

    public Office365DownloadServiceImplDataTest(String proxyUserName, String password, String host, int port) {
        this.proxyUserName = proxyUserName;
        this.password = password;
        this.host = host;
        this.port = port;
    }

    public Office365DownloadServiceImplDataTest() {
    }

    public static void main(String[] args) throws IOException {
        Office365DownloadServiceImplDataTest.getGraphClient("eyJ0eXAiOiJKV1QiLCJub25jZSI6ImZJWlh6MWd6QWlsT2x5ek5qRWJJRlZHZ2FUSW8xVHR2cjBST2xKczl2OWciLCJhbGciOiJSUzI1NiIsIng1dCI6Im5PbzNaRHJPRFhFSzFqS1doWHNsSFJfS1hFZyIsImtpZCI6Im5PbzNaRHJPRFhFSzFqS1doWHNsSFJfS1hFZyJ9.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.krKYKPjObOjYHqpjp3NaAxgSHkrKPc0qKszozo1LY7BFzr0wYxpvo_FU_Fn0oGuzF5fMEeDAZCyDPuHsTWMPhthW6yWpkA5TusCwaQp8StR-0Rf7R4yLCL0OQgwRgIC4ZTeldUW8Z9H8w-PD7XWBghcYZeATOot_hTIO4RPAAGrGmYKEflCFW26YXJJNBSDC_wWu3rj8tyvg4mvfpE_IxA_Y2CGrB12xFu1sJE4Q1OQ01w0K5JLQ5Tz3wyfl_QXF6OhiO1Wqjoa9XieUnvXP6jfAPNevFhGVErm-Wkudk51oy8Uy_5y1rMDG5bcXSHPT4rYqMSAUV5bVH48rqtYZwA");
        Office365DownloadServiceImplDataTest.searchItem();
    }

    protected HttpResponse executeDownload() throws ClientProtocolException, IOException {
        logger.debug(" ............new path................." + this.downloadUrl);
        HttpGet httpGet = new HttpGet(this.downloadUrl);
        httpGet.addHeader("Authorization", BEARER + this.authorizationTokenElement.getAccessToken());
        httpGet.addHeader("Accept", "application/json;odata=verbose");
        httpGet.addHeader("Content-Type", "*/*");
        if (!StringUtils.isEmpty((String)PCHelperConstant.getODBDecorationValue())) {
            httpGet.addHeader("User-Agent", PCHelperConstant.getODBDecorationValue());
            logger.debug("..add retry THROTTLE_DECOR..............." + PCHelperConstant.getODBDecorationValue());
        }
        if (StringUtils.isEmpty((String)this.proxyUserName) || StringUtils.isEmpty((String)this.password) || StringUtils.isEmpty((String)this.host) || this.port <= 0) {
            logger.debug(" without proxy ....");
            HttpClient httpclient = HttpClientUtil.getSSlConnection();
            this.result = httpclient.execute((HttpUriRequest)httpGet);
        } else {
            logger.debug(" using proxy ....");
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            credsProvider.setCredentials(new AuthScope(this.host, this.port), (Credentials)new UsernamePasswordCredentials(this.proxyUserName, this.password));
            CloseableHttpClient httpclient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credsProvider).build();
            HttpHost proxy = new HttpHost(this.host, this.port);
            RequestConfig config = RequestConfig.custom().setProxy(proxy).build();
            httpGet.setConfig(config);
            this.result = httpclient.execute((HttpUriRequest)httpGet);
        }
        logger.debug(this.result.getStatusLine().getReasonPhrase() + "...Inside execute..." + this.result.getStatusLine().getStatusCode());
        return this.result;
    }

    protected HttpResponse executeDownloadUsingGraph() throws IOException, ClientProtocolException {
        try {
            HttpGet httpGet = new HttpGet(this.downloadUrl);
            httpGet.addHeader("Authorization", BEARER + this.authorizationTokenElement.getAccessToken());
            httpGet.addHeader("Accept", "application/json;odata=verbose");
            httpGet.addHeader("Content-Type", "*/*");
            if (!StringUtils.isEmpty((String)PCHelperConstant.getODBDecorationValue())) {
                httpGet.addHeader("User-Agent", PCHelperConstant.getODBDecorationValue());
                logger.debug("..add retry THROTTLE_DECOR..............." + PCHelperConstant.getODBDecorationValue());
            }
            if (StringUtils.isEmpty((String)this.proxyUserName) || StringUtils.isEmpty((String)this.password) || StringUtils.isEmpty((String)this.host) || this.port <= 0) {
                logger.debug(" without proxy ....");
                HttpClient httpclient = HttpClientUtil.getSSlConnection();
                this.result = httpclient.execute((HttpUriRequest)httpGet);
            } else {
                logger.debug(" using proxy ....");
                BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                credsProvider.setCredentials(new AuthScope(this.host, this.port), (Credentials)new UsernamePasswordCredentials(this.proxyUserName, this.password));
                CloseableHttpClient httpclient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credsProvider).build();
                HttpHost proxy = new HttpHost(this.host, this.port);
                RequestConfig config = RequestConfig.custom().setProxy(proxy).build();
                httpGet.setConfig(config);
                this.result = httpclient.execute((HttpUriRequest)httpGet);
            }
            logger.debug(this.result.getStatusLine().getReasonPhrase() + "...Inside execute..." + this.result.getStatusLine().getStatusCode());
        }
        catch (GraphServiceException e) {
            logger.error("... failed graph exception ... " + e.getResponseCode());
            DefaultHttpResponseFactory factory = new DefaultHttpResponseFactory();
            this.result = factory.newHttpResponse((StatusLine)new BasicStatusLine((ProtocolVersion)HttpVersion.HTTP_1_1, e.getResponseCode(), null), null);
        }
        return this.result;
    }

    public static void searchItem() throws IOException {
        block4: {
            String driveId = "";
            String id = "";
            try {
                IDriveSearchCollectionPage search = graphClient.users("samis@testpara.onmicrosoft.com").drives().byId("b!cojjwYW6I06HL4g7EaVDWXJ6poHprAZGmVW0O5eTNxR1lU0yD4W4SJO1-L7UUcqk").search("+jUhe8ac+11OFD3VIkXp8Q").buildRequest().get();
                if (search == null || search.getRawObject() == null) {
                    System.out.println("Search object is null...");
                    return;
                }
                System.out.println("search result:" + search.getRawObject().toString());
                JSONObject jsonObject = new JSONObject(search.getRawObject().toString());
                JSONArray jsonArray = jsonObject.getJSONArray("value");
                if (jsonArray.isNull(0)) {
                    System.out.println("search not found.....");
                    return;
                }
                JSONObject jsonObj = (JSONObject)jsonArray.get(0);
                driveId = jsonObj.getJSONObject("parentReference").getString("driveId");
                id = jsonObj.getString("id");
                System.out.println("driveId:" + driveId + " Item id:" + id);
                InputStream stream = (InputStream)graphClient.customRequest("/drives/" + driveId + "/items/" + id + "/content", InputStream.class).buildRequest().get();
                System.out.println("stream...." + stream.available());
                String text = IOUtils.toString((InputStream)stream, (String)StandardCharsets.UTF_8.name());
                System.out.println("text...." + text);
            }
            catch (GraphServiceException e) {
                System.out.println("exception...." + e.getMessage());
                if (e.getResponseCode() != 401) break block4;
                System.out.println("un authorized........");
            }
        }
    }

    public String getPBFolderItemId() {
        String pbFolderItemId = "";
        try {
            Office365DownloadServiceImplDataTest.getGraphClient(this.authorizationTokenElement.getAccessToken());
            IUserRequestBuilder users = graphClient.users(this.authorizationTokenElement.getAccountId());
            IDriveCollectionRequestBuilder drives = users.drives();
            IDriveCollectionRequest buildRequests = drives.buildRequest();
            IDriveCollectionPage iDriveCollectionPages = buildRequests.get();
            for (Drive drive : iDriveCollectionPages.getCurrentPage()) {
                if (!Office365DownloadServiceImplDataTest.isPBDrive(drive.getRawObject().toString())) continue;
                this.driveId = pbFolderItemId = drive.id;
            }
        }
        catch (GraphServiceException e) {
            logger.error("GraphServiceException", (Throwable)e);
            if (e.getResponseCode() == 401) {
                pbFolderItemId = "401";
            }
        }
        catch (Exception e) {
            logger.error("graph exception to get id:", (Throwable)e);
        }
        logger.debug("driveId:" + this.driveId);
        return pbFolderItemId;
    }

    protected static IGraphServiceClient getGraphClient(String accessToken) {
        Graph graph = Graph.getInstance(accessToken);
        graphClient = GraphServiceClient.builder().authenticationProvider((IAuthenticationProvider)graph).buildClient();
        return graphClient;
    }

    private static boolean isPBDrive(String json) {
        boolean pbDrive = false;
        String webUrl = "";
        try {
            JSONObject jsonObject = new JSONObject(json);
            webUrl = (String)jsonObject.get("webUrl");
            String docLibraryName = webUrl.substring(webUrl.lastIndexOf("/") + 1);
            if (!StringUtils.isEmpty((String)docLibraryName) && docLibraryName.equalsIgnoreCase("PB")) {
                pbDrive = true;
            }
        }
        catch (Exception e) {
            logger.error(webUrl + "...unable to get drive .... " + e.getMessage());
            pbDrive = false;
        }
        return pbDrive;
    }

    public HttpResponse getResult() {
        return this.result;
    }

    public void setResult(HttpResponse result) {
        this.result = result;
    }

    public PciAuthorizationTokenElement getToken() {
        return this.authorizationTokenElement;
    }

    public void setToken(PciAuthorizationTokenElement authorizationTokenElement) {
        this.authorizationTokenElement = authorizationTokenElement;
    }

    public String getDeviceUUID() {
        return this.deviceUUID;
    }

    public void setDeviceUUID(String deviceUUID) {
        this.deviceUUID = deviceUUID;
    }

    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    public void setDownloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
    }

    public String getDriveId() {
        return this.driveId;
    }

    public void setDriveId(String driveId) {
        this.driveId = driveId;
    }

    public IGraphServiceClient getGraphClient() {
        return graphClient;
    }

    public void setGraphClient(IGraphServiceClient graphClient) {
        Office365DownloadServiceImplDataTest.graphClient = graphClient;
    }

    static {
        logger = LoggerFactory.getLogger(Office365DownloadServiceImplDataTest.class);
    }
}

