/*
 * Decompiled with CFR 0.152.
 */
package com.pg.service.impl;

import com.microsoft.graph.authentication.IAuthenticationProvider;
import com.microsoft.graph.http.GraphServiceException;
import com.microsoft.graph.models.extensions.Drive;
import com.microsoft.graph.models.extensions.IGraphServiceClient;
import com.microsoft.graph.requests.extensions.GraphServiceClient;
import com.microsoft.graph.requests.extensions.IDriveCollectionPage;
import com.microsoft.graph.requests.extensions.IDriveCollectionRequest;
import com.microsoft.graph.requests.extensions.IDriveCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IDriveSearchCollectionPage;
import com.microsoft.graph.requests.extensions.IUserRequestBuilder;
import com.pg.controller.Graph;
import com.pg.element.PciAuthorizationTokenElement;
import com.pg.helper.constant.PCHelperConstant;
import com.pg.httpclient.util.HttpClientUtil;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.DefaultHttpResponseFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicStatusLine;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Office365DownloadServiceImplData {
    private static final String BEARER = "Bearer ";
    private HttpResponse result;
    private PciAuthorizationTokenElement authorizationTokenElement;
    private String deviceUUID;
    private String downloadUrl;
    private String proxyUserName;
    private String password;
    private String host;
    private int port;
    private String driveId;
    private IGraphServiceClient graphClient;
    private String fileItemId;
    private static Logger logger = LoggerFactory.getLogger(Office365DownloadServiceImplData.class);

    public Office365DownloadServiceImplData(String proxyUserName, String password, String host, int port) {
        this.proxyUserName = proxyUserName;
        this.password = password;
        this.host = host;
        this.port = port;
    }

    public Office365DownloadServiceImplData() {
    }

    protected HttpResponse executeDownload() throws ClientProtocolException, IOException {
        logger.debug(" ............new path................." + this.downloadUrl);
        HttpGet httpGet = new HttpGet(this.downloadUrl);
        httpGet.addHeader("Authorization", BEARER + this.authorizationTokenElement.getAccessToken());
        httpGet.addHeader("Accept", "application/json;odata=verbose");
        httpGet.addHeader("Content-Type", "*/*");
        if (!StringUtils.isEmpty((String)PCHelperConstant.getODBDecorationValue())) {
            httpGet.addHeader("User-Agent", PCHelperConstant.getODBDecorationValue());
            logger.debug("..add retry THROTTLE_DECOR..............." + PCHelperConstant.getODBDecorationValue());
        }
        if (StringUtils.isEmpty((String)this.proxyUserName) || StringUtils.isEmpty((String)this.password) || StringUtils.isEmpty((String)this.host) || this.port <= 0) {
            logger.debug(" without proxy ....");
            HttpClient httpclient = HttpClientUtil.getSSlConnection();
            this.result = httpclient.execute((HttpUriRequest)httpGet);
        } else {
            logger.debug(" using proxy ....");
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            credsProvider.setCredentials(new AuthScope(this.host, this.port), (Credentials)new UsernamePasswordCredentials(this.proxyUserName, this.password));
            CloseableHttpClient httpclient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credsProvider).build();
            HttpHost proxy = new HttpHost(this.host, this.port);
            RequestConfig config = RequestConfig.custom().setProxy(proxy).build();
            httpGet.setConfig(config);
            this.result = httpclient.execute((HttpUriRequest)httpGet);
        }
        logger.debug(this.result.getStatusLine().getReasonPhrase() + "...Inside execute..." + this.result.getStatusLine().getStatusCode());
        return this.result;
    }

    protected HttpResponse executeDownloadUsingGraph() throws IOException, ClientProtocolException {
        try {
            HttpGet httpGet = new HttpGet(this.downloadUrl);
            httpGet.addHeader("Authorization", BEARER + this.authorizationTokenElement.getAccessToken());
            httpGet.addHeader("Accept", "application/json;odata=verbose");
            httpGet.addHeader("Content-Type", "*/*");
            if (!StringUtils.isEmpty((String)PCHelperConstant.getODBDecorationValue())) {
                httpGet.addHeader("User-Agent", PCHelperConstant.getODBDecorationValue());
                logger.debug("..add retry THROTTLE_DECOR..............." + PCHelperConstant.getODBDecorationValue());
            }
            if (StringUtils.isEmpty((String)this.proxyUserName) || StringUtils.isEmpty((String)this.password) || StringUtils.isEmpty((String)this.host) || this.port <= 0) {
                logger.debug(" without proxy ....");
                HttpClient httpclient = HttpClientUtil.getSSlConnection();
                this.result = httpclient.execute((HttpUriRequest)httpGet);
            } else {
                logger.debug(" using proxy ....");
                BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                credsProvider.setCredentials(new AuthScope(this.host, this.port), (Credentials)new UsernamePasswordCredentials(this.proxyUserName, this.password));
                CloseableHttpClient httpclient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credsProvider).build();
                HttpHost proxy = new HttpHost(this.host, this.port);
                RequestConfig config = RequestConfig.custom().setProxy(proxy).build();
                httpGet.setConfig(config);
                this.result = httpclient.execute((HttpUriRequest)httpGet);
            }
            logger.debug(this.result.getStatusLine().getReasonPhrase() + "...Inside execute..." + this.result.getStatusLine().getStatusCode());
        }
        catch (GraphServiceException e) {
            logger.error("... failed graph exception ... " + e.getResponseCode());
            DefaultHttpResponseFactory factory = new DefaultHttpResponseFactory();
            this.result = factory.newHttpResponse((StatusLine)new BasicStatusLine((ProtocolVersion)HttpVersion.HTTP_1_1, e.getResponseCode(), null), null);
        }
        return this.result;
    }

    public String getPBFolderItemId() {
        String pbFolderItemId = "";
        try {
            this.getGraphClient(this.authorizationTokenElement.getAccessToken());
            IUserRequestBuilder users = this.graphClient.users(this.authorizationTokenElement.getAccountId());
            IDriveCollectionRequestBuilder drives = users.drives();
            IDriveCollectionRequest buildRequests = drives.buildRequest();
            IDriveCollectionPage iDriveCollectionPages = buildRequests.get();
            for (Drive drive : iDriveCollectionPages.getCurrentPage()) {
                if (!Office365DownloadServiceImplData.isPBDrive(drive.getRawObject().toString())) continue;
                this.driveId = pbFolderItemId = drive.id;
            }
        }
        catch (GraphServiceException e) {
            logger.error("GraphServiceException", (Throwable)e);
            if (e.getResponseCode() == 401) {
                pbFolderItemId = "401";
            }
        }
        catch (Exception e) {
            logger.error("graph exception to get id:", (Throwable)e);
        }
        logger.debug("driveId:" + this.driveId);
        return pbFolderItemId;
    }

    protected String searchFileItemInOneDrive(String fileName) {
        String fileItemId = "";
        try {
            this.getGraphClient(this.authorizationTokenElement.getAccessToken());
            IDriveSearchCollectionPage search = this.graphClient.users(this.authorizationTokenElement.getAccountId()).drives().byId(this.driveId).search(fileName).buildRequest().get();
            if (search == null || search.getRawObject() == null) {
                logger.debug("Search object is null...");
                return "";
            }
            logger.debug("search result:" + search.getRawObject().toString());
            JSONObject jsonObject = new JSONObject(search.getRawObject().toString());
            JSONArray jsonArray = jsonObject.getJSONArray("value");
            if (jsonArray.isNull(0)) {
                logger.debug("search not found.....");
                return "404";
            }
            JSONObject jsonObj = (JSONObject)jsonArray.get(0);
            this.driveId = jsonObj.getJSONObject("parentReference").getString("driveId");
            this.fileItemId = fileItemId = jsonObj.getString("id");
        }
        catch (GraphServiceException e) {
            logger.error("GraphServiceException", (Throwable)e);
            if (e.getResponseCode() == 401) {
                fileItemId = "401";
            }
        }
        catch (Exception e) {
            logger.error("graph exception to get id:", (Throwable)e);
        }
        return fileItemId;
    }

    protected IGraphServiceClient getGraphClient(String accessToken) {
        Graph graph = Graph.getInstance(accessToken);
        this.graphClient = GraphServiceClient.builder().authenticationProvider((IAuthenticationProvider)graph).buildClient();
        return this.graphClient;
    }

    private static boolean isPBDrive(String json) {
        boolean pbDrive = false;
        String webUrl = "";
        try {
            JSONObject jsonObject = new JSONObject(json);
            webUrl = (String)jsonObject.get("webUrl");
            String docLibraryName = webUrl.substring(webUrl.lastIndexOf("/") + 1);
            if (!StringUtils.isEmpty((String)docLibraryName) && docLibraryName.equalsIgnoreCase("PB")) {
                pbDrive = true;
            }
        }
        catch (Exception e) {
            logger.error(webUrl + "...unable to get drive .... " + e.getMessage());
            pbDrive = false;
        }
        return pbDrive;
    }

    public HttpResponse getResult() {
        return this.result;
    }

    public void setResult(HttpResponse result) {
        this.result = result;
    }

    public PciAuthorizationTokenElement getToken() {
        return this.authorizationTokenElement;
    }

    public void setToken(PciAuthorizationTokenElement authorizationTokenElement) {
        this.authorizationTokenElement = authorizationTokenElement;
    }

    public String getDeviceUUID() {
        return this.deviceUUID;
    }

    public void setDeviceUUID(String deviceUUID) {
        this.deviceUUID = deviceUUID;
    }

    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    public void setDownloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
    }

    public String getDriveId() {
        return this.driveId;
    }

    public void setDriveId(String driveId) {
        this.driveId = driveId;
    }

    public IGraphServiceClient getGraphClient() {
        return this.graphClient;
    }

    public void setGraphClient(IGraphServiceClient graphClient) {
        this.graphClient = graphClient;
    }

    public String getFileItemId() {
        return this.fileItemId;
    }

    public void setFileItemId(String fileItemId) {
        this.fileItemId = fileItemId;
    }
}

