/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.SubjectKeyIdentifier;

public class SignerIdentifier
implements DEREncodable {
    private DEREncodable id;

    public SignerIdentifier(IssuerAndSerialNumber issuerAndSerialNumber) {
        this.setId(issuerAndSerialNumber);
    }

    public SignerIdentifier(SubjectKeyIdentifier subjectKeyIdentifier) {
        this.setId(subjectKeyIdentifier);
    }

    public SignerIdentifier(DEREncodable dEREncodable) {
        this.id = dEREncodable instanceof BERTaggedObject ? SubjectKeyIdentifier.getInstance(((BERTaggedObject)dEREncodable).getObject()) : IssuerAndSerialNumber.getInstance(dEREncodable);
    }

    public SignerIdentifier(SignerIdentifier signerIdentifier) {
        this.id = signerIdentifier.id;
    }

    public static SignerIdentifier getInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof SignerIdentifier) {
            return (SignerIdentifier)object;
        }
        if (object instanceof DEREncodable) {
            return new SignerIdentifier((DEREncodable)object);
        }
        if (object instanceof BERTaggedObject) {
            return SignerIdentifier.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid SignerIdentifier");
    }

    public static SignerIdentifier newInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof SignerIdentifier) {
            return new SignerIdentifier((SignerIdentifier)object);
        }
        if (object instanceof DEREncodable) {
            return new SignerIdentifier((DEREncodable)object);
        }
        if (object instanceof BERTaggedObject) {
            return SignerIdentifier.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid SignerIdentifier");
    }

    public DEREncodable getId() {
        return this.id;
    }

    private void setId(IssuerAndSerialNumber issuerAndSerialNumber) {
        this.id = issuerAndSerialNumber;
    }

    private void setId(SubjectKeyIdentifier subjectKeyIdentifier) {
        this.id = subjectKeyIdentifier;
    }

    public DERObject getDERObject() {
        if (this.id instanceof SubjectKeyIdentifier) {
            return new BERTaggedObject(0, this.id.getDERObject());
        }
        return this.id.getDERObject();
    }
}

