/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.service.settings;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionHelper {
    private static Logger logger = LoggerFactory.getLogger(VersionHelper.class);
    private static final String REG_COMMAND = "reg query ";
    private static final String REGSTR_TOKEN = "REG_SZ";
    private static final String REG_KEY_32 = "\"HKCU\\Software\\ParaBlu\\BluSync\" /v Version";
    private static String productVersion = null;
    private static final String REG_KEY_64 = "\"HKCU64\\Software\\ParaBlu\\BluSync\" /v Version";

    private VersionHelper() {
    }

    static void readVersionDetails() {
        try {
            Process process = Runtime.getRuntime().exec("reg query \"HKCU\\Software\\ParaBlu\\BluSync\" /v Version");
            VersionReader reader = new VersionReader(process.getInputStream());
            reader.startReading();
            process.waitFor();
            String result = reader.getResult();
            int p = result.indexOf(REGSTR_TOKEN);
            if (p == -1 && !VersionHelper.check64Bit(process)) {
                productVersion = null;
                return;
            }
            productVersion = result.substring(p + REGSTR_TOKEN.length()).trim();
        }
        catch (Exception e) {
            logger.error("Exception while Reading Version Details: ", e);
        }
    }

    public static String getProductVersion() {
        return productVersion;
    }

    static boolean check64Bit(Process process) throws IOException, InterruptedException {
        Process process1 = Runtime.getRuntime().exec("reg query \"HKCU64\\Software\\ParaBlu\\BluSync\" /v Version");
        VersionReader reader1 = new VersionReader(process.getInputStream());
        reader1.startReading();
        process1.waitFor();
        String result1 = reader1.getResult();
        int p1 = result1.indexOf(REGSTR_TOKEN);
        return p1 != -1;
    }

    public static void setProductVersion(String productVersion) {
        VersionHelper.productVersion = productVersion;
    }

    static class VersionReader {
        private InputStream is;
        private StringWriter sw;

        VersionReader(InputStream is) {
            this.is = is;
            this.sw = new StringWriter();
        }

        public void startReading() {
            try {
                int c;
                while ((c = this.is.read()) != -1) {
                    this.sw.write(c);
                }
            }
            catch (IOException e) {
                logger.error("IOException while start to read: " + e);
            }
        }

        String getResult() {
            return this.sw.toString();
        }
    }
}

