/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.service.notifications;

import com.parablu.epa.common.service.settings.SettingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryRefreshHelper {
    private static Logger logger = LoggerFactory.getLogger(DirectoryRefreshHelper.class);

    private native void startProcess();

    public void refreshDirectory() {
        Runnable runnable = () -> {
            try {
                this.startProcess();
            }
            catch (Exception e) {
                logger.debug("Exception during directory refresh: ", e);
            }
            catch (UnsatisfiedLinkError e) {
                logger.debug("UnsatisfiedLink error during directory refresh: ", e);
            }
        };
        Thread refreshDirectoryThread = new Thread(runnable);
        refreshDirectoryThread.setDaemon(true);
        refreshDirectoryThread.start();
    }

    static {
        try {
            System.load(SettingHelper.getParabluBaseAppDataFolderUrl() + "\\lib\\shell32\\parabludlr.dll");
            logger.debug("System.load executed for directory refresh");
        }
        catch (UnsatisfiedLinkError e) {
            logger.debug("Error during directory refresh: ", e);
        }
    }
}

