/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.convert;

import java.lang.reflect.Constructor;
import org.simpleframework.xml.convert.Convert;
import org.simpleframework.xml.convert.ConvertException;
import org.simpleframework.xml.convert.Converter;
import org.simpleframework.xml.convert.ConverterCache;

class ConverterFactory {
    private final ConverterCache cache = new ConverterCache();

    public Converter getInstance(Class type) throws Exception {
        Converter converter = (Converter)this.cache.fetch(type);
        if (converter == null) {
            return this.getConverter(type);
        }
        return converter;
    }

    public Converter getInstance(Convert convert) throws Exception {
        Class<? extends Converter> type = convert.value();
        if (type.isInterface()) {
            throw new ConvertException("Can not instantiate %s", type);
        }
        return this.getInstance(type);
    }

    private Converter getConverter(Class type) throws Exception {
        Constructor factory = this.getConstructor(type);
        if (factory == null) {
            throw new ConvertException("No default constructor for %s", type);
        }
        return this.getConverter(type, factory);
    }

    private Converter getConverter(Class type, Constructor factory) throws Exception {
        Converter converter = (Converter)factory.newInstance(new Object[0]);
        if (converter != null) {
            this.cache.cache(type, converter);
        }
        return converter;
    }

    private Constructor getConstructor(Class type) throws Exception {
        Constructor factory = type.getDeclaredConstructor(new Class[0]);
        if (!factory.isAccessible()) {
            factory.setAccessible(true);
        }
        return factory;
    }
}

