/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.view;

import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.service.settings.WindowsSettingsHelper;
import com.parablu.epa.to.NetworkDriveTo;
import com.parablu.epa.view.FontsManager;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MediaHubDialog
extends Dialog {
    private Logger logger = LoggerFactory.getLogger(MediaHubDialog.class);
    public boolean result = false;
    FontsManager fontsManager;

    public MediaHubDialog(Shell shell) {
        super(shell, 0);
    }

    public MediaHubDialog(Shell parent, int style) {
        super(parent, style);
    }

    public boolean open(final Link mediaWebDAVenabled, final Button mediaWebDavButton) {
        Shell parent = this.getParent();
        final Shell shell = new Shell(parent, 67680);
        Display display = parent.getDisplay();
        this.fontsManager = new FontsManager(display);
        shell.setText(this.getText());
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginBottom = 10;
        gridLayout.marginTop = 10;
        shell.setLayout((Layout)gridLayout);
        Point point = parent.getLocation();
        int newx = point.x;
        int newy = point.y + 150;
        shell.setLocation(newx, newy);
        shell.setText("Media Hub Credentials");
        Composite composite = new Composite((Composite)shell, 0x1000000);
        GridLayout compositeGridLayout = new GridLayout();
        compositeGridLayout.marginHeight = 0;
        compositeGridLayout.marginBottom = 0;
        compositeGridLayout.marginTop = 0;
        compositeGridLayout.numColumns = 2;
        compositeGridLayout.verticalSpacing = 5;
        compositeGridLayout.makeColumnsEqualWidth = false;
        composite.setLayout((Layout)compositeGridLayout);
        composite.setLayoutData((Object)new GridData(768));
        Label label1 = new Label(composite, 256);
        label1.setLayoutData((Object)new GridData(768));
        label1.setText("Please enter your media hub credentials below");
        label1.setFont(this.fontsManager.getMediumNormalFont());
        Group mediaCredentials = new Group(composite, 0x1000000);
        GridLayout groupGridLayout = new GridLayout();
        groupGridLayout.numColumns = 2;
        groupGridLayout.makeColumnsEqualWidth = false;
        groupGridLayout.marginHeight = 10;
        groupGridLayout.marginBottom = 5;
        groupGridLayout.verticalSpacing = 5;
        mediaCredentials.setLayout((Layout)groupGridLayout);
        GridData contactGroupGridData = new GridData(768);
        contactGroupGridData.horizontalSpan = 2;
        mediaCredentials.setLayoutData((Object)contactGroupGridData);
        mediaCredentials.setText("User Credentials");
        mediaCredentials.setFont(this.fontsManager.getSmallNormalFont());
        Label label = new Label((Composite)mediaCredentials, 320);
        label.setText("User Name");
        label.setFont(this.fontsManager.getMediumNormalFont());
        final Text text = new Text((Composite)mediaCredentials, 2052);
        GridData gridData = new GridData(768);
        gridData.widthHint = 140;
        text.setLayoutData((Object)gridData);
        Label passwordLabel = new Label((Composite)mediaCredentials, 320);
        passwordLabel.setText("Password");
        passwordLabel.setFont(this.fontsManager.getMediumNormalFont());
        final Text passwordText = new Text((Composite)mediaCredentials, 0x400804);
        GridData passwordGridData = new GridData(768);
        passwordGridData.widthHint = 140;
        passwordText.setLayoutData((Object)passwordGridData);
        Button button = new Button(composite, 8);
        GridData buttonGridData = new GridData();
        buttonGridData.horizontalIndent = 200;
        button.setLayoutData((Object)buttonGridData);
        button.setText("Map Drive");
        button.setFont(this.fontsManager.getMediumNormalFont());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                NetworkDriveTo networkDriveTo;
                if (passwordText.getText().isEmpty() || text.getText().isEmpty()) {
                    MessageBox msg = new MessageBox(shell, 34);
                    msg.setText("Invalid Input");
                    msg.setMessage("Please fill all the fields");
                    msg.open();
                    return;
                }
                if (SettingHelper.isMediaHubEnabled()) {
                    WindowsSettingsHelper.dsconnectWebDAVasNetworkDrive();
                }
                if ((networkDriveTo = WindowsSettingsHelper.mapWebDAVasNetworkDrive(text.getText(), passwordText.getText(), null)).isStatus()) {
                    MessageBox msg = new MessageBox(shell, 34);
                    msg.setText("Media Hub");
                    msg.setMessage("Media hub has been mapped on network drive successfully");
                    msg.open();
                    mediaWebDAVenabled.setText("");
                    mediaWebDavButton.setText("");
                    mediaWebDAVenabled.setText("<a>Media Hub</a> has been successfully mapped.");
                    mediaWebDavButton.setText("Remap Drive");
                    mediaWebDAVenabled.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent event) {
                            Program.launch((String)(SettingHelper.getWebdevDrive() + ":"));
                        }
                    });
                    mediaWebDAVenabled.getParent().layout();
                    MediaHubDialog.this.result = true;
                } else {
                    MessageBox msg = new MessageBox(shell, 34);
                    msg.setText("Media Hub");
                    MediaHubDialog.this.logger.debug("Network error" + networkDriveTo.getErrorMessage());
                    msg.setMessage("BluSync failed to map network drive\n\nDetails:\n" + networkDriveTo.getErrorMessage());
                    msg.open();
                    mediaWebDAVenabled.setText("Click here to map the network drive");
                    mediaWebDavButton.setText("Map Drive");
                    mediaWebDAVenabled.getParent().layout();
                    MediaHubDialog.this.result = false;
                }
                shell.close();
            }
        });
        shell.pack();
        shell.open();
        return this.result;
    }
}

