/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.view;

import com.parablu.epa.common.constants.SyncConstants;
import com.parablu.epa.common.dao.ActivityHistoryImpl;
import com.parablu.epa.common.dao.BackUpFolderDAOImpl;
import com.parablu.epa.common.service.notification.NotificationHelper;
import com.parablu.epa.common.service.settings.PolicyManagementServerHelper;
import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.common.service.support.SupportHelper;
import com.parablu.epa.common.view.BaseView;
import com.parablu.epa.core.adapter.pcb.BackupAdapter;
import com.parablu.epa.core.adapter.pcb.CloudAdapter;
import com.parablu.epa.core.constant.CrawlLifecycle;
import com.parablu.epa.core.constant.StringLiterals;
import com.parablu.epa.core.helper.PropertyHelper;
import com.parablu.epa.core.to.ActivityTO;
import com.parablu.epa.service.alarm.BlusyncThreadHelper;
import com.parablu.epa.service.alarm.ManualSyncHelper;
import com.parablu.epa.service.backup.WindowsCheckBackupPolicy;
import com.parablu.epa.service.notifications.DirectoryRefreshHelper;
import com.parablu.epa.service.notifications.UIHelper;
import com.parablu.epa.service.settings.VersionHelper;
import com.parablu.epa.service.settings.WindowsSettingsHelper;
import com.parablu.epa.view.BluSyncLauncher;
import com.parablu.epa.view.ConsolidatedView;
import com.parablu.epa.view.RestoreBackup;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolTip;
import org.eclipse.swt.widgets.Tray;
import org.eclipse.swt.widgets.TrayItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemTrayUI
extends BaseView {
    private static Logger logger = LoggerFactory.getLogger(SystemTrayUI.class);
    private Shell systrayShell;
    private TrayItem systrayItem;
    private static File uiFile;
    private static FileLock uiFileLock;
    private static FileChannel uiFileChannel;
    private static RandomAccessFile randomAccessFile;
    private ConsolidatedView instance = null;
    private boolean forcestop = true;
    private ImageData systrayImageData = null;
    private Image systrayImage = null;
    private Tray tray = null;
    private Display display = null;
    private Menu menu = null;
    private MenuItem systemStartCrawlMenuItem = null;
    private MenuItem searchMenuItem = null;
    private Timer systrayTimer = null;
    private static CloudAdapter cloudAdapter;
    public static final String RESOURCE = "resource";
    private static final String IMG = "img";
    public static final String FILE_SEPARATOR;
    public static final String PARABLU_LICENSE_EXPIRED_IMAGE;
    private static String userName;
    private static String iP;
    private static String port;
    private static String token;
    private static String cloudName;
    private MenuItem systemStartBackupMenuItem = null;
    private RestoreBackup restoreInstance = null;
    private MenuItem systemPolicyRefreshMenuItem = null;
    private int uiVersion = -1;
    private Menu subMenuForSync = null;
    private Menu subMenuForBackup = null;
    private Menu subMenuForSupport = null;
    private MenuItem restoreMenuItem = null;
    private MenuItem pauseBackup = null;
    private static final String EXCEPTION = "Exception :";
    private static final String HTTPS_PROTOCOL = "https://";
    private static final String PORTAL_URL_CLOUD_NAME = "/portal/auth?c=";
    private static final String PORTAL_URL_PARAM = "&param=";
    private static final String PORTAL_URL = "&url=";
    private static final String FILE = "files";

    public void loadSystemTray() {
        Listener listener2;
        Listener listener;
        Listener listener3;
        if (SettingHelper.isLicenseActive()) {
            this.systrayTimer = new Timer();
            this.systrayTimer.schedule((TimerTask)new SystrayNotificationTask(), 500L, 2000L);
        }
        if (Display.getCurrent() != null && !Display.getCurrent().isDisposed()) {
            try {
                Display.getCurrent().dispose();
            }
            catch (Exception e) {
                logger.error("Exception", (Throwable)e);
            }
        }
        this.display = new Display();
        this.tray = this.display.getSystemTray();
        if (this.tray == null) {
            return;
        }
        logger.info("Loading systray");
        if (SettingHelper.getUiVersion() != 0) {
            this.uiVersion = SettingHelper.getUiVersion();
            logger.debug("UI version in systray" + this.uiVersion);
        }
        this.systrayImageData = new ImageData(SyncConstants.SYNCING_IMAGE);
        ImageData systrayLicenseExpiredImageData = new ImageData(PARABLU_LICENSE_EXPIRED_IMAGE);
        this.systrayShell = new Shell(this.display);
        ToolTip toolTip = new ToolTip(this.systrayShell, 4098);
        if (SettingHelper.isLicenseActive()) {
            this.systrayImage = new Image((Device)this.display, this.systrayImageData.scaledTo(24, 24));
            toolTip.setText(PropertyHelper.SYSTRAY_BALLOONTIP_LABEL);
            toolTip.setMessage(PropertyHelper.SYSTRAY_BALLOONTIP_BELOW_LABEL);
        } else {
            this.systrayImage = new Image((Device)this.display, systrayLicenseExpiredImageData.scaledTo(24, 24));
            toolTip.setText("Paracloud License Expired");
            toolTip.setMessage("Paracloud License Expired");
        }
        this.systrayItem = new TrayItem(this.tray, 0);
        this.systrayItem.setToolTipText(PropertyHelper.SYSTRAY_TOOLTIP_LABEL);
        this.systrayItem.setImage(this.systrayImage);
        if (SettingHelper.getSyncLicenced().equals("true")) {
            listener3 = event -> {
                Runnable runnable = () -> {
                    if (!NotificationHelper.isUpdateDialogueOpened) {
                        logger.debug("Parablu folder clicked is selected.");
                        Program.launch((String)(SettingHelper.getParabluSyncFolder() + StringLiterals.FILE_SEPARATOR + "ParaBlu"));
                    }
                };
                new Thread(runnable).start();
            };
            this.systrayItem.addListener(14, listener3);
        }
        this.systrayItem.setToolTip(toolTip);
        toolTip.setAutoHide(true);
        toolTip.setVisible(true);
        this.menu = new Menu((Decorations)this.systrayShell, 8);
        if (SettingHelper.getSyncLicenced().equalsIgnoreCase("true") && SettingHelper.getBackupLicenced().equalsIgnoreCase("true")) {
            MenuItem syncMenuItem = new MenuItem(this.menu, 64);
            syncMenuItem.setText("&Sync and Share");
            this.subMenuForSync = new Menu(this.menu);
            syncMenuItem.setMenu(this.subMenuForSync);
            MenuItem backupMenuItem = new MenuItem(this.menu, 64);
            backupMenuItem.setText("&Backup");
            this.subMenuForBackup = new Menu(this.menu);
            backupMenuItem.setMenu(this.subMenuForBackup);
            MenuItem supportMenuItem = new MenuItem(this.menu, 64);
            supportMenuItem.setText("&Support");
            this.subMenuForSupport = new Menu(this.menu);
            supportMenuItem.setMenu(this.subMenuForSupport);
        } else {
            this.subMenuForSupport = this.menu;
            if (SettingHelper.getBackupLicenced().equalsIgnoreCase("true")) {
                this.subMenuForBackup = this.menu;
            } else if (SettingHelper.getSyncLicenced().equalsIgnoreCase("true")) {
                this.subMenuForSync = this.menu;
            }
        }
        if (SettingHelper.getSyncLicenced().equals("true")) {
            MenuItem parabluMenuItem = new MenuItem(this.subMenuForSync, 8);
            parabluMenuItem.setText(PropertyHelper.SYSTRAY_OPEN_SHORTCUT_FOLDER_LABEL);
            listener = event -> {
                Runnable runnable = () -> {
                    logger.debug("Clicked to open Parablu folder.");
                    Program.launch((String)(SettingHelper.getParabluSyncFolder() + StringLiterals.FILE_SEPARATOR + "ParaBlu"));
                };
                new Thread(runnable).start();
            };
            parabluMenuItem.addListener(13, listener);
            if (SettingHelper.getSyncLicenced().equals("true")) {
                this.systemStartCrawlMenuItem = new MenuItem(this.subMenuForSync, 8);
                if (SettingHelper.isLicenseActive()) {
                    this.systemStartCrawlMenuItem.setText("Sync Now");
                } else {
                    this.systemStartCrawlMenuItem.setText("License Expired");
                    this.systemStartCrawlMenuItem.setEnabled(false);
                }
                listener2 = event -> {
                    ManualSyncHelper.startManualSync();
                    this.systemStartCrawlMenuItem.setEnabled(false);
                    this.systemStartCrawlMenuItem.setText("");
                    this.systemStartCrawlMenuItem.setText("Currently Syncing...");
                    UIHelper.displaySyncingGif();
                };
                this.systemStartCrawlMenuItem.addListener(13, listener2);
            }
        }
        if (SettingHelper.getBackupLicenced().equalsIgnoreCase("true")) {
            MenuItem portalMenuItem = new MenuItem(this.subMenuForBackup, 8);
            portalMenuItem.setText("My Backup Files");
            listener = event -> new Thread(new Runnable(){

                @Override
                public void run() {
                    logger.debug("Launch Portal Now");
                    try {
                        String authToken = SystemTrayUI.this.getUserAuthenticationToken();
                        this.launchPortal(authToken);
                    }
                    catch (Exception e) {
                        logger.debug(SystemTrayUI.EXCEPTION, (Throwable)e);
                    }
                }

                private void launchPortal(String proxyToken) {
                    cloudName = SettingHelper.getCloudName();
                    String url = port != null ? SystemTrayUI.HTTPS_PROTOCOL + iP + ":" + port + SystemTrayUI.PORTAL_URL_CLOUD_NAME + cloudName + "&u=" + userName + "&t=" + proxyToken + SystemTrayUI.PORTAL_URL + "mydevices" + SystemTrayUI.PORTAL_URL_PARAM : SystemTrayUI.HTTPS_PROTOCOL + iP + SystemTrayUI.PORTAL_URL_CLOUD_NAME + cloudName + "&u=" + userName + "&t=" + proxyToken + SystemTrayUI.PORTAL_URL + "mydevices" + SystemTrayUI.PORTAL_URL_PARAM;
                    Program.launch((String)url);
                }
            }).start();
            portalMenuItem.addListener(13, listener);
        }
        if (SettingHelper.getSyncLicenced().equalsIgnoreCase("true")) {
            MenuItem syncFilesMenuItem = new MenuItem(this.subMenuForSync, 8);
            syncFilesMenuItem.setText("My Files");
            listener = event -> new Thread(new Runnable(){

                @Override
                public void run() {
                    logger.debug("Launch My files Now");
                    try {
                        String authToken = SystemTrayUI.this.getUserAuthenticationToken();
                        this.launchPortal(authToken);
                    }
                    catch (Exception e) {
                        logger.debug(SystemTrayUI.EXCEPTION, (Throwable)e);
                    }
                }

                private void launchPortal(String proxyToken) {
                    cloudName = SettingHelper.getCloudName();
                    String url = port != null ? SystemTrayUI.HTTPS_PROTOCOL + iP + ":" + port + SystemTrayUI.PORTAL_URL_CLOUD_NAME + cloudName + "&u=" + userName + "&t=" + proxyToken + SystemTrayUI.PORTAL_URL + SystemTrayUI.FILE + SystemTrayUI.PORTAL_URL_PARAM : SystemTrayUI.HTTPS_PROTOCOL + iP + SystemTrayUI.PORTAL_URL_CLOUD_NAME + cloudName + "&u=" + userName + "&t=" + proxyToken + SystemTrayUI.PORTAL_URL + SystemTrayUI.FILE + SystemTrayUI.PORTAL_URL_PARAM;
                    Program.launch((String)url);
                }
            }).start();
            syncFilesMenuItem.addListener(13, listener);
        }
        if (SettingHelper.getBackupLicenced().contentEquals("true")) {
            this.systemStartBackupMenuItem = new MenuItem(this.subMenuForBackup, 8);
            if (SettingHelper.isLicenseActive()) {
                this.systemStartBackupMenuItem.setText("Initiate Backup");
            } else {
                this.systemStartBackupMenuItem.setText("License Expired");
                this.systemStartBackupMenuItem.setEnabled(false);
            }
            listener3 = event -> {
                NotificationHelper.setBackupStatus((int)1);
                BackUpFolderDAOImpl backUpFolderDAOImpl = new BackUpFolderDAOImpl(SettingHelper.getBackUpDbUrl());
                List listOfFolder = backUpFolderDAOImpl.getAllFolderToBackUpFiles();
                if (listOfFolder.isEmpty()) {
                    NotificationHelper.setBackupStatus((int)2);
                    UIHelper.updateSystrayToolTipNotification("ParaBlu Blusync", "You have no folders configured for backup");
                } else {
                    ManualSyncHelper.startManualBackup();
                    this.systemStartBackupMenuItem.setEnabled(false);
                    this.systemStartBackupMenuItem.setText("");
                    this.systemStartBackupMenuItem.setText("Backup in progress");
                    UIHelper.displaySyncingGif();
                }
            };
            this.systemStartBackupMenuItem.addListener(13, listener3);
        }
        if (SettingHelper.getBackupLicenced().contentEquals("true")) {
            MenuItem newSettingsMenuItem = new MenuItem(this.subMenuForBackup, 8);
            newSettingsMenuItem.setText("Backup Settings");
            listener = event -> {
                if (SettingHelper.getLdapEnabled().equalsIgnoreCase("true") && this.uiVersion == 1) {
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            logger.debug("Launch new settings UI Now");
                            try {
                                String authToken = SystemTrayUI.this.getUserAuthenticationToken();
                                this.launchnewSettings(authToken);
                            }
                            catch (Exception e) {
                                logger.debug(SystemTrayUI.EXCEPTION, (Throwable)e);
                            }
                        }

                        private void launchnewSettings(String proxyToken) {
                            cloudName = SettingHelper.getCloudName();
                            String url = port != null ? SystemTrayUI.HTTPS_PROTOCOL + iP + ":" + port + SystemTrayUI.PORTAL_URL_CLOUD_NAME + cloudName + "&u=" + userName + "&t=" + proxyToken + SystemTrayUI.PORTAL_URL + "mybackup" + SystemTrayUI.PORTAL_URL_PARAM + "&v=" + VersionHelper.getProductVersion() + "&action=" + SettingHelper.getDeviceName() : SystemTrayUI.HTTPS_PROTOCOL + iP + SystemTrayUI.PORTAL_URL_CLOUD_NAME + cloudName + "&u=" + userName + "&t=" + proxyToken + SystemTrayUI.PORTAL_URL + "mybackup" + SystemTrayUI.PORTAL_URL_PARAM + "&v=" + VersionHelper.getProductVersion() + "&id=" + SettingHelper.getDeviceUUId() + "&action=" + SettingHelper.getDeviceName();
                            Program.launch((String)url);
                        }
                    }).start();
                } else {
                    logger.debug("Settings or  Preferences is selected.");
                    this.loadParaBluClient();
                }
            };
            newSettingsMenuItem.addListener(13, listener);
        }
        if (SettingHelper.getSyncLicenced().contentEquals("true")) {
            MenuItem syncSettingsMenuItem = new MenuItem(this.subMenuForSync, 8);
            syncSettingsMenuItem.setText("Sync Settings");
            listener = event -> {
                logger.debug("Settings or Preferences is selected.");
                this.loadParaBluClient();
            };
            syncSettingsMenuItem.addListener(13, listener);
        }
        if (SettingHelper.getLdapEnabled().equalsIgnoreCase("true") && SettingHelper.getBackupLicenced().equalsIgnoreCase("true")) {
            this.systemPolicyRefreshMenuItem = new MenuItem(this.subMenuForBackup, 8);
            this.systemPolicyRefreshMenuItem.setText("Refresh Policy");
            listener3 = event -> {
                Runnable runnable = () -> {
                    WindowsCheckBackupPolicy.checkGroupPolicy();
                    BlusyncThreadHelper.initiateBackup();
                };
                new Thread(runnable).start();
            };
            this.systemPolicyRefreshMenuItem.addListener(13, listener3);
        }
        if (SettingHelper.getSyncLicenced().equals("true")) {
            this.searchMenuItem = new MenuItem(this.subMenuForSync, 8);
            this.searchMenuItem.setText("Search ");
            if (!SettingHelper.isLicenseActive()) {
                this.searchMenuItem.setEnabled(false);
            }
            listener3 = event -> new Thread(new Runnable(){

                @Override
                public void run() {
                    logger.debug("Launch Search");
                    String authToken = null;
                    try {
                        authToken = SystemTrayUI.this.getUserAuthenticationToken();
                        this.searchFolder(authToken);
                    }
                    catch (Exception e) {
                        logger.debug(SystemTrayUI.EXCEPTION, (Throwable)e);
                    }
                }

                private void searchFolder(String authToken) throws UnsupportedEncodingException {
                    cloudName = SettingHelper.getCloudName();
                    String url = port != null ? SystemTrayUI.HTTPS_PROTOCOL + iP + ":" + Integer.valueOf(port) + SystemTrayUI.PORTAL_URL_CLOUD_NAME + cloudName + "&u=" + userName + "&t=" + authToken + SystemTrayUI.PORTAL_URL + "search" + SystemTrayUI.PORTAL_URL_PARAM + URLEncoder.encode("ParaBlu", "UTF-8") : SystemTrayUI.HTTPS_PROTOCOL + iP + SystemTrayUI.PORTAL_URL_CLOUD_NAME + cloudName + "&u=" + userName + "&t=" + authToken + SystemTrayUI.PORTAL_URL + "search" + SystemTrayUI.PORTAL_URL_PARAM + URLEncoder.encode("ParaBlu", "UTF-8");
                    Program.launch((String)url);
                }
            }).start();
            this.searchMenuItem.addListener(13, listener3);
        }
        if (SettingHelper.getBackupLicenced().equalsIgnoreCase("true")) {
            this.restoreMenuItem = new MenuItem(this.subMenuForBackup, 8);
            this.restoreMenuItem.setText("Restore");
            listener3 = event -> {
                logger.debug("Launch portal now.....");
                this.loadRestoreUI();
            };
            this.restoreMenuItem.addListener(13, listener3);
        }
        MenuItem supportLogMenuItem = new MenuItem(this.subMenuForSupport, 8);
        supportLogMenuItem.setText("Support Logs");
        listener = event -> {
            if (SupportHelper.isSupportRequestInitiated()) {
                logger.debug("Support Request is Initiated: " + SupportHelper.isSupportRequestInitiated());
                return;
            }
            int logsSent = SupportHelper.sendNewSupportLogs((String)SettingHelper.getCloudName(), (String)SettingHelper.getUserName(), (String)SettingHelper.getDeviceName(), (boolean)true);
            Shell shell = new Shell(this.display);
            if (logsSent == 2) {
                MessageBox messageBox = new MessageBox(shell, 34);
                messageBox.setText("Support Request Raised Successfully");
                messageBox.setMessage("Thank you for contacting ParaBlu Support.\n We will get back to you shortly. Your request Id is " + SupportHelper.getSupportRequestId() + "\n Please note this for all future correspondence.");
                messageBox.open();
            } else if (logsSent == 1) {
                MessageBox messageBox = new MessageBox(shell, 40);
                messageBox.setMessage("Failed to send logs.");
                messageBox.setText("Request Failed");
                messageBox.open();
            }
        };
        supportLogMenuItem.addListener(13, listener);
        if (SettingHelper.getBackupLicenced().equalsIgnoreCase("true")) {
            this.pauseBackup = new MenuItem(this.subMenuForBackup, 8);
            this.pauseBackup.setText("Stop Backup");
            this.pauseBackup.setEnabled(false);
            listener2 = event -> {
                if (NotificationHelper.isBackUpStarted()) {
                    logger.debug("Calling stop backup.");
                    this.pauseBackup.setText("Stopping Backup...");
                    BlusyncThreadHelper.cancelCurrentBackupProcess();
                }
            };
            this.pauseBackup.addListener(13, listener2);
        }
        MenuItem decoupleMenuItem = new MenuItem(this.menu, 8);
        decoupleMenuItem.setText("Decouple User");
        decoupleMenuItem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                logger.debug("Settings decouple is selected.");
                Shell shell = new Shell(SystemTrayUI.this.display);
                MessageBox dialog = new MessageBox(shell, 200);
                dialog.setText("Decouple Device");
                dialog.setMessage("Are you sure you want to decouple this computer?");
                int result = dialog.open();
                if (result == 64) {
                    logger.debug("Clicked on Decouple button");
                    this.sendDecoupleRequest();
                    WindowsSettingsHelper.dsconnectWebDAVasNetworkDrive();
                    DirectoryRefreshHelper directoryRefreshHelper = new DirectoryRefreshHelper();
                    directoryRefreshHelper.refreshDirectory();
                    BluSyncLauncher.changeAccount();
                }
            }

            private int sendDecoupleRequest() {
                BackupAdapter backupAdapter = new BackupAdapter(SettingHelper.getCloudName(), SettingHelper.getKeystorePath());
                int response = 0;
                try {
                    response = backupAdapter.getDecoupleResponse(SettingHelper.getCurrentCloudIpAddress(), SettingHelper.getDeviceUUId(), SettingHelper.readTokenFromFile());
                }
                catch (Exception e) {
                    logger.trace("" + e);
                    logger.error(SystemTrayUI.EXCEPTION + e.getMessage());
                }
                return response;
            }
        });
        MenuItem systemTrayExit = new MenuItem(this.menu, 8);
        systemTrayExit.setText("Exit");
        Listener listener22 = event -> {
            logger.debug("Exiting Client Application");
            this.stopTimer();
            SystemTrayUI.unlockFileUI();
            if (this.instance != null) {
                this.instance.close(true);
                this.instance = null;
            }
            this.systrayItem.dispose();
            this.systrayShell.getDisplay().dispose();
            this.systrayShell.dispose();
            this.checkCrawlStatusAndUpdateTable();
            if (SettingHelper.process != null) {
                SettingHelper.process.destroy();
            }
            SettingHelper.deleteParaBluFolderPathTempFile();
            SettingHelper.deleteUserValidityFilePath();
            SettingHelper.deleteNotSyncedFile();
            DirectoryRefreshHelper directoryRefreshHelper = new DirectoryRefreshHelper();
            directoryRefreshHelper.refreshDirectory();
            if (NotificationHelper.isBackUpStarted()) {
                PolicyManagementServerHelper.updateFailCodeToActivityHistory((int)911);
                PolicyManagementServerHelper.sendCurrentStatisticsToServerBeforeExit((String)"FAILED");
            }
            System.exit(0);
        };
        systemTrayExit.addListener(13, listener22);
        Listener lstnr = event -> {
            logger.debug("System Tray - Menu Detection Listener");
            this.menu.setVisible(true);
            if (SettingHelper.getUiVersion() != -1) {
                this.uiVersion = SettingHelper.getUiVersion();
            }
        };
        this.systrayItem.addListener(35, lstnr);
        logger.debug("Systray loading and listeners attached");
        UIHelper.setSystemTrayUI(this, this.display);
        while (this.systrayShell != null && !this.systrayShell.isDisposed() && this.forcestop) {
            if (this.display.isDisposed() || this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
        this.stopTimer();
        if (this.systrayImage != null && !this.systrayImage.isDisposed()) {
            this.systrayImage.dispose();
        }
        if (this.systrayItem != null && !this.systrayItem.isDisposed()) {
            this.systrayItem.dispose();
        }
        if (this.systrayShell != null && !this.systrayShell.isDisposed()) {
            this.systrayShell.dispose();
        }
        if (this.display != null && !this.display.isDisposed()) {
            this.display.dispose();
        }
        this.systrayItem = null;
        this.systrayImage = null;
        this.display = null;
        this.systrayShell = null;
    }

    protected void checkCrawlStatusAndUpdateTable() {
        if (NotificationHelper.getMainStatus() != 101 || NotificationHelper.getCurrentActivityState() != 8) {
            return;
        }
        ActivityHistoryImpl activityHistoryHandle = new ActivityHistoryImpl(SettingHelper.getActivityDBUrl());
        ActivityTO activity = new ActivityTO();
        Date crawlDate = new Date(Long.valueOf(NotificationHelper.getCurrentCrawlTimeStamp()));
        activity.setActivityTimeStamp(crawlDate);
        activity.setActivityName(CrawlLifecycle.EXITED.name());
        activity.setUploadCount(NotificationHelper.getUploadCount());
        activity.setDownloadCount(NotificationHelper.getDowloadCount());
        activity.setActivityID(NotificationHelper.getCurrentActivityId());
        activityHistoryHandle.updateEventToActivityHistoryTable(activity);
    }

    public synchronized void stopTimer() {
        if (this.systrayTimer != null) {
            this.systrayTimer.cancel();
            this.systrayTimer = null;
        }
    }

    public void loadParaBluClient() {
        try {
            if (this.display == null || this.display.isDisposed()) {
                return;
            }
            this.acquireLockForNewUI();
            this.createConsolidatedViewInstance();
        }
        catch (Exception e) {
            logger.error("Exception while creating BluSync GUI" + e);
        }
    }

    private void createConsolidatedViewInstance() {
        Runnable runnable = () -> {
            try {
                this.instance = null;
                this.instance = new ConsolidatedView(uiFileLock);
            }
            catch (Exception e) {
                logger.error("Exception during instantiation of UI" + e);
            }
        };
        this.display.asyncExec(runnable);
    }

    public void loadRestoreUI() {
        try {
            if (this.display == null || this.display.isDisposed()) {
                return;
            }
            this.acquireLockForNewUI();
            this.createRestoreBkupInstance();
        }
        catch (Exception e) {
            logger.error("Exception while creating BluSync GUI" + e);
        }
    }

    private void createRestoreBkupInstance() {
        Runnable runnable = () -> {
            try {
                this.restoreInstance = null;
                this.restoreInstance = new RestoreBackup(uiFileLock);
                this.restoreInstance.setText("Restore Backup");
                this.restoreInstance.startRestoreBackup();
                this.restoreInstance.openShell();
            }
            catch (Exception e) {
                logger.error("Exception during instantiation of UI" + e);
            }
        };
        this.display.asyncExec(runnable);
    }

    private void acquireLockForNewUI() throws Exception {
        boolean fileLockSuccess = false;
        uiFile = new File(SettingHelper.getUiLockUrl());
        if (uiFile.exists()) {
            logger.debug("Trying to delete uiFile");
            uiFile.delete();
        }
        randomAccessFile = new RandomAccessFile(uiFile, "rw");
        uiFileChannel = randomAccessFile.getChannel();
        try {
            uiFileLock = uiFileChannel.tryLock();
            logger.debug("Trying to acquire uiFileLock");
            fileLockSuccess = true;
        }
        catch (IOException e) {
            logger.error("IOException; UI Already active,cant acquire file Lock." + e);
        }
        catch (OverlappingFileLockException e) {
            logger.error("UI Already active,cant acquire file Lock" + e);
        }
        if (!fileLockSuccess || uiFileLock == null) {
            uiFileChannel.close();
            if (this.instance != null && this.instance.shell != null) {
                logger.debug("Trying to maximise");
                this.instance.shell.open();
            }
            throw new Exception("Instance already running. Unable to acquire lock. Terminate application.");
        }
        ShutdownHookUI shutdownHook = new ShutdownHookUI();
        Runtime.getRuntime().addShutdownHook(shutdownHook);
    }

    public static synchronized void unlockFileUI() {
        try {
            if (uiFileLock != null) {
                uiFileLock.release();
            }
        }
        catch (IOException e) {
            logger.error("IOException in uiFileLock" + e);
        }
        logger.debug("Trying to delete the UI File");
        try {
            if (uiFileChannel != null) {
                uiFileChannel.close();
            }
        }
        catch (IOException e1) {
            logger.error("IOException in uiFileChannel" + e1);
        }
        catch (Exception e1) {
            logger.error(EXCEPTION + e1);
        }
        if (uiFile != null && uiFile.exists()) {
            logger.debug("Deleting UI File");
            uiFile.delete();
        }
        uiFile = null;
        uiFileLock = null;
        uiFileChannel = null;
    }

    public synchronized void disposeSystrayUIShells() {
        this.stopTimer();
        if (this.instance != null) {
            this.instance.close(false);
            SystemTrayUI.unlockFileUI();
        }
        this.menu.dispose();
        this.systrayImage.dispose();
        this.systrayItem.dispose();
        this.systrayShell.dispose();
        this.tray.dispose();
        this.display.dispose();
    }

    public String getUserAuthenticationToken() throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        iP = SettingHelper.getCurrentCloudIpAddress();
        port = SettingHelper.getCurrentHttpsPort();
        token = SettingHelper.readTokenFromFile();
        cloudName = SettingHelper.getCloudName();
        userName = SettingHelper.getUserName();
        cloudAdapter = new CloudAdapter(cloudName, SettingHelper.getKeystorePath());
        String proxyToken = null;
        String[] resArray = port == null ? cloudAdapter.getAuthenticationToken(iP, null, token, userName) : cloudAdapter.getAuthenticationToken(iP, Integer.valueOf(port), token, userName);
        if (resArray != null) {
            proxyToken = resArray[0];
            SettingHelper.setCloudName((String)resArray[1]);
            cloudName = SettingHelper.getCloudName();
        }
        return proxyToken;
    }

    public MenuItem getSystemStartCrawl() {
        return this.systemStartCrawlMenuItem;
    }

    public MenuItem getSearchMenuItem() {
        return this.searchMenuItem;
    }

    public Shell getSystrayShell() {
        return this.systrayShell;
    }

    public void setSystrayShell(Shell systrayShell) {
        this.systrayShell = systrayShell;
    }

    public TrayItem getSystrayItem() {
        return this.systrayItem;
    }

    public void setSystrayItem(TrayItem systrayItem) {
        this.systrayItem = systrayItem;
    }

    public ConsolidatedView getInstance() {
        return this.instance;
    }

    public MenuItem systemStartBackupMenuItem() {
        return this.systemStartBackupMenuItem;
    }

    public MenuItem systemPolicyRefreshMenuItem() {
        return this.systemPolicyRefreshMenuItem;
    }

    static {
        cloudAdapter = null;
        FILE_SEPARATOR = System.getProperty("file.separator");
        PARABLU_LICENSE_EXPIRED_IMAGE = RESOURCE + FILE_SEPARATOR + IMG + FILE_SEPARATOR + "ParaBlu_2.png";
        userName = null;
        iP = null;
        port = null;
        token = null;
        cloudName = null;
    }

    class SystrayNotificationTask
    extends TimerTask {
        SystrayNotificationTask() {
        }

        @Override
        public void run() {
            if (SystemTrayUI.this.display == null) {
                return;
            }
            Runnable runnable = () -> {
                try {
                    if (NotificationHelper.getMainStatus() == 100) {
                        if (!(SystemTrayUI.this.systemStartCrawlMenuItem == null || SystemTrayUI.this.systemStartCrawlMenuItem.isDisposed() || SystemTrayUI.this.systemStartCrawlMenuItem.getEnabled() || SettingHelper.getSyncLicenced().contentEquals("false"))) {
                            SystemTrayUI.this.systemStartCrawlMenuItem.setEnabled(true);
                            SystemTrayUI.this.systemStartCrawlMenuItem.setText("");
                            SystemTrayUI.this.systemStartCrawlMenuItem.setText("Sync Now");
                        }
                        return;
                    }
                    if (NotificationHelper.getCurrentActivityState() != 9) {
                        if (SystemTrayUI.this.systemStartCrawlMenuItem != null && !SystemTrayUI.this.systemStartCrawlMenuItem.isDisposed() && SystemTrayUI.this.systemStartCrawlMenuItem.getEnabled()) {
                            SystemTrayUI.this.systemStartCrawlMenuItem.setEnabled(false);
                            SystemTrayUI.this.systemStartCrawlMenuItem.setText("");
                            SystemTrayUI.this.systemStartCrawlMenuItem.setText("Currently Syncing...");
                            UIHelper.displaySyncingGif();
                        }
                        return;
                    }
                }
                catch (Exception e) {
                    logger.error("Exception during the crawl process " + e);
                }
            };
            SystemTrayUI.this.display.asyncExec(runnable);
            SystemTrayUI.this.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (SettingHelper.getBackupLicenced().equalsIgnoreCase("true") && SettingHelper.getIsEnableBackupPolicy().contentEquals("true")) {
                            if (NotificationHelper.policyRefreshStarted) {
                                if (SystemTrayUI.this.systemPolicyRefreshMenuItem != null && !SystemTrayUI.this.systemPolicyRefreshMenuItem.isDisposed() && SystemTrayUI.this.systemPolicyRefreshMenuItem.getEnabled()) {
                                    SystemTrayUI.this.systemPolicyRefreshMenuItem.setEnabled(false);
                                    SystemTrayUI.this.systemPolicyRefreshMenuItem.setText("");
                                    SystemTrayUI.this.systemPolicyRefreshMenuItem.setText("Refreshing Policy");
                                }
                            } else {
                                SystemTrayUI.this.systemPolicyRefreshMenuItem.setEnabled(true);
                                SystemTrayUI.this.systemPolicyRefreshMenuItem.setText("");
                                SystemTrayUI.this.systemPolicyRefreshMenuItem.setText("Refresh Policy");
                            }
                        }
                        if (SettingHelper.getBackupLicenced().contentEquals("true")) {
                            if (NotificationHelper.backUpStarted) {
                                this.updateBackupProgressTooltip();
                                SystemTrayUI.this.pauseBackup.setEnabled(true);
                                SystemTrayUI.this.restoreMenuItem.setEnabled(false);
                                if (SystemTrayUI.this.systemStartBackupMenuItem != null && !SystemTrayUI.this.systemStartBackupMenuItem.isDisposed() && SystemTrayUI.this.systemStartBackupMenuItem.getEnabled()) {
                                    SystemTrayUI.this.systemStartBackupMenuItem.setEnabled(false);
                                    SystemTrayUI.this.systemStartBackupMenuItem.setText("");
                                    SystemTrayUI.this.systemStartBackupMenuItem.setText("Backup in progress");
                                    UIHelper.displaySyncingGif();
                                }
                                return;
                            }
                            SystemTrayUI.this.systemStartBackupMenuItem.setEnabled(true);
                            SystemTrayUI.this.systemStartBackupMenuItem.setText("");
                            SystemTrayUI.this.systemStartBackupMenuItem.setText("Initiate Backup");
                            SystemTrayUI.this.restoreMenuItem.setEnabled(true);
                            SystemTrayUI.this.systrayItem.setToolTipText(PropertyHelper.SYSTRAY_TOOLTIP_LABEL);
                            SystemTrayUI.this.pauseBackup.setText("Stop Backup");
                            SystemTrayUI.this.pauseBackup.setEnabled(false);
                            if (NotificationHelper.getMainStatus() == 100) {
                                UIHelper.updateSystrayImageAccordingToStage(SyncConstants.PARABLU_IMAGE);
                            }
                            return;
                        }
                    }
                    catch (Exception e) {
                        logger.error("Exception during the crawl process " + e);
                    }
                }

                private void updateBackupProgressTooltip() {
                    String filesCount = NotificationHelper.getTotalBackupCount() + "/" + NotificationHelper.getNoOfFilesToBeBackedUp();
                    SystemTrayUI.this.systrayItem.setToolTipText("Backup in Progress. " + filesCount + SystemTrayUI.FILE);
                }
            });
        }
    }

    static class ShutdownHookUI
    extends Thread {
        ShutdownHookUI() {
        }

        @Override
        public void run() {
            SystemTrayUI.unlockFileUI();
        }
    }
}

