/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.core.adapter.pcb;

import com.parablu.epa.core.adapter.BaseAdapter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateAdapter
extends BaseAdapter {
    private Logger logger = LoggerFactory.getLogger(UpdateAdapter.class);
    private static final String CLOUD = "/cloud";

    public UpdateAdapter(String cloudName, String keyStorePath) {
        super(cloudName, keyStorePath);
    }

    public UpdateAdapter(InputStream stream, String cloudName) {
        super(stream, cloudName);
    }

    public String checkCloudForVersion(String ip, Integer port, String productVersion, String productType) {
        this.logger.debug("Entering check cloud for version");
        String cloudVersion = null;
        HttpResponse httpResponse = null;
        try {
            URI uri = port != null ? this.formHttpsUri(ip, port, "/paracloud/cloud" + this.cloudName + "/update/details") : this.formHttpsUri(ip, "/paracloud/cloud" + this.cloudName + "/update/details");
            HttpPost httpPost = new HttpPost(uri);
            this.logger.debug("URL: " + uri);
            httpPost.setHeader("version-type", productType);
            httpPost.setHeader("current-version", productVersion);
            httpResponse = this.httpclient.execute((HttpUriRequest)httpPost);
        }
        catch (Exception e) {
            this.logger.error("Exception", (Throwable)e);
        }
        if (httpResponse == null) {
            return null;
        }
        if (httpResponse.getStatusLine().getStatusCode() == 200) {
            cloudVersion = httpResponse.getFirstHeader("current-version").getValue();
        }
        try {
            if (httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
        catch (IOException e) {
            this.logger.error("Exception", (Throwable)e);
        }
        return cloudVersion;
    }

    public boolean downloadLatestVersion(String ip, Integer port, String cloudName, String productVersion, String productType, String downloadUrl, String deviceUUID) {
        HttpResponse httpResponse = null;
        boolean downloaded = false;
        this.logger.debug("Inside UpdateAdapter.downloadLatestVersion ");
        this.logger.debug("Values : IP" + ip + " Port :" + port + " Cloud name :" + cloudName + " productVersion :" + productVersion + " productType :" + productType);
        try {
            URI uri = port != null ? this.formHttpsUri(ip, port, "/paracloud/cloud" + this.cloudName + "/update/download") : this.formHttpsUri(ip, "/paracloud/cloud" + this.cloudName + "/update/download");
            this.logger.debug("Going to execute url " + uri);
            this.logger.debug("Headers version-type:" + productType);
            this.logger.debug("Headers current-version:" + productVersion);
            HttpGet httpGet = new HttpGet(uri);
            httpGet.setHeader("version-type", productType);
            httpGet.setHeader("current-version", productVersion);
            httpGet.setHeader("deviceUUID", deviceUUID);
            httpResponse = this.httpclient.execute((HttpUriRequest)httpGet);
            this.logger.debug("HTTP Response " + httpResponse.getStatusLine().getStatusCode());
        }
        catch (Exception e) {
            this.logger.error("Exception", (Throwable)e);
        }
        if (httpResponse == null) {
            this.logger.error("Error 0 during Upgrade");
            return false;
        }
        try {
            if (httpResponse.getStatusLine() == null) {
                this.logger.error("Error 1 during upgrade");
            }
            int responseCode = httpResponse.getStatusLine().getStatusCode();
            this.logger.debug("Response code " + responseCode);
            if (responseCode == 200 && httpResponse.getEntity() != null) {
                downloaded = this.downloadUpdate(downloadUrl, httpResponse);
            }
            if (httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
        catch (IOException | IllegalStateException e) {
            this.logger.error("Exception", (Throwable)e);
        }
        return downloaded;
    }

    private boolean downloadUpdate(String downloadUrl, HttpResponse httpResponse) {
        boolean isDownloaded = false;
        try (FileOutputStream fileOS = new FileOutputStream(new File(downloadUrl));){
            this.logger.debug(" Going to download to " + downloadUrl);
            IOUtils.copy((InputStream)httpResponse.getEntity().getContent(), (OutputStream)fileOS);
            isDownloaded = true;
        }
        catch (Exception e) {
            this.logger.error("Exception", (Throwable)e);
        }
        return isDownloaded;
    }
}

