/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.helper.windows;

import com.parablu.epa.common.dao.BackUpFolderDAOImpl;
import com.parablu.epa.common.dao.BackupPolicyDAOImpl;
import com.parablu.epa.common.service.notification.NotificationHelper;
import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.core.constant.StringLiterals;
import com.parablu.epa.core.helper.PropertyHelper;
import com.parablu.epa.core.to.BackupFolderTO;
import com.parablu.epa.core.to.ContainerDetailsTo;
import com.parablu.epa.core.to.ScheduleTO;
import com.parablu.epa.core.to.ScriptTo;
import com.parablu.epa.helper.windows.ExecuteCalloutScript;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VolumeShadowService {
    private static Logger logger = LoggerFactory.getLogger(VolumeShadowService.class);
    public static String serverBackupType = "I";

    public void createSnapshot(List<BackupFolderTO> listOfFolder) {
        if (!listOfFolder.isEmpty()) {
            String snapFolder = SettingHelper.getSnapFolderPath();
            ArrayList<String> snapDrives = new ArrayList<String>();
            for (BackupFolderTO i : listOfFolder) {
                String filePath = i.getFolderPath();
                String drive = filePath.substring(0, 1);
                if (snapDrives.isEmpty() || !snapDrives.contains(drive)) {
                    logger.debug("Creating snapshot for drive:" + drive);
                    String target = snapFolder + StringLiterals.CONSTANTS_FILE_SEPARATOR + drive + "_drive\\";
                    File f = new File(target);
                    boolean folderResp = !f.exists() ? f.mkdirs() : true;
                    logger.debug("Folder creation resp for snap creation : " + folderResp);
                    if (!folderResp) continue;
                    ArrayList<String> args = new ArrayList<String>();
                    args.add("Create");
                    args.add("-Target");
                    args.add(target);
                    args.add("-Volume");
                    args.add(drive);
                    args.add(SettingHelper.getParabluVshadowPath());
                    Boolean result = ExecuteCalloutScript.executeScript("VssSnapshot.ps1", args);
                    if (!result.booleanValue()) {
                        logger.debug("Could not create snapshot");
                        continue;
                    }
                    logger.debug("created snap sucessfully");
                    snapDrives.add(drive);
                    continue;
                }
                logger.debug("Snaps for " + drive + " drive already created ");
            }
        }
    }

    public void deleteSnapshot(List<BackupFolderTO> listOfFolder) {
        if (!listOfFolder.isEmpty()) {
            String snapFolder = SettingHelper.getSnapFolderPath();
            ArrayList<String> snapDrives = new ArrayList<String>();
            for (BackupFolderTO i : listOfFolder) {
                String actualPath = i.getFolderPath();
                String drive = actualPath.substring(0, 1);
                if (snapDrives.isEmpty() || !snapDrives.contains(drive)) {
                    String target = snapFolder + StringLiterals.CONSTANTS_FILE_SEPARATOR + drive + "_drive";
                    if (new File(target).exists() && new File(target).list().length > 0) {
                        ArrayList<String> args = new ArrayList<String>();
                        args.add("delete");
                        args.add("-Target");
                        args.add(target);
                        args.add("-Volume");
                        args.add(drive);
                        args.add(SettingHelper.getParabluVshadowPath());
                        Boolean result = ExecuteCalloutScript.executeScript("VssSnapshot.ps1", args);
                        if (!result.booleanValue()) {
                            logger.debug("Could not delete snapshot");
                            continue;
                        }
                        logger.debug("Sucessfully deleted snap shot of " + drive);
                        snapDrives.add(drive);
                        continue;
                    }
                    logger.debug("snaps dont exit ");
                    continue;
                }
                logger.debug("Snapshot of drive dosent exist ");
            }
        } else {
            logger.debug("List of folders for snapshot is empty");
        }
    }

    public boolean runScript(String type, boolean isManual, Map<String, String> env) {
        ScriptTo scriptTo = null;
        boolean result = false;
        try {
            scriptTo = this.getScriptDetails(type, isManual);
            logger.debug("scritps to >>>>  " + scriptTo);
        }
        catch (NullPointerException e) {
            logger.trace("" + e);
            logger.error("Error getting Scripts" + e.getMessage());
        }
        if (scriptTo != null) {
            List args = scriptTo.getScriptArgs();
            logger.debug("before Executing Script");
            args.set(0, env.get("-myPath"));
            args.add(env.get("-timeStamp"));
            try {
                result = ExecuteCalloutScript.executeScript(scriptTo.getScriptName(), args);
                logger.debug("Script run : " + result);
            }
            catch (Exception e) {
                logger.trace("" + e);
                logger.error("Exception while executeCalloutScript " + e.getMessage());
            }
        } else {
            logger.debug("No scripts found to run");
        }
        return result;
    }

    public boolean runScript(String type, boolean isManual) {
        ScriptTo scriptTo = null;
        boolean result = false;
        try {
            scriptTo = this.getScriptDetails(type, isManual);
        }
        catch (NullPointerException e) {
            logger.error("Error geting Scripts" + e.getMessage());
            logger.trace("" + e);
        }
        if (scriptTo != null) {
            List args = scriptTo.getScriptArgs();
            logger.debug("before Executing Script");
            try {
                result = ExecuteCalloutScript.executeScript(scriptTo.getScriptName(), args);
                logger.debug("Script run : " + result);
            }
            catch (Exception e) {
                logger.trace("" + e);
                logger.error("Exception in executing script" + e.getMessage());
            }
        } else {
            logger.debug("No Scripts to run");
        }
        return result;
    }

    private ScriptTo getScriptDetails(String type, boolean isManual) {
        String backupType = type;
        if (!isManual) {
            if (type.equalsIgnoreCase("preBackup")) {
                backupType = type.concat(NotificationHelper.getServerBackupType());
            }
        } else if (type.equalsIgnoreCase("preBackup") && !NotificationHelper.getServerBackupType().isEmpty()) {
            if (!this.isPreviousFullBackupSuccessful()) {
                logger.debug("Setting FUll backup as previous full schedule skipped");
                NotificationHelper.setServerBackupType((String)"F");
            }
            backupType = type.concat(NotificationHelper.getServerBackupType());
        }
        logger.debug("script type queried " + backupType + " contName " + NotificationHelper.getCurrentContainerName());
        ScriptTo scriptTo = this.getCurrentContainerScriptdetails(backupType);
        logger.debug("name script >>>>>>>>>>>>> " + scriptTo.getScriptName());
        if (scriptTo.getScriptName() == null) {
            scriptTo = null;
        }
        return scriptTo;
    }

    private ScriptTo getCurrentContainerScriptdetails(String scriptType) {
        logger.debug("inside get container details :" + NotificationHelper.getCurrentContainerName());
        BackupPolicyDAOImpl backupPolicyDAOImpl = new BackupPolicyDAOImpl(SettingHelper.getBackUpDbUrl());
        ScriptTo scriptTo = null;
        List containerDetailsTos = backupPolicyDAOImpl.getCurrentContainerDetails(NotificationHelper.getCurrentContainerName(), true);
        if (!containerDetailsTos.isEmpty()) {
            ContainerDetailsTo containerDetailsTo = null;
            try {
                containerDetailsTo = (ContainerDetailsTo)containerDetailsTos.get(0);
            }
            catch (Exception e) {
                logger.trace("" + e);
                logger.error("Exception in getting container details" + e.getMessage());
            }
            if (containerDetailsTo != null) {
                scriptTo = new ScriptTo();
                ArrayList<String> args = new ArrayList<String>();
                String dump = this.getDumpPathForContainer();
                if (dump != null) {
                    args.add(dump);
                    args.add(containerDetailsTo.getContainerName());
                    args.add(containerDetailsTo.getContainerUserName());
                    args.add(containerDetailsTo.getContainerPassword());
                    args.add(containerDetailsTo.getContainerLocation());
                    args.add(SettingHelper.getSystemIP());
                    args.add(containerDetailsTo.getContainerPort());
                    scriptTo.setScriptArgs(args);
                    scriptTo.setScriptName(PropertyHelper.getScriptResourceString((String)(containerDetailsTo.getContainerType() + scriptType)));
                } else {
                    logger.debug("Could not get dump path");
                }
            } else {
                logger.debug("Could not get dump path");
            }
        } else {
            logger.debug("container list empty , container name: " + NotificationHelper.getCurrentContainerName());
        }
        return scriptTo;
    }

    private boolean isPreviousFullBackupSuccessful() {
        BackupPolicyDAOImpl backupPolicyDAOImpl = new BackupPolicyDAOImpl(SettingHelper.getBackUpDbUrl());
        List containerDetailsTos = backupPolicyDAOImpl.getCurrentContainerDetails(NotificationHelper.getCurrentContainerName(), true);
        if (!containerDetailsTos.isEmpty()) {
            ContainerDetailsTo containerDetailsTo = null;
            try {
                containerDetailsTo = (ContainerDetailsTo)containerDetailsTos.get(0);
            }
            catch (Exception e) {
                logger.trace("" + e);
                logger.error("cannot get the container details" + e.getMessage());
            }
            if (containerDetailsTo != null) {
                String prevFullTimeStr = containerDetailsTo.getPrevTimesamp();
                if (prevFullTimeStr != null && !prevFullTimeStr.isEmpty()) {
                    List scheduleTOList;
                    Date prevFullTime = new Date(Long.valueOf(prevFullTimeStr));
                    try {
                        scheduleTOList = backupPolicyDAOImpl.getSchedulesAccordingToType("F");
                    }
                    catch (Exception e) {
                        logger.error("error in get schedule type " + e);
                        return true;
                    }
                    TreeSet<Date> dates = new TreeSet<Date>();
                    for (ScheduleTO scheduleTO : scheduleTOList) {
                        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm");
                        try {
                            Date date1 = sdf.parse(scheduleTO.getStartTime());
                            Calendar calendar = Calendar.getInstance();
                            int dayOfWeek = calendar.get(7);
                            int[] daysArray = VolumeShadowService.toIntArray(scheduleTO.getDayArray());
                            for (int i = 0; i < daysArray.length; ++i) {
                                Calendar calendar1 = Calendar.getInstance();
                                if (daysArray[i] > dayOfWeek) {
                                    calendar1.add(5, daysArray[i] - dayOfWeek - 7);
                                    calendar1.set(11, date1.getHours());
                                    calendar1.set(12, date1.getMinutes());
                                    dates.add(calendar1.getTime());
                                    continue;
                                }
                                if (daysArray[i] < dayOfWeek) {
                                    calendar1.add(5, daysArray[i] - dayOfWeek);
                                    calendar1.set(11, date1.getHours());
                                    calendar1.set(12, date1.getMinutes());
                                    dates.add(calendar1.getTime());
                                    continue;
                                }
                                if (daysArray[i] != dayOfWeek) continue;
                                calendar1.set(11, date1.getHours());
                                calendar1.set(12, date1.getMinutes());
                                dates.add(calendar1.getTime());
                            }
                        }
                        catch (ParseException e) {
                            logger.trace("" + e);
                            logger.error("Parse Exception" + e.getMessage());
                        }
                    }
                    Date prevSchedule = dates.lower(Calendar.getInstance().getTime());
                    if (prevSchedule == null) {
                        prevSchedule = (Date)Collections.max(dates);
                    }
                    if (prevFullTime.compareTo(prevSchedule) >= 0) {
                        return true;
                    }
                } else {
                    return false;
                }
            }
        }
        return false;
    }

    public static int[] toIntArray(String input) {
        String beforeSplit = input.replaceAll("\\[|\\]|\\s", "");
        String[] split = beforeSplit.split("\\,");
        int[] result = new int[split.length];
        for (int i = 0; i < split.length; ++i) {
            result[i] = Integer.parseInt(split[i]);
        }
        return result;
    }

    public static String getPolicyForContainer(String containerName) {
        String[] containerNamearr;
        String contName;
        String policyName = "";
        BackupPolicyDAOImpl backupPolicyDAOImpl = new BackupPolicyDAOImpl(SettingHelper.getBackUpDbUrl());
        List containerDetailsTos = backupPolicyDAOImpl.getCurrentContainerDetails(contName = (containerNamearr = containerName.split("\\|"))[0], true);
        if (!containerDetailsTos.isEmpty()) {
            ContainerDetailsTo containerDetailsTo = (ContainerDetailsTo)containerDetailsTos.get(0);
            policyName = containerDetailsTo.getPolicyname();
        }
        return policyName;
    }

    public String getDumpPathForContainer() {
        String dumpPath = null;
        ArrayList<BackupFolderTO> listOfFolder = new ArrayList<BackupFolderTO>();
        BackUpFolderDAOImpl backUpFolderDAOImpl = new BackUpFolderDAOImpl(SettingHelper.getBackUpDbUrl());
        List listOfAllFolder = backUpFolderDAOImpl.getAllFolderToBackUpFiles();
        if (SettingHelper.getServerBackupLicensed().equals("true")) {
            for (BackupFolderTO backupFolderTO : listOfAllFolder) {
                logger.debug("bkpto polname : " + backupFolderTO.getPolicyName());
                logger.debug("pol name Nooti : " + NotificationHelper.getCurrentPolicyName());
                if (!backupFolderTO.getPolicyName().equals(NotificationHelper.getCurrentPolicyName())) continue;
                listOfFolder.add(backupFolderTO);
            }
        }
        if (!listOfFolder.isEmpty()) {
            dumpPath = ((BackupFolderTO)listOfFolder.get(0)).getFolderPath();
        }
        return dumpPath;
    }
}

