/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.io.OutputStream;
import java.security.cert.CRLReason;
import java.util.Enumeration;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.AttributeNameEnumeration;
import sun.security.x509.CertAttrSet;
import sun.security.x509.Extension;
import sun.security.x509.PKIXExtensions;

public class CRLReasonCodeExtension
extends Extension
implements CertAttrSet<String> {
    public static final String NAME = "CRLReasonCode";
    public static final String REASON = "reason";
    private static CRLReason[] values = CRLReason.values();
    private int reasonCode = 0;

    private void encodeThis() throws IOException {
        if (this.reasonCode == 0) {
            this.extensionValue = null;
            return;
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.putEnumerated(this.reasonCode);
        this.extensionValue = derOutputStream.toByteArray();
    }

    public CRLReasonCodeExtension(int n) throws IOException {
        this(false, n);
    }

    public CRLReasonCodeExtension(boolean bl, int n) throws IOException {
        this.extensionId = PKIXExtensions.ReasonCode_Id;
        this.critical = bl;
        this.reasonCode = n;
        this.encodeThis();
    }

    public CRLReasonCodeExtension(Boolean bl, Object object) throws IOException {
        this.extensionId = PKIXExtensions.ReasonCode_Id;
        this.critical = bl;
        this.extensionValue = (byte[])object;
        DerValue derValue = new DerValue(this.extensionValue);
        this.reasonCode = derValue.getEnumerated();
    }

    public void set(String string, Object object) throws IOException {
        if (!(object instanceof Integer)) {
            throw new IOException("Attribute must be of type Integer.");
        }
        if (!string.equalsIgnoreCase(REASON)) {
            throw new IOException("Name not supported by CRLReasonCodeExtension");
        }
        this.reasonCode = (Integer)object;
        this.encodeThis();
    }

    public Integer get(String string) throws IOException {
        if (string.equalsIgnoreCase(REASON)) {
            return new Integer(this.reasonCode);
        }
        throw new IOException("Name not supported by CRLReasonCodeExtension");
    }

    public void delete(String string) throws IOException {
        if (!string.equalsIgnoreCase(REASON)) {
            throw new IOException("Name not supported by CRLReasonCodeExtension");
        }
        this.reasonCode = 0;
        this.encodeThis();
    }

    @Override
    public String toString() {
        return super.toString() + "    Reason Code: " + (Object)((Object)this.getReasonCode());
    }

    @Override
    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        if (this.extensionValue == null) {
            this.extensionId = PKIXExtensions.ReasonCode_Id;
            this.critical = false;
            this.encodeThis();
        }
        super.encode(derOutputStream);
        outputStream.write(derOutputStream.toByteArray());
    }

    public Enumeration<String> getElements() {
        AttributeNameEnumeration attributeNameEnumeration = new AttributeNameEnumeration();
        attributeNameEnumeration.addElement(REASON);
        return attributeNameEnumeration.elements();
    }

    @Override
    public String getName() {
        return NAME;
    }

    public CRLReason getReasonCode() {
        if (this.reasonCode > 0 && this.reasonCode < values.length) {
            return values[this.reasonCode];
        }
        return CRLReason.UNSPECIFIED;
    }
}

