/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.io.IOException;
import java.io.OutputStream;
import java.security.cert.Extension;
import java.util.Collections;
import java.util.List;
import sun.misc.HexDumpEncoder;
import sun.security.provider.certpath.CertId;
import sun.security.provider.certpath.OCSP;
import sun.security.util.Debug;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

class OCSPRequest {
    private static final Debug debug = Debug.getInstance("certpath");
    private static final boolean dump = debug != null && Debug.isOn("ocsp");
    private final List<CertId> certIds;
    private final List<Extension> extensions;
    private byte[] nonce;

    OCSPRequest(CertId certId) {
        this(Collections.singletonList(certId));
    }

    OCSPRequest(List<CertId> list) {
        this.certIds = list;
        this.extensions = Collections.emptyList();
    }

    OCSPRequest(List<CertId> list, List<Extension> list2) {
        this.certIds = list;
        this.extensions = list2;
    }

    byte[] encodeBytes() throws IOException {
        Object object;
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        for (CertId object32 : this.certIds) {
            DerOutputStream derOutputStream3 = new DerOutputStream();
            object32.encode(derOutputStream3);
            derOutputStream2.write((byte)48, derOutputStream3);
        }
        derOutputStream.write((byte)48, derOutputStream2);
        if (!this.extensions.isEmpty()) {
            object = new DerOutputStream();
            for (Extension extension : this.extensions) {
                extension.encode((OutputStream)object);
                if (!extension.getId().equals(OCSP.NONCE_EXTENSION_OID.toString())) continue;
                this.nonce = extension.getValue();
            }
            DerOutputStream derOutputStream4 = new DerOutputStream();
            derOutputStream4.write((byte)48, (DerOutputStream)object);
            derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)2), derOutputStream4);
        }
        object = new DerOutputStream();
        object.write((byte)48, derOutputStream);
        DerOutputStream derOutputStream5 = new DerOutputStream();
        derOutputStream5.write((byte)48, (DerOutputStream)object);
        byte[] byArray = derOutputStream5.toByteArray();
        if (dump) {
            HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
            debug.println("OCSPRequest bytes...\n\n" + hexDumpEncoder.encode(byArray) + "\n");
        }
        return byArray;
    }

    List<CertId> getCertIds() {
        return this.certIds;
    }

    byte[] getNonce() {
        return this.nonce;
    }
}

